PK       ! sΦ      fontconfig/fcfreetype.hnu [        PK       ! @t.  t.  
  inttypes.hnu [        PK       ! myĒj  j    perf/perf_dlfilter.hnu [        PK       ! O:$  $  
  ldap_schema.hnu [        PK       ! rR      netrom/netrom.hnu [        PK       ! /R      	  syscall.hnu [        PK       ! u  u    endian.hnu [        PK       ! ܞ/  /    php/Zend/zend_ini.hnu [        /*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Author: Zeev Suraski <zeev@php.net>                                  |
   +----------------------------------------------------------------------+
*/

#ifndef ZEND_INI_H
#define ZEND_INI_H

#include "zend_modules.h"

#define ZEND_INI_USER	(1<<0)
#define ZEND_INI_PERDIR	(1<<1)
#define ZEND_INI_SYSTEM	(1<<2)

#define ZEND_INI_ALL (ZEND_INI_USER|ZEND_INI_PERDIR|ZEND_INI_SYSTEM)

#define ZEND_INI_MH(name) int name(zend_ini_entry *entry, zend_string *new_value, void *mh_arg1, void *mh_arg2, void *mh_arg3, int stage)
#define ZEND_INI_DISP(name) ZEND_COLD void name(zend_ini_entry *ini_entry, int type)

typedef struct _zend_ini_entry_def {
	const char *name;
	ZEND_INI_MH((*on_modify));
	void *mh_arg1;
	void *mh_arg2;
	void *mh_arg3;
	const char *value;
	void (*displayer)(zend_ini_entry *ini_entry, int type);

	uint32_t value_length;
	uint16_t name_length;
	uint8_t modifiable;
} zend_ini_entry_def;

struct _zend_ini_entry {
	zend_string *name;
	ZEND_INI_MH((*on_modify));
	void *mh_arg1;
	void *mh_arg2;
	void *mh_arg3;
	zend_string *value;
	zend_string *orig_value;
	void (*displayer)(zend_ini_entry *ini_entry, int type);

	int module_number;

	uint8_t modifiable;
	uint8_t orig_modifiable;
	uint8_t modified;

};

BEGIN_EXTERN_C()
ZEND_API void zend_ini_startup(void);
ZEND_API void zend_ini_shutdown(void);
ZEND_API void zend_ini_global_shutdown(void);
ZEND_API void zend_ini_deactivate(void);
ZEND_API void zend_ini_dtor(HashTable *ini_directives);

ZEND_API void zend_copy_ini_directives(void);

ZEND_API void zend_ini_sort_entries(void);

ZEND_API zend_result zend_register_ini_entries(const zend_ini_entry_def *ini_entry, int module_number);
ZEND_API zend_result zend_register_ini_entries_ex(const zend_ini_entry_def *ini_entry, int module_number, int module_type);
ZEND_API void zend_unregister_ini_entries(int module_number);
ZEND_API void zend_unregister_ini_entries_ex(int module_number, int module_type);
ZEND_API void zend_ini_refresh_caches(int stage);
ZEND_API zend_result zend_alter_ini_entry(zend_string *name, zend_string *new_value, int modify_type, int stage);
ZEND_API zend_result zend_alter_ini_entry_ex(zend_string *name, zend_string *new_value, int modify_type, int stage, bool force_change);
ZEND_API zend_result zend_alter_ini_entry_chars(zend_string *name, const char *value, size_t value_length, int modify_type, int stage);
ZEND_API zend_result zend_alter_ini_entry_chars_ex(zend_string *name, const char *value, size_t value_length, int modify_type, int stage, int force_change);
ZEND_API zend_result zend_restore_ini_entry(zend_string *name, int stage);
ZEND_API void display_ini_entries(zend_module_entry *module);

ZEND_API zend_long zend_ini_long(const char *name, size_t name_length, int orig);
ZEND_API double zend_ini_double(const char *name, size_t name_length, int orig);
ZEND_API char *zend_ini_string(const char *name, size_t name_length, int orig);
ZEND_API char *zend_ini_string_ex(const char *name, size_t name_length, int orig, bool *exists)