cessarily state or   |
   |   reflect those of the United States Government or  the  University   |
   |   of  California,  and shall not be used for advertising or product   |
    \  endorsement purposes.                                              /
     ---------------------------------------------------------------------
*/

/*
 *       Define macros for handling SIGFPE.
 *       Lee Busby, LLNL, November, 1996
 *       busby1@llnl.gov
 *
 *********************************************
 * Overview of the system for handling SIGFPE:
 *
 * This file (Include/pyfpe.h) defines a couple of "wrapper" macros for
 * insertion into your Python C code of choice. Their proper use is
 * discussed below. The file Python/pyfpe.c defines a pair of global
 * variables PyFPE_jbuf and PyFPE_counter which are used by the signal
 * handler for SIGFPE to decide if a particular exception was protected
 * by the macros. The signal handler itself, and code for enabling the
 * generation of SIGFPE in the first place, is in a (new) Python module
 * named fpectl. This module is standard in every respect. It can be loaded
 * either statically or dynamically as you choose, and like any other
 * Python module, has no effect until you import it.
 *
 * In the general case, there are three steps toward handling SIGFPE in any
 * Python code:
 *
 * 1) Add the *_PROTECT macros to your C code as required to protect
 *    dangerous floating point sections.
 *
 * 2) Turn on the inclusion of the code by adding the ``--with-fpectl''
 *    flag at the time you run configure.  If the fpectl or other modules
 *    which use the *_PROTECT macros are to be dynamically loaded, be
 *    sure they are compiled with WANT_SIGFPE_HANDLER defined.
 *
 * 3) When python is built and running, import fpectl, and execute
 *    fpectl.turnon_sigfpe(). This sets up the signal handler and enables
 *    generation of SIGFPE whenever an exception occurs. From this point
 *    on, any properly trapped SIGFPE should result in the Python
 *    FloatingPointError exception.
 *
 * Step 1 has been done already for the Python kernel code, and should be
 * done soon for the NumPy array package.  Step 2 is usually done once at
 * python install time. Python's behavior with respect to SIGFPE is not
 * changed unless you also do step 3. Thus you can control this new
 * facility at compile time, or run time, or both.
 *
 ********************************
 * Using the macros in your code:
 *
 * static PyObject *foobar(PyObject *self,PyObject *args)
 * {
 *     ....
 *     PyFPE_START_PROTECT("Error in foobar", return 0)
 *     result = dangerous_op(somearg1, somearg2, ...);
 *     PyFPE_END_PROTECT(result)
 *     ....
 * }
 *
 * If a floating point error occurs in dangerous_op, foobar returns 0 (NULL),
 * after setting the associated value of the FloatingPointError exception to
 * "Error in foobar". ``Dangerous_op'' can be a single operation, or a block
 * of code, function calls, or any combination, so long as no alternate
 * return is possible before the PyFPE_END_PROTECT macro is reached.
 *
 * The macros can only be used in a function context where an error return
 * can be recognized as signaling a Python exception. (Generally, most
 * functions that return a PyObject * will qualify.)
 *
 * Guido's original design suggestion for PyFPE_START_PROTECT and
 * PyFPE_END_PROTECT had them open and close a local block, with a locally
 * defined jmp_buf and jmp_buf pointer. This would allow recursive nesting
 * of the macros. The Ansi C standard makes it clear that such local
 * variables need to be declared with the "volatile" type qualifier to keep
 * setjmp from corrupting their values. Some current implementations seem
 * to be more restrictive. For example, the HPUX man page for setjmp says
 *
 *   Upon the return from a setjmp() call caused by a longjmp(), the
 *   values of any non-static local variables belonging to the routine
 *   from which setjmp() was called are undefined. Code which depends on
 *   such values is not guaranteed to be portable.
 *
 * I therefore decided on a more limited form of nesting, using a counter
 * variable (PyFPE_counter) to keep track of any recursion.  If an exception
 * occurs in an ``inner'' pair of macros, the return will apparently
 * come from the outermost level.
 *
 */

#ifdef WANT_SIGFPE_HANDLER
#include <signal.h>
#include <setjmp.h>
#include <math.h>
extern jmp_buf PyFPE_jbuf;
extern int PyFPE_counter;
extern double PyFPE_dummy(void *);

#define PyFPE_START_PROTECT(err_string, leave_stmt) \
if (!PyFPE_counter++ && setjmp(PyFPE_jbuf)) { \
	PyErr_SetString(PyExc_FloatingPointError, err_string); \
	PyFPE_counter = 0; \
	leave_stmt; \
}

/*
 * This (following) is a heck of a way to decrement a counter. However,
 * unless the macro argument is provided, code optimizers will sometimes move
 * this statement so that it gets executed *before* the unsafe expression
 * which we're trying to protect.  That pretty well messes things up,
 * of course.
 *
 * If the expression(s) you're trying to protect don't happen to return a
 * value, you will need to manufacture a dummy result just to preserve the
 * correct ordering of statements.  Note that the macro passes the address
 * of its argument (so you need to give it something which is addressable).
 * If your expression returns multiple results, pass the last such result
 * to PyFPE_END_PROTECT.
 *
 * Note that PyFPE_dummy returns a double, which is cast to int.
 * This seeming insanity is to tickle the Floating Point Unit (FPU).
 * If an exception has occurred in a preceding floating point operation,
 * some architectures (notably Intel 80x86) will not deliver the interrupt
 * until the *next* floating point operation.  This is painful if you've
 * already decremented PyFPE_counter.
 */
#define PyFPE_END_PROTECT(v) PyFPE_counter -= (int)PyFPE_dummy(&(v));

#else

#define PyFPE_START_PROTECT(err_string, leave_stmt)
#define PyFPE_END_PROTECT(v)

#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_PYFPE_H */
PK       ! '
      python3.5m/pycapsule.hnu [        
/* Capsule objects let you wrap a C "void *" pointer in a Python
   object.  They're a way of passing data through the Python interpreter
   without creating your own custom type.

   Capsules are used for communication between extension modules.
   They provide a way for an extension module to export a C interface
   to other extension modules, so that extension modules can use the
   Python import mechanism to link to one another.

   For more information, please see "c-api/capsule.html" in the
   documentation.
*/

#ifndef Py_CAPSULE_H
#define Py_CAPSULE_H
#ifdef __cplusplus
extern "C" {
#endif

PyAPI_DATA(PyTypeObject) PyCapsule_Type;

typedef void (*PyCapsule_Destructor)(PyObject *);

#define PyCapsule_CheckExact(op) (Py_TYPE(op) == &PyCapsule_Type)


PyAPI_FUNC(PyObject *) PyCapsule_New(
    void *pointer,
    const char *name,
    PyCapsule_Destructor destructor);

PyAPI_FUNC(void *) PyCapsule_GetPointer(PyObject *capsule, const char *name);

PyAPI_FUNC(PyCapsule_Destructor) PyCapsule_GetDestructor(PyObject *capsule);

PyAPI_FUNC(const char *) PyCapsule_GetName(PyObject *capsule);

PyAPI_FUNC(void *) PyCapsule_GetContext(PyObject *capsule);

PyAPI_FUNC(int) PyCapsule_IsValid(PyObject *capsule, const char *name);

PyAPI_FUNC(int) PyCapsule_SetPointer(PyObject *capsule, void *pointer);

PyAPI_FUNC(int) PyCapsule_SetDestructor(PyObject *capsule, PyCapsule_Destructor destructor);

PyAPI_FUNC(int) PyCapsule_SetName(PyObject *capsule, const char *name);

PyAPI_FUNC(int) PyCapsule_SetContext(PyObject *capsule, void *context);

PyAPI_FUNC(void *) PyCapsule_Import(
    const char *name,           /* UTF-8 encoded string */
    int no_block);


#ifdef __cplusplus
}
#endif
#endif /* !Py_CAPSULE_H */
PK       ! (]R=  =    python3.5m/import.hnu [        
/* Module definition and import interface */

#ifndef Py_IMPORT_H
#define Py_IMPORT_H
#ifdef __cplusplus
extern "C" {
#endif

PyAPI_FUNC(void) _PyImportZip_Init(void);

PyMODINIT_FUNC PyInit_imp(void);
PyAPI_FUNC(long) PyImport_GetMagicNumber(void);
PyAPI_FUNC(const char *) PyImport_GetMagicTag(void);
PyAPI_FUNC(PyObject *) PyImport_ExecCodeModule(
    const char *name,           /* UTF-8 encoded string */
    PyObject *co
    );
PyAPI_FUNC(PyObject *) PyImport_ExecCodeModuleEx(
    const char *name,           /* UTF-8 encoded string */
    PyObject *co,
    const char *pathname        /* decoded from the filesystem encoding */
    );
PyAPI_FUNC(PyObject *) PyImport_ExecCodeModuleWithPathnames(
    const char *name,           /* UTF-8 encoded string */
    PyObject *co,
    const char *pathname,       /* decoded from the filesystem encoding */
    const char *cpathname       /* decoded from the filesystem encoding */
    );
PyAPI_FUNC(PyObject *) PyImport_ExecCodeModuleObject(
    PyObject *name,
    PyObject *co,
    PyObject *pathname,
    PyObject *cpathname
    );
PyAPI_FUNC(PyObject *) PyImport_GetModuleDict(void);
PyAPI_FUNC(PyObject *) PyImport_AddModuleObject(
    PyObject *name
    );
PyAPI_FUNC(PyObject *) PyImport_AddModule(
    const char *name            /* UTF-8 encoded string */
    );
PyAPI_FUNC(PyObject *) PyImport_ImportModule(
    const char *name            /* UTF-8 encoded string */
    );
PyAPI_FUNC(PyObject *) PyImport_ImportModuleNoBlock(
    const char *name            /* UTF-8 encoded string */
    );
PyAPI_FUNC(PyObject *) PyImport_ImportModuleLevel(
    const char *name,           /* UTF-8 encoded string */
    PyObject *globals,
    PyObject *locals,
    PyObject *fromlist,
    int level
    );
PyAPI_FUNC(PyObject *) PyImport_ImportModuleLevelObject(
    PyObject *name,
    PyObject *globals,
    PyObject *locals,
    PyObject *fromlist,
    int level
    );

#define PyImport_ImportModuleEx(n, g, l, f) \
    PyImport_ImportModuleLevel(n, g, l, f, 0)

PyAPI_FUNC(PyObject *) PyImport_GetImporter(PyObject *path);
PyAPI_FUNC(PyObject *) PyImport_Import(PyObject *name);
PyAPI_FUNC(PyObject *) PyImport_ReloadModule(PyObject *m);
PyAPI_FUNC(void) PyImport_Cleanup(void);
PyAPI_FUNC(int) PyImport_ImportFrozenModuleObject(
    PyObject *name
    );
PyAPI_FUNC(int) PyImport_ImportFrozenModule(
    const char *name            /* UTF-8 encoded string */
    );

#ifndef Py_LIMITED_API
#ifdef WITH_THREAD
PyAPI_FUNC(void) _PyImport_AcquireLock(void);
PyAPI_FUNC(int) _PyImport_ReleaseLock(void);
#else
#define _PyImport_AcquireLock()
#define _PyImport_ReleaseLock() 1
#endif

PyAPI_FUNC(void) _PyImport_ReInitLock(void);

PyAPI_FUNC(PyObject *) _PyImport_FindBuiltin(
    const char *name            /* UTF-8 encoded string */
    );
PyAPI_FUNC(PyObject *) _PyImport_FindExtensionObject(PyObject *, PyObject *);
PyAPI_FUNC(int) _PyImport_FixupBuiltin(
    PyObject *mod,
    const char *name            /* UTF-8 encoded string */
    );
PyAPI_FUNC(int) _PyImport_FixupExtensionObject(PyObject*, PyObject *, PyObject *);

struct _inittab {
    const char *name;           /* ASCII encoded string */
    PyObject* (*initfunc)(void);
};
PyAPI_DATA(struct _inittab *) PyImport_Inittab;
PyAPI_FUNC(int) PyImport_ExtendInittab(struct _inittab *newtab);
#endif /* Py_LIMITED_API */

PyAPI_DATA(PyTypeObject) PyNullImporter_Type;

PyAPI_FUNC(int) PyImport_AppendInittab(
    const char *name,           /* ASCII encoded string */
    PyObject* (*initfunc)(void)
    );

#ifndef Py_LIMITED_API
struct _frozen {
    const char *name;                 /* ASCII encoded string */
    const unsigned char *code;
    int size;
};

/* Embedding apps may change this pointer to point to their favorite
   collection of frozen modules: */

PyAPI_DATA(const struct _frozen *) PyImport_FrozenModules;
#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_IMPORT_H */
PK       ! y^L#7  7    python3.5m/iterobject.hnu [        #ifndef Py_ITEROBJECT_H
#define Py_ITEROBJECT_H
/* Iterators (the basic kind, over a sequence) */
#ifdef __cplusplus
extern "C" {
#endif

PyAPI_DATA(PyTypeObject) PySeqIter_Type;
PyAPI_DATA(PyTypeObject) PyCallIter_Type;
PyAPI_DATA(PyTypeObject) PyCmpWrapper_Type;

#define PySeqIter_Check(op) (Py_TYPE(op) == &PySeqIter_Type)

PyAPI_FUNC(PyObject *) PySeqIter_New(PyObject *);


#define PyCallIter_Check(op) (Py_TYPE(op) == &PyCallIter_Type)

PyAPI_FUNC(PyObject *) PyCallIter_New(PyObject *, PyObject *);

#ifdef __cplusplus
}
#endif
#endif /* !Py_ITEROBJECT_H */

PK       ! $οe	  	    python3.5m/sliceobject.hnu [        #ifndef Py_SLICEOBJECT_H
#define Py_SLICEOBJECT_H
#ifdef __cplusplus
extern "C" {
#endif

/* The unique ellipsis object "..." */

PyAPI_DATA(PyObject) _Py_EllipsisObject; /* Don't use this directly */

#define Py_Ellipsis (&_Py_EllipsisObject)

/* Slice object interface */

/*

A slice object containing start, stop, and step data members (the
names are from range).  After much talk with Guido, it was decided to
let these be any arbitrary python type.  Py_None stands for omitted values.
*/
#ifndef Py_LIMITED_API
typedef struct {
    PyObject_HEAD
    PyObject *start, *stop, *step;	/* not NULL */
} PySliceObject;
#endif

PyAPI_DATA(PyTypeObject) PySlice_Type;
PyAPI_DATA(PyTypeObject) PyEllipsis_Type;

#define PySlice_Check(op) (Py_TYPE(op) == &PySlice_Type)

PyAPI_FUNC(PyObject *) PySlice_New(PyObject* start, PyObject* stop,
                                  PyObject* step);
#ifndef Py_LIMITED_API
PyAPI_FUNC(PyObject *) _PySlice_FromIndices(Py_ssize_t start, Py_ssize_t stop);
PyAPI_FUNC(int) _PySlice_GetLongIndices(PySliceObject *self, PyObject *length,
                                 PyObject **start_ptr, PyObject **stop_ptr,
                                 PyObject **step_ptr);
#endif
PyAPI_FUNC(int) PySlice_GetIndices(PyObject *r, Py_ssize_t length,
                                  Py_ssize_t *start, Py_ssize_t *stop, Py_ssize_t *step);
PyAPI_FUNC(int) PySlice_GetIndicesEx(PyObject *r, Py_ssize_t length,
                                     Py_ssize_t *start, Py_ssize_t *stop,
                                     Py_ssize_t *step, Py_ssize_t *slicelength);

#if !defined(Py_LIMITED_API) || (Py_LIMITED_API+0 >= 0x03050400 && Py_LIMITED_API+0 < 0x03060000) || Py_LIMITED_API+0 >= 0x03060100
#ifdef Py_LIMITED_API
#define PySlice_GetIndicesEx(slice, length, start, stop, step, slicelen) (  \
    PySlice_Unpack((slice), (start), (stop), (step)) < 0 ?                  \
    ((*(slicelen) = 0), -1) :                                               \
    ((*(slicelen) = PySlice_AdjustIndices((length), (start), (stop), *(step))), \
     0))
#endif
PyAPI_FUNC(int) PySlice_Unpack(PyObject *slice,
                               Py_ssize_t *start, Py_ssize_t *stop, Py_ssize_t *step);
PyAPI_FUNC(Py_ssize_t) PySlice_AdjustIndices(Py_ssize_t length,
                                             Py_ssize_t *start, Py_ssize_t *stop,
                                      