ent of the Python
     expression: o1^o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Or(PyObject *o1, PyObject *o2);

       /*
     Returns the result of bitwise or on o1 and o2 on success, or
     NULL on failure.  This is the equivalent of the Python
     expression: o1|o2.
       */

#define PyIndex_Check(obj) \
   ((obj)->ob_type->tp_as_number != NULL && \
    (obj)->ob_type->tp_as_number->nb_index != NULL)

     PyAPI_FUNC(PyObject *) PyNumber_Index(PyObject *o);

       /*
     Returns the object converted to a Python int
     or NULL with an error raised on failure.
       */

     PyAPI_FUNC(Py_ssize_t) PyNumber_AsSsize_t(PyObject *o, PyObject *exc);

       /*
    Returns the object converted to Py_ssize_t by going through
    PyNumber_Index first.  If an overflow error occurs while
    converting the int to Py_ssize_t, then the second argument
    is the error-type to return.  If it is NULL, then the overflow error
    is cleared and the value is clipped.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Long(PyObject *o);

       /*
     Returns the o converted to an integer object on success, or
     NULL on failure.  This is the equivalent of the Python
     expression: int(o).
       */

     PyAPI_FUNC(PyObject *) PyNumber_Float(PyObject *o);

       /*
     Returns the o converted to a float object on success, or NULL
     on failure.  This is the equivalent of the Python expression:
     float(o).
       */

/*  In-place variants of (some of) the above number protocol functions */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceAdd(PyObject *o1, PyObject *o2);

       /*
     Returns the result of adding o2 to o1, possibly in-place, or null
     on failure.  This is the equivalent of the Python expression:
     o1 += o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceSubtract(PyObject *o1, PyObject *o2);

       /*
     Returns the result of subtracting o2 from o1, possibly in-place or
     null on failure.  This is the equivalent of the Python expression:
     o1 -= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceMultiply(PyObject *o1, PyObject *o2);

       /*
     Returns the result of multiplying o1 by o2, possibly in-place, or
     null on failure.  This is the equivalent of the Python expression:
     o1 *= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceMatrixMultiply(PyObject *o1, PyObject *o2);

       /*
     This is the equivalent of the Python expression: o1 @= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceFloorDivide(PyObject *o1,
                                                        PyObject *o2);

       /*
     Returns the result of dividing o1 by o2 giving an integral result,
     possibly in-place, or null on failure.
     This is the equivalent of the Python expression:
     o1 /= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceTrueDivide(PyObject *o1,
                                                       PyObject *o2);

       /*
     Returns the result of dividing o1 by o2 giving a float result,
     possibly in-place, or null on failure.
     This is the equivalent of the Python expression:
     o1 /= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceRemainder(PyObject *o1, PyObject *o2);

       /*
     Returns the remainder of dividing o1 by o2, possibly in-place, or
     null on failure.  This is the equivalent of the Python expression:
     o1 %= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlacePower(PyObject *o1, PyObject *o2,
                                                  PyObject *o3);

       /*
     Returns the result of raising o1 to the power of o2, possibly
     in-place, or null on failure.  This is the equivalent of the Python
     expression: o1 **= o2, or pow(o1, o2, o3) if o3 is present.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceLshift(PyObject *o1, PyObject *o2);

       /*
     Returns the result of left shifting o1 by o2, possibly in-place, or
     null on failure.  This is the equivalent of the Python expression:
     o1 <<= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceRshift(PyObject *o1, PyObject *o2);

       /*
     Returns the result of right shifting o1 by o2, possibly in-place or
     null on failure.  This is the equivalent of the Python expression:
     o1 >>= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceAnd(PyObject *o1, PyObject *o2);

       /*
     Returns the result of bitwise and of o1 and o2, possibly in-place,
     or null on failure. This is the equivalent of the Python
     expression: o1 &= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceXor(PyObject *o1, PyObject *o2);

       /*
     Returns the bitwise exclusive or of o1 by o2, possibly in-place, or
     null on failure.  This is the equivalent of the Python expression:
     o1 ^= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_InPlaceOr(PyObject *o1, PyObject *o2);

       /*
     Returns the result of bitwise or of o1 and o2, possibly in-place,
     or null on failure.  This is the equivalent of the Python
     expression: o1 |= o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_ToBase(PyObject *n, int base);

       /*
     Returns the integer n converted to a string with a base, with a base
     marker of 0b, 0o or 0x prefixed if applicable.
     If n is not an int object, it is converted with PyNumber_Index first.
       */


/*  Sequence protocol:*/

     PyAPI_FUNC(int) PySequence_Check(PyObject *o);

       /*
     Return 1 if the object provides sequence protocol, and zero
     otherwise.

     This function always succeeds.
       */

     PyAPI_FUNC(Py_ssize_t) PySequence_Size(PyObject *o);

       /*
     Return the size of sequence object o, or -1 on failure.
       */

       /* For DLL compatibility */
#undef PySequence_Length
     PyAPI_FUNC(Py_ssize_t) PySequence_Length(PyObject *o);
#define PySequence_Length PySequence_Size


     PyAPI_FUNC(PyObject *) PySequence_Concat(PyObject *o1, PyObject *o2);

       /*
     Return the concatenation of o1 and o2 on success, and NULL on
     failure.   This is the equivalent of the Python
     expression: o1+o2.
       