(Py_buffer *view, void *buf,
                                             Py_ssize_t len, char order);


    /* Copy len bytes of data from the contiguous chunk of memory
       pointed to by buf into the buffer exported by obj.  Return
       0 on success and return -1 and raise a PyBuffer_Error on
       error (i.e. the object does not have a buffer interface or
       it is not working).

       If fort is 'F', then if the object is multi-dimensional,
       then the data will be copied into the array in
       Fortran-style (first dimension varies the fastest).  If
       fort is 'C', then the data will be copied into the array
       in C-style (last dimension varies the fastest).  If fort
       is 'A', then it does not matter and the copy will be made
       in whatever way is more efficient.

    */

     PyAPI_FUNC(int) PyObject_CopyData(PyObject *dest, PyObject *src);

    /* Copy the data from the src buffer to the buffer of destination
     */

     PyAPI_FUNC(int) PyBuffer_IsContiguous(const Py_buffer *view, char fort);


     PyAPI_FUNC(void) PyBuffer_FillContiguousStrides(int ndims,
                                                    Py_ssize_t *shape,
                                                    Py_ssize_t *strides,
                                                    int itemsize,
                                                    char fort);

    /*  Fill the strides array with byte-strides of a contiguous
        (Fortran-style if fort is 'F' or C-style otherwise)
        array of the given shape with the given number of bytes
        per element.
    */

     PyAPI_FUNC(int) PyBuffer_FillInfo(Py_buffer *view, PyObject *o, void *buf,
                                       Py_ssize_t len, int readonly,
                                       int flags);

    /* Fills in a buffer-info structure correctly for an exporter
       that can only share a contiguous chunk of memory of
       "unsigned bytes" of the given length. Returns 0 on success
       and -1 (with raising an error) on error.
     */

     PyAPI_FUNC(void) PyBuffer_Release(Py_buffer *view);

       /* Releases a Py_buffer obtained from getbuffer ParseTuple's s*.
    */
#endif /* Py_LIMITED_API */

     PyAPI_FUNC(PyObject *) PyObject_Format(PyObject* obj,
                                            PyObject *format_spec);
       /*
     Takes an arbitrary object and returns the result of
     calling obj.__format__(format_spec).
       */

/* Iterators */

     PyAPI_FUNC(PyObject *) PyObject_GetIter(PyObject *);
     /* Takes an object and returns an iterator for it.
    This is typically a new iterator but if the argument
    is an iterator, this returns itself. */

#define PyIter_Check(obj) \
    ((obj)->ob_type->tp_iternext != NULL && \
     (obj)->ob_type->tp_iternext != &_PyObject_NextNotImplemented)

     PyAPI_FUNC(PyObject *) PyIter_Next(PyObject *);
     /* Takes an iterator object and calls its tp_iternext slot,
    returning the next value.  If the iterator is exhausted,
    this returns NULL without setting an exception.
    NULL with an exception means an error occurred. */

/*  Number Protocol:*/

     PyAPI_FUNC(int) PyNumber_Check(PyObject *o);

       /*
     Returns 1 if the object, o, provides numeric protocols, and
     false otherwise.

     This function always succeeds.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Add(PyObject *o1, PyObject *o2);

       /*
     Returns the result of adding o1 and o2, or null on failure.
     This is the equivalent of the Python expression: o1+o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Subtract(PyObject *o1, PyObject *o2);

       /*
     Returns the result of subtracting o2 from o1, or null on
     failure.  This is the equivalent of the Python expression:
     o1-o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Multiply(PyObject *o1, PyObject *o2);

       /*
     Returns the result of multiplying o1 and o2, or null on
     failure.  This is the equivalent of the Python expression:
     o1*o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_MatrixMultiply(PyObject *o1, PyObject *o2);

       /*
     This is the equivalent of the Python expression: o1 @ o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_FloorDivide(PyObject *o1, PyObject *o2);

       /*
     Returns the result of dividing o1 by o2 giving an integral result,
     or null on failure.
     This is the equivalent of the Python expression: o1//o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_TrueDivide(PyObject *o1, PyObject *o2);

       /*
     Returns the result of dividing o1 by o2 giving a float result,
     or null on failure.
     This is the equivalent of the Python expression: o1/o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Remainder(PyObject *o1, PyObject *o2);

       /*
     Returns the remainder of dividing o1 by o2, or null on
     failure.  This is the equivalent of the Python expression:
     o1%o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Divmod(PyObject *o1, PyObject *o2);

       /*
     See the built-in function divmod.  Returns NULL on failure.
     This is the equivalent of the Python expression:
     divmod(o1,o2).
       */

     PyAPI_FUNC(PyObject *) PyNumber_Power(PyObject *o1, PyObject *o2,
                                           PyObject *o3);

       /*
     See the built-in function pow.  Returns NULL on failure.
     This is the equivalent of the Python expression:
     pow(o1,o2,o3), where o3 is optional.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Negative(PyObject *o);

       /*
     Returns the negation of o on success, or null on failure.
     This is the equivalent of the Python expression: -o.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Positive(PyObject *o);

       /*
     Returns the (what?) of o on success, or NULL on failure.
     This is the equivalent of the Python expression: +o.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Absolute(PyObject *o);

       /*
     Returns the absolute value of o, or null on failure.  This is
     the equivalent of the Python expression: abs(o).
       */

     PyAPI_FUNC(PyObject *) PyNumber_Invert(PyObject *o);

       /*
     Returns the bitwise negation of o on success, or NULL on
     failure.  This is the equivalent of the Python expression:
     ~o.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Lshift(PyObject *o1, PyObject *o2);

       /*
     Returns the result of left shifting o1 by o2 on success, or
     NULL on failure.  This is the equivalent of the Python
     expression: o1 << o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_Rshift(PyObject *o1, PyObject *o2);

       /*
     Returns the result of right shifting o1 by o2 on success, or
     NULL on failure.  This is the equivalent of the Python
     expression: o1 >> o2.
       */

     PyAPI_FUNC(PyObject *) PyNumber_And(PyObject *o1, PyObject *o2);

       /*
     Returns the result of bitwise and of o1 and o2 on success, or
     NULL on failure. This is the equivalent of the Python
     expression: o1&o2.

       */

     PyAPI_FUNC(PyObject *) PyNumber_Xor(PyObject *o1, PyObject *o2);

       /*
     Returns the bitwise exclusive or of