hon expression: o(*args).
       */


     PyAPI_FUNC(PyObject *) PyObject_CallMethodObjArgs(PyObject *o,
                                                       PyObject *method, ...);
     PyAPI_FUNC(PyObject *) _PyObject_CallMethodIdObjArgs(PyObject *o,
                                               struct _Py_Identifier *method,
                                               ...);

       /*
     Call the method named m of object o with a variable number of
     C arguments.  The C arguments are provided as PyObject *
     values, terminated by NULL.  Returns the result of the call
     on success, or NULL on failure.  This is the equivalent of
     the Python expression: o.method(args).
       */


     /* Implemented elsewhere:

     long PyObject_Hash(PyObject *o);

     Compute and return the hash, hash_value, of an object, o.  On
     failure, return -1.  This is the equivalent of the Python
     expression: hash(o).
       */


     /* Implemented elsewhere:

     int PyObject_IsTrue(PyObject *o);

     Returns 1 if the object, o, is considered to be true, 0 if o is
     considered to be false and -1 on failure. This is equivalent to the
     Python expression: not not o
       */

     /* Implemented elsewhere:

     int PyObject_Not(PyObject *o);

     Returns 0 if the object, o, is considered to be true, 1 if o is
     considered to be false and -1 on failure. This is equivalent to the
     Python expression: not o
       */

     PyAPI_FUNC(PyObject *) PyObject_Type(PyObject *o);

       /*
     On success, returns a type object corresponding to the object
     type of object o. On failure, returns NULL.  This is
     equivalent to the Python expression: type(o).
       */

     PyAPI_FUNC(Py_ssize_t) PyObject_Size(PyObject *o);

       /*
     Return the size of object o.  If the object, o, provides
     both sequence and mapping protocols, the sequence size is
     returned. On error, -1 is returned.  This is the equivalent
     to the Python expression: len(o).
       */

       /* For DLL compatibility */
#undef PyObject_Length
     PyAPI_FUNC(Py_ssize_t) PyObject_Length(PyObject *o);
#define PyObject_Length PyObject_Size

#ifndef Py_LIMITED_API
     PyAPI_FUNC(int) _PyObject_HasLen(PyObject *o);
     PyAPI_FUNC(Py_ssize_t) PyObject_LengthHint(PyObject *o, Py_ssize_t);
#endif

       /*
     Guess the size of object o using len(o) or o.__length_hint__().
     If neither of those return a non-negative value, then return the
     default value.  If one of the calls fails, this function returns -1.
       */

     PyAPI_FUNC(PyObject *) PyObject_GetItem(PyObject *o, PyObject *key);

       /*
     Return element of o corresponding to the object, key, or NULL
     on failure. This is the equivalent of the Python expression:
     o[key].
       */

     PyAPI_FUNC(int) PyObject_SetItem(PyObject *o, PyObject *key, PyObject *v);

       /*
     Map the object key to the value v.  Raise an exception and return -1
     on failure; return 0 on success.  This is the equivalent of the Python
     statement o[key]=v.
       */

     PyAPI_FUNC(int) PyObject_DelItemString(PyObject *o, const char *key);

       /*
     Remove the mapping for object, key, from the object *o.
     Returns -1 on failure.  This is equivalent to
     the Python statement: del o[key].
       */

     PyAPI_FUNC(int) PyObject_DelItem(PyObject *o, PyObject *key);

       /*
     Delete the mapping for key from *o.  Returns -1 on failure.
     This is the equivalent of the Python statement: del o[key].
       */

    /* old buffer API
       FIXME:  usage of these should all be replaced in Python itself
       but for backwards compatibility we will implement them.
       Their usage without a corresponding "unlock" mechanism
       may create issues (but they would already be there). */

     PyAPI_FUNC(int) PyObject_AsCharBuffer(PyObject *obj,
                                           const char **buffer,
                                           Py_ssize_t *buffer_len);

       /*
      Takes an arbitrary object which must support the (character,
      single segment) buffer interface and returns a pointer to a
      read-only memory location useable as character based input
      for subsequent processing.

      0 is returned on success.  buffer and buffer_len are only
      set in case no error occurs. Otherwise, -1 is returned and
      an exception set.
       */

     PyAPI_FUNC(int) PyObject_CheckReadBuffer(PyObject *obj);

      /*
      Checks whether an arbitrary object supports the (character,
      single segment) buffer interface.  Returns 1 on success, 0
      on failure.
      */

     PyAPI_FUNC(int) PyObject_AsReadBuffer(PyObject *obj,
                                           const void **buffer,
                                           Py_ssize_t *buffer_len);

       /*
      Same as PyObject_AsCharBuffer() except that this API expects
      (readable, single segment) buffer interface and returns a
      pointer to a read-only memory location which can contain
      arbitrary data.

      0 is returned on success.  buffer and buffer_len are only
      set in case no error occurs.  Otherwise, -1 is returned and
      an exception set.
       */

     PyAPI_FUNC(int) PyObject_AsWriteBuffer(PyObject *obj,
                                            void **buffer,
                                            Py_ssize_t *buffer_len);

       /*
      Takes an arbitrary object which must support the (writable,
      single segment) buffer interface and returns a pointer to a
      writable memory location in buffer of size buffer_len.

      0 is returned on success.  buffer and buffer_len are only
      set in case no error occurs. Otherwise, -1 is returned and
      an exception set.
       */

    /* new buffer API */

#ifndef Py_LIMITED_API
#define PyObject_CheckBuffer(obj) \
    (((obj)->ob_type->tp_as_buffer != NULL) &&  \
     ((obj)->ob_type->tp_as_buffer->bf_getbuffer != NULL))

    /* Return 1 if the getbuffer function is available, otherwise
       return 0 */

     PyAPI_FUNC(int) PyObject_GetBuffer(PyObject *obj, Py_buffer *view,
                                        int flags);

    /* This is a C-API version of the getbuffer function call.  It checks
       to make sure object has the required function pointer and issues the
       call.  Returns -1 and raises an error on failure and returns 0 on
       success
    */


     PyAPI_FUNC(void *) PyBuffer_GetPointer(Py_buffer *view, Py_ssize_t *indices);

    /* Get the memory area pointed to by the indices for the buffer given.
       Note that view->ndim is the assumed size of indices
    */

     PyAPI_FUNC(int) PyBuffer_SizeFromFormat(const char *);

    /* Return the implied itemsize of the data-format area from a
       struct-style description */



     /* Implementation in memoryobject.c */
     PyAPI_FUNC(int) PyBuffer_ToContiguous(void *buf, Py_buffer *view,
                                           Py_ssiz