nts *arguments_ty;

typedef struct _arg *arg_ty;

typedef struct _keyword *keyword_ty;

typedef struct _alias *alias_ty;

typedef struct _withitem *withitem_ty;

typedef struct _type_ignore *type_ignore_ty;


enum _mod_kind {Module_kind=1, Interactive_kind=2, Expression_kind=3,
                 FunctionType_kind=4};
struct _mod {
    enum _mod_kind kind;
    union {
        struct {
            asdl_seq *body;
            asdl_seq *type_ignores;
        } Module;

        struct {
            asdl_seq *body;
        } Interactive;

        struct {
            expr_ty body;
        } Expression;

        struct {
            asdl_seq *argtypes;
            expr_ty returns;
        } FunctionType;

    } v;
};

enum _stmt_kind {FunctionDef_kind=1, AsyncFunctionDef_kind=2, ClassDef_kind=3,
                  Return_kind=4, Delete_kind=5, Assign_kind=6,
                  AugAssign_kind=7, AnnAssign_kind=8, For_kind=9,
                  AsyncFor_kind=10, While_kind=11, If_kind=12, With_kind=13,
                  AsyncWith_kind=14, Raise_kind=15, Try_kind=16,
                  Assert_kind=17, Import_kind=18, ImportFrom_kind=19,
                  Global_kind=20, Nonlocal_kind=21, Expr_kind=22, Pass_kind=23,
                  Break_kind=24, Continue_kind=25};
struct _stmt {
    enum _stmt_kind kind;
    union {
        struct {
            identifier name;
            arguments_ty args;
            asdl_seq *body;
            asdl_seq *decorator_list;
            expr_ty returns;
            string type_comment;
        } FunctionDef;

        struct {
            identifier name;
            arguments_ty args;
            asdl_seq *body;
            asdl_seq *decorator_list;
            expr_ty returns;
            string type_comment;
        } AsyncFunctionDef;

        struct {
            identifier name;
            asdl_seq *bases;
            asdl_seq *keywords;
            asdl_seq *body;
            asdl_seq *decorator_list;
        } ClassDef;

        struct {
            expr_ty value;
        } Return;

        struct {
            asdl_seq *targets;
        } Delete;

        struct {
            asdl_seq *targets;
            expr_ty value;
            string type_comment;
        } Assign;

        struct {
            expr_ty target;
            operator_ty op;
            expr_ty value;
        } AugAssign;

        struct {
            expr_ty target;
            expr_ty annotation;
            expr_ty value;
            int simple;
        } AnnAssign;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_seq *body;
            asdl_seq *orelse;
            string type_comment;
        } For;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_seq *body;
            asdl_seq *orelse;
            string type_comment;
        } AsyncFor;

        struct {
            expr_ty test;
            asdl_seq *body;
            asdl_seq *orelse;
        } While;

        struct {
            expr_ty test;
            asdl_seq *body;
            asdl_seq *orelse;
        } If;

        struct {
            asdl_seq *items;
            asdl_seq *body;
            string type_comment;
        } With;

        struct {
            asdl_seq *items;
            asdl_seq *body;
            string type_comment;
        } AsyncWith;

        struct {
            expr_ty exc;
            expr_ty cause;
        } Raise;

        struct {
            asdl_seq *body;
            asdl_seq *handlers;
            asdl_seq *orelse;
            asdl_seq *finalbody;
        } Try;

        struct {
            expr_ty test;
            expr_ty msg;
        } Assert;

        struct {
            asdl_seq *names;
        } Import;

        struct {
            identifier module;
            asdl_seq *names;
            int level;
        } ImportF