at otherwise treat
  objects generically.

Memory Management

  For all of the functions described in this proposal, if a function
  retains a reference to a Python object passed as an argument, then the
  function will increase the reference count of the object.  It is
  unnecessary for the caller to increase the reference count of an
  argument in anticipation of the object's retention.

  All Python objects returned from functions should be treated as new
  objects.  Functions that return objects assume that the caller will
  retain a reference and the reference count of the object has already
  been incremented to account for this fact.  A caller that does not
  retain a reference to an object that is returned from a function
  must decrement the reference count of the object (using
  DECREF(object)) to prevent memory leaks.

  Note that the behavior mentioned here is different from the current
  behavior for some objects (e.g. lists and tuples) when certain
  type-specific routines are called directly (e.g. setlistitem).  The
  proposed abstraction layer will provide a consistent memory
  management interface, correcting for inconsistent behavior for some
  built-in types.

Protocols

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/

/*  Object Protocol: */

     /* Implemented elsewhere:

     int PyObject_Print(PyObject *o, FILE *fp, int flags);

     Print an object, o, on file, fp.  Returns -1 on
     error.  The flags argument is used to enable certain printing
     options. The only option currently supported is Py_Print_RAW.

     (What should be said about Py_Print_RAW?)

       */

     /* Implemented elsewhere:

     int PyObject_HasAttrString(PyObject *o, const char *attr_name);

     Returns 1 if o has the attribute attr_name, and 0 otherwise.
     This is equivalent to the Python expression:
     hasattr(o,attr_name).

     This function always succeeds.

       */

     /* Implemented elsewhere:

     PyObject* PyObject_GetAttrString(PyObject *o, const char *attr_name);

     Retrieve an attributed named attr_name form object o.
     Returns the attribute value on success, or NULL on failure.
     This is the equivalent of the Python expression: o.attr_name.

       */

     /* Implemented elsewhere:

     int PyObject_HasAttr(PyObject *o, PyObject *attr_name);

     Returns 1 if o has the attribute attr_name, and 0 otherwise.
     This is equivalent to the Python expression:
     hasattr(o,attr_name).

     This function always succeeds.

       */

     /* Implemented elsewhere:

     PyObject* PyObject_GetAttr(PyObject *o, PyObject *attr_name);

     Retrieve an attributed named attr_name form object o.
     Returns the attribute value on success, or NULL on failure.
     This is the equivalent of the Python expression: o.attr_name.

       */


     /* Implemented elsewhere:

     int PyObject_SetAttrString(PyObject *o, const char *attr_name, PyObject *v);

     Set the value of the attribute named attr_name, for object o,
     to the value v. Raise an exception and return -1 on failure; return 0 on
     success.  This is the equivalent of the Python statement o.attr_name=v.

       */

     /* Implemented elsewhere:

     int PyObject_SetAttr(PyObject *o, PyObject *attr_name, PyObject *v);

     Set the value of the attribute named attr_name, for object o,
     to the value v. Raise an exception and return -1 on failure; return 0 on
     success.  This is the equivalent of the Python statement o.attr_name=v.

       */

     /* implemented as a macro:

     int PyObject_DelAttrString(PyObject *o, const char *attr_name);

     Delete attribute named attr_name, for object o. Returns
     -1 on failure.  This is the equivalent of the Python
     statement: del o.attr_name.

       */
#define  PyObject_DelAttrString(O,A) PyObject_SetAttrString((O),(A),NULL)

     /* implemented as a macro:

     int PyObject_DelAttr(PyObject *o, PyObject *attr_name);

     Delete attribute named attr_name, for object o. Returns -1
     on failure.  This is the equivalent of the Python
     statement: del o.attr_name.

       */
#define  PyObject_DelAttr(O,A) PyObject_SetAttr((O),(A),NULL)

     /* Implemented elsewhere:

     PyObject *PyObject_Repr(PyObject *o);

     Compute the string representation of object, o.  Returns the
     string representation on success, NULL on failure.  This is
     the equivalent of the Python expression: repr(o).

     Called by the repr() built-in function.

       */

     /* Implemented elsewhere:

     PyObject *PyObject_Str(PyObject *o);

     Compute the string representation of object, o.  Returns the
     string representation on success, NULL on failure.  This is
     the equivalent of the Python expression: str(o).)

     Called by the str() and print() built-in functions.

       */

       /* Declared elsewhere

     PyAPI_FUNC(int) PyCallable_Check(PyObject *o);

     Determine if the object, o, is callable.  Return 1 if the
     object is callable and 0 otherwise.

     This function always succeeds.
       */

     PyAPI_FUNC(PyObject *) PyObject_Call(PyObject *callable_object,
                                          PyObject *args, PyObject *kw);

       /*
     Call a callable Python object, callable_object, with
     arguments and keywords arguments.  The 'args' argument can not be
     NULL, but the 'kw' argument can be NULL.
       */

#ifndef Py_LIMITED_API
     PyAPI_FUNC(PyObject *) _Py_CheckFunctionResult(PyObject *func,
                                                    PyObject *result,
                                                    const char *where);
#endif

     PyAPI_FUNC(PyObject *) PyObject_CallObject(PyObject *callable_object,
                                                PyObject *args);

       /*
     Call a callable Python object, callable_object, with
     arguments given by the tuple, args.  If no arguments are
     needed, then args may be NULL.  Returns th