ze_t count);

       /*
     Return the result of repeating sequence object o count times,
     or NULL on failure.  This is the equivalent of the Python
     expression: o1*count.
       */

     PyAPI_FUNC(PyObject *) PySequence_GetItem(PyObject *o, Py_ssize_t i);

       /*
     Return the ith element of o, or NULL on failure. This is the
     equivalent of the Python expression: o[i].
       */

     PyAPI_FUNC(PyObject *) PySequence_GetSlice(PyObject *o, Py_ssize_t i1, Py_ssize_t i2);

       /*
     Return the slice of sequence object o between i1 and i2, or
     NULL on failure. This is the equivalent of the Python
     expression: o[i1:i2].
       */

     PyAPI_FUNC(int) PySequence_SetItem(PyObject *o, Py_ssize_t i, PyObject *v);

       /*
     Assign object v to the ith element of o.  Raise an exception and return
     -1 on failure; return 0 on success.  This is the equivalent of the
     Python statement o[i]=v.
       */

     PyAPI_FUNC(int) PySequence_DelItem(PyObject *o, Py_ssize_t i);

       /*
     Delete the ith element of object v.  Returns
     -1 on failure.  This is the equivalent of the Python
     statement: del o[i].
       */

     PyAPI_FUNC(int) PySequence_SetSlice(PyObject *o, Py_ssize_t i1, Py_ssize_t i2,
                                         PyObject *v);

       /*
     Assign the sequence object, v, to the slice in sequence
     object, o, from i1 to i2.  Returns -1 on failure. This is the
     equivalent of the Python statement: o[i1:i2]=v.
       */

     PyAPI_FUNC(int) PySequence_DelSlice(PyObject *o, Py_ssize_t i1, Py_ssize_t i2);

       /*
     Delete the slice in sequence object, o, from i1 to i2.
     Returns -1 on failure. This is the equivalent of the Python
     statement: del o[i1:i2].
       */

     PyAPI_FUNC(PyObject *) PySequence_Tuple(PyObject *o);

       /*
     Returns the sequence, o, as a tuple on success, and NULL on failure.
     This is equivalent to the Python expression: tuple(o)
       */


     PyAPI_FUNC(PyObject *) PySequence_List(PyObject *o);
       /*
     Returns the sequence, o, as a list on success, and NULL on failure.
     This is equivalent to the Python expression: list(o)
       */

     PyAPI_FUNC(PyObject *) PySequence_Fast(PyObject *o, const char* m);
       /*
     Return the sequence, o, as a list, unless it's already a
     tuple or list.  Use PySequence_Fast_GET_ITEM to access the
     members of this list, and PySequence_Fast_GET_SIZE to get its length.

     Returns NULL on failure.  If the object does not support iteration,
     raises a TypeError exception with m as the message text.
       */

#define PySequence_Fast_GET_SIZE(o) \
    (PyList_Check(o) ? PyList_GET_SIZE(o) : PyTuple_GET_SIZE(o))
       /*
     Return the size of o, assuming that o was returned by
     PySequence_Fast and is not NULL.
       */

#define PySequence_Fast_GET_ITEM(o, i)\
     (PyList_Check(o) ? PyList_GET_ITEM(o, i) : PyTuple_GET_ITEM(o, i))
       /*
     Return the ith element of o, assuming that o was returned by
     PySequence_Fast, and that i is within bounds.
       */

#define PySequence_ITEM(o, i)\
    ( Py_TYPE(o)->tp_as_sequence->sq_item(o, i) )
       /* Assume tp_as_sequence and sq_item exist and that i does not
      need to be corrected for a negative index
       */

#define PySequence_Fast_ITEMS(sf) \
    (PyList_Check(sf) ? ((PyListObject *)(sf))->ob_item \
                      : ((PyTupleObject *)(sf))->ob_item)
    /* Return a pointer to the underlying item array for
       an object retured by PySequence_Fast */

     PyAPI_FUNC(Py_ssize_t) PySequence_Count(PyObject *o, PyObject *value);

       /*
     Return the number of occurrences on value on o, that is,
     return the number of keys for which o[key]==value.  On
     failure, return -1.  This is equivalent to the Python
     expression: o.count(value).
       */

     PyAPI_FUNC(int) PySequence_Contains(PyObject *seq, PyObject *ob);
       /*
     Return -1 if error; 1 if ob in seq; 0 if ob not in seq.
     Use __contains__ if possible, else _PySequence_IterSearch().
       */

#ifndef Py_LIMITED_API
#define PY_ITERSEARCH_COUNT    1
#define PY_ITERSEARCH_INDEX    2
#define PY_ITERSEARCH_CONTAINS 3
     PyAPI_FUNC(Py_ssize_t) _PySequence_IterSearch(PyObject *seq,
                                        PyObject *obj, int operation);
#endif
    /*
      Iterate over seq.  Result depends on the operation:
      PY_ITERSEARCH_COUNT:  return # of times obj appears in seq; -1 if
        error.
      PY_ITERSEARCH_INDEX:  return 0-based index of first occurrence of
        obj in seq; set ValueError and return -1 if none found;
        also return -1 on error.
      PY_ITERSEARCH_CONTAINS:  return 1 if obj in seq, else 0; -1 on
        error.
    */

/* For DLL-level backwards compatibility */
#undef PySequence_In
     PyAPI_FUNC(int) PySequence_In(PyObject *o, PyObject *value);

/* For source-level backwards compatibility */
#define PySequence_In PySequence_Contains

       /*
     Determine if o contains value.  If an item in o is equal to
     X, return 1, otherwise return 0.  On error, return -1.  This
     is equivalent to the Python expression: value in o.
       */

     PyAPI_FUNC(Py_ssize_t) PySequence_Index(PyObject *o, PyObject *value);

       /*
     Return the first index for which o[i]=value.  On error,
     return -1.    This is equivalent to the Python
     expression: o.index(value).
       */

/* In-place versions of some of the above Sequence functions. */

     PyAPI_FUNC(PyObject *) PySequence_InPlaceConcat(PyObject *o1, PyObject *o2);

       /*
     Append o2 to o1, in-place when possible. Return the resulting
     object, which could be o1, or NULL on failure.  This is the
     equivalent of the Python expression: o1 += o2.

       */

     PyAPI_FUNC(PyObject *) PySequence_InPlaceRepeat(PyObject *o, Py_ssize_t count);

       /*
     Repeat o1 by count, in-place when possible. Return the resulting
     object, which could be o1, or NULL on failure.  This is the
     equivalent of the Python expression: o1 *= count.

       */

/*  Mapping protocol:*/

     PyAPI_FUNC(int) PyMapping_Check(PyObject *o);

       /*
     Return 1 if the object provides mapping protocol, and zero
     otherwise.

     This function always succeeds.
       */

     PyAPI_FUNC(Py_ssize_t) PyMapping_Size(PyObject *o);

       /*
     Returns the number of keys in object o on success, and -1 on
     failure.  For objects that do not provide sequence protocol,
     this is equivalent to the Python expression: len(o).
       */

       /* For DLL compatibility */
#undef PyMapping_Length
     PyAPI_FUNC(Py_ssize_t) PyMapping_Length(PyObject *o);
#define PyMapping_Length PyMapping_Size


     /* implemented as a macro:

     int PyMapping_DelItemString(PyObject *o, const char *key);

     Remove the mapping for object, key, from the object *o.
     Returns -1 on failure.  This is equivalent to
     the Python statement: del o[key].
       */
#define PyMapping_DelItemString(O,K) PyObject_DelItemString((O),(K))

     /* implemented as a macro:

     int PyMapping_DelItem(PyObject *o, PyObject *key);

     Remove the mapping for object, key, from the object *o.
     Returns -1 on failure.  This is equivalent to
     the Python statement: del o[key].
       */
#define PyMapping_DelItem(O,K) PyObject_DelItem((O),(K))

     PyAPI_FUNC(int) PyMapping_HasKeyString(PyObject *o, const char *key);

       /*
     On success, return 1 if the mapping object has the key, key,
     and 0 otherwise.  This is equivalent to the Python expression:
     key in o.

     This function always succeeds.
       */

     PyAPI_FUNC(int) PyMapping_HasKey(PyObject *o, PyObject *key);

       /*
     Return 1 if the mapping object has the key, key,
     and 0 otherwise.  This is equivalent to the Python expression:
     key in o.

     This function always succeeds.

       */

     PyAPI_FUNC(PyObject *) PyMapping_Keys(PyObject *o);

       /*
     On success, return a list or tuple of the keys in object o.
     On failure, return NULL.
       */

     PyAPI_FUNC(PyObject *) PyMapping_Values(PyObject *o);

       /*
     On success, return a list or tuple of the values in object o.
     On failure, return NULL.
       */

     PyAPI_FUNC(PyObject *) PyMapping_Items(PyObject *o);

       /*
     On success, return a list or tuple of the items in object o,
     where each item is a tuple containing a key-value pair.
     On failure, return NULL.

       */

     PyAPI_FUNC(PyObject *) PyMapping_GetItemString(PyObject *o,
                                                    const char *key);

       /*
     Return element of o corresponding to the object, key, or NULL
     on failure. This is the equivalent of the Python expression:
     o[key].
       */

     PyAPI_FUNC(int) PyMapping_SetItemString(PyObject *o, const char *key,
                                            PyObject *value);

       /*
     Map the object, key, to the value, v.  Returns
     -1 on failure.  This is the equivalent of the Python
     statement: o[key]=v.
      */


PyAPI_FUNC(int) PyObject_IsInstance(PyObject *object, PyObject *typeorclass);
      /* isinstance(object, typeorclass) */

PyAPI_FUNC(int) PyObject_IsSubclass(PyObject *object, PyObject *typeorclass);
      /* issubclass(object, typeorclass) */


#ifndef Py_LIMITED_API
PyAPI_FUNC(int) _PyObject_RealIsInstance(PyObject *inst, PyObject *cls);

PyAPI_FUNC(int) _PyObject_RealIsSubclass(PyObject *derived, PyObject *cls);

PyAPI_FUNC(char *const *) _PySequence_BytesToCharpArray(PyObject* self);

PyAPI_FUNC(void) _Py_FreeCharPArray(char *const array[]);
#endif

/* For internal use by buffer API functions */
PyAPI_FUNC(void) _Py_add_one_to_index_F(int nd, Py_ssize_t *index,
                                        const Py_ssize_t *shape);
PyAPI_FUNC(void) _Py_add_one_to_index_C(int nd, Py_ssize_t *index,
                                        const Py_ssize_t *shape);


#ifdef __cplusplus
}
#endif
#endif /* Py_ABSTRACTOBJECT_H */
PK       ! EF@      python3.5m/modsupport.hnu [        
#ifndef Py_MODSUPPORT_H
#define Py_MODSUPPORT_H
#ifdef __cplusplus
extern "C" {
#endif

/* Module support interface */

#include <stdarg.h>

/* If PY_SSIZE_T_CLEAN is defined, each functions treats #-specifier
   to mean Py_ssize_t */
#ifdef PY_SSIZE_T_CLEAN
#define PyArg_Parse                     _PyArg_Parse_SizeT
#define PyArg_ParseTuple                _PyArg_ParseTuple_SizeT
#define PyArg_ParseTupleAndKeywords     _PyArg_ParseTupleAndKeywords_SizeT
#define PyArg_VaParse                   _PyArg_VaParse_SizeT
#define PyArg_VaParseTupleAndKeywords   _PyArg_VaParseTupleAndKeywords_SizeT
#define Py_BuildValue                   _Py_BuildValue_SizeT
#define Py_VaBuildValue                 _Py_VaBuildValue_SizeT
#else
PyAPI_FUNC(PyObject *) _Py_VaBuildValue_SizeT(const char *, va_list);
#endif

/* Due to a glitch in 3.2, the _SizeT versions weren't exported from the DLL. */
#if !defined(PY_SSIZE_T_CLEAN) || !defined(Py_LIMITED_API) || Py_LIMITED_API+0 >= 0x03030000
PyAPI_FUNC(int) PyArg_Parse(PyObject *, const char *, ...);
PyAPI_FUNC(int) PyArg_ParseTuple(PyObject *, const char *, ...);
PyAPI_FUNC(int) PyArg_ParseTupleAndKeywords(PyObject *, PyObject *,
                                                  const char *, char **, ...);
PyAPI_FUNC(int) PyArg_VaParse(PyObject *, const char *, va_list);
PyAPI_FUNC(int) PyArg_VaParseTupleAndKeywords(PyObject *, PyObject *,
                                                  const char *, char **, va_list);
#endif
PyAPI_FUNC(int) PyArg_ValidateKeywordArguments(PyObject *);
PyAPI_FUNC(int) PyArg_UnpackTuple(PyObject *, const char *, Py_ssize_t, Py_ssize_t, ...);
PyAPI_FUNC(PyObject *) Py_BuildValue(const char *, ...);
PyAPI_FUNC(PyObject *) _Py_BuildValue_SizeT(const char *, ...);

#ifndef Py_LIMITED_API
PyAPI_FUNC(int) _PyArg_NoKeywords(const char *funcname, PyObject *kw);
PyAPI_FUNC(int) _PyArg_NoPositional(const char *funcname, PyObject *args);
#endif
PyAPI_FUNC(PyObject *) Py_VaBuildValue(const char *, va_list);

PyAPI_FUNC(int) PyModule_AddObject(PyObject *, const char *, PyObject *);
PyAPI_FUNC(int) PyModule_AddIntConstant(PyObject *, const char *, long);
PyAPI_FUNC(int) PyModule_AddStringConstant(PyObject *, const char *, const char *);
#define PyModule_AddIntMacro(m, c) PyModule_AddIntConstant(m, #c, c)
#define PyModule_AddStringMacro(m, c) PyModule_AddStringConstant(m, #c, c)

#if !defined(Py_LIMITED_API) || Py_LIMITED_API+0 >= 0x03050000
/* New in 3.5 */
PyAPI_FUNC(int) PyModule_SetDocString(PyObject *, const char *);
PyAPI_FUNC(int) PyModule_AddFunctions(PyObject *, PyMethodDef *);
PyAPI_FUNC(int) PyModule_ExecDef(PyObject *module, PyModuleDef *def);
#endif

#define Py_CLEANUP_SUPPORTED 0x20000

#define PYTHON_API_VERSION 1013
#define PYTHON_API_STRING "1013"
/* The API version is maintained (independently from the Python version)
   so we can detect mismatches between the interpreter and dynamically
   loaded modules.  These are diagnosed by an error message but
   the module is still loaded (because the mismatch can only be tested
   after loading the module).  The error message is intended to
   explain the core dump a few seconds later.

   The symbol PYTHON_API_STRING defines the same value as a string
   literal.  *** PLEASE MAKE SURE THE DEFINITIONS MATCH. ***

   Please add a line or two to the top of this log for each API
   version change:

   22-Feb-2006  MvL     1013    PEP 353 - long indices for sequence lengths

   19-Aug-2002  GvR     1012    Changes to string object struct for
                                interning changes, saving 3 bytes.

   17-Jul-2001  GvR     1011    Descr-branch, just to be on the safe side

   25-Jan-2001  FLD     1010    Parameters added to PyCode_New() and
                                PyFrame_New(); Python 2.1a2

   14-Mar-2000  GvR     1009    Unicode API added

   3-Jan-1999   GvR     1007    Decided to change back!  (Don't reuse 1008!)

   3-Dec-1998   GvR     1008    Python 1.5.2b1

   18-Jan-1997  GvR     1007    string interning and other speedups

   11-Oct-1996  GvR     renamed Py_Ellipses to Py_Ellipsis :-(

   30-Jul-1996  GvR     Slice and ellipses syntax added

   23-Jul-1996  GvR     For 1.4 -- better safe than sorry this time :-)

   7-Nov-1995   GvR     Keyword arguments (should've been done at 1.3 :-( )

   10-Jan-1995  GvR     Renamed globals to new naming scheme

   9-Jan-1995   GvR     Initial version (incompatible with older API)
*/

/* The PYTHON_ABI_VERSION is introduced in PEP 384. For the lifetime of
   Python 3, it will stay at the value of 3; changes to the limited API
   must be performed in a strictly backwards-compatible manner. */
#define PYTHON_ABI_VERSION 3
#define PYTHON_ABI_STRING "3"

#ifdef Py_TRACE_REFS
 /* When we are tracing reference counts, rename module creation functions so
    modules compiled with incompatible settings will generate a
    link-time error. */
 #define PyModule_Create2 PyModule_Create2TraceRefs
 #define PyModule_FromDefAndSpec2 PyModule_FromDefAndSpec2TraceRefs
#endif

PyAPI_FUNC(PyObject *) PyModule_Create2(struct PyModuleDef*,
                                     int apiver);

#ifdef Py_LIMITED_API
#define PyModule_Create(module) \
        PyModule_Create2(module, PYTHON_ABI_VERSION)
#else
#define PyModule_Create(module) \
        PyModule_Create2(module, PYTHON_API_VERSION)
#endif

#if !defined(Py_LIMITED_API) || Py_LIMITED_API+0 >= 0x03050000
/* New in 3.5 */
PyAPI_FUNC(PyObject *) PyModule_FromDefAndSpec2(PyModuleDef *def,
                                                PyObject *spec,
                                                int module_api_version);

#ifdef Py_LIMITED_API
#define PyModule_FromDefAndSpec(module, spec) \
    PyModule_FromDefAndSpec2(module, spec, PYTHON_ABI_VERSION)
#else
#define PyModule_FromDefAndSpec(module, spec) \
    PyModule_FromDefAndSpec2(module, spec, PYTHON_API_VERSION)
#endif /* Py_LIMITED_API */
#endif /* New in 3.5 */

#ifndef Py_LIMITED_API
PyAPI_DATA(char *) _Py_PackageContext;
#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_MODSUPPORT_H */
PK       !         python3.5m/enumobject.hnu [        #ifndef Py_ENUMOBJECT_H
#define Py_ENUMOBJECT_H

/* Enumerate Object */

#ifdef __cplusplus
extern "C" {
#endif

PyAPI_DATA(PyTypeObject) PyEnum_Type;
PyAPI_DATA(PyTypeObject) PyReversed_Type;

#ifdef __cplusplus
}
#endif

#endif /* !Py_ENUMOBJECT_H */
PK       ! 5.n=  =    python3.5m/fileutils.hnu [        #ifndef Py_FILEUTILS_H
#define Py_FILEUTILS_H

#ifdef __cplusplus
extern "C" {
#endif

PyAPI_FUNC(PyObject *) _Py_device_encoding(int);

PyAPI_FUNC(wchar_t *) Py_DecodeLocale(
    const char *arg,
    size_t *size);

PyAPI_FUNC(char*) Py_EncodeLocale(
    const wchar_t *text,
    size_t *error_pos);

#ifndef Py_LIMITED_API

#ifdef MS_WINDOWS
struct _Py_stat_struct {
    unsigned long st_dev;
    __int64 st_ino;
    unsigned short st_mode;
    int st_nlink;
    int st_uid;
    int st_gid;
    unsigned long st_rdev;
    __int64 st_size;
    time_t st_atime;
    int st_atime_nsec;
    time_t st_mtime;
    int st_mtime_nsec;
    time_t st_ctime;
    int st_ctime_nsec;
    unsigned long st_file_attributes;
};
#else
#  define _Py_stat_struct stat
#endif

PyAPI_FUNC(int) _Py_fstat(
    int fd,
    struct _Py_stat_struct *status);

PyAPI_FUNC(int) _Py_fstat_noraise(
    int fd,
    struct _Py_stat_struct *status);
#endif   /* Py_LIMITED_API */

PyAPI_FUNC(int) _Py_stat(
    PyObject *path,
    s