 struct members to Python object attributes */

#include <stddef.h> /* For offsetof */

/* An array of PyMemberDef structures defines the name, type and offset
   of selected members of a C structure.  These can be read by
   PyMember_GetOne() and set by PyMember_SetOne() (except if their READONLY
   flag is set).  The array must be terminated with an entry whose name
   pointer is NULL. */

typedef struct PyMemberDef {
    const char *name;
    int type;
    Py_ssize_t offset;
    int flags;
    const char *doc;
} PyMemberDef;

/* Types */
#define T_SHORT     0
#define T_INT       1
#define T_LONG      2
#define T_FLOAT     3
#define T_DOUBLE    4
#define T_STRING    5
#define T_OBJECT    6
/* XXX the ordering here is weird for binary compatibility */
#define T_CHAR      7   /* 1-character string */
#define T_BYTE      8   /* 8-bit signed int */
/* unsigned variants: */
#define T_UBYTE     9
#define T_USHORT    10
#define T_UINT      11
#define T_ULONG     12

/* Added by Jack: strings contained in the structure */
#define T_STRING_INPLACE    13

/* Added by Lillo: bools contained in the structure (assumed char) */
#define T_BOOL      14

#define T_OBJECT_EX 16  /* Like T_OBJECT, but raises AttributeError
                           when the value is NULL, instead of
                           converting to None. */
#define T_LONGLONG      17
#define T_ULONGLONG     18

#define T_PYSSIZET      19      /* Py_ssize_t */
#define T_NONE          20      /* Value is always None */


/* Flags */
#define READONLY            1
#define READ_RESTRICTED     2
#define PY_WRITE_RESTRICTED 4
#define RESTRICTED          (READ_RESTRICTED | PY_WRITE_RESTRICTED)


/* Current API, use this */
PyAPI_FUNC(PyObject *) PyMember_GetOne(const char *, struct PyMemberDef *);
PyAPI_FUNC(int) PyMember_SetOne(char *, struct PyMemberDef *, PyObject *);


#ifdef __cplusplus
}
#endif
#endif /* !Py_STRUCTMEMBER_H */
PK       ! <C"  "    python3.9/pytime.hnu [        #ifndef Py_LIMITED_API
#ifndef Py_PYTIME_H
#define Py_PYTIME_H

#include "pyconfig.h" /* include for defines */
#include "object.h"

/**************************************************************************
Symbols and macros to supply platform-independent interfaces to time related
functions and constants
**************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/* _PyTime_t: Python timestamp with subsecond precision. It can be used to
   store a duration, and so indirectly a date (related to another date, like
   UNIX epoch). */
typedef int64_t _PyTime_t;
#define _PyTime_MIN INT64_MIN
#define _PyTime_MAX INT64_MAX

typedef enum {
    /* Round towards minus infinity (-inf).
       For example, used to read a clock. */
    _PyTime_ROUND_FLOOR=0,
    /* Round towards infinity (+inf).
       For example, used for timeout to wait "at least" N seconds. */
    _PyTime_ROUND_CEILING=1,
    /* Round to nearest with ties going to nearest even integer.
       For example, used to round from a Python float. */
    _PyTime_ROUND_HALF_EVEN=2,
    /* Round away from zero
       For example, used for timeout. _PyTime_ROUND_CEILING rounds
       -1e-9 to 0 milliseconds which causes bpo-31786 issue.
       _PyTime_ROUND_UP rounds -1e-9 to -1 millisecond which keeps
       the timeout sign as expected. select.poll(timeout) must block
       for negative values." */
    _PyTime_ROUND_UP=3,
    /* _PyTime_ROUND_TIMEOUT (an alias for _PyTime_ROUND_UP) should be
       used for timeouts. */
    _PyTime_ROUND_TIMEOUT = _PyTime_ROUND_UP
} _PyTime_round_t;


/* Convert a time_t to a PyLong. */
PyAPI_FUNC(PyObject *) _PyLong_FromTime_t(
    time_t sec);

/* Convert a PyLong to a time_t. */
PyAPI_FUNC(time_t) _PyLong_AsTime_t(
    PyObject *obj);

/* Convert a number of seconds, int or float, to t