<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

/**
 * Class ilTestVirtualSequenceTest
 * @author Marvin Beym <mbeym@databay.de>
 */
class ilTestVirtualSequenceTest extends ilTestBaseTestCase
{
    private ilTestVirtualSequence $testObj;

    protected function setUp(): void
    {
        parent::setUp();

        $this->testObj = new ilTestVirtualSequence(
            $this->createMock(ilDBInterface::class),
            $this->getTestObjMock(),
            $this->createMock(ilTestSequenceFactory::class)
        );
    }

    public function test_instantiateObject_shouldReturnInstance(): void
    {
        $this->assertInstanceOf(ilTestVirtualSequence::class, $this->testObj);
    }

    public function testActiveId(): void
    {
        $active_id = 12;
        $this->testObj->setActiveId($active_id);
        $this->assertEquals($active_id, $this->testObj->getActiveId());
    }
}
