<?php

declare(strict_types=1);
/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

namespace ILIAS\GlobalScreen\Identification;

/**
 * Class CoreIdentificationProvider
 * @see    IdentificationProviderInterface
 * @author Fabian Schmid <fs@studer-raimann.ch>
 */
class CoreIdentificationProvider extends AbstractIdentificationProvider implements IdentificationProviderInterface
{
    /**
     * @inheritdoc
     */
    public function identifier(string $identifier_string): IdentificationInterface
    {
        if (isset(self::$instances[$identifier_string])) {
            return self::$instances[$identifier_string];
        }

        $core_identification = new CoreIdentification(
            $identifier_string,
            $this->class_name,
            $this->serializer,
            $this->provider->getProviderNameForPresentation()
        );
        $this->map->addToMap($core_identification);

        return self::$instances[$identifier_string] = $core_identification;
    }
}
