<?php

declare(strict_types=1);

namespace ILIAS\UI\examples\Button\Toggle;

/**
 * ---
 * description: >
 *   This example provides the given button with an unavailable action. Note
 *   that the disabled attribute is set in the DOM. No action must be fired,
 *   even if done by keyboard.
 *
 * expected output: >
 *   ILIAS shows a greyed out switch. Clicking onto the switch won't activate any actions.
 * ---
 */
function unavailable_action()
{
    global $DIC;
    $f = $DIC->ui()->factory();
    $renderer = $DIC->ui()->renderer();

    $button = $f->button()->toggle('', '#', '#')
                          ->withAriaLabel("Switch the State of XY")
                          ->withUnavailableAction();

    return $renderer->render([$button]);
}
