var ilAnswerWizardInputTemplate = {

	tag_container: 'tbody.answwzd',
	tag_row: 'tr.answwzd',
	tag_button: 'answerwizard',

	getRowFromEvent: function (e) {
		return $(e.target).closest(this.tag_row);
	},

	getContainerFromEvent: function (e) {
		return $(e.target).closest(this.tag_container);
	},

	cleanRow: function (row) {
		$(row).find('input:text').val('');
		$(row).find('input:checkbox').prop('checked', false);
	},

	reindexRows: function (tbody) {
		var that = this;
		var rowindex = 0;

		// process all rows
		$(tbody).find(this.tag_row).each(function() {

			// answer
			$(this).find('input:text[id*="[answer]"]').each(function() {
				that.handleId(this, 'id', rowindex);
				that.handleId(this, 'name', rowindex);
			});

			// points
			$(this).find('input:text[id*="[points]"]').each(function() {
				that.handleId(this, 'id', rowindex);
				that.handleId(this, 'name', rowindex);
			});

			// button
			$(this).find('div.btn.btn-link').each(function() {
				that.handleId(this, 'id', rowindex);
			});

			rowindex++;
		});
	}
};

$(document).ready(function () {
	var ilAnswerWizardInput = $.extend({}, ilAnswerWizardInputTemplate, AnswerWizardInput);
	ilAnswerWizardInput.init();
});