<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

class ilOpenIdConnectAppEventListener implements ilAppEventListener
{
    protected function handleLogoutFor(int $user_id): void
    {
        $provider = new ilAuthProviderOpenIdConnect(new ilAuthFrontendCredentials());
        $provider->handleLogout();
    }

    public static function handleEvent(string $a_component, string $a_event, array $a_parameter): void
    {
        global $DIC;

        $DIC->logger()->auth()->debug($a_component . ' : ' . $a_event);

        if (($a_component === 'components/ILIAS/Authentication') && $a_event === 'beforeLogout') {
            $listener = new self();
            $listener->handleLogoutFor($a_parameter['user_id']);
        }
    }
}
