<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

namespace ILIAS;

class LTIConsumer implements Component\Component
{
    public function init(
        array | \ArrayAccess &$define,
        array | \ArrayAccess &$implement,
        array | \ArrayAccess &$use,
        array | \ArrayAccess &$contribute,
        array | \ArrayAccess &$seek,
        array | \ArrayAccess &$provide,
        array | \ArrayAccess &$pull,
        array | \ArrayAccess &$internal,
    ): void {
        $contribute[\ILIAS\Setup\Agent::class] = static fn() =>
            new \ilLTIConsumerSetupAgent(
                $pull[\ILIAS\Refinery\Factory::class]
            );
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiauth.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltitoken.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "lticerts.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiregistration.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiregend.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiregstart.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "lticonfig.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiservices.php");
        $contribute[Component\Resource\PublicAsset::class] = fn() =>
        new Component\Resource\Endpoint($this, "ltiresult.php");
    }
}
