<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

namespace ILIAS\GlobalScreen\Scope\Footer\Collector\Information;

use ILIAS\GlobalScreen\Scope\Footer\Factory\isItem;
use ILIAS\GlobalScreen\Identification\IdentificationInterface;
use ILIAS\GlobalScreen\Identification\NullIdentification;

/**
 * @author Fabian Schmid <fabian@sr.solutions>
 */
class NullItemInformation implements ItemInformation
{
    public function isItemActive(isItem $item): bool
    {
        return false;
    }

    public function customPosition(isItem $item): isItem
    {
        return $item;
    }

    public function customTranslationForUser(hasTitle $item): hasTitle
    {
        return $item;
    }

    public function getParent(isItem $item): IdentificationInterface
    {
        return new NullIdentification();
    }

}
