<?php include('users_menu.tpl.php'); ?>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<fieldset>
		<legend><?php echo __('Permissions'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_only_members">
			<input<?php if ($tpl['config']['users_only_members']) : ?> checked<?php endif; ?> id="users_only_members" name="config[users_only_members]" type="checkbox">
			<label for="users_only_members"><?php echo __('Interdire l\'accès à la galerie pour les invités'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_only_members_contact">
			<input<?php if ($tpl['config']['users_only_members_contact']) : ?> checked<?php endif; ?> id="users_only_members_contact" name="config[users_only_members_contact]" type="checkbox">
			<label for="users_only_members_contact"><?php echo __('Interdire l\'accès à la page "Contact" pour les invités'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_items_resize">
			<input<?php if ($tpl['config']['users_items_resize']) : ?> checked<?php endif; ?> id="users_items_resize" name="config[users_items_resize]" type="checkbox">
			<label for="users_items_resize"><?php echo __('Redimensionner les photos pour les groupes n\'ayant pas la permission de les télécharger'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="users_items_resize_width"><?php echo __('Dimensions maximum :'); ?></label>
				<span class="block">
					<input required value="<?php echo $tpl['config']['users_items_resize_width']; ?>" id="users_items_resize_width" name="config[users_items_resize_width]" type="text" maxlength="5" size="6">
					x
					<input required value="<?php echo $tpl['config']['users_items_resize_height']; ?>" id="users_items_resize_height" name="config[users_items_resize_height]" type="text" maxlength="5" size="6"> <?php echo __('pixels'); ?>
				</span>
			</p>
			<p class="field">
				<label for="users_items_resize_type"><?php echo __('Format :'); ?></label>
				<select class="block" name="config[users_items_resize_type]" id="users_items_resize_type">
<?php foreach ($tpl['file_types'] as $value => $name) : ?>
					<option<?php if ($tpl['config']['users_items_resize_type'] == $value) : ?> selected<?php endif; ?> value="<?php echo $value; ?>"><?php echo $name; ?></option>
<?php endforeach; ?>
				</select>
			</p>
			<p class="field">
				<label for="users_items_resize_quality"><?php echo __('Qualité (entre 0 et 100) :'); ?></label>
				<input required value="<?php echo $tpl['config']['users_items_resize_quality']; ?>" id="users_items_resize_quality" name="config[users_items_resize_quality]" maxlength="3" type="text" size="3">
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Fonctionnalités'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_online">
			<input<?php if ($tpl['config']['users_online']) : ?> checked<?php endif; ?> id="users_online" name="config[users_online]" type="checkbox">
			<label for="users_online"><?php echo __('Afficher les membres en ligne'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="users_online_duration"><?php echo __('Durée pendant laquelle un membre est considéré comme en ligne depuis sa dernière visite :'); ?></label>
				<input value="<?php echo $tpl['config']['users_online_duration']; ?>" id="users_online_duration" name="config[users_online_duration]" type="text" maxlength="5" size="5">
				<?php echo __('secondes'); ?>
			</p>
		</div>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="favorites">
			<input<?php if ($tpl['config']['favorites']) : ?> checked<?php endif; ?> id="favorites" name="config[favorites]" type="checkbox">
			<label for="favorites"><?php echo __('Activer les favoris'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="favorites_download">
				<input<?php if ($tpl['config']['favorites_download']) : ?> checked<?php endif; ?> id="favorites_download" name="config[favorites_download]" type="checkbox">
				<label for="favorites_download"><?php echo __('Permettre le téléchargement des favoris (archive Zip)'); ?></label>
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Activité des utilisateurs'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_log_activity">
			<input<?php if ($tpl['config']['users_log_activity']) : ?> checked<?php endif; ?> id="users_log_activity" name="config[users_log_activity]" type="checkbox">
			<label data-help-icon="log_activity" for="users_log_activity"><?php echo __('Enregistrer les actions effectuées par les utilisateurs'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="users_log_activity_rejected_only">
				<input<?php if ($tpl['config']['users_log_activity_rejected_only']) : ?> checked<?php endif; ?> id="users_log_activity_rejected_only" name="config[users_log_activity_rejected_only]" type="checkbox">
				<label for="users_log_activity_rejected_only"><?php echo __('Enregistrer uniquement les actions rejetées'); ?></label>
			</p>
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="users_log_activity_no_admin">
				<input<?php if ($tpl['config']['users_log_activity_no_admin']) : ?> checked<?php endif; ?> id="users_log_activity_no_admin" name="config[users_log_activity_no_admin]" type="checkbox">
				<label for="users_log_activity_no_admin"><?php echo __('Ne pas enregistrer les actions des administrateurs'); ?></label>
			</p>
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="users_log_activity_delete">
				<input<?php if ($tpl['config']['users_log_activity_delete']) : ?> checked<?php endif; ?> id="users_log_activity_delete" name="config[users_log_activity_delete]" type="checkbox">
				<label for="users_log_activity_delete"><?php echo __('Supprimer les entrées au bout de :'); ?></label>
				<input value="<?php echo $tpl['config']['users_log_activity_delete_days']; ?>" id="users_log_activity_delete_days" name="config[users_log_activity_delete_days]" type="text" maxlength="5" size="5">
				<?php echo __('jours'); ?>
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Inscriptions'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_registration">
			<input<?php if ($tpl['config']['users_registration']) : ?> checked<?php endif; ?> id="users_registration" name="config[users_registration]" type="checkbox">
			<label for="users_registration"><?php echo __('Autoriser les nouvelles inscriptions'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_registration_valid_admin">
			<input<?php if ($tpl['config']['users_registration_valid_admin']) : ?> checked<?php endif; ?> id="users_registration_valid_admin" name="config[users_registration_valid_admin]" type="checkbox">
			<label for="users_registration_valid_admin"><?php echo __('Valider les inscriptions par un administrateur'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_registration_valid_email">
			<input<?php if ($tpl['config']['users_registration_valid_email']) : ?> checked<?php endif; ?> id="users_registration_valid_email" name="config[users_registration_valid_email]" type="checkbox">
			<label for="users_registration_valid_email"><?php echo __('Valider les inscriptions par courriel'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="users_registration_valid_password">
			<input<?php if ($tpl['config']['users_registration_valid_password']) : ?> checked<?php endif; ?> id="users_registration_valid_password" name="config[users_registration_valid_password]" type="checkbox">
			<label for="users_registration_valid_password"><?php echo __('Valider les inscriptions par mot de passe'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="users_registration_password"><?php echo __('Mot de passe :'); ?></label>
				<input value="<?php echo $tpl['config']['users_registration_password']; ?>" id="users_registration_password" name="config[users_registration_password]" type="password" maxlength="255" size="50" class="large">
			</p>
			<p class="field">
				<label for="users_registration_password_text"><?php echo __('Indice pour le mot de passe :'); ?></label>
				<textarea rows="3" cols="30" id="users_registration_password_text" name="config[users_registration_password_text]"><?php echo $tpl['config']['users_registration_password_text']; ?></textarea>
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Informations de profil'); ?></legend>
		<table id="profile_infos" class="default">
			<tr>
				<th><?php echo __('Information'); ?></th>
				<th><?php echo __('Activer ?'); ?></th>
				<th><?php echo __('Obligatoire ?'); ?></th>
			</tr>
			<tr>
				<td><?php echo __('Pseudonyme'); ?></td>
				<td><input<?php if ($tpl['profile_params']['nickname']['activated']) : ?> checked<?php endif; ?> name="profile[nickname][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['nickname']['required']) : ?> checked<?php endif; ?> name="profile[nickname][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Nom'); ?></td>
				<td><input<?php if ($tpl['profile_params']['name']['activated']) : ?> checked<?php endif; ?> name="profile[name][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['name']['required']) : ?> checked<?php endif; ?> name="profile[name][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Prénom'); ?></td>
				<td><input<?php if ($tpl['profile_params']['firstname']['activated']) : ?> checked<?php endif; ?> name="profile[firstname][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['firstname']['required']) : ?> checked<?php endif; ?> name="profile[firstname][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Genre'); ?></td>
				<td><input<?php if ($tpl['profile_params']['gender']['activated']) : ?> checked<?php endif; ?> name="profile[gender][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['gender']['required']) : ?> checked<?php endif; ?> name="profile[gender][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Date de naissance'); ?></td>
				<td><input<?php if ($tpl['profile_params']['birthdate']['activated']) : ?> checked<?php endif; ?> name="profile[birthdate][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['birthdate']['required']) : ?> checked<?php endif; ?> name="profile[birthdate][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Localisation'); ?></td>
				<td><input<?php if ($tpl['profile_params']['location']['activated']) : ?> checked<?php endif; ?> name="profile[location][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['location']['required']) : ?> checked<?php endif; ?> name="profile[location][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Courriel'); ?></td>
				<td><input<?php if ($tpl['profile_params']['email']['activated']) : ?> checked<?php endif; ?> name="profile[email][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['email']['required']) : ?> checked<?php endif; ?> name="profile[email][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Site Web'); ?></td>
				<td><input<?php if ($tpl['profile_params']['website']['activated']) : ?> checked<?php endif; ?> name="profile[website][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['website']['required']) : ?> checked<?php endif; ?> name="profile[website][required]" type="checkbox"></td>
			</tr>
			<tr>
				<td><?php echo __('Description'); ?></td>
				<td><input<?php if ($tpl['profile_params']['description']['activated']) : ?> checked<?php endif; ?> name="profile[description][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['description']['required']) : ?> checked<?php endif; ?> name="profile[description][required]" type="checkbox"></td>
			</tr>
<?php for ($n = 1; $n <= 5; $n++) : ?>
			<tr>
				<td><input name="profile[<?php echo 'custom_' . $n; ?>][name]" maxlength="64" size="25" type="text" value="<?php echo $tpl['profile_custom'][$n]; ?>"></td>
				<td><input<?php if ($tpl['profile_params']['custom_' . $n]['activated']) : ?> checked<?php endif; ?> name="profile[<?php echo 'custom_' . $n; ?>][activated]" type="checkbox"></td>
				<td><input<?php if ($tpl['profile_params']['custom_' . $n]['required']) : ?> checked<?php endif; ?> name="profile[<?php echo 'custom_' . $n; ?>][required]" type="checkbox"></td>
			</tr>
<?php endfor; ?>
		</table>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>