<!DOCTYPE html>
<html lang="<?php echo $tpl['lang']; ?>" class="nojs">

<head>
	<title><?php echo $tpl['page_title'](); ?></title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width">
<?php if (!empty($tpl['meta_description'])) : ?>
	<meta name="description" content="<?php echo $tpl['meta_description']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['canonical'])) : ?>
	<link rel="canonical" href="<?php echo $tpl['canonical']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['rss']['items'])) : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php echo $tpl['rss']['items']['title']; ?>" href="<?php echo $tpl['rss']['items']['link']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['rss']['comments'])) : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php echo $tpl['rss']['comments']['title']; ?>" href="<?php echo $tpl['rss']['comments']['link']; ?>">
<?php endif; ?>
	<link rel="stylesheet" type="text/css" media="screen" title="style" href="<?php echo $tpl['gallery']['template']['path'](); ?>/style/style.css?<?php echo $tpl['version_key']; ?>" id="style_clear">
<?php if (!empty($tpl['diaporama'])) : ?>
	<link rel="stylesheet" type="text/css" media="screen" title="style" href="<?php echo $tpl['gallery']['template']['path'](); ?>/style/diaporama.css?<?php echo $tpl['version_key']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['geolocation'])) : ?>
	<link rel="stylesheet" type="text/css" media="screen" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="">
	<script id="leaflet_js" src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
<?php endif; ?>
<?php include_once(__DIR__ . '/head.tpl.php'); ?>
</head>

<body id="section_<?php echo str_replace('-', '_', $_GET['section']); ?>" <?php if ($body_class) : ?>class="<?php echo implode(' ', $body_class); ?>"<?php endif; ?>>

<div id="gallery" class="<?php echo $gallery_size; ?>">
<div id="gallery_inner">
	<header class="<?php echo $header_class; ?><?php if ($tpl['users']) : ?> user<?php endif; ?>">
		<div id="header_top">
<?php if (($display_menu || $tpl['user']['admin']) && (($tpl['user']['auth'] && $tpl['config']('users_only_members')) || !$tpl['config']('users_only_members'))) : ?>
			<a data-option-display="menu" id="menu_link" href="javascript:;"<?php if ($display_menu) : ?> class="show"<?php endif; ?>>&#xe966;</a>
<?php endif; ?>
			<div id="title">
<?php if ($title = $tpl['gallery']['title']()) : ?>
				<h1><a href="<?php echo $tpl['link'](); ?>"><?php echo $title; ?></a></h1>
<?php endif; ?>
			</div>
<?php if ($tpl['users']) : ?>
			<div id="user_links">
<?php if ($tpl['user']['auth']) : ?>
				<a data-box-arrow="user_menu" href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a>
				<ul class="box_arrow" id="user_menu">
					<li id="user_login"><a href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><?php echo $tpl['user']['nickname']; ?></a></li>
					<li id="user_avatar"><a tabindex="-1" href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a></li>
					<li id="user_logout"><a href="<?php echo $tpl['link']('logout'); ?>"><?php echo __('Déconnexion'); ?></a></li>
				</ul>
<?php else : ?>
				<a data-box-arrow="user_menu" href="javascript:;"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a>
				<ul class="box_arrow" id="user_menu">
<?php if ($tpl['config']('users_registration')) : ?>
					<li id="user_register"><a href="<?php echo $tpl['link']('register'); ?>"><?php echo __('Créer un compte'); ?></a></li>
<?php endif; ?>
					<li id="user_avatar"><a data-box="login" href="<?php echo $tpl['link']('login'); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a></li>
					<li id="user_connection"><a data-box="login" href="<?php echo $tpl['link']('login'); ?>"><?php echo __('Connexion'); ?></a></li>
				</ul>
<?php endif; ?>
			</div>
<?php endif; ?>
<?php if ($tpl['theme']['user_style_change'] || $tpl['user']['admin']) : ?>
			<div <?php if ($tpl['theme']['user_style_change']) : ?>class="active" <?php endif; ?>data-style="<?php if ($tpl['theme']['user_style'] == 'dark') : ?>clear<?php else : ?>dark<?php endif; ?>" id="user_style_large"><a href="javascript:;"><?php if ($tpl['theme']['user_style'] == 'dark') : ?>&#xe902;<?php else : ?>&#xe908;<?php endif; ?></a></div>
<?php endif; ?>
		</div>
<?php if (($display_menu || $tpl['user']['admin']) && (($tpl['user']['auth'] && $tpl['config']('users_only_members')) || !$tpl['config']('users_only_members'))) : ?>
		<div id="menu" data-option-display="menu"<?php if ($display_menu) : ?> class="show"<?php endif; ?>>
			<nav>
				<ul>
<?php if ($display_menu_home || $tpl['user']['admin']) : ?>
					<li data-option-display="menu_home" id="menu_home_icon" class="icon<?php if ($display_menu_home) : ?> show<?php endif; ?>"><a title="<?php echo __('Accueil'); ?>" href="<?php echo $tpl['link'](); ?>"><span>&#xe906;</span></a></li>
<?php endif; ?>
					<li id="menu_gallery" class="<?php if (!empty($tpl['categories_browse'])) : ?>browse<?php endif; ?><?php echo (in_array($_GET['section'], ['album', 'category', 'item'])) ? ' current' : ''; ?>"><a<?php if (!empty($tpl['categories_browse'])) : ?> data-box-arrow="browse"<?php endif; ?> href="<?php echo $tpl['gallery']['path']; ?>/"><?php echo __('Galerie'); ?></a></li>
<?php foreach ($tpl['menu_pages'] as &$i) : ?>
					<li id="menu_<?php echo $i['name']; ?>"<?php echo ($i['current']) ? ' class="current"' : ''; ?>><a href="<?php echo $i['link']; ?>"><?php echo $i['title']; ?></a></li>
<?php endforeach; ?>
<?php if ($tpl['config']('search')) : ?>
					<li id="menu_search"<?php echo (substr($_GET['section'], 0, 6) == 'search') ? ' class="current"' : ''; ?>><a href="<?php echo $tpl['link']('search'); ?>"><?php echo __('Recherche'); ?></a></li>
					<li id="menu_search_icon" class="icon<?php echo (substr($_GET['section'], 0, 6) == 'search') ? ' current' : ''; ?>"><a title="<?php echo __('Recherche'); ?>" data-box-arrow="search" href="<?php echo $tpl['link']('search'); ?>"><span>&#xe986;</span></a></li>
<?php endif; ?>
				</ul>
			</nav>
		</div>
<?php endif; ?>
	</header>
	<div id="content">

		<main>
<?php include($tpl['template']['file']); ?>
		</main>

<?php if (!empty($tpl['category']['stats']) || !empty($tpl['category']['tags'])
	   || !empty($tpl['links']) || !empty($tpl['users_online']) || !empty($tpl['random_item'])) : ?>
<?php include_once('bottom.tpl.php'); ?>
<?php endif; ?>

	</div>
</div>
<footer>
<?php if ($tpl['lang_switch']) : ?>
	<p id="footer_lang"><a href="<?php echo $tpl['link']('language'); ?>"><span>&#xe900;</span><?php echo $tpl['lang_switch'][$tpl['lang']]['name']; ?></a></p>
<?php endif; ?>
<?php if ($tpl['footer_text']) : ?>
	<p id="footer_text"><?php echo nl2br(HTML::decode($tpl['footer_text'])); ?></p>
<?php endif; ?>
<?php if (CONF_EXEC_TIME) : ?>
	<p id="footer_time"><?php echo $tpl['time'](); ?></p>
<?php endif; ?>
	<p id="footer_system"><?php printf(__('Propulsé par %s'), '<a class="ex" href="' . $tpl['app']['website'] . '">' . $tpl['app']['name'] . '</a>'); ?><?php if ($tpl['admin']['link']) : ?> - <a href="<?php echo $tpl['admin']['path']; ?>/">admin</a><?php endif; ?></p>
</footer>

<?php if ($tpl['user']['admin']) : ?><?php include_once(__DIR__ . '/theme_options.tpl.php'); ?><?php endif; ?>
<?php if ($tpl['debug']()) : ?>
<div id="debug">
<?php $tpl['print']('logs'); ?>
<?php $tpl['print']('errors'); ?>
<?php $tpl['print']('sql'); ?>
</div>
<?php endif; ?>

</div>

</body>

</html>