<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminItems.class.php');

template:
{
	AdminItems::tplSection('item_thumb_new');
}

update:
{	
	Admin::displayOptions('album');

	AdminAlbums::videoCapture();
}

get_data:
{
	AdminItems::getInfos();

	$i =& AdminItems::$infos;
	if (Item::isImage($i['item_type']))
	{
		App::redirect('item-thumb/' . $i['item_id']);
	}
	$capture = '/cache/captures/' . Video::getCapture((int) $i['item_id'], $i['item_adddt']);
	$capture = (file_exists(GALLERY_ROOT . $capture)) ? App::getFileSource($capture) : '';
	Template::set('videocapture',
	[
		'hash' => Video::uniqueHash((string) $i['item_id'], $i['item_adddt']),
		'id' => $i['item_id'],
		'image' => $capture
	]);

	AdminItems::getBrowseItems();
}
?>