<?php
declare(strict_types = 1);

require_once(__DIR__ . '/Admin.class.php');

/**
 * Connexion/déconnexion à l'interface d'administration.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */
class AdminConnection extends Admin
{
	/**
	 * Authentification.
	 *
	 * @return void
	 */
	public static function login(): void
	{
		Template::set('login', $POST['login'] ?? '');

		if (!isset($_POST['login']) || !isset($_POST['password']))
		{
			return;
		}

		// Vérification des informations.
		$cause = '';
		if (!Auth::form($_POST['login'], $_POST['password'], isset($_POST['remember']), $cause))
		{
			Report::warning(L10N::getTextLoginRejected($cause));
			return;
		}

		App::redirect('dashboard');
	}

	/**
	 * Déconnexion.
	 *
	 * @return bool
	 */
	public static function logout(): bool
	{
		return isset($_POST['anticsrf']) && Auth::logout();
	}

	/**
	 * Procédure pour la récupération d'un nouveau mot de passe.
	 *
	 * @return void
	 */
	public static function passwordForgot(): void
	{
		if ($_POST)
		{
			$r = User::passwordForgot($_POST['login'] ?? '', $_POST['email'] ?? '', TRUE);
			if ($r === NULL)
			{
				Report::warning(__('Informations incorrectes.'));
			}
			else if ($r === TRUE)
			{
				Template::set('success', __('Un courriel avec les indications'
					. ' à suivre vous a été envoyé.'));
			}
			else
			{
				Report::error();
			}
		}
	}

	/**
	 * Génère un nouveau mot de passe.
	 *
	 * @return void
	 */
	public static function passwordNew(): void
	{
		if ($_POST)
		{
			$r = User::passwordNew(
				$_POST['login'] ?? '', $_POST['email'] ?? '', $_POST['key'] ?? ''
			);
			if ($r === NULL)
			{
				Report::warning(__('Informations incorrectes.'));
			}
			else if ($r === FALSE)
			{
				Report::error();
			}
			else
			{
				Template::set('new_password', $r);
				Template::set('success', __('Le nouveau mot de passe que'
					. ' vous avez demandé a été créé :'));
			}
		}
	}
}
?>