<?php if ($tpl['objects_count']) : ?>
<?php $confirm_delete = __('Supprimer les incidents sélectionnés ?'); ?>
<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
</nav>

<?php if ($tpl['errors']) : ?>
<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

<div id="obj_mini_links_js">
<?php include('object_select.tpl.php'); ?>
	<span class="sep">&nbsp; | &nbsp;</span>
	<p>
		<a class="js show_all" href="javascript:;"><?php echo __('Tout montrer'); ?></a>
		-
		<a class="js hide_all" href="javascript:;"><?php echo __('Tout cacher'); ?></a>
	</p>
	<span class="sep">&nbsp; | &nbsp;</span>
	<p>
		<span class="show_tool"><a data-id="forum" class="js<?php if ($_GET['section_1'] == 'errors-forum') : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('errors' . (strstr($_GET['section_1'], 'forum') ? '' : '-forum')); ?>"><?php echo __('Format forum'); ?></a></span>
	</p>
</div>

<div id="forum"<?php if ($_GET['section_1'] == 'errors-forum') : ?> class="show"<?php endif; ?>>
	<p class="field">
<textarea<?php if ($_GET['section_1'] == 'errors-forum') : ?> autofocus<?php endif; ?> class="focus" cols="80" rows="20">[code]<?php $n = $tpl['objects_count']; foreach ($tpl['errors'] as &$i) : ?>

#<?php echo $n--; ?>

<?php echo __('Date'); ?> : <?php echo $i['date']; ?>

<?php echo System::APP_NAME; ?> : <?php echo $i['app_version']; ?>

PHP : <?php echo $i['php_version']; ?>

<?php echo __('Type'); ?> : <?php echo $i['type']; ?>

<?php echo __('Fichier'); ?> : <?php echo $i['file']; ?>

<?php echo __('Ligne'); ?> : <?php echo $i['line']; ?>

<?php echo __('Page'); ?> : <?php echo $i['q']; ?>

<?php echo __('Message'); ?> : <?php echo $i['message']; ?>

<?php if (isset($i['trace'])) : ?><?php echo __('Trace'); ?> : <?php foreach ($i['trace'] as &$t) : ?><?php echo $t; ?><?php endforeach; ?><?php endif; ?>
<?php endforeach; ?>[/code]</textarea>
	</p>
</div>

<form id="incidents" action="<?php echo $tpl['current_url']; ?>" method="post">
<?php $n = 1; foreach ($tpl['errors'] as &$i) : ?>
	<div id="obj_<?php echo $n; ?>" class="selectable_class obj">
		<div class="obj_body">
			<div class="obj_checkbox selectable_zone">
				<input class="selectable" name="selected[<?php echo $i['error_file']; ?>]" type="checkbox">
			</div>
			<p class="obj_title">
				<span class="show_parts icon icon_error_<?php echo (substr($i['type'], 0, 3) == 'PHP') ? 'php' : 'db' ; ?>">
					<a data-id="obj_details_<?php echo $n; ?>" class="js show" href="javascript:;"><?php echo $i['message']; ?></a>
				</span>
			</p>
		</div>
		<div class="obj_fold obj_details" id="obj_details_<?php echo $n; ?>">
			<div>
				<div>
					<table>
						<tr>
							<td><?php echo __('Type'); ?></td>
							<td><?php echo $i['type']; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Date'); ?></td>
							<td><?php echo $i['date']; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Fichier'); ?></td>
							<td><?php echo $i['file']; ?>(<?php echo $i['line']; ?>)</td>
						</tr>
						<tr>
							<td><?php echo __('Page'); ?></td>
							<td>?q=<?php echo $i['q']; ?></td>
						</tr>
						<tr>
							<td><?php echo System::APP_NAME; ?></td>
							<td><?php echo $i['app_version']; ?></td>
						</tr>
						<tr>
							<td>PHP</td>
							<td><?php echo $i['php_version']; ?></td>
						</tr>
					</table>
				</div>
<?php if (isset($i['trace'])) : ?>
				<div class="trace">
					<table>
						<tr>
							<td><?php echo __('Trace'); ?></td>
							<td>
								<ul>
<?php foreach ($i['trace'] as &$t) : ?>
									<li><?php echo $t; ?></li>
<?php endforeach; ?>
								</ul>
							</td>
						</tr>
					</table>
				</div>
<?php endif; ?>
			</div>
		</div>
	</div>
<?php $n++; endforeach; ?>

	<div id="submit" class="submit_actions">
		<div>
			<div id="form_actions">
				<label for="selection_action"><?php echo __('Pour la sélection :'); ?></label>
				<select id="selection_action" name="action">
					<optgroup label="<?php echo __('Supprimer'); ?>">
						<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
					</optgroup>
<?php if ($tpl['export']) : ?>
					<optgroup label="<?php echo __('Exporter'); ?>">
						<option value="export"><?php echo __('Exporter'); ?></option>
					</optgroup>
<?php endif; ?>
				</select>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
			</div>
		</div>
	</div>

</form>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
document.querySelectorAll('.obj_title .show').forEach((e) => e.classList.remove('show'));
</script>
<?php endif; ?>
<?php else : ?>
<div class="report_classic">
	<div class="report_msg report_warning">
		<p><?php printf(__('%s non chargé.'), 'SimpleXML'); ?></p>
	</div>
</div>
<?php endif; ?>
<?php else : ?>
<div class="report_classic">
	<div class="report_msg report_info">
		<p><?php echo __('Aucun incident.'); ?></p>
	</div>
</div>
<?php endif; ?>