<form id="new_cat_form" action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
	<h3 class="icon"><?php echo __('Créer un album'); ?></h3>

<?php if (isset($tpl['create_success'])) : ?>
<div id="messages">
	<p class="message_success"><?php printf($tpl['create_success']['message'], '<a href="' . $tpl['create_success']['upload_link'] . '">' . $tpl['create_success']['title'] . '</a>'); ?></p>
</div>
<?php else : ?>
<?php include(__DIR__ . '/report.tpl.php'); ?>
<?php endif; ?>

	<p id="list_categories_msg">
		<label for="cat_id">
<?php if ($tpl['user']['perms']['create_albums_categories']) : ?>
			<?php echo __('Choisissez la catégorie dans laquelle vous souhaitez créer un album ou une catégorie :'); ?>
<?php else : ?>
			<?php echo __('Choisissez la catégorie dans laquelle vous souhaitez créer un album :'); ?>
<?php endif; ?>
		</label>
	</p>
	<p id="list_categories">
		<select autofocus required name="cat_id" id="cat_id">
<?php foreach ($tpl['categories_list'] as &$i) : ?>
			<option<?php if (!$i['selectable']) : ?> disabled<?php elseif ($i['id'] == ($_POST['cat_id'] ?? 0)) : ?> selected<?php endif; ?> value="<?php echo $i['id']; ?>"><?php echo str_repeat('&nbsp;', $i['level'] * 4); ?><?php echo $i['title']; ?></option>
<?php endforeach; ?>
		</select>
	</p>
	<div id="new_category">
<?php if ($tpl['user']['perms']['create_albums_categories']) : ?>
		<p class="field">
			<?php echo __('Type :'); ?>
			&nbsp;
			<input id="new_category_type_cat" value="category" name="type" type="radio">
			<label for="new_category_type_cat"><?php echo __('Catégorie'); ?></label>
			&nbsp;
			<input checked="checked" id="new_category_type_alb" value="album" name="type" type="radio">
			<label for="new_category_type_alb"><?php echo __('Album'); ?></label>
			<br>
			<?php echo __('Une catégorie ne peut contenir que des catégories ou des albums, tandis qu\'un album ne peut contenir que des fichiers.'); ?>
		</p>
<?php else : ?>
		<input name="type" type="hidden" value="album">
<?php endif; ?>
		<p class="field">
			<label for="new_cat_title"><?php echo __('Titre :'); ?></label>
			<input required size="40" maxlength="128" id="new_cat_title" type="text" class="large" name="title" value="<?php echo $_POST['title'] ?? ''; ?>">
		</p>
		<p class="field">
			<label for="new_cat_desc"><?php echo __('Description :'); ?></label>
			<span id="cat_desc">
				<textarea id="new_cat_desc" name="desc" cols="45" rows="5"><?php echo $_POST['desc'] ?? ''; ?></textarea>
			</span>
		</p>
		<p id="submit">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input name="new_category" type="submit" value="<?php echo __('Créer'); ?>" class="button">
		</p>
	</div>
</form>