<?php
declare(strict_types = 1);

/**
 * Capture d'image des vidéos.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */
require_once(__DIR__ . '/includes/prepend.php');

$data = json_decode(file_get_contents('php://input'), TRUE);
if ($data)
{
	$_POST = $data;
}
$_POST = array_map('strval', $_POST);

// Vérification du format des paramètres.
if (!isset($_POST['data'])
 || !isset($_POST['hash'])     || !preg_match('`^[a-f0-9]{32}$`', $_POST['hash'])
 || !isset($_POST['duration']) || !preg_match('`^\d{1,5}$`',      $_POST['duration'])
 || !isset($_POST['height'])   || !preg_match('`^\d{1,4}$`',      $_POST['height'])
 || !isset($_POST['id'])       || !preg_match('`^p?\d{1,12}$`',   $_POST['id'])
 || !isset($_POST['key'])      || !preg_match('`^[a-f0-9]{32}$`', $_POST['key'])
 || !isset($_POST['width'])    || !preg_match('`^\d{1,4}$`',      $_POST['width']))
{
	die(App::httpResponse(400));
}

// Vérification de la clé de sécurité.
if (!Security::fileKeyVerify([$_POST['id']], $_POST['key']))
{
	die(App::httpResponse(403));
}

// Création du fichier.
$capture = GALLERY_ROOT . '/cache/captures/' . $_POST['id'] . '-' . $_POST['hash'] . '.jpg';
File::putContents($capture, base64_decode($_POST['data']));

// Mise à jour de la base de données.
if (DB::connect())
{
	if ($_POST['id'][0] == 'p')
	{
		$table = "items_pending";
		$prefix = "pending";
		$id = substr($_POST['id'], 1);
	}
	else
	{
		$table = "items";
		$prefix = "item";
		$id = $_POST['id'];
	}
	$sql = "UPDATE {{$table}}
			   SET {$prefix}_height = :height,
				   {$prefix}_width = :width,
				   {$prefix}_duration = :duration
			 WHERE {$prefix}_id = :id";
	DB::execute($sql,
	[
		'duration' => $_POST['duration'],
		'height' => $_POST['height'],
		'id' => $id,
		'width' => $_POST['width']
	]);
}

die(json_encode(['success' => 1]));
?>