<?php

namespace Classes;

/**
 * @method static IceRoute get(string $route, Callable $callback)
 * @method static IceRoute post(string $route, Callable $callback)
 * @method static IceRoute put(string $route, Callable $callback)
 * @method static IceRoute delete(string $route, Callable $callback)
 * @method static IceRoute options(string $route, Callable $callback)
 * @method static IceRoute head(string $route, Callable $callback)
 */
class IceRoute
{

    public static $foundRoute = false;

    public static $halts = false;

    public static $routes = array();

    public static $methods = array();

    public static $callbacks = array();

    public static $patterns = array(
        ':any' => '[^/]+',
        ':num' => '[0-9]+',
        ':all' => '.*'
    );

    public static $error_callback;

    /**
     * Defines a route w/ callback and method
     */
    public static function __callstatic($method, $params)
    {

        $uri = $params[0][0];
        $callback = $params[0][1];

        array_push(self::$routes, $uri);
        array_push(self::$methods, strtoupper($method));
        array_push(self::$callbacks, $callback);

        return $uri;
    }

    /**
     * Defines callback if route is not found
    */
    public static function error($callback)
    {
        self::$error_callback = $callback;
    }

    public static function haltOnMatch($flag = true)
    {
        self::$halts = $flag;
    }

    /**
     * Runs the callback for the given request
     */
    public static function dispatch($uri, $method)
    {

        $searches = array_keys(static::$patterns);
        $replaces = array_values(static::$patterns);

        $found_route = false;

        self::$routes = str_replace('//', '/', self::$routes);

        // check if route is defined without regex
        if (in_array($uri, self::$routes)) {
            $route_pos = array_keys(self::$routes, $uri);
            foreach ($route_pos as $route) {
                //using an ANY option to match both GET and POST requests
                if (self::$methods[$route] == $method || self::$methods[$route] == 'ANY') {
                    $found_route = true;

                    //if route is not an object
                    if (!is_object(self::$callbacks[$route])) {
                        //grab all parts based on a / separator
                        $parts = explode('/', self::$callbacks[$route]);

                        //collect the last index of the array
                        $last = end($parts);

                        //grab the controller name and method call
                        $segments = explode('@', $last);

                        //instanitate controller
                        $controller = new $segments[0]();

                        //call method
                        $controller->$segments[1]();

                        if (self::$halts) {
                            return;
                        }
                    } else {
                        //call closure
                        call_user_func(self::$callbacks[$route]);

                        if (self::$halts) {
                            return;
                        }
                    }
                }
            }
        } else {
            // check if defined with regex
            $pos = 0;
            foreach (self::$routes as $route) {
                if (strpos($route, ':') !== false) {
                    $route = str_replace($searches, $replaces, $route);
                }

                if (preg_match('#^' . $route . '$#', $uri, $matched)) {
                    if (self::$methods[$pos] == $method) {
                        $found_route = true;

                        array_shift($matched); //remove $matched[0] as [1] is the first parameter.


                        if (!is_object(self::$callbacks[$pos])) {
                            //grab all parts based on a / separator
                            $parts = explode('/', self::$callbacks[$pos]);

                            //collect the last index of the array
                            $last = end($parts);

                            //grab the controller name and method call
                            $segments = explode('@', $last);

                            //instanitate controller
                            $controller = new $segments[0]();

                            //fix multi parameters
                            if (!method_exists($controller, $segments[1])) {
                                echo "controller and action not found";
                            } else {
                                call_user_func_array(array($controller, $segments[1]), $matched);
                            }

                            //call method and pass any extra parameters to the method
                            // $controller->$segments[1](implode(",", $matched));

                            if (self::$halts) {
                                return;
                            }
                        } else {
                            call_user_func_array(self::$callbacks[$pos], $matched);

                            if (self::$halts) {
                                return;
                            }
                        }
                    }
                }
                $pos++;
            }
        }

        self::$foundRoute = $found_route;
        // run the error callback if the route was not found
        if ($found_route == false) {
            if (!self::$error_callback) {
                self::$error_callback = function () {
                    header($_SERVER['SERVER_PROTOCOL']." 404 Not Found");
                    echo '404';
                };
            }
            call_user_func(self::$error_callback);
        }
    }
}
