### Core Widgets

Some/many of these widgets have restrictions which may restrict the type of page where they may appear or may require login


* clock - displays the current time
    * args: military (1 or 0) - use 24 hour time as opposed to AM/PM

* profile - displays a profile sidebar on pages which load profiles (pages with nickname in the URL)

* tagcloud - display a tagcloud of webpage items

    * args: count - number of items to return (default 24)

* collections - privacy group selector for the current logged in channel

    * args: mode - one of "conversation", "group", "abook" depending on module

* suggestions - friend suggestions for the current logged on channel

* follow - presents a text box for following another channel

* notes - private notes area for the current logged in channel if private_notes feature is enabled

* savedsearch - network/matrix search with save - must be logged in and savedsearch feature enabled

* filer - select filed items from network/matrix stream - must be logged in

* archive - date range selector for network and channel pages
    * args: 'wall' - 1 or 0, limit to wall posts or network/matrix posts (default)

* fullprofile - same as profile currently

* categories - categories filter (channel page)

* tagcloud_wall - tagcloud for channel page only
    * args: 'limit' - number of tags to return (default 50)

* catcloud_wall - tagcloud for channel page categories
    * args: 'limit' - number of categories to return (default 50)

* affinity - affinity slider for network page - must be logged in

* settings_menu - sidebar menu for settings page, must be logged in

* mailmenu - sidebar menu for private message page - must be logged in

* design_tools - design tools menu for webpage building pages, must be logged in

* findpeople - tools to find other channels

* photo_albums - list photo albums of the current page owner with a selector menu

* vcard - mini profile sidebar for the person of interest (page owner, whatever)

* dirsafemode - directory selection tool - only on directory pages

* dirsort - directory selection tool - only on directory pages

* dirtags - directory tool - only on directory pages

* menu_preview - preview a menu - only on menu edit pages

* chatroom_list - list of chatrooms for the page owner

* bookmarkedchats - list of bookmarked chatrooms collected on this site for the current observer

* suggestedchats - "interesting" chatrooms chosen for the current observer

* item - displays a single webpage item by mid or page title
    * args:
	* channel_id - channel that owns the content, defualt is the profile_uid 
	* mid - message_id of webpage to display (must be webpage, not a conversation item)
	* title - URL page title of webpage (must provide one of either title or mid)

* photo - display a single photo
    * args: 
    * src - URL of photo, must be http or https
    * zrl - use zid authenticated link
    * style - CSS style string

* cover_photo - display the cover photo for the selected channel
    * args:
	* channel_id - channel to use, default is the profile_uid 
    * style - CSS style string (default is dynamically resized to width of region)


* photo_rand - display a random photo from one of your photo albums. Photo permissions are honoured
    * args: 
    * album - album name (very strongly recommended if you have lots of photos)
    * scale - typically 0 (original size), 1 (1024px), 2, (640px), or 3 (320px)
    * style - CSS style string
	* channel_id - if not your own

* random_block - display a random block element from your webpage design tools collection. Permissions are honoured.
    * args: 
    * contains - only return blocks which include the contains string in the block name
    * channel_id - if not your own

* tasklist - provide a task or to-do list for the currently logged-in channel.
	* args:
	* all - display completed tasks if all is non-zero.

* forums - provide a list of connected public forums with unseen counts for the current logged-in channel.

* activity - provide a list of authors of unread network content for the current logged-in channel.

* album - provides a widget containing a complete photo album from albums belonging to the page owner; this may be too large to present in a sidebar region as is best implemented as a content region widget. 
	* args:
	* album - album name
	* title - optional title, album name is used if not present


#### Creating New Widgets

#### Class Widgets

To create a class-based widget named 'slugfish' create a file with the following contents:

````
<?php

namespace Zotlabs\Widget;


class Slugfish {

	function widget($args) {

	... widget code goes here.
	... The function returns a string which is the HTML content of the widget.
	... $args is a named array which is passed any [var] variables from the layout editor
	... For instance [widget=slugfish][var=count]3[/var][/widget] will populate $args with
	... [ 'count' => 3 ]

	}

````

The resultant file may be placed in widget/Slugfish/Slugfish.php , or Zotlabs/SiteWidgets/Slugfish.php . It also may be linked from a git repository using util/add_widget_repo.



Traditional function based widget:

If you want a widget named 'slugfish', create widget/widget_slugfish.php containing


    <?php
    
    function widget_slugfish($args) {
    
    .. widget code goes here. See above information for class-based widgets for details.
    
    }


