<?php /** @file */

namespace Zotlabs\Render;

use Smarty\Smarty;
use App;

class SmartyInterface extends Smarty {

	public $filename;

	function __construct() {
		parent::__construct();

		$theme = Theme::current();
		$thname = $theme[0];

		// setTemplateDir can be set to an array, which Smarty will parse in order.
		// The order is thus very important here

		$template_dirs = array('theme' => "view/theme/$thname/tpl/");
		if (!empty(App::$theme_info['extends'])) {
			$template_dirs = $template_dirs + array('extends' => "view/theme/" . App::$theme_info["extends"] . "/tpl/");
		}
		$template_dirs = $template_dirs + array('base' => 'view/tpl/');
		$this->setTemplateDir($template_dirs);

		$basecompiledir = App::$config['system']['smarty3_folder'];

		$this->setCompileDir($basecompiledir.'/compiled/');
		$this->setConfigDir($basecompiledir.'/config/');
		$this->setCacheDir($basecompiledir.'/cache/');

		$this->setLeftDelimiter(App::get_template_ldelim('smarty3'));
		$this->setRightDelimiter(App::get_template_rdelim('smarty3'));

		// Don't report errors so verbosely
		$this->error_reporting = E_ALL & ~E_WARNING & ~E_NOTICE;
	}

	function parsed($template = '') {
		if ($template) {
			return $this->fetch('string:' . $template);
		}
		return $this->fetch('file:' . $this->filename);
	}
}



