<?php
namespace Zotlabs\Module;

use Zotlabs\Lib\Config;

class Siteinfo extends \Zotlabs\Web\Controller {

	function init() {
		if (argv(1) === 'json' || (isset($_REQUEST['module_format']) && $_REQUEST['module_format'] === 'json')) {
			$data = get_site_info();
			json_return_and_die($data);
		}
	}

	function get() {

		$federated = [];
		call_hooks('federated_transports',$federated);

		$siteinfo = replace_macros(get_markup_template('siteinfo.tpl'),
			[
				'$title' => t('About this site'),
				'$sitenametxt' => t('Site Name'),
				'$sitename' => \Zotlabs\Lib\System::get_site_name(),
				'$headline' => t('Site Information'),
				'$site_about' => bbcode(Config::Get('system','siteinfo')),
				'$admin_headline' => t('Administrator'),
				'$admin_about' => bbcode(Config::Get('system','admininfo')),
				'$terms' => t('Terms of Service'),
				'$prj_header' => t('Software and Project information'),
				'$prj_name' => t('This site is powered by $Projectname'),
				'$prj_transport' => t('Federated and decentralised networking and identity services provided by'),
				'$transport_link' => '<a href="https://hubzilla.org">https://hubzilla.org</a>',

				'$additional_text' => t('Additional federated transport protocols:'),
				'$additional_fed' => implode(', ', $federated),
				'$prj_version' => ((Config::Get('system','hidden_version_siteinfo')) ? '' : sprintf( t('Version %s'), \Zotlabs\Lib\System::get_project_version())),
				'$prj_linktxt' => t('Project homepage'),
				'$prj_srctxt' => t('Developer homepage'),
				'$prj_link' => \Zotlabs\Lib\System::get_project_link(),
				'$prj_src' => \Zotlabs\Lib\System::get_project_srclink(),
				'$addons' => array( t('Active addons'), \App::$plugins ),
				'$blocked_sites' => array( t('Blocked sites'), \Zotlabs\Lib\Config::Get('system', 'blacklisted_sites') )
			]
		);

		call_hooks('about_hook', $siteinfo);

		return $siteinfo;

	}


}
