<?php

require_once("../includes/auth.php");

function input_val($name)
{
	return DUtil::getGoodVal(DUtil::grab_input('GET', $name));
}

$graph_type = input_val('graph_type');
$stats = new STATS();
$stats->parse_litespeed();
$d = new stdClass();
$d->CURTIME = date("M j H:i:s");

switch ($graph_type) {
	case 'Server':
		$sd = $stats->vhosts['_Server'];
		$d->BPS_IN = $stats->bps_in;
		$d->BPS_OUT = $stats->bps_out;
		$d->SSL_BPS_IN = $stats->ssl_bps_in;
		$d->SSL_BPS_OUT = $stats->ssl_bps_out;
		$d->MAXCONN = $stats->max_conn;
		$d->MAXSSL_CONN = $stats->max_ssl_conn;
		$d->PLAINCONN = $stats->plain_conn;
		$d->AVAILCONN = $stats->avail_conn;
		$d->IDLECONN = $stats->idle_conn;
		$d->SSLCONN = $stats->ssl_conn;
		$d->AVAILSSL = $stats->avail_ssl_conn;
		$d->REQ_PROCESSING = $sd->req_processing;
		$d->REQ_PER_SEC = $sd->req_per_sec;
		$d->TOT_REQS = $sd->req_total;
		$d->TOTAL_CACHE_HITS = $sd->total_cache_hits;
		$d->CACHE_HITS_PER_SEC = $sd->cache_hits_per_sec;
		$d->TOTAL_STATIC_HITS = $sd->total_static_hits;
		$d->STATIC_HITS_PER_SEC = $sd->static_hits_per_sec;
		$d->TOTAL_PRIVATE_CACHE_HITS = $sd->total_private_cache_hits;
		$d->PRIVATE_CACHE_HITS_PER_SEC = $sd->private_cache_hits_per_sec;
		break;

	case 'VH':
		$vhost = input_val('vhost');
		if (!empty($stats->vhosts[$vhost])) {
			$vd = $stats->vhosts[$vhost];
			$d->REQ_PROCESSING = $vd->req_processing;
			$d->REQ_PER_SEC = $vd->req_per_sec;
			$d->STATIC_HITS_PER_SEC = $vd->static_hits_per_sec;
			$d->CACHE_HITS_PER_SEC = $vd->cache_hits_per_sec;
			$d->EAP_PROCESS = $vd->eap_process;
			$d->EAP_INUSE = $vd->eap_inuse;
			$d->EAP_IDLE = $vd->eap_idle;
			$d->EAP_WAITQ = $vd->eap_waitQ;
			$d->EAP_REQ_PER_SEC = $vd->eap_req_per_sec;
			$d->TOTAL_STATIC_HITS = $vd->total_static_hits;
			$d->TOTAL_CACHE_HITS = $vd->total_cache_hits;
			$d->TOTAL_PRIVATE_CACHE_HITS = $vd->total_private_cache_hits;
			$d->PRIVATE_CACHE_HITS_PER_SEC = $vd->private_cache_hits_per_sec;
		} else {
			$d->REQ_PROCESSING = 0;
			$d->REQ_PER_SEC = 0;
			$d->STATIC_HITS_PER_SEC = 0;
			$d->CACHE_HITS_PER_SEC = 0;
			$d->EAP_PROCESS = 0;
			$d->EAP_INUSE = 0;
			$d->EAP_IDLE = 0;
			$d->EAP_WAITQ = 0;
			$d->EAP_REQ_PER_SEC = 0;
			$d->TOTAL_STATIC_HITS = 0;
			$d->TOTAL_CACHE_HITS = 0;
			$d->TOTAL_PRIVATE_CACHE_HITS = 0;
			$d->PRIVATE_CACHE_HITS_PER_SEC = 0;
		}
		break;

	case 'EXTAPP':
		$vhost = input_val('vhost');
		$extapp = input_val('extapp');
		if (!empty($stats->vhosts[$vhost]->extapps[$extapp])) {
			$ed = $stats->vhosts[$vhost]->extapps[$extapp];
			$d->VHOST = $ed->vhost;
			$d->TYPE = $ed->type;
			$d->EXTAPP = $ed->extapp;
			$d->CONFIG_MAX_CONN = $ed->config_max_conn;
			$d->EFFECT_MAX_CONN = $ed->effect_max_conn;
			$d->POOL_SIZE = $ed->pool_size;
			$d->INUSE_CONN = $ed->inuse_conn;
			$d->IDLE_CONN = $ed->idle_conn;
			$d->WAITQUEUE_DEPTH = $ed->waitqueue_depth;
			$d->REQ_PER_SEC = $ed->req_per_sec;
			$d->REQ_TOTAL = $ed->req_total;
		} else {
			$d->VHOST = 0;
			$d->TYPE = 0;
			$d->EXTAPP = 0;
			$d->CONFIG_MAX_CONN = 0;
			$d->EFFECT_MAX_CONN = 0;
			$d->POOL_SIZE = 0;
			$d->INUSE_CONN = 0;
			$d->IDLE_CONN = 0;
			$d->WAITQUEUE_DEPTH = 0;
			$d->REQ_PER_SEC = 0;
			$d->REQ_TOTAL = 0;
		}
		break;

	default:
		json_encode('graph_type error');
		return;
}

echo json_encode($d);
