<?php

class DPageDef
{
	protected $_pageDef = [];
	protected $_fileDef = [];
	protected $_tabDef = [];

	protected function __construct()
	{
		$this->defineAll();
	}

	public static function GetInstance()
	{
        if ( !isset($GLOBALS['_DPageDef_']) ) {
			$GLOBALS['_DPageDef_'] = new DPageDef();
        }
		return $GLOBALS['_DPageDef_'];
	}

	public function GetFileDef($type)
	{
		if ( !isset($this->_fileDef[$type]) )
		{
			$funcname = 'add_FilePage_' . $type;
			if (!method_exists($this, $funcname)) {
				die("invalid func name $funcname");
			}
			$this->$funcname();
		}
		return $this->_fileDef[$type];
	}

	public function GetPageDef($type, $pid)
	{
		return $this->_pageDef[$type][$pid];
	}

	public function GetTabDef($type)
	{
		return $this->_tabDef[$type];
	}

	protected function add_FilePage_serv()
	{
		$pages = [];
		$pages[] = new DFileSect([
			'SERV_PROCESS', 'APACHE_CONF_FILE', 'SERV_GENERAL',
			'SERV_LOG', 'SERV_ACLOG', 'SERV_INDEX',
			'A_HTACCESS', 'SERV_EXPIRES',
			'A_GEOIP', 'SERV_IP2LOCATION', 'SERV_APACHECONF',
			'SERV_TUNING_OS', 'SERV_TUNING_CONN', 'SERV_TUNING_REQ',
			'SERV_TUNING_STATIC', 'SERV_TUNING_GZIP',
			'SERV_TUNING_SSL', 'SERV_QUIC',
			'SERV_SEC_WP', 'SERV_SEC_FILE', 'SERV_SEC_CONN', 'SERV_SEC_CGI',
			'SERV_SEC_CC', 'A_SEC_CR', 'SERV_SEC_RECAP', 'SERV_SEC_BUBBLEWRAP', 'SERV_SEC_DENY',
			'A_SECAC', 'A_EXT_SEL', 'A_SCRIPT',
			'SERV_CACHE_STORAGE', 'SERV_CACHE_POLICY', 'A_CACHE_NCURL', 'SERV_CACHE_NCDOMAIN',
			'SERV_PAGESPEED',
			'S_PHP', 'S_PHP_HANDLER', 'S_PHP_DEFAULT',
			'S_RAILS', 'S_RAILS_HOSTING', 'S_WSGI', 'S_NODEJS',
			'VH_TOP_D', 'SERVICE_SUSPENDVH',
		]);

		$pages[] = new DFileSect(
			array('L_GENERAL', 'L_VHMAP', 'L_SSL_CERT', 'L_SSL', 'L_SSL_FEATURE', 'L_SSL_OCSP', 'L_SSL_CLIENT_VERIFY'),
			'listenerList:listener', 'listeners', 'name' );

		$pages[] = new DFileSect(
			array('TP', 'TP_MEMBER'),
			'vhTemplateList:vhTemplate', 'tpTop', 'name');

		$this->_fileDef['serv'] = &$pages;
	}

	protected function add_FilePage_vh()
	{
		$pages = [];
		$pages[] = new DFileSect([
			'VH_GENERAL', 'VH_LOG', 'VH_ACLOG', 'VH_INDXF', 'VH_ERRPG',
			'A_SCRIPT', 'A_HTACCESS', 'VH_EXPIRES', 'VH_APACHECONF',
			'VH_SEC_WP', 'VH_SECHL', 'VH_SEC_CC', 'A_SEC_CR', 'VH_SEC_RECAP', 'VH_SEC_BUBBLEWRAP', 'A_SECAC', 'VH_REALM_SEL',
			'VH_CACHE_STORAGE', 'VH_CACHE_POLICY', 'A_CACHE_NCURL',
			'A_EXT_SEL', 'VH_CTX_SEL',
			'VH_REWRITE_CTRL', 'VH_REWRITE_MAP', 'VH_REWRITE_RULE',
			'VH_SSL_CERT', 'VH_SSL_SSL', 'VH_SSL_FEATURE', 'VH_SSL_OCSP', 'VH_SSL_CLIENT_VERIFY',
			'VH_PAGESPEED',
			'VH_WEBSOCKET', 'VH_FRONTPG', 'VH_AWSTATS',
		]);
		$this->_fileDef['vh'] = &$pages;
	}

	protected function add_FilePage_tp()
	{
		$pages = [];
		$pages[] = new DFileSect(
			array('TP_GENERAL1',	'TP_SEC_FILE', 'TP_SEC_CONN', 'TP_SEC_CGI'));

		$pages[] = new DFileSect([
			'TP_GENERAL2', 'TP_LOG', 'TP_ACLOG', 'VH_INDXF', 'VH_ERRPG',
			'A_SCRIPT', 'A_HTACCESS', 'VH_EXPIRES', 'VH_APACHECONF',
			'VH_SEC_WP', 'VH_SECHL', 'VH_SEC_CC', 'A_SEC_CR', 'VH_SEC_RECAP', 'VH_SEC_BUBBLEWRAP', 'A_SECAC', 'TP_REALM_SEL',
			'VH_CACHE_STORAGE', 'VH_CACHE_POLICY', 'A_CACHE_NCURL',
			'TP_EXT_SEL', 'VH_CTX_SEL',
			'VH_REWRITE_CTRL', 'VH_REWRITE_MAP', 'VH_REWRITE_RULE',
			'VH_SSL_CERT', 'VH_SSL_SSL', 'VH_SSL_FEATURE', 'VH_SSL_OCSP', 'VH_SSL_CLIENT_VERIFY',
			'VH_PAGESPEED',
			'VH_WEBSOCKET', 'VH_FRONTPG', 'TP_AWSTATS',
				],
				'virtualHostConfig');

		$this->_fileDef['tp'] = &$pages;
	}

	protected function add_FilePage_admin()
	{
		$pages = [];
		$pages[] = new DFileSect(
			array('ADMIN_PHP', 'VH_LOG', 'VH_ACLOG', 'A_SECAC'));

		$pages[] = new DFileSect(
			array('ADMIN_L_GENERAL', 'L_SSL_CERT', 'L_SSL', 'L_SSL_FEATURE', 'L_SSL_CLIENT_VERIFY'),
			'listenerList:listener', 'listeners', 'name' );

		$this->_fileDef['admin'] = &$pages;
	}

	protected function defineAll()
	{
		$page = new DPage('serv', 'general', 'General',
						  'Server General Settings',
						  array('SERV_PROCESS', 'SERV_GENERAL', 'SERV_INDEX', 'A_HTACCESS',
						  	'SERV_EXPIRES', 'A_GEOIP_TOP', 'SERV_IP2LOCATION',
                              'APACHE_CONF_FILE', 'SERV_APACHECONF'));
		$page->_helpLink = 'ServGeneral_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'log', 'Log',
						  'Server Log Settings',
						  array('SERV_LOG', 'SERV_ACLOG'));
		$page->_helpLink = 'ServGeneral_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;


		$page = new DPage('serv', 'tuning', 'Tuning',
						  'Server Tuning Settings',
						  array('SERV_TUNING_OS', 'SERV_TUNING_CONN', 'SERV_TUNING_REQ',
                              'SERV_TUNING_STATIC', 'SERV_TUNING_GZIP',
                              'SERV_TUNING_SSL', 'SERV_QUIC'));
		$page->_helpLink = 'ServTuning_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'security', 'Security',
						  'Server Security Settings',
						  array('SERV_SEC_WP', 'SERV_SEC_CC', 'A_SEC_CR_TOP',
                              'SERV_SEC_CONN', 'SERV_SEC_FILE',  'SERV_SEC_CGI',
                              'SERV_SEC_RECAP', 'SERV_SEC_BUBBLEWRAP', 'SERV_SEC_DENY', 'A_SECAC'));
		$page->_helpLink = 'ServSecurity_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'cache', 'Cache',
						  'Server Cache Settings',
						  ['SERV_CACHE_STORAGE', 'SERV_CACHE_POLICY', 'A_CACHE_NCURL', 'SERV_CACHE_NCDOMAIN']);
		$page->_helpLink = 'Cache_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'modpagespeed', 'PageSpeed',
						  'PageSpeed Settings',
						  array('SERV_PAGESPEED'));
		$page->_helpLink = 'PageSpeed_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'ext', 'External App',
						  'Server Level External Applications',
						  array('A_EXT_TOP'));
		$page->_helpLink = 'ExtApp_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'scriptHandler', 'Script Handler',
						  'Server Level Script Handler',
						  array('A_SCRIPT_TOP'));
		$page->_helpLink = 'ScriptHandler_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

        $page = new DPage('serv', 'phpConfig', 'PHP',
						  'Global PHP Settings',
						  array('S_PHP', 'S_PHP_HANDLER_TOP', 'S_PHP_DEFAULT'));
		$page->_helpLink = 'PHPHandler_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('serv', 'appServer', 'App Server',
						  'App Server Default Settings',
						  array('S_RAILS', 'S_RAILS_HOSTING', 'S_WSGI', 'S_NODEJS'));
		$page->_helpLink = 'Rails_Help.html';
		$this->_pageDef['serv'][$page->_id] = $page;

		$page = new DPage('tptop', 'tpTop', 'Virtual Host Templates',
						  'Virtual Host Templates',
						  array('TP_TOP'));
		$page->_helpLink = 'Templates_Help.html';
		$this->_pageDef['tptop'][$page->_id] = $page;

		$page = new DPage('vhtop', 'vhTop', 'Virtual Hosts',
						  'Virtual Hosts Settings',
						  array('VH_TOP'));
		$page->_helpLink = 'VirtualHosts_Help.html';
		$this->_pageDef['vhtop'][$page->_id] = $page;

		$page = new DPage('sltop', 'slTop', 'Listeners',
						  'Listeners Settings',
						  array('L_TOP' ));
		$page->_helpLink = 'Listeners_Help.html';
		$this->_pageDef['sltop'][$page->_id] = $page;

		$page = new DPage('sl', 'lgeneral', 'General',
						  'Listener General Settings',
						  array('L_GENERAL', 'L_VHMAP_TOP'));
		$page->_helpLink = 'Listeners_Help.html';
		$this->_pageDef['sl'][$page->_id] = $page;

		$page = new DPage('sl', 'lsecure', 'SSL',
						  'Listener SSL Settings',
						  array('L_SSL_CERT', 'L_SSL', 'L_SSL_FEATURE', 'L_SSL_OCSP', 'L_SSL_CLIENT_VERIFY'));
		$page->_helpLink = 'Listeners_Help.html';
		$this->_pageDef['sl'][$page->_id] = $page;

		$page = new DPage('tp', 'member', 'Template',
						  'Template Settings',
						  array('TP', 'TP_MEMBER_TOP'));
		$page->_helpLink = 'Templates_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'base', 'Basic',
						  'Virtual Host Base',
						  array('VH_BASE', 'VH_BASE_CONNECTION', 'VH_BASE_THROTTLE', 'VH_BASE_SECURITY'));

		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('vh', 'general', 'General',
						  'Virtual Host General Settings',
						  array('VH_GENERAL', 'VH_INDXF', 'VH_ERRPG_TOP', 'A_HTACCESS', 'VH_EXPIRES', 'VH_APACHECONF', 'VH_WEBSOCKET_TOP'));
		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('tp', 'general', 'General',
						  'Template General Settings',
						  array('TP_GENERAL',  'VH_INDXF','VH_ERRPG_TOP', 'A_HTACCESS', 'VH_EXPIRES', 'VH_APACHECONF', 'VH_WEBSOCKET_TOP'));
		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'log', 'Log',
						  'Virtual Host Log Settings',
						  array('VH_LOG', 'VH_ACLOG'));
		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('tp', 'log', 'Log',
						  'Template Log Settings',
						  array('TP_LOG', 'TP_ACLOG',));
		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'security', 'Security',
						  'Virtual Host Security Settings',
						  array('VH_SEC_WP', 'VH_SEC_CC', 'A_SEC_CR_TOP', 'VH_SEC_RECAP', 'VH_SEC_BUBBLEWRAP',
                              'VH_SECHL', 'A_SECAC', 'VH_REALM_TOP'));
		$page->_helpLink = 'VHSecurity_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('tp', 'security', 'Security',
						  'Tempage Security Settings',
						  array('TP_SEC_CONN', 'TP_SEC_FILE', 'TP_SEC_CGI',
                              'VH_SEC_WP', 'VH_SEC_CC', 'A_SEC_CR_TOP', 'VH_SEC_RECAP', 'VH_SEC_BUBBLEWRAP',
								'VH_SECHL',	'A_SECAC', 'TP_REALM_TOP',
                              ));
		$page->_helpLink = 'VHSecurity_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'cache', 'Cache',
						  'Virtual Host Cache Settings',
						  ['VH_CACHE_STORAGE', 'VH_CACHE_POLICY', 'A_CACHE_NCURL']);
		$page->_helpLink = 'Cache_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'ext', 'External App',
						  'Virtual Host Level External Applications',
						  array('A_EXT_TOP'));
		$page->_helpLink = 'ExtApp_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('tp', 'ext', 'External App',
						  'Template External Applications',
						  array('TP_EXT_TOP'));
		$page->_helpLink = 'ExtApp_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'scriptHandler', 'Script Handler',
						  'Virtual Host Script Handler',
						  array('A_SCRIPT_TOP'));
		$page->_helpLink = 'VHGeneral_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'rewrite', 'Rewrite',
						  'Virtual Host Rewrite Settings',
						  array('VH_REWRITE_CTRL', 'VH_REWRITE_MAP_TOP', 'VH_REWRITE_RULE'));
		$page->_helpLink = 'Rewrite_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'context', 'Context',
						  'Virtual Host Context Settings',
						  array('VH_CTX_TOP'));
		$page->_helpLink = 'Context_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'vhssl', 'SSL',
						  'Virtual Host SSL Settings',
						  array('VH_SSL_CERT', 'VH_SSL_SSL', 'VH_SSL_FEATURE', 'VH_SSL_OCSP', 'VH_SSL_CLIENT_VERIFY'));
		$page->_helpLink = 'Listeners_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'modpagespeed', 'PageSpeed',
						  'PageSpeed Settings',
						  array('VH_PAGESPEED'));
		$page->_helpLink = 'PageSpeed_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('vh', 'addons', 'Add-ons',
						  'Virtual Host Add-ons Settings',
						  array('VH_FRONTPG', 'VH_AWSTATS'));
		$page->_helpLink = 'VHAddOns_Help.html';
		$this->_pageDef['vh'][$page->_id] = $page;

		$page = new DPage('tp', 'addons', 'Add-ons',
						  'Virtual Host Add-ons Settings',
						  array('VH_FRONTPG', 'TP_AWSTATS'));
		$page->_helpLink = 'VHAddOns_Help.html';
		$this->_pageDef['tp'][$page->_id] = $page;

		$page = new DPage('admin', 'general', 'General',
						  'Web Admin Settings',
						  array('ADMIN_PHP', 'VH_LOG', 'VH_ACLOG'));
		$page->_helpLink = 'AdminGeneral_Help.html';
		$this->_pageDef['admin'][$page->_id] = $page;

		$page = new DPage('admin', 'security', 'Security',
						  'Web Admin Security Settings',
						  array('A_SECAC', 'ADMIN_USR_TOP'));
		$page->_helpLink = 'AdminGeneral_Help.html';
		$this->_pageDef['admin'][$page->_id] = $page;

		$page = new DPage('altop', 'alTop', 'Admin Listeners',
						  'Listeners Settings',
						  array('ADMIN_L_TOP' ));
		$page->_helpLink = 'AdminListener_Help.html';
		$this->_pageDef['altop'][$page->_id] = $page;

		$page = new DPage('al', 'lgeneral', 'General',
						  'Admin Listener General Settings',
						  array('ADMIN_L_GENERAL'));
		$page->_helpLink = 'AdminListener_Help.html';
		$this->_pageDef['al'][$page->_id] = $page;

		$page = new DPage('al', 'lsecure', 'SSL',
						  'Listener SSL Settings',
						  array('L_SSL_CERT', 'L_SSL', 'L_SSL_FEATURE', 'L_SSL_CLIENT_VERIFY'));
		$page->_helpLink = 'AdminListener_Help.html';
		$this->_pageDef['al'][$page->_id] = $page;

		$types = array_keys($this->_pageDef);
		foreach ( $types as $type )
		{
			$pids = array_keys( $this->_pageDef[$type] );
			foreach ( $pids as $pid )
			{
				$this->_tabDef[$type][$pid] = $this->_pageDef[$type][$pid]->_name;
			}
		}

	}


}
