<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Slovenščina (Slovenian)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Klemen Štirn (https://www.hesk.com)
* Matija Gluhodedov (http://www.gluhi.com)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Slovenščina';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Slovenian';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_slovenian_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Odgovor napišite nad to črto ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nov zahtevek: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Zahtevek sprejet: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Zahtevek dodeljen: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nov odgovor na: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nov odgovor na: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Zahtevek premaknjen: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Opombe dodane k: %%SUBJECT%%';
$hesklang['new_pm']='Novo zasebno sporočilo: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Seznam vaših zahtevkov';

// ERROR MESSAGES
$hesklang['cant_connect_db']='napaka pri povezavi v bazo podatkov';
$hesklang['invalid_action']='Nedovoljena operacija';
$hesklang['select_username']='izberite svoje uporabniško ime';
$hesklang['enter_pass']='Vnesite svoje geslo';
$hesklang['cant_sql']='Napaka pri izvajanju SQL kode';
$hesklang['contact_webmsater']='Obvestite skrbnika na naslov';
$hesklang['mysql_said']='MySQL pravi';
$hesklang['wrong_pass']='napačno geslo.';
$hesklang['session_expired']='vaša seja je potekla, ponovno se prijavite.';
$hesklang['attempt']='Neveljaven poskus!';
$hesklang['not_authorized_tickets']='nimate dovoljenja za ogled zahtevkov znotraj te kategorije!';
$hesklang['must_be_admin']='za ogled te strani morate biti prijavljeni kot skrbnik.';
$hesklang['no_session']='ne morem začeti nove seje!';
$hesklang['error']='Napaka';
$hesklang['int_error']='Programska napaka';
$hesklang['no_trackID']='manjka sledilna koda';
$hesklang['status_not_valid']='status ni veljaven';
$hesklang['trackID_not_found']='ne najdem sledilne kode';
$hesklang['enter_message']='vnesite sporočilo';
$hesklang['select_priority']='izberite nujnost';
$hesklang['ticket_not_found']='zahtevka ni mogoče najti. Preverite, ali je sledilna koda prava.';
$hesklang['no_selected']='ni izbranih zahtevkov.';
$hesklang['id_not_valid']='neveljavna sledilna koda';
$hesklang['enter_id']='vnesite sledilno kodo';
$hesklang['enter_name']='vnesite ime in priimek stranke';
$hesklang['enter_date']='vnesite datum iskanja';
$hesklang['date_not_valid']='Datum mora biti v obliki <b>LLLL-MM-DD</b>.';
$hesklang['enter_subject']='vnesite zadevo';
$hesklang['invalid_search']='Neveljavno iskanje';
$hesklang['choose_cat_ren']='Izberite kategorijo, ki jo želite preimenovati';
$hesklang['cat_ren_name']='vnesite nov naziv kategorije';
$hesklang['cat_not_found']='kategorija ne obstaja';
$hesklang['enter_cat_name']='vnesite naziv kategorije';
$hesklang['no_cat_id']='Manjka ID kategorije';
$hesklang['cant_del_default_cat']='Privzete kategorije ne morete izbrisati, lahko pa jo preimenujete';
$hesklang['no_valid_id']='neveljaven ID uporabnika';
$hesklang['user_not_found']='uporabnik ne obstaja';
$hesklang['enter_real_name']='vnesite ime uporabnika';
$hesklang['enter_valid_email']='vnesite veljaven e-poštni naslov';
$hesklang['enter_username']='vnesite uporabniško ime';
$hesklang['asign_one_cat']='uporabnik potrebuje dostop do vsaj ene kategorije!';
$hesklang['signature_long']='Podpis je predolg, omejite ga na 1000 znakov';
$hesklang['confirm_user_pass']='potrdite geslo';
$hesklang['passwords_not_same']='vneseni gesli se ne ujemata!';
$hesklang['cant_del_admin']='privzetega skrbnika ne morete izbrisati!';
$hesklang['cant_del_own']='profila, v katerega ste prijavljeni, ne morete izbrisati!';
$hesklang['enter_your_name']='vnesite ime in priimek';
$hesklang['sel_app_cat']='izberite ustrezno kategorijo';
$hesklang['sel_app_priority']='izberite nujnost';
$hesklang['enter_ticket_subject']='vnesite zadevo';
$hesklang['user_not_found_nothing_edit']='Ni bilo sprememb, ki bi jih bilo treba shraniti.';

// ADMIN PANEL
$hesklang['administrator']='Skrbnik';
$hesklang['login']='Prijava';
$hesklang['user']='Uporabnik';
$hesklang['username']='Uporabniško ime';
$hesklang['pass']='Geslo';
$hesklang['confirm_pass']='Potrdite geslo';
$hesklang['logged_out']='Odjava';
$hesklang['logout']='Odjava';
$hesklang['logout_success']='odjavljeni ste iz sistema.';
$hesklang['click_login']='Prijava v sistem';
$hesklang['back']='Nazaj';
$hesklang['displaying_pages']='Število zahtevkov: <b>%d</b>. Strani:';
$hesklang['trackID']='Sledilna koda';
$hesklang['timestamp']='Datum';
$hesklang['name']='Ime in priimek';
$hesklang['subject']='Zadeva';
$hesklang['status']='Status';
$hesklang['priority']='Nujnost';
$hesklang['open']='Novo';
$hesklang['open_action']='Odpri zahtevek'; // Open ACTION
$hesklang['close']='Zaprt'; // Closed ticket STATUS
$hesklang['any_status']='Katerikoli status';
$hesklang['high']='Visoka';
$hesklang['medium']='Srednja';
$hesklang['low']='Nizka';
$hesklang['del_selected']='Izbriši izbrane zahtevke';
$hesklang['manage_cat']='Urejanje kategorij';
$hesklang['profile']='Vaš profil';
$hesklang['show_tickets']='Prikaži zahtevke';
$hesklang['sort_by']='Razvrsti po';
$hesklang['date_posted']='Datum';
$hesklang['category']='Kategorija';
$hesklang['any_cat']='Vse kategorije';
$hesklang['order']='Način prikaza';
$hesklang['ascending']='naraščajoče';
$hesklang['descending']='padajoče';
$hesklang['display']='Prikaži';
$hesklang['tickets_page']='zahtevkov na stran';
$hesklang['find_ticket']='Najdi zahtevek';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='zadetkov na stran';
$hesklang['opened']='odprt'; // The ticket has been OPENED
$hesklang['closed']='Zaključen'; // Ticket has been RESOLVED
$hesklang['ticket']='Zahtevek';
$hesklang['tickets']='Zahtevki';
$hesklang['ticket_been']='Ta zahtevek je bil';
$hesklang['view_ticket']='Poglej zahtevek';
$hesklang['open_tickets']='Odprti zahtevki';
$hesklang['remove_statement']='Odstrani &quot;Powered by&quot; obvestilo';
$hesklang['click_info']='Klikni tukaj za več informacij';
$hesklang['reply_added']='Odgovor dodan';
$hesklang['reply_submitted']='Odgovor oddan';
$hesklang['ticket_marked']='Ta zahtevek je bil';
$hesklang['ticket_status']='Status';
$hesklang['replies']='Odgovori';
$hesklang['date']='Datum';
$hesklang['email']='E-pošta';
$hesklang['ip']='IP';
$hesklang['message']='Sporočilo';
$hesklang['add_reply']='Dodaj odgovor';
$hesklang['close_this_ticket']='Zapri ta zahtevek';
$hesklang['change_priority']='Spremeni nujnost v';
$hesklang['attach_sign']='Dodaj podpis';
$hesklang['profile_settings']='Nastavitve profila';
$hesklang['submit_reply']='Pošlji odgovor';
$hesklang['support_panel']='Pomoč uporabnikom';
$hesklang['ticket_trackID']='Sledilna koda zahtevka';
$hesklang['c2c']='Kliknite za nadaljevanje';
$hesklang['tickets_deleted']='Zahtevki izbrisani';
$hesklang['num_tickets_deleted']='Število izbrisanih zahtevkov: <b>%d</b>';
$hesklang['confirm_del_cat']='Ste prepričani, da želite odstraniti to kategorijo?';
$hesklang['cat_intro']='Tukaj lahko upravljate kategorije. Te so koristne za združevanje zahtevkov po namembnosti (na primer &quot;Prodaja&quot;,
&quot;Podpora uporabnikom&quot;, &quot;Težave s strojno opremo&quot; itd) in za omejitev dostopa osebju (na primer vaši prodajalci lahko vidijo samo
zahtevke, objavljene v kategoriji &quot;Prodaja&quot;)';
$hesklang['cat_name']='Naziv kategorije';
$hesklang['remove']='Odstrani';
$hesklang['add_cat']='Nova kategorija';
$hesklang['max_chars']='Največ 40 znakov';
$hesklang['create_cat']='Ustvari kategorijo';
$hesklang['ren_cat']='Preimenuj kategorijo';
$hesklang['to']='do';
$hesklang['cat_added']='Kategorija dodana';
$hesklang['cat_name_added']='Kategorija %s je bila dodana';
$hesklang['cat_renamed']='Kategorija preimenovana';
$hesklang['cat_renamed_to']='izbrana kategorija je bila preimenovana v';
$hesklang['cat_removed']='Kategorija odstranjena';
$hesklang['cat_removed_db']='izbrana kategorija je bila odstranjen iz baze podatkov';
$hesklang['sure_remove_user']='Ste prepričani, da želite odstraniti tega uporabnika?';
$hesklang['manage_users']='Urejanje uporabnikov';
$hesklang['users_intro']='Tu lahko urejate uporabniške račune za osebje centra za podporo uporabnikom. Skrbniki imajo neomejen dostop do funkcij, drugim uporabnikom pa je mogoče omejiti dostop in pravice.';
$hesklang['yes']='DA';
$hesklang['no']='NE';
$hesklang['edit']='Uredi';
$hesklang['add_user']='Dodaj novega uporabnika';
$hesklang['req_marked_with']='Obvezna polja so označena z';
$hesklang['real_name']='Pravo ime';
$hesklang['signature_max']='Podpis (do 1000 znakov)';
$hesklang['sign_extra']='HTML koda ni dovoljena. Povezave bodo ustvarjene samodejno.';
$hesklang['create_user']='Dodaj uporabnika';
$hesklang['editing_user']='Urejanje uporabnika';
$hesklang['user_added']='Uporabnik dodan';
$hesklang['user_added_success']='uporabnik %s z geslom %s je bil ustvarjen';
$hesklang['profile_updated']='Profil posodobljen';
$hesklang['profile_updated_success']='Vaš profil je bil posodobljen';
$hesklang['user_removed']='Uporabnik odstranjen';
$hesklang['sel_user_removed']='izbrani uporabnik je bil odstranjen iz baze podatkov';
$hesklang['profile_for']='Profil za uporabnika:';
$hesklang['new_pass']='Novo geslo';
$hesklang['update_profile']='Posodobi profil';
$hesklang['notify_new_posts']='Obvestite me o novih zahtevkih in objavah v mojih kategorijah';
$hesklang['view_profile']='Ogled profila';
$hesklang['new_ticket_submitted']='Odprt je nov zahtevek';
$hesklang['user_profile_updated_success']='uporabniški profil je bil posodobljen';
$hesklang['printer_friendly']='Tiskalniku prijazna verzija';
$hesklang['end_ticket']='--- Konec zahtevka ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='zahtevek je bil';
$hesklang['view_your_ticket']='Ogled zahtevka';
$hesklang['submit_ticket']='Nov zahtevek';
$hesklang['sub_ticket']='Oddaj zahtevek';
$hesklang['before_submit']='Pred oddajo zahtevka preverite, da';
$hesklang['all_info_in']='ste vnesli vse zahtevane podatke';
$hesklang['all_error_free']='so vsi podatki točni in brez napak';
$hesklang['we_have']='Zabeležili bomo';
$hesklang['recorded_ip']='vaš IP naslov';
$hesklang['recorded_time']='Čas oddaje zahtevka';
$hesklang['save_changes']='Shrani spremembe';
$hesklang['reply_submitted_success']='Vaš odgovor je bil dodan zahtevku';
$hesklang['ticket_submitted']='zahtevek oddan';
$hesklang['ticket_submitted_success']='Zahtevek je bil oddan. Sledilna koda zahtevka';
$hesklang['your_ticket']='Vaš zahtevek';

// Added in version 0.94
$hesklang['check_updates']='Vedno imejte nameščeno najnovejšo različico programa Hesk!';
$hesklang['check4updates']='Preveri posodobitve';
$hesklang['wait_reply']='Potrebuje odgovor';
$hesklang['replied']='Odgovorjen';
$hesklang['last_replier']='Zadnji odgovoril';
$hesklang['staff']='Osebje';
$hesklang['customer']='Stranka';
$hesklang['close_selected']='Označi izbrane zahtevke kot zaključene';
$hesklang['execute']='Izvedi';
$hesklang['saved_replies']='Predloge odgovorov';
$hesklang['manage_saved']='Predloge odgovorov';
$hesklang['manage_intro']='Tukaj lahko dodate in upravljate predloge odgovorov. Te se običajno uporabljajo za odgovore, ki so bolj ali manj enaki za vsakega kupca. Uporabite predloge, da se izognete večkratnemu vnovičnemu tipkanju enakega odgovora različnim strankam.';
$hesklang['saved_title']='Naslov (do 50 znakov)';
$hesklang['no_saved']='Ni predlog odgovorov';
$hesklang['delete_saved']='Ste prepričani, da želite izbrisati to predlogo?';
$hesklang['new_saved']='Dodaj ali uredi predlogo odgovora';
$hesklang['canned_add']='Ustvari novo predlogo odgovora';
$hesklang['canned_edit']='Uredi izbrano predlogo odgovora';
$hesklang['save_reply']='Shrani odgovor';
$hesklang['saved']='Odgovor shranjen ';
$hesklang['your_saved']='predloga odgovora je bila shranjena za nadaljnjo uporabo';
$hesklang['ent_saved_title']='vnesite naslov predloge odgovora';
$hesklang['ent_saved_msg']='vnesite sporočilo';
$hesklang['saved_removed']='Predloga odgovora odstranjena';
$hesklang['saved_rem_full']='predloga odgovora je bila odstranjena';
$hesklang['clip_alt']='Sporočilo ima priponke';
$hesklang['attachments']='Priponke';
$hesklang['fill_all']='Manjka zahtevano polje';
$hesklang['file_too_large']='Vaša datoteka %s je prevelika';
$hesklang['cannot_move_tmp']='ne morem premakniti datoteke v mapo za priponke';
$hesklang['created_on']='Ustvarjen';
$hesklang['tickets_closed']='Zaključeni zahtevki';
$hesklang['num_tickets_closed']='<b>%d</b> zahtevkov je bilo zaključenih';
$hesklang['select_saved']='Izberi predlogo odgovora';
$hesklang['select_empty']='Izberi / Izbriši';
$hesklang['insert_special']='Vstavi posebno kodo (ta bo samodejno zamenjana s podatki stranke)';
$hesklang['move_to_catgory']='Premakni zahtevek v';
$hesklang['move']='Premakni';
$hesklang['moved']='Zahtevek premaknjen';
$hesklang['moved_to']='Zahtevek bo premaknjen v novo kategorijo';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Vsi, razen zaprti';
$hesklang['chg_all']='Spremeni vse';
$hesklang['settings']='Nastavitve';
$hesklang['settings_intro']='Tukaj lahko spreminjate nastavitve in prilagoditve centra za podporo uporabnikom. Za več informacij o možnostih in nastavitvah kliknite znak za pomoč [?] zraven nastavitve.';
$hesklang['all_req']='Vsa polja (razen onemogočenih) so obvezna!';
$hesklang['wbst_title']='Naziv spletne strani';
$hesklang['wbst_url']='URL spletne strani';
$hesklang['email_wm']='E-pošta skrbnika';
$hesklang['max_listings']='Izpisov na stran';
$hesklang['print_size']='Velikost pisave za tiskanje';
$hesklang['debug_mode']='Iskanje napak';
$hesklang['on']='Vključi';
$hesklang['off']='Izključi';
$hesklang['use_secimg']='Uporabi varnostno kodo';
$hesklang['secimg_no']='Ni na voljo';
$hesklang['attach_use']='Dovoli priponke';
$hesklang['attach_num']='Število priponk na sporočilo';
$hesklang['attach_type']='Dovoljene vrste datotek';
$hesklang['place_after']='Po sporočilu';
$hesklang['place_before']='Pred sporočilom';
$hesklang['custom_f']='Polja po meri';
$hesklang['custom_u']='Uporabi to polje';
$hesklang['custom_n']='Naziv polja';
$hesklang['custom_l']='Največja dolžina (znakov)';
$hesklang['db_host']='Gostitelj (host)';
$hesklang['db_name']='Ime baze';
$hesklang['db_user']='Uporabnik';
$hesklang['db_pass']='Geslo';
$hesklang['err_sname']='Vnesite naziv spletne strani';
$hesklang['err_surl']='Vnesite URL spletne strani. Pazite, da je veljaven URL (začne se s http:// ali https://)';
$hesklang['err_wmmail']='Vnesite veljavno e-pošto skrbnika';
$hesklang['err_nomail']='Vnesite veljavno &quot;ne odgovarjaj&quot; e-pošto';
$hesklang['err_htitle']='Vnesite naziv podporne plošče';
$hesklang['err_hurl']='Vnesite URL do HESK mape. Pazite, da je veljaven URL (začne se s http:// ali https://)';
$hesklang['err_lang']='Izberite jezik za HESK';
$hesklang['err_nolang']='Navedena datoteka ne obstaja v mapi z jeziki! Preverite, da ste naložili datoteko na strežnik, preden spreminjate jezik.';
$hesklang['err_max']='Določite največje število zapisov na stran';
$hesklang['err_psize']='Izberite velikost pisave za tiskanje';
$hesklang['err_dbhost']='Vnesite MySQL ime strežnika';
$hesklang['err_dbname']='Vnesite MySQL ime baze';
$hesklang['err_dbuser']='Vnesite MySQL uporabniško ime';
$hesklang['err_dbpass']='Vnesite MySQL geslo baze';
$hesklang['err_dbconn']='Ne morem se povezati z MySQL bazo';
$hesklang['err_dbsele']='Ne morem se povezati na MySQL bazo podatkov, prosim, dvakrat preverite IME podatkovne baze';
$hesklang['err_custname']='vnesite ime polja';
$hesklang['err_openset']='Ne morem odpreti datoteke <b>hesk_settings.inc.php</b> za pisanje. Nastavite CHMOD te datoteke na 666 (rw-rw-rw-)';
$hesklang['set_saved']='Nastavitve shranjene';
$hesklang['set_were_saved']='nastavitve so bile shranjene';
$hesklang['sec_img']='Varnostna koda';
$hesklang['sec_miss']='vnesite varnostno kodo';
$hesklang['sec_wrng']='napačna varnostna koda';
$hesklang['submit_problems']='Vrnite se in popravite naslednje napake';
$hesklang['cat_order']='Vrstni red kategorij';
$hesklang['reply_order']='Vrstni red predlog odgovorov';
$hesklang['move_up']='Premakni gor';
$hesklang['move_dn']='Premakni dol';
$hesklang['cat_move_id']='Manjka ID kategorije';
$hesklang['reply_move_id']='Manjka ID predloge odgovora';
$hesklang['forgot_tid']='Ste pozabili sledilno kodo?';
$hesklang['tid_send']='Pošlji mi sledilno kodo';
$hesklang['tid_not_found']='Noben zahtevek z vašim e-poštnim naslovom ne obstaja';
$hesklang['tid_sent']='sledilna koda poslana';
$hesklang['tid_sent2']='Obvestilo o vaših zahtevkih je bilo poslan na vaš e-poštni naslov';
$hesklang['check_spambox']='Preverite, ali je obvestilo zašlo med neželeno e-pošto!';
$hesklang['reply_not_found']='Predloge odgovora ni bilo mogoče najti';
$hesklang['exists']='Obstaja';
$hesklang['no_exists']='Manjka';
$hesklang['writable']='odklenjeno';
$hesklang['not_writable']='Zaklenjeno';
$hesklang['disabled']='Onemogočen';
$hesklang['e_settings']='Če HESK ne more pisati v to datoteko, ne boste mogli shraniti nastavitve. Preberite readme file za nadaljnja navodila!';
$hesklang['e_attdir']='Če HESK ne more pisati v to mapo, ne boste mogli dodajati priponk! Preberite readme file za nadaljnja navodila!';
$hesklang['e_save_settings']='Ne morem shraniti nastavitev, ker je datoteka <b>hesk_settings.inc.php</b> zaklenjena.';
$hesklang['e_attach']='Onemogočeno, ker HESK ne more pisati v mapo <b>attachments</b>.';
$hesklang['go']='Izvedi';

// Added in version 2.0
$hesklang['v']='HESK verzija';
$hesklang['check_status']='Preverjam status';
$hesklang['sub_support']='Nov zahtevek';
$hesklang['open_ticket']='Vnesite nov zahtevek za pomoč';
$hesklang['view_existing']='Ogled zahtevka';
$hesklang['vet']='Oglejte si in odgovorite na zahtevek';
$hesklang['enter_user']='Vnesite uporabniško ime';
$hesklang['remember_user']='Zapomni si moje uporabniško ime';
$hesklang['wrong_user']='Napačno uporabniško ime';
$hesklang['no_permission']='Nimate dovoljenja za izvedbo tega opravila, prijavite se z računom, ki ga ima.';
$hesklang['tickets_on_pages']='Število zahtevkov: %d | Število strani: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Skoči na stran:';
$hesklang['no_tickets_open']='Ni odprtih zahtevkov';
$hesklang['no_tickets_crit']='Ne najdem zahtevkov, ki bi ustrezali vašim pogojem';
$hesklang['confirm_execute']='Ste prepričani, da želite nadaljevati?';
$hesklang['legend']='Legenda';
$hesklang['main_page']='Domov';
$hesklang['menu_users']='Uporabniki';
$hesklang['menu_cat']='Kategorije';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Zbirka znanja'; // Admin MENU item
$hesklang['kb_text']='Zbirka znanja'; // Item visible to customers
$hesklang['viewkb']='Ogled celotne zbirke znanja';
$hesklang['kb']='Uredi zbirko znanja';
$hesklang['kb_intro']='Zbirka znanja je zbirka odgovorov na pogosto zastavljena vprašanja (FAQ) in pojasnil, ki stranki pomagajo, da sama reši težave.
Celovita in dobro napisana zbirka znanja lahko drastično zmanjša število zahtevkov, ki jih prejmete in prihrani veliko vašega časa. Odgovore lahko razvrščate v kategorije
in podkategorije.'; // Description in ADMIN panel
$hesklang['kb_is']='Zbirka znanja je kategorizirana zbirka odgovorov na pogosto zastavljena vprašanja (FAQ) in člankov. Lahko si preberete članke v tej kategoriji ali izberite podkategorijo, ki vas zanima.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Dodaj članek v zbirko znanja';
$hesklang['kb_cat']='Kategorija';
$hesklang['kb_subject']='Naslov';
$hesklang['kb_content']='Vsebina';
$hesklang['kb_type']='Vidnost';
$hesklang['kb_published']='Javno';
$hesklang['kb_published2']='Članek v zbirki znanja je viden vsem.';
$hesklang['kb_private']='Zasebno';
$hesklang['kb_private2']='Zasebne članke lahko bere samo osebje.';
$hesklang['kb_draft']='Osnutek';
$hesklang['kb_draft2']='Osnutek članka je shranjen. Vidi in ureja ga lahko osebje z dovoljenjem<br />za urejanje zbirke znanja.';
$hesklang['kb_links']='<i><span class="notice"><b>Pozor!</b></span><br />Vnesite veljavno kodo brez &lt;head&gt; in &lt;body&gt;, le vsebino!</i>';
$hesklang['kb_ehtml']='Vnesel sem veljavno (X)HTML kodo';
$hesklang['kb_dhtml']='Vnesel sem golo besedilo (Povezave bo mogoče klikniti)';
$hesklang['kb_save']='Shrani članek';
$hesklang['kb_e_subj']='vnesite naslov članka';
$hesklang['kb_e_cont']='napišite vsebino članka';
$hesklang['kb_art_added']='Članek dodan';
$hesklang['your_kb_added']='članek je bil dodan v zbirko znanja';
$hesklang['kb_art_deleted']='Članek izbrisan';
$hesklang['your_kb_deleted']='izbrani članki so bili izbrisani iz zbirke znanja';
$hesklang['kb_art_mod']='Članek spremenjen';
$hesklang['your_kb_mod']='spremembe v članku so bile shranjene';
$hesklang['kb_cat_new']='Nova kategorija v zbirki znanja';
$hesklang['kb_cat_parent']='Glavna kategorija';
$hesklang['kb_cat_sub']='Podkategorije';
$hesklang['kb_cat_title']='Naziv kategorije';
$hesklang['kb_cat_published']='Kategorija je dostopna vsem.';
$hesklang['kb_cat_private']='Kategorija je dostopna le osebju.';
$hesklang['kb_cat_add']='Dodaj kategorijo';
$hesklang['kb_cat_e_title']='vnesite naziv kategorije.';
$hesklang['kb_cat_added']='kategorija dodana';
$hesklang['kb_cat_added2']='nova kategorija je bila dodana v zbirko znanja';
$hesklang['kb_cat_man']='Urejanje kategorij v zbirki znanja';
$hesklang['kb_cat_edit']='Uredi nastavitve kategorije';
$hesklang['kb_cat_inv']='Neveljavna kategorija';
$hesklang['kb_cat_art']='Članki v tej kategoriji';
$hesklang['kb_p_art']='+ članek';
$hesklang['kb_p_art2']='Dodaj nov članek v izbrano kategorijo.';
$hesklang['kb_add_art']='Dodaj članek';
$hesklang['kb_p_cat']='+ Kategorija';
$hesklang['kb_p_cat2']='Ustvari novo podkategorijo v izbrani kategoriji.';
$hesklang['kb_add_cat']='Dodaj kategorijo';
$hesklang['kb_p_man']='Uredi';
$hesklang['kb_p_man2']='Uredi izbrano kategorijo (popravi, izbriši, uredi članke).';
$hesklang['kb_main']='Privzete kategorije v zbirki znanja ne morete izbrisati ali premakniti.';
$hesklang['kb_no_art']='V tej kategoriji ni člankov.';
$hesklang['author']='Avtor';
$hesklang['views']='Število ogledov';
$hesklang['delete']='Izbriši';
$hesklang['rating']='Ocena';
$hesklang['votes']='Glasov';
$hesklang['kb_rated']='Ocena članka %s/5.0';
$hesklang['kb_not_rated']='Članek še ni ocenjen';
$hesklang['del_art']='Res želite izbrisati ta članek?';
$hesklang['kb_art_id']='ID članka manjka ali ni pravilen!';
$hesklang['kb_art_edit']='Uredi članek';
$hesklang['revhist']='Zgodovina urejanja';
$hesklang['revision1']='<li class="smaller">%s | ustvaril %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | spremenil %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Razvrsti';
$hesklang['kb_delcat']='Ste prepričani, da želite izbrisati to kategorijo?';
$hesklang['kb_cat_mod']='Kategorija urejena';
$hesklang['your_cat_mod']='spremembe v izbrani kategoriji so bile shranjene';
$hesklang['kb_cat_del']='Kategorija zbirke znanja izbrisana';
$hesklang['kb_cat_dlt']='Izbrana kategorija zbirke znanja je bila izbrisana.';
$hesklang['allowed_cat']='Kategorije';
$hesklang['allow_feat']='Funkcije';
$hesklang['can_view_tickets']='Ogled zahtevkov';
$hesklang['can_reply_tickets']='Odgovarjanje na zahtevke';
$hesklang['can_assign_tickets']='Dodeljevanje zahtevkov';
$hesklang['can_del_tickets']='Brisanje zahtevkov';
$hesklang['can_edit_tickets']='Urejanje zahtevkov';
$hesklang['can_change_cat']='Lahko premakne zahtevek v katerokoli drugo kategorijo';
$hesklang['can_man_kb']='Urejanje zbirke znanja';
$hesklang['can_man_users']='Urejanje uporabnikov';
$hesklang['can_man_cat']='Urejanje kategorij';
$hesklang['can_man_canned']='Urejanje predlog odgovorov';
$hesklang['can_man_settings']='Urejanje nastavitev podpore';
$hesklang['can_del_notes']='Brisanje opomb na zahtevkih';
$hesklang['dan']='Uporabniki lahko izbrišejo svoje opombe na zahtevkih. To izberite le, če želite temu uporabniku omogočiti tudi brisanje opomb drugih uporabnikov';
$hesklang['in_all_cat']='znotraj dodeljenih kategorij';
$hesklang['admin_can']='(ima dostop do vseh funkcij in kategorij)';
$hesklang['staff_can']='(lahko omejite dostop do funkcij in kategorij)';
$hesklang['asign_one_feat']='Dodelite vsaj eno kategorijo temu uporabniku!';
$hesklang['na_view_tickets']='Nimate dovoljenja za ogled tega zahtevka';
$hesklang['support_notice']='Za odstranitev tega obvestila je potreben nakup licence.';
$hesklang['rart']='Vam je bil članek v pomoč?';
$hesklang['r']='Vam je bil ta odgovor v pomoč?';
$hesklang['tyr']='Hvala za oceno';
$hesklang['cw']='Zapri okno';
$hesklang['cw2']='Zapri okno in pošlji zahtevek';
$hesklang['rh']='Odgovor je bil v pomoč';
$hesklang['rnh']='Odgovor ni bil v pomoč';
$hesklang['ar']='Že ocenjen';
$hesklang['rated']='Uporabnik ocenjen %s/5.0 (%s glasov)';
$hesklang['not_rated']='Uporabnik še ni bil ocenjen';
$hesklang['rdis']='Ocenjevanje je onemogočeno';
$hesklang['kbdis']='Zbirka znanja je onemogočena';
$hesklang['kbpart']='Oprostite, nimate pravic za dostop do tega članka';
$hesklang['popart']='Priljubljeni članki:';
$hesklang['latart']='Najnovejši članki:';
$hesklang['m']='Pokaži več';
$hesklang['ac']='Članki v tej kategoriji:';
$hesklang['noa']='Ni člankov';
$hesklang['noac']='Ni člankov';
$hesklang['dta']='Datum vnosa:';
$hesklang['ad']='Podrobnosti članka';
$hesklang['aid']='ID številka';
$hesklang['as']='Rešitev';
$hesklang['search']='Išči';
$hesklang['sr']='Rezultati iskanja';
$hesklang['nosr']='Ni ustreznih člankov. Poskusite prebrskati zbirko znanja ali odprite nov zahtevek v centru za pomoč uporabnikom.';
$hesklang['rv']='Ponastavi število ogledov';
$hesklang['rr']='Ponastavi število glasov in oceno';
$hesklang['opt']='Možnosti';
$hesklang['delcat']='Izbriši kategorijo';
$hesklang['move1']='Premakni članke v glavno kategorijo';
$hesklang['move2']='Izbriši članke v tej kategoriji';
$hesklang['sc']='Predlogi iz zbirke znanja';
$hesklang['not']='Zahtevkov'; // Number of all tickets in category
$hesklang['graph']='Diagram';
$hesklang['lu']='Seznam uporabnikov';
$hesklang['aclose']='Samodejno zapri zahtevke';
$hesklang['aclose2']='dni po zadnjem odgovoru osebja';
$hesklang['s_ucrt']='Stranka lahko ponovno odpre zahtevek';
$hesklang['urate']='Stranka lahko oceni odgovor';
$hesklang['hesk_url']='URL centra za podporo';
$hesklang['hesk_title']='Naziv centra';
$hesklang['cid']='Sledilna koda';
$hesklang['tfor']='Zapis časa';
$hesklang['prefix']='Predpona tabel';
$hesklang['s_ekb']='Omogoči zbirko znanja';
$hesklang['s_kbs']='Omogoči iskanje po ZZ';
$hesklang['s_kbr']='Omogoči ocenjevanje ZZ';
$hesklang['s_maxsr']='Število zadetkov';
$hesklang['s_suggest']='Predlagaj članke iz ZZ';
$hesklang['s_spop']='Prikaži priljubljene članke';
$hesklang['s_slat']='Prikaži zadnje članke';
$hesklang['s_onin']='na <a href="../" target="_blank">začetni strani</a>';
$hesklang['s_onkb']='na strani <a href="../knowledgebase.php" target="_blank">Zbirka znanja</a>';
$hesklang['s_scol']='Kategorije v vrsti';
$hesklang['s_ptxt']='Dolžina predogleda člankov';
$hesklang['s_psubart']='Članki v podkategoriji';
$hesklang['enable']='Omogoči';
$hesklang['s_type']='Tip';
$hesklang['custom_r']='Obvezno';
$hesklang['custom_place']='Lokacija';
$hesklang['custom_use']='Polja po meri';
$hesklang['stf']='Vrstica besedila (text)';
$hesklang['stb']='Polje besedila (textarea) ';
$hesklang['srb']='Izbirni gumb (radio)';
$hesklang['ssb']='Izbirni meni (select)';
$hesklang['db']='MySQL baza';
$hesklang['hd']='Nastavitve podpore';
$hesklang['gs']='Splošne nastavitve';
$hesklang['cwin']='Zapri okno';
$hesklang['defw']='Privzeta vrednost';
$hesklang['ok']='V redu';
$hesklang['ns']='Za polja po meri so na voljo te možnosti. Da shranite spremembe, kliknite <b>OK</b> in gumb <b>Shrani spremembe</b> na dnu strani!';
$hesklang['rows']='Vrstice (višina)';
$hesklang['cols']='Stolpci (širina)';
$hesklang['opt2']='Možne vrednosti za to polje. Vnesite po eno vrednost v vsako vrstico (vsaka vrstica bo prikazana kot izbirni gumb). Vnesti morate vsaj dve vrednosti.';
$hesklang['opt3']='Možne vrednosti za to polje. Vnesite po eno vrednost v vsako vrstico (vsaka vrstica bo prikazana kot izbirni meni). Vnesti morate vsaj dve vrednosti.';
$hesklang['atl2']='vnesite vsaj dve vrednosti (eno v vsako vrstico)';
$hesklang['notes']='Opombe';
$hesklang['addnote']='+ Dodaj opombo';
$hesklang['noteby']='Opombo dodal/a';
$hesklang['delnote']='Izbriši opombo';
$hesklang['noteerr']='Opomba je že izbrisana ali napačni parametri';
$hesklang['s']='Shrani';
$hesklang['nhid']='Opombe so skrite pred očmi strank!';
$hesklang['delt']='Izbriši sporočilo';
$hesklang['edtt']='Uredi sporočilo';
$hesklang['edt1']='Sporočilo urejeno';
$hesklang['edt2']='Spremembe v sporočilu so shranjene';
$hesklang['dele']='Izbriši ta zahtevek';
$hesklang['repd']='Odgovor izbrisan';
$hesklang['repl']='Izbrani odgovor je bil izbrisan';
$hesklang['tickets_found']='Rezultati iskanja';
$hesklang['al']='Nadzorna plošča';
$hesklang['ap']='Prijava v nadzorno ploščo';
$hesklang['dap']='Prikaži povezavo do nadzorne plošče na <a href="../" target="_blank">prvi strani</a>';
$hesklang['q_miss']='Odgovorite na varnostno vprašanje';
$hesklang['use_q']='Varnostno vprašanje';
$hesklang['q_q']='-&gt; Vprašanje (HTML koda je <font class="success">dovoljena</font>)';
$hesklang['q_a']='-&gt; Odgovor';
$hesklang['err_qask']='Vnesite varnostno vprašanje';
$hesklang['err_qans']='Vnesite odgovor na varnostno vprašanje';
$hesklang['genq']='ustvari naključno vprašanje';

// Added in version 2.1
$hesklang['amo']='Dodaj nove';
$hesklang['delatt']='Izbrišem priponko?';
$hesklang['kb_att_rem']='priponka je bila odstranjena';
$hesklang['inv_att_id']='Napačen ID priponke!';
$hesklang['scb']='Potrdilno polje (checkbox)';
$hesklang['opt4']='Možne vrednosti za to polje. Vnesite po eno vrednost v vsako vrstico (vsaka vrstica bo prikazana kot potrdilno polje).';
$hesklang['autologin']='Samodejna prijava ob vsakem obisku';
$hesklang['just_user']='Zapomni si moje uporabniško ime';
$hesklang['nothx']='Ne, hvala';
$hesklang['pinfo']='Nastavitve profila';
$hesklang['sig']='Podpis';
$hesklang['pref']='Možnosti';
$hesklang['aftrep']='Ko odgovorim na zahtevek';
$hesklang['showtic']='pokaži zahtevek, na katerega sem pravkar odgovoril';
$hesklang['gomain']='se vrni na glavno stran nadzorne plošče';
$hesklang['shownext']='odpri naslednji zahtevek, ki čaka moj odgovor';
$hesklang['rssn']='Prikazujem naslednji zahtevek, ki čaka odgovor';
$hesklang['mrep']='Zamenjaj trenutno sporočilo';
$hesklang['madd']='Dodaj na dno sporočila';
$hesklang['priv']='Zasebne kategorije in članki, vidni samo osebju, so označeni z *';
$hesklang['inve']='Neveljavna e-poštna datoteka';
$hesklang['emfm']='Manjka e-poštna datoteka';
$hesklang['hesk_lang']='Privzeti jezik';
$hesklang['s_mlang']='Izbira jezika';
$hesklang['s_mlange']='Obiskovalci bodo lahko sami izbrali jezik. Omogočite le, če nudite podporo v vseh nameščenih jezikih!';
$hesklang['s_inl']='Testiraj mapo z jeziki';
$hesklang['s_inle']='Iščem veljavne prevode za HESK. Samo prevodi, ki ustrezajo vsem merilom, bodo objavljeni.';
$hesklang['ta']='Preveri ponovno';
$hesklang['alo']='Samodejna prijava';
$hesklang['chol']='Privzeti jezik';
$hesklang['mmdl']='Nastavi kot moj privzeti jezik';
$hesklang['warn']='POZOR';
$hesklang['dmod']='Vklopljen je način za odpravljanje napak. Po končanem testiranju ga izklopite za normalno delovanje.';
$hesklang['kb_spar']='Kategorija ne more biti lastna nadrejena kategorija!';
$hesklang['mysql_root']='Vaše geslo za MySQL bazo je prazno, res želite tako geslo? To je precejšnje varnostno tveganje!';
$hesklang['chg']='Spremeni';
$hesklang['chpri']='Nujnost spremenjena';
$hesklang['chpri2']='Nujnost zahtevka je bila spremenjena v %s';
$hesklang['selcan']='Izberi predlogo odgovora, ki jo želiš urediti';
$hesklang['q_wrng']='Napačen odgovor na varnostno vprašanje';
$hesklang['cndupl']='Kategorija s tem imenom že obstaja. Izberite unikatno ime za vsako kategorijo.';
$hesklang['wsel']='Izberite polje, po katerem želite iskati';

// Added in version 2.2
$hesklang['eto']='Napačna zahteva';
$hesklang['id']='ID';
$hesklang['geco']='Neposredna povezava';
$hesklang['genl']='Neposredna povezava do kategorije';
$hesklang['genl2']='Uporabi to povezavo za predizbor kategorije v obrazcu za vnos novega zahtevka.';
$hesklang['ask']='Iskanje:';
$hesklang['exa']='zahtevki';
$hesklang['small']='Malo iskalno polje';
$hesklang['large']='Veliko iskalno polje';
$hesklang['cpri']='Stranka lahko izbere nujnost zahtevka';
$hesklang['owner']='Lastnik';
$hesklang['unas']='Nedodeljen';
$hesklang['assi']='Dodeli';
$hesklang['asst']='Dodeli uporabniku';
$hesklang['asst2']='Dodeli ta zahtevek k';
$hesklang['asss']='Dodeli sebi';
$hesklang['asss2']='Dodeli ta zahtevek sebi';
$hesklang['can_assign_self']='Zahtevek lahko dodeli sebi';
$hesklang['can_assign_others']='Zahtevek lahko dodeli drugim';
$hesklang['can_run_reports']='Lahko ustvari poročila (lastna)';
$hesklang['can_view_ass_others']='Lahko vidi zahtevke, dodeljene drugim';
$hesklang['unoa']='Izbrani uporabnik nima dostopa do te kategorije';
$hesklang['tasi']='Lastnik dodeljen';
$hesklang['tasy']='zahtevek vam je bil dodeljen';
$hesklang['taso']='zahtevek je bil dodeljen izbranemu uporabniku';
$hesklang['tasy2']='Dodeljen meni';
$hesklang['taso2']='Dodeljen drugemu osebju';
$hesklang['nose']='Izberi novega lastnika';
$hesklang['onasc']='Ta lastnik nima dostopa do izbrane kategorije.';
$hesklang['tunasi']='zahtevek nedodeljen';
$hesklang['tunasi2']='zahtevek je brez lastnika in pripravljen, da se nekomu dodeli';
$hesklang['note']='Opomba';
$hesklang['success']='V redu';
$hesklang['nyt']='Ta zahtevek je dodeljen';
$hesklang['noch']='nobena sprememba ni bila narejena';
$hesklang['orch']='vrstni red prikaza je bil spremenjen';
$hesklang['rfm']='manjkajo potrebne informacije:';
$hesklang['repl0']='nezadostna dovoljenja za izvajanje te naloge';
$hesklang['repl1']='ta objava ne obstaja';
$hesklang['reports']='Poročila';
$hesklang['reports_intro']='Poročila vam omogočajo ogled več vrst poročil in statistiko zahtevkov v želenem časovnem obdobju.';
$hesklang['refi']='Ponastavi podatke obrazca';
$hesklang['dich']='Zavrzi spremembe';
$hesklang['dire']='Prikaži poročilo';
$hesklang['m1']='januar';
$hesklang['m2']='februar';
$hesklang['m3']='marec';
$hesklang['m4']='april';
$hesklang['m5']='maj';
$hesklang['m6']='junij';
$hesklang['m7']='julij';
$hesklang['m8']='avgust';
$hesklang['m9']='september';
$hesklang['m10']='oktober';
$hesklang['m11']='november';
$hesklang['m12']='december';
$hesklang['d1']='ponedeljek';
$hesklang['d2']='torek';
$hesklang['d3']='sreda';
$hesklang['d4']='četrtek';
$hesklang['d5']='petek';
$hesklang['d6']='sobota';
$hesklang['d0']='nedelja';
$hesklang['mo']='po';
$hesklang['tu']='to';
$hesklang['we']='sr';
$hesklang['th']='če';
$hesklang['fr']='pe';
$hesklang['sa']='so';
$hesklang['su']='ne';
$hesklang['from']='Od';
$hesklang['cinv']='Napačen datum';
$hesklang['cinv2']='Sprejemljiv format je mm/dd/LLLL';
$hesklang['cinm']='Neveljavna vrednost za mesec';
$hesklang['cinm2']='Dovoljen obseg je';
$hesklang['cind']='Neveljavna vrednost za dan v mesecu';
$hesklang['cind2']='Dovoljen obseg za izbrani mesec je';
$hesklang['month']='Mesec';
$hesklang['ocal']='Odpri koledar';
$hesklang['ca01']='Prejšnje leto';
$hesklang['ca02']='Prejšnji mesec';
$hesklang['ca03']='Naslednji mesec';
$hesklang['ca04']='Naslednje leto';
$hesklang['ca05']='Zapri koledar';
$hesklang['cdr']='Izberite časovno obdobje:';
$hesklang['crt']='Tip poročila';
$hesklang['r1']='Danes';
$hesklang['r2']='Včeraj';
$hesklang['r3']='Ta mesec';
$hesklang['r4']='Zadnji mesec';
$hesklang['r5']='Zadnjih 30 dni';
$hesklang['r6']='Ta teden (pon-ned)';
$hesklang['r7']='Prejšnji teden (pon-ned)';
$hesklang['r8']='Ta delovni teden (pon-pet)';
$hesklang['r9']='Prejšnji delovni teden (pon-pet)';
$hesklang['r10']='Letos';
$hesklang['r11']='Lani';
$hesklang['r12']='Od začetka';
$hesklang['datetofrom']='&quot;Datum od&quot; ne sme biti višji kot &quot;datum do&quot;, zato bosta zamenjana.';
$hesklang['t1']='Po dnevih';
$hesklang['t2']='Po mesecih';
$hesklang['t3']='Po uporabnikih';
$hesklang['t4']='Po kategorijah';
$hesklang['ticass']='Dodeljeni zahtevki';
$hesklang['ticall']='Odgovorov na zahtevke';
$hesklang['totals']='Skupaj';
$hesklang['all']='Vsi';
$hesklang['atik']='Novi zahtevki';
$hesklang['kbca']='V zbirki znanja že imate kategorijo s tem imenom.';
$hesklang['menu_msg']='Pošta';
$hesklang['menu_can']='Predloge';
$hesklang['m_from']='Od:'; // Mail "from" address
$hesklang['m_to']='Za:'; // Mail "to" address
$hesklang['m_sub']='Zadeva:'; // Mail subject
$hesklang['m_re']='Odgovori:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Posreduj:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Zasebna sporočila';
$hesklang['m_intro']='Uporabi zasebna sporočila za pošiljanje hitrih sporočil za druge člane osebja v HESK.';
$hesklang['e_udel']='(Uporabnik izbrisan)';
$hesklang['new_mail']='Novo zasebno sporočilo';
$hesklang['m_send']='Pošlji sporočilo';
$hesklang['m_rec']='izberite prejemnike sporočila';
$hesklang['m_inr']='napačen prejemnik sporočila';
$hesklang['m_esu']='vnesite zadevo zasebnega sporočila';
$hesklang['m_pms']='zasebno sporočilo je bilo poslano';
$hesklang['inbox']='PREJETO';
$hesklang['outbox']='POSLANO';
$hesklang['m_new']='NOVO SPOROČILO';
$hesklang['pg']='Prikaži stran';
$hesklang['npm']='V tej mapi ni zasebnih sporočil.';
$hesklang['m_ena']='Nimate ustreznih pravic za branje tega sporočila.';
$hesklang['mau']='Označi kot neprebrano';
$hesklang['mo1']='Označi izbrana sporočila kot prebrana';
$hesklang['mo2']='Označi izbrana sporočila kot neprebrana';
$hesklang['mo3']='Izbriši izbrana sporočila';
$hesklang['delm']='Izbriši to sporočilo';
$hesklang['e_tid']='Napaka pri generiranju ID-ja zahtevka, prosim, poskusite poslati obrazec pozneje.';
$hesklang['smmr']='izbrana sporočila so bila označena kot prebrana';
$hesklang['smmu']='izbrana sporočila so bila označena kot neprebrana';
$hesklang['smdl']='izbrana sporočila so bila izbrisana';
$hesklang['show']='Prikaži';
$hesklang['s_my']='Dodeljen meni';
$hesklang['s_ot']='Dodeljen drugim';
$hesklang['s_un']='Nedodeljeni zahtevki';
$hesklang['s_for']='Išči besedo';
$hesklang['s_in']='Išči v';
$hesklang['s_incl']='Išči med';
$hesklang['find_ticket_by']='Najdi zahtevek';
$hesklang['e_nose']='Noben status dodelitve ni izbran, prikazujem vse zahtevke.';
$hesklang['fsq']='Vpišite svojo poizvedbo';
$hesklang['topen']='Odprti zahtevki';
$hesklang['nms']='nobeno sporočilo ni bilo izbrano';
$hesklang['tlo']='Zakleni zahtevek';
$hesklang['tul']='Odkleni zahtevek';
$hesklang['loc']='Zaklenjeno';
$hesklang['isloc']='Stranke ne morejo odgovarjati ali ponovno odpirati zaklenjenih zahtevkov. Ko je zahtevek zaklenjen, je označen kot razrešen.';
$hesklang['tlock']='zahtevek je zaklenjen';
$hesklang['tunlock']='zahtevek je bil odklenjen';
$hesklang['tislock']='Ta zahtevek je bil zaklenjen, stranka ne bo mogla odgovoriti nanj.';
$hesklang['tislock2']='Ta zahtevek je bil zaklenjen, zato ne morete objaviti odgovora.';
$hesklang['nsfo']='Ni predlogov.';
$hesklang['thist1']='<li class="smaller">%s | premaknjen v kategorijo %s s strani uporabnika %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | dodeljen uporabniku %s s strani uporabnika %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | zaprl %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | odprl %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | zaklenil %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | odklenil %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | zahtevek ustvaril %s</li>'; // %s = date, user making change
$hesklang['elocked']='Ta zahtevek je bi zaklenjen ali izbrisan.';
$hesklang['nti2']='Dodaj nov zahtevek';
$hesklang['nti3']='Uporabite ta obrazec za vnos novega zahtevka v imenu stranke. Vnesite podatke o stranki (ime stranke, e-poštni naslov, ...) in NE vaše podatke.';
$hesklang['addop']='Možnosti';
$hesklang['seno']='Pošlji obvestilo stranki po e-pošti';
$hesklang['otas']='Pokaži vsebino zahtevka po pošiljanju';
$hesklang['notn']='Obvestila';
$hesklang['nomw']='Center za pomoč uporabnikom naj pošlje obvestilo po e-pošti, ko:';
$hesklang['nwts']='Je predložen nov zahtevek s statusom:';
$hesklang['ncrt']='Stranka odgovori na zahtevek s statusom:';
$hesklang['ntam']='Je zahtevek dodeljen meni';
$hesklang['npms']='Mi je poslano zasebno sporočilo';
$hesklang['support_remove']='Veliko časa in truda je šlo v razvoj tega centra za podporo uporabnikom.<br /><br />Podprite nadaljnji razvoj in kupite licenco, ki bo odstranila povezavo <i>Powered by Help Desk Software HESK</i> iz vašega centra za pomoč uporabnikom';
$hesklang['ycvtao']='Nimate dovoljenja za ogled zahtevkov, dodeljenih drugim';
$hesklang['password_not_valid']='geslo mora vsebovati vsaj 5 znakov (raje več)';
$hesklang['lkbs']='Nalagam predloge iz zbirke znanja ...';
$hesklang['auto']='(samodejno)';

// Added in version 2.3
$hesklang['unknown']='Neznano';
$hesklang['pcer']='odpravite naslednje pomanjkljivosti:';
$hesklang['seqid']='ID številka';
$hesklang['close_action']='Označi kot rešen'; // Close ACTION
$hesklang['archived']='Značka';
$hesklang['archived2']='Zahtevek z značko';
$hesklang['add_archive']='Pripni značko zahtevku';
$hesklang['add_archive_quick']='Pripni značke izbranim zahtevkom';
$hesklang['remove_archive']='Odpni značko s tega zahtevka';
$hesklang['remove_archive_quick']='Odpni značke z zahtevkov';
$hesklang['added_archive']='značka pripeta zahtevku';
$hesklang['removed_archive']='značka odpeta z zahtevka';
$hesklang['added2archive']='zahtevek je bila pripeta značka';
$hesklang['removedfromarchive']='značka je bila odpeta z zahtevka';
$hesklang['num_tickets_tag']='(<b>%d</b>) Značka je bila pripeta zahtevkom';
$hesklang['num_tickets_untag']='(<b>%d</b>) Značka je bila odpeta z zahtevkov';
$hesklang['can_add_archive']='Zahtevkom lahko pripne značko';
$hesklang['disp_only_archived']='Samo zahtevke z značko';
$hesklang['search_only_archived']='Samo zahtevke z značko';
$hesklang['critical']='Kritična';
$hesklang['thist8']='<li class="smaller">%s | nujnost spremenjena v %s s strani uporabnika %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status spremenjen v %s s strani uporabnika %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | samodejno dodeljen uporabniku %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | ustvarjen preko e-pošte</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='l';
$hesklang['abbr']['month']='m';
$hesklang['abbr']['week']='t';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Ne morem poslati sporočila k:';
$hesklang['yhbb']='zaradi prevelikega števila napačnih prijav ste bili blokirani za %s minut.';
$hesklang['pwdst']='Zahtevnost gesla';
$hesklang['tid_mail']='Nič hudega! Vpišite svoj <b>e-poštni naslov</b> in poslali vam jo bomo:';
$hesklang['rem_email']='Zapomni si moj e-poštni naslov';
$hesklang['eytid']='vnesite sledilno kodo zahtevka.';
$hesklang['enmdb']='vneseni e-poštni naslov se ne ujema z e-poštnim naslovom zahtevka v bazi podatkov.';
$hesklang['confemail']='E-pošta (ponovno)';
$hesklang['confemail2']='potrdite svoj e-poštni naslov';
$hesklang['confemaile']='vnesena e-poštna naslova se ne ujemata';
$hesklang['taso3']='Dodeljen:';
$hesklang['sec_enter']='Vnesite številko, ki jo vidite na spodnji sliki.';
$hesklang['reload']='Prikaži novo sliko';
$hesklang['verify_q']='Varnostno vprašanje:'; // For anti-spam question
$hesklang['verify_i']='Varnostna slika:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Prijava v nadzorno ploščo';
$hesklang['vrfy']='Test opravljen';
$hesklang['last_update']='Posodobljen';
$hesklang['cot']='Ne sili kritičnih zahtevkov na vrh';
$hesklang['def']='Shrani kot moj privzeti pogled';
$hesklang['gbou']='zahtevki, ki <b>niso dodeljeni</b>:';
$hesklang['gbom']='zahtevki, dodeljeni <b>meni</b>:';
$hesklang['gboo']='zahtevki, dodeljeni <b>%s</b>:';
$hesklang['select']=' - - Klikni za izbiro - - ';
$hesklang['chngstatus']='Spremeni status v';
$hesklang['perat']='%s vseh zahtevkov'; // Will change to "23% of all tickets"
$hesklang['viewart']='Preberi članek';
$hesklang['chdp']='Prosimo, da spremenite privzeto geslo za vašo <a href="profile.php">Profile</a> stran!';
$hesklang['chdp2']='Spremenite svoje geslo, trenutno uporabljate privzeto geslo!';
$hesklang['security']='Varnost';
$hesklang['kb_i_art']='Nov članek';
$hesklang['kb_i_art2']='Dodaj članek';
$hesklang['kb_i_cat']='Nova kategorija';
$hesklang['kb_i_cat2']='Vrini kategorijo';
$hesklang['gopr']='Preglej zbirko znanja';
$hesklang['kbstruct']='Struktura zbirke znanja';
$hesklang['cancel']='Prekliči';
$hesklang['sh']='Skrij obvestilo';
$hesklang['goodkb']='Kako napisati dobre članke za zbirko znanja?';
$hesklang['catset']='Nastavitev kategorij';
$hesklang['inpr']='Izberite novo nujnost';
$hesklang['incat']='Izberite novo kategorijo';
$hesklang['instat']='Izberite nov status';
$hesklang['tsst']='Status zahtevka je bil nastavljen na %s';
$hesklang['aass']='Samodejno dodeli';
$hesklang['aaon']='Temu uporabniku se bodo zahtevki dodeljevali samodejno (klikni za izklop)';
$hesklang['aaoff']='Temu uporabniku se zahtevki ne bodo dodeljevali samodejno (klikni za vklop)';
$hesklang['uaaon']='samodejno dodeljevanje zahtevkov je vklopljeno za izbrane uporabnike';
$hesklang['uaaoff']='samodejno dodeljevanje zahtevkov je izklopljeno za izbrane uporabnike';
$hesklang['taasy']='Ta zahtevek vam je bil dodeljen samodejno';
$hesklang['can_view_unassigned']='Lahko si ogleda nedodeljene zahtevke';
$hesklang['ycovtay']='Vidite lahko samo zahtevke, ki so vam dodeljeni';
$hesklang['in_progress']='V teku';
$hesklang['on_hold']='Zadržan';
$hesklang['import_kb']='Uvozi ta zahtevek v članek za zbirko znanja';
$hesklang['import']='Uvažate <i>zasebni zahtevek</i> v <i>javni članek</i>.<br /><br />Prepričajte se, da ste izbrisali vse osebne ali občutljive podatke iz naslova in vsebine zahtevka!';
$hesklang['tab_1']='Splošno';
$hesklang['tab_2']='Podpora uporabnikom';
$hesklang['tab_3']='Zbirka znanja';
$hesklang['tab_4']='Polja po meri';
$hesklang['tab_5']='Razno';
$hesklang['disable']='Onemogoči';
$hesklang['dat']='Datum &amp; ura';
$hesklang['lgs']='Jezik';
$hesklang['onc']='DA - stranke';
$hesklang['ons']='Vključi - za vse';
$hesklang['viewvtic']='Ogled zahtevkov';
$hesklang['reqetv']='Zahtevaj e-poštni naslov za ogled zahtevka';
$hesklang['banlim']='Število poskusov prijave';
$hesklang['banmin']='Čas prepovedi (minut)';
$hesklang['subnot']='Prikaži opombe';
$hesklang['subnot2']='Prikaži opombe strankam na obrazcu za nov zahtevek';
$hesklang['eseqid']='Zaporedni ID-ji';
$hesklang['sconfe']='Potrdite e-poštni naslov';
$hesklang['saass']='Samodejno dodeljevanje zahtevkov';
$hesklang['swyse']='WYSIWYG urejevalnik';
$hesklang['hrts']='Oceni HESK';
$hesklang['hrts2']='Prikaži povezavo "oceni to skripto" v Nadzorni plošči';
$hesklang['emlpipe']='Uvoze e-pošte (piping)';
$hesklang['emlsend2']='Za pošiljanje uporabi';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Strežnik';
$hesklang['smtph']='SMTP gostitelj (host)';
$hesklang['smtpp']='SMTP vrata';
$hesklang['smtpu']='SMTP uporabnik';
$hesklang['smtpw']='SMTP geslo';
$hesklang['smtpt']='SMTP časova omejitev';
$hesklang['other']='Ostalo';
$hesklang['features']='Lastnosti';
$hesklang['can_view_online']='Lahko vidi osebje, ki je trenutno prijavljeno';
$hesklang['online']='Trenutno aktiven';
$hesklang['offline']='Trenutno neaktivni';
$hesklang['onlinep']='Trenutno aktivni'; // For display in footer
$hesklang['sonline']='Trenutno aktivni'; // For settings page
$hesklang['sonline2']='Prikaži trenutno aktivne uporabnike. Omejitev (minut):'; // For settings page
$hesklang['gb']='Združi po';
$hesklang['dg']='Ne združuj';
$hesklang['err_dpi']='Podatkovna baza %s ne vsebuje vseh HESK tabel s predpono %s, spremembe niso shranjene.';
$hesklang['err_dpi2']='Tabele ni mogoče najti:';
$hesklang['sme']='SMTP napaka';
$hesklang['scl']='Podrobnosti SMTP povezave';
$hesklang['dnl']='Prenesi';
$hesklang['dela']='Izbriši to priponko';
$hesklang['pda']='Želite za vedno izbrisati to priponko?';
$hesklang['thist12']='<li class="smaller">%s | priponko %s odstranil %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Več možnosti';
$hesklang['lopt']='Manj možnosti';
$hesklang['meml']='Dodatni e-poštni naslovi';
$hesklang['meml2']='Stranki omogoči vnos več e-poštnih naslovov';

// Added in version 2.4
$hesklang['catd']='(kategorija izbrisana)';
$hesklang['noopen']='Ni najdenih odprtih zahtevkov za ta e-poštni naslov.';
$hesklang['maxopen']='Dosegli ste največje število odprtih zahtevkov (%d od %d). Počakajte na razplet obstoječih zahtevkov, preden odprete nove.';
$hesklang['ntnote']='Je dodana opomba v zahtevek, ki mi je dodeljen';
$hesklang['cat_public']='Javna';
$hesklang['cat_private']='Zasebna';
$hesklang['cat_aa']='Samodejno dodeli zahtevke v tej kategoriji.';
$hesklang['cat_type']='Tip kategorije';
$hesklang['caaon']='Samodejno dodeljevanje je bilo omogočeno za izbrano kategorijo';
$hesklang['caaoff']='Samodejno dodeljevanje je bilo onemogočeno za izbrano kategorijo';
$hesklang['cpub']='kategorija je spremenjena v JAVNO';
$hesklang['cpriv']='kategorija je spremenjena v ZASEBNO';
$hesklang['cpric']='Stranke ne morejo izbirati zasebnih kategorij, lahko jih samo osebje!';
$hesklang['user_aa']='Samodejno dodeli zahtevke temu uporabniku.';
$hesklang['attach_size']='Največja velikost datoteke';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bajt';
$hesklang['kilobytes']='kilobajt';
$hesklang['megabytes']='megabajt';
$hesklang['gigabytes']='gigabajt';
$hesklang['smtpssl']='SSL protokol';
$hesklang['smtptls']='TLS protokol';
$hesklang['oo']='Samo odprti zahtevki';
$hesklang['ool']='V sporočilu &quot;Pozabljena sledilna koda&quot; pošlji samo odprte zahtevke';
$hesklang['mop']='Največ odprtih zahtevkov';
$hesklang['rord']='Zaporedje odgovorov';
$hesklang['newbot']='Novejši odgovori na dnu';
$hesklang['newtop']='Novejši odgovori na vrhu';
$hesklang['ford']='Obrazec za odgovor';
$hesklang['formbot']='Pokaži obrazec na dnu';
$hesklang['formtop']='Pokaži obrazec na vrhu';
$hesklang['mysqlv']='MySQL verzija';
$hesklang['phpv']='PHP verzija';
$hesklang['csrt']='Trenutni čas strežnika:';
$hesklang['listp']='Seznam zasebnih člankov';
$hesklang['listd']='Seznam osnutkov člankov';
$hesklang['artp']='Zasebni članki';
$hesklang['artd']='Osnutki člankov';
$hesklang['kb_no_part']='V zbirki znanja ni zasebnih člankov.';
$hesklang['kb_no_dart']='V zbirki znanja ni osnutkov člankov.';
$hesklang['attpri']='Nimate dostopa do te priponke.';
$hesklang['can_merge_tickets']='Združevanje zahtevkov';
$hesklang['mer_selected']='Združi izbrane zahtevke';
$hesklang['merged']='Izbrani zahtevki so bili združeni v enega.';
$hesklang['merge_err']='Pri združevanju zahtevkov je prišlo do težav:';
$hesklang['merr1']='Izberite vsaj dva zahtevka.';
$hesklang['merr2']='Ciljnega zahtevka ni mogoče najti.';
$hesklang['merr3']='zahtevek v kategoriji, do katere nimate dostopa.';
$hesklang['tme']='zahtevek %s je bil združen s tem zahtevkom (%s).';
$hesklang['tme1']='zahtevek %s je bil združen z zahtevkom %s';
$hesklang['tme2']='Za dostop do zahtevka %s vnesite povezan e-poštni naslov.';
$hesklang['eyou']='Uporabite stran Profil za urejanje vaših nastavitev.';
$hesklang['npea']='Nimate dovoljenja za urejanje tega uporabnika.';
$hesklang['duplicate_user']='Uporabnik s tem uporabniškim imenom že obstaja, izberite drugo uporabniško ime.';
$hesklang['kw']='Ključne besede';
$hesklang['kw1']='(opcijsko - ločeno s presledkom, z vejico ali novo vrstico)';
$hesklang['type_not_allowed']='datoteke s končnico <b>%s</b> niso dovoljene (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Stranka še ni prebrala tega odgovora.';
$hesklang['sticky']='Prilepi članek';
$hesklang['stickyon']='Prilepi članek';
$hesklang['stickyoff']='Odlepi članek';
$hesklang['ason']='članek je bil prilepljen';
$hesklang['asoff']='članek je bil odlepljen';
$hesklang['ts']='Porabljen čas';
$hesklang['start']='Začni / Končaj';
$hesklang['reset']='Ponastavi';
$hesklang['save']='Shrani';
$hesklang['hh']='Ur';
$hesklang['mm']='Minut';
$hesklang['ss']='Sekund';
$hesklang['thist']='Zgodovina zahtevka';
$hesklang['thist13']='<li class="smaller">%s | združil z zahtevkom %s s strani uporabnika %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | porabljen čas posodobljen na %s s strani uporabnika %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | ustvaril %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | ustvarjen iz POP3 uvoza</li>';
$hesklang['twu']='Porabljen čas za ta zahtevek je bil posodobljen.';
$hesklang['autoss']='Samodejno zaženi uro, ko odprem zahtevek';
$hesklang['ful']='Omejitve priponk';
$hesklang['ufl']='Tip datoteke:';
$hesklang['nat']='Število priponk:';
$hesklang['mfs']='Velikost priponke:';
$hesklang['lps']='Vaše jezikovne nastavitve so bile shranjene';
$hesklang['sav']='Prikaži števec ogledov';
$hesklang['sad']='Prikaži datum vnosa';
$hesklang['emp']='Vaša PHP instalacija ne podpira baz MySQL';
$hesklang['epd']='[HESK] E-poštna sporočila so onemogočena v nastavitvah';
$hesklang['pfd']='[HESK] Uvoz iz POP3 je onemogočen v nastavitvah';
$hesklang['pem']='[Sporočilo iz e-pošte]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Stranka]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-pošta';
$hesklang['pop3']='Uvoz iz POP3';
$hesklang['pop3h']='POP3 strežnik';
$hesklang['pop3p']='POP3 vrata';
$hesklang['pop3tls']='TLS protokol';
$hesklang['pop3u']='POP3 uporabniško ime';
$hesklang['pop3w']='POP3 geslo';
$hesklang['pop3e']='POP3 napaka';
$hesklang['pop3log']='Podrobnosti POP3 povezave';
$hesklang['mysqltest']='Preveri MySQL povezavo';
$hesklang['smtptest']='Preveri SMTP povezavo';
$hesklang['pop3test']='Preveri POP3 povezavo';
$hesklang['contest']='Preverjam povezavo, to lahko traja nekaj časa ...';
$hesklang['conok']='povezava deluje.';
$hesklang['conokn']='Če vaš strežnik zahteva uporabniško ime in geslo, e-sporočilo ne bo poslano!';
$hesklang['saving']='Shranjujem nastavitve, prosim, počakajte ...';
$hesklang['sns']='Nastavitve so bile shranjene, vendar so nekatere funkcije onemogočene zaradi neuspelih testov.';
$hesklang['looph']='Dovoljeno število zadetkov';
$hesklang['loopt']='Časovni okvir';
$hesklang['didum']='Ste mislili %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Da, popravite';
$hesklang['nole']='Ne, pustite na miru';
$hesklang['sconfe2']='Zahtevaj ponoven vnos e-poštnega naslova stranke v kreiranju zahtevka';
$hesklang['oln']='Staro ime:';
$hesklang['nen']='Novo ime:';
$hesklang['use_form_below']='<i>S tem obrazcem pošljete zahtevo za podporo uporabnikom. Obvezno izpolnite polja, označena z</i>';
$hesklang['esf']='Ne morem poslati e-poštnega obvestila.';
$hesklang['qrr']='(citiran odgovor je odstranjen)';
$hesklang['remqr']='Odstrani izvorno sporočilo';
$hesklang['remqr2']='Odstrani izvorno sporočilo iz besedila sporočila';
$hesklang['suge']='Popravljanje napak';
$hesklang['epro']='Ponudniki e-pošte';
$hesklang['email_noreply']='E-pošta pošiljatelja';
$hesklang['email_name']='Ime pošiljatelja';
$hesklang['vscl']='Prikaži omejitve strežnika';
$hesklang['fnuscphp']='Nalaganje datoteke ni uspelo, poskusite z manjšo ali brez priponk.';
$hesklang['redv']='Ponastavi privzet pogled';
$hesklang['fatte1']='Nastavitev &quot;Število priponk na sporočilo&quot; je večje, kot jih dovoljuje vaš strežnik!';
$hesklang['fatte2']='Največja velikost priponke je večja, kot omogoča vaš strežnik!';
$hesklang['fatte3']='Vaš strežnik ne omogoča tako velikih prispevkov, poskusite zmanjšati število prilog ali velikost datoteke!';
$hesklang['embed']='Vstavljene datoteke';
$hesklang['embed2']='Shrani vstavljene datoteke kot priponke';
$hesklang['emrem']='(slika odstranjena)';
$hesklang['hdemo']='(SKRITO V DEMO VERZIJI)';
$hesklang['ddemo']='Oprostite, ta funkcija je onemogočena v DEMO načinu!';
$hesklang['sdemo']='Shranjevanje sprememb je onemogočeno v DEMO načinu';
$hesklang['hud']='imate najnovejšo verzijo';
$hesklang['hnw']='posodobitev je na voljo';
$hesklang['getup']='Posodobi HESK';
$hesklang['updates']='Posodobitve';
$hesklang['updates2']='Samodejno preveri, ali so na voljo posodobitve za HESK';

// Added in version 2.5.0
$hesklang['attdel']='ta datoteka je bila izbrisana iz strežnika in ni več na voljo za prenos';
$hesklang['dsen']='Ne pošlji e-poštnega obvestila stranki o tem odgovoru';
$hesklang['attrem']='* Nekatere priponke so bile odstranjene *';
$hesklang['attnum']='Preseženo število priponk: %s'; // %s will show attachment name
$hesklang['attsiz']='Prevelika priponka: %s'; // %s will show attachment name
$hesklang['atttyp']='Tip datoteke ni dovoljen: %s'; // %s will show attachment name
$hesklang['adf']='Mapa nadzorne plošče';
$hesklang['atf']='Mapa za priponke';
$hesklang['err_adf']='Izbrana mapa nadzorne plošče (%s) ne obstaja!'; // %s will show folder name
$hesklang['err_atf']='Izbrana mapa za priponke (%s) ne obstaja!'; // %s will show folder name
$hesklang['err_atr']='Ne morem pisati v mapo za priponke (%s)!'; // %s will show folder name
$hesklang['fatt']='To sporočilo vsebuje datoteke:';
$hesklang['wrepo']='prosim napišite sporočilo po ponovnem odprtju zahtevka.';
$hesklang['ktool']='&raquo; Orodja zbirke znanja';
$hesklang['uac']='Preveri in posodobi število člankov';
$hesklang['acv']='število člankov je bilo preverjeno in po potrebi popravljeno';
$hesklang['xyz']='(število javnih člankov, število zasebnih člankov, število osnutkov)';
$hesklang['reports_tab']='Poročila'; // Tab title
$hesklang['can_run_reports_full']='Lahko ustvari poročila (vsa)';
$hesklang['can_export']='Lahko izvozi zahtevke v Excel';
$hesklang['roo']='<i>(le zahtevki, dodeljeni vam, so vključeni v poročilo)</i>';
$hesklang['shu']='Kratke povezave';
$hesklang['export']='Izvozi zahtevke'; // Tab title
$hesklang['export_btn']='Izvozi zahtevke'; // Button title
$hesklang['export_intro']='To orodje vam omogoča izvoz zahtevkov v XML preglednico, ki se lahko odpre v Excel-u.';
$hesklang['stte']='Izberi zahtevke za izvoz';
$hesklang['dtrg']='Datum';
$hesklang['sequentially']='Po vrstnem redu'; // Order tickets: Sequentially
$hesklang['ede']='Ne morem ustvariti mape za izvoz. Prosim ročno ustvarite mapo z imenom <b>export</b> znotraj mape za začasne datoteke ter preverite, da lahko PHP ustvarja datoteke v tej mapi.';
$hesklang['eef']='Ne morem ustvariti datoteke za izvoz, nimam dovoljenja za pisanje v mapi.';
$hesklang['inite']='Začenjam izvoz';
$hesklang['gXML']='Ustvarjam XML datoteko';
$hesklang['nrow']='Število izvoženih zahtevkov: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Stiskam datoteko v Zip arhiv';
$hesklang['eZIP']='Napaka pri ustvarjanju Zip arhiva';
$hesklang['fZIP']='Stiskanje končano';
$hesklang['pmem']='Uporabljen sistemski pomnilnik: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; KLIKNI TU ZA PRENOS DATOTEKE &laquo;';
$hesklang['n2ex']='Ne najdem zahtevkov, ki bi ustrezali izbranim merilom.';
$hesklang['sp']='Preprečevanje SPAM-a'; // For settings page
$hesklang['sit']='-&gt; Tip kode';
$hesklang['sis']='Preprosta slika';
$hesklang['rcpb']='Site key';
$hesklang['rcpv']='Secret key';
$hesklang['pop3keep']='Obdrži kopijo';
$hesklang['beta']='(PREIZKUSNA VERZIJA)';
$hesklang['maxpost']='Verjetno ste poskusili poslati več podatkov, kot jih ta strežnik lahko sprejme.<br /><br />Prosim poskusite ponovno z manjšimi priponkami ali brez njih.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Ne morem potrditi reCAPTCHA SPAM zaščite.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Zahtevek zaključen';
$hesklang['ms01']='jan';
$hesklang['ms02']='feb';
$hesklang['ms03']='mar';
$hesklang['ms04']='apr';
$hesklang['ms05']='maj';
$hesklang['ms06']='jun';
$hesklang['ms07']='jul';
$hesklang['ms08']='avg';
$hesklang['ms09']='sep';
$hesklang['ms10']='okt';
$hesklang['ms11']='nov';
$hesklang['ms12']='dec';
$hesklang['sdf']='Prikaz datuma vnosa';
$hesklang['lcf']='Prikaz datuma urejanja';
$hesklang['lcf0']='Kratek opisni';
$hesklang['lcf1']='Datum in čas';
$hesklang['lcf2']='HESK slog';
$hesklang['ticket_tpl']='Predloge zahtevkov';
$hesklang['can_man_ticket_tpl']='Urejanje predlog zahtevkov'; // Permission title
$hesklang['ticket_tpl_man']='Urejanje predlog zahtevkov'; // Page and link title
$hesklang['ticket_tpl_intro']='Predloge zahtevkov se uporabljajo za hitro vnašanje novih zahtevkov s strani osebja centra za pomoč uporabnikom.';
$hesklang['no_ticket_tpl']='Ni predlog';
$hesklang['ticket_tpl_title']='Zadeva';
$hesklang['delete_tpl']='Ste prepričani, da želite izbrisati to predlogo?';
$hesklang['new_ticket_tpl']='Ustvari, ali uredi predlogo';
$hesklang['ticket_tpl_add']='Ustvari novo predlogo';
$hesklang['ticket_tpl_edit']='Uredi izbrano predlogo';
$hesklang['save_ticket_tpl']='Shrani predlogo';
$hesklang['ticket_tpl_saved']='predloga je bila shranjena';
$hesklang['ticket_tpl_removed']='predloga je bila izbrisana';
$hesklang['ticket_tpl_not_found']='ne najdem te predloge';
$hesklang['sel_ticket_tpl']='izberi predlogo, ki jo želiš urediti';
$hesklang['ent_ticket_tpl_title']='vnesite zadevo predloge';
$hesklang['ent_ticket_tpl_msg']='vnesite besedilo predloge';
$hesklang['ticket_tpl_id']='manjka ID predloge';
$hesklang['select_ticket_tpl']='Izberi predlogo';
$hesklang['list_tickets_cat']='Prikaži vse zahtevke v tej kategoriji';
$hesklang['def_msg']='[Brez sporočila]';
$hesklang['emlreqmsg']='Zahtevaj sporočilo';
$hesklang['emlreqmsg2']='Zavrzi zahtevke preko e-pošte brez sporočila';
$hesklang['relart']='Sorodni članki'; // Title of related articles box
$hesklang['s_relart']='Sorodni članki'; // On settings page
$hesklang['tab_7']='Seznam zahtevkov';
$hesklang['fitl']='Stolpci v seznamu zahtevkov';
$hesklang['submitted']='Ustvarjen';
$hesklang['clickemail']='Poglej';
$hesklang['set_pri_to']='Nastavi nujnost na:'; // Action below the ticket list
$hesklang['pri_set_to']='Nujnost je bila nastavljena na:';
$hesklang['cat_pri']='Če strankam ni dovoljeno nastaviti nujnosti zahtevkov, bo uporabljena privzeta nujnost kategorije.';
$hesklang['cat_pri_info']='Vaše stranke lahko same določijo nujnost zahtevkov, zato se privzeta nujnost kategorije ne bo uporabljala.<br /><br />Za uporabo privzete nujnosti kategorije, izklopite naslednjo nastavitev:';
$hesklang['def_pri']='Nujnost kategorije:';
$hesklang['ch_cat_pri']='Nastavi nujnost kategorije';
$hesklang['cat_pri_ch']='nujnost kategorije je bila nastavljena na:';
$hesklang['err_dbversion']='Nepodprta (prestara) verzija MySQL:';
$hesklang['ip_whois']='IP poizvedba';
$hesklang['ednote']='Uredi besedilo opombe';
$hesklang['ednote2']='Besedilo opombe shranjeno';
$hesklang['perm_deny']='Nimate dovoljenja';
$hesklang['mis_note']='Manjka ID opombe';
$hesklang['no_note']='Opomba s to ID številko ne obstaja';
$hesklang['sacl']='Shrani za kasneje';
$hesklang['reply_saved']='Vaš odgovor je bil shranjen za kasneje.';
$hesklang['submit_as']='Vnesi kot:';
$hesklang['sasc']='Vnesi kot odgovor stranke';
$hesklang['creb']='Odgovor vnesel:';
$hesklang['show_select']='Prikaži &quot;Klikni in izberi&quot; kot privzeto vrednost';
// Settings
$hesklang['mms']='Vzdrževanje';
$hesklang['mmd']='Omogoči način za Vzdrževanje';
// Customer notice
$hesklang['mm1']='Vzdrževanje v teku';
$hesklang['mm2']='Podpora uporabnikom je začasno nedosegljiva zaradi vzdrževalnih del.';
$hesklang['mm3']='Opravičujemo se za nevšečnost, prosimo, pokusite kasneje.';
// Staff notice
$hesklang['mma1']='Vzdrževanje v teku!';
$hesklang['mma2']='Stranke trenutno ne morejo vnašati novih zahtevkov!';
$hesklang['tools']='Orodja';
$hesklang['banemail']='Blokada e-pošte';
$hesklang['banemail_intro']='Prepreči vnos zahtevkov z določenih e-poštnih naslovov.';
$hesklang['no_banemails']='<i>Trenutno ni blokiranih e-poštnih naslovov.</i>';
$hesklang['eperm']='Blokirani e-poštni naslovi:';
$hesklang['bananemail']='Blokiraj e-poštni naslov';
$hesklang['savebanemail']='Blokiraj naslov';
$hesklang['enterbanemail']='vnesite e-poštni naslov, ki ga želite blokirati.';
$hesklang['validbanemail']='vnesite veljaven e-poštni naslov (<i>janez.novak@domena.si</i>) ali domeno (<i>@domena.si</i>)';
$hesklang['email_banned']='e-poštni naslov <i>%s</i> je blokiran. HESK ne bo več sprejemal zahtevkov s tega naslova.'; // %s will be replaced with email
$hesklang['emailbanexists']='e-poštni naslov <i>%s</i> je že blokiran.'; // %s will be replaced with email
$hesklang['email_unbanned']='blokada odstranjena';
$hesklang['banby']='Blokiral';
$hesklang['delban']='Odstrani blokado';
$hesklang['delban_confirm']='Odstranim to blokado?';
$hesklang['baned_e']='Blokiran vam je vnos novih zahtevkov.';
$hesklang['baned_ip']='Blokiran vam je dostop do podpore';
$hesklang['can_ban_emails']='Lahko blokira e-poštne naslove';
$hesklang['can_unban_emails']='Lahko ureja blokade e-poštnih naslovov';
$hesklang['eisban']='Ta e-poštni naslov je blokiran.';
$hesklang['click_unban']='Klikni tu za izbris blokade.';
$hesklang['banip']='IP blokada';
$hesklang['banip_intro']='Obiskovalci z blokiranim IP naslovom ne morejo vnašati in pregledovati zahtevkov ter se prijaviti v nadzorno ploščo.';
$hesklang['ipperm']='Blokirani IP naslovi:';
$hesklang['iptemp']='Samodejne blokade:';
$hesklang['savebanip']='Blokiraj IP';
$hesklang['no_banips']='<i>Ni aktivnih IP blokad.</i>';
$hesklang['bananip']='Blokiraj IP naslov';
$hesklang['banex']='Primeri:';
$hesklang['iprange']='IP območje';
$hesklang['ippermban']='Trajno blokiraj IP';
$hesklang['enterbanip']='vnesite IP ali območje za blokado.';
$hesklang['validbanip']='vnesite veljaven IP ali območje IP';
$hesklang['ip_banned']='IP naslov <i>%s</i> je blokiran. HESK ne bo sprejemal novih zahtevkov s tega naslova.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='IP območje <i>%s</i> je blokirano. HESK ne bo sprejemal novih zahtevkov s tega območja.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP naslov <i>%s</i> je že blokiran.'; // %s will be replaced with IP
$hesklang['iprbanexists']='IP območje <i>%s</i> je že blokirano.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP blokada odstranjena';
$hesklang['ip_tempun']='Začasna blokada odstranjena';
$hesklang['can_ban_ips']='Lahko blokira IP';
$hesklang['can_unban_ips']='Lahko ureja IP blokade';
$hesklang['ipisban']='Ta IP je blokiran.';
$hesklang['m2e']='Minut do zastaranja';
$hesklang['info']='Informacija';
$hesklang['sm_title']='Obvestila';
$hesklang['sm_intro']='Prikaži obvestilo v območju za obiskovalce, na primer sporočilo o znanih okvarah, stanju na omrežju ...';
$hesklang['can_service_msg']='Urejanje obvestil';
$hesklang['new_sm']='Novo obvestilo';
$hesklang['edit_sm']='Uredi obvestilo';
$hesklang['ex_sm']='Obstoječa obvestila';
$hesklang['sm_author']='Avtor';
$hesklang['sm_type']='Tip';
$hesklang['sm_published']='Objavljeno';
$hesklang['sm_draft']='Osnutek';
$hesklang['sm_style']='Slog';
$hesklang['sm_none']='Brez';
$hesklang['sm_success']='Uspeh';
$hesklang['sm_info']='Informacija';
$hesklang['sm_notice']='Obvestilo';
$hesklang['sm_error']='Napaka';
$hesklang['sm_save']='Shrani';
$hesklang['sm_preview']='Predogled obvestila';
$hesklang['sm_mtitle']='Naslov';
$hesklang['sm_msg']='Sporočilo';
$hesklang['sm_e_title']='vnesite naslov obvestila';
$hesklang['sm_e_msg']='vnesite sporočilo obvestila';
$hesklang['sm_e_id']='manjka ID obvestila';
$hesklang['sm_added']='obvestilo je bilo dodano';
$hesklang['sm_deleted']='obvestilo izbrisano';
$hesklang['sm_not_found']='obvestilo ne obstaja';
$hesklang['no_sm']='Ni obvestil';
$hesklang['del_sm']='Izbrišem obvestilo?';
$hesklang['sm_mdf']='obvestilo je bilo shranjeno';
$hesklang['sska']='Prikaži sorodne članke';
$hesklang['taws']='Predlagani članki:';
$hesklang['defaults']='Privzeto';
$hesklang['pncn']='Izberi obveščanje stranke v obrazcu za nov zahtevek';
$hesklang['pncr']='Izberi obveščanje stranke v obrazcu za odgovor na zahtevek';
$hesklang['pssy']='Prikaži kateri članki iz zbirke znanja so bili predlagani stranki';
$hesklang['ccct']='Stranka lahko zaključi zahtevek';
$hesklang['custnot']='Pošlji obvestilo stranki';
$hesklang['notnew']='ob sprejemu novega zahtevka';
$hesklang['notclo']='ko je zahtevek zaključen';
$hesklang['enn']='razen za zahtevke prejete preko e-pošte, če zadeva vsebuje:';
$hesklang['spamn']='SPAM namig';
$hesklang['spam_inbox']='<span style="color:red"><b>Niste prejeli obvestila?</b><br />Na vaš e-poštni naslov smo poslali obvestilo. Če ga ne prejmete v roku 10 minut, preverite v mapi za nezaželeno pošto (Junk, Bulk ali Spam). Označite sporočilo kot &quot;Ni spam&quot; za nemoteno prejemanje obvestil v prihodnje.</span>';
$hesklang['ekb_n']='<b>NE</b>, onemogoči zbirko znanja';
$hesklang['ekb_y']='<b>DA</b>, omogoči zbirko znanja';
$hesklang['ekb_o']='<b>DA</b>, uporabi HESK samo kot zbirko znanja (<i>onemogoči vnašanje zahtevkov</i>)';
$hesklang['kb_set']='Nastavitve zbirke znanja (ZZ)';
$hesklang['kbo1']='Vklopljen način samo zbirke znanja';
$hesklang['kbo2']='<br /><br />Obiskovalci ne morejo vnašati zahtevkov in so napoteni neposredno v zbirko znanja.';
$hesklang['fpass']='Ste pozabili geslo?';
$hesklang['passr']='Ponastavi geslo';
$hesklang['passa']='Dovoli uporabnikom ponastavitev gesla preko e-pošte';
$hesklang['passe']='E-poštni naslov';
$hesklang['passs']='Pošlji navodila za ponastavitev gesla';
$hesklang['noace']='ne najdem uporabnika s tem e-poštnim naslovom';
$hesklang['pemls']='poslali smo vam e-pošto z navodili za ponastavitev gesla';
$hesklang['reset_password']='Ponastavitev gesla'; // Email subject
$hesklang['ehash']='neveljavna ali zastarana povezava za ponastavitev gesla';
$hesklang['ehaip']='napačen IP naslov. Geslo lahko ponastavite samo iz IP naslova, s katerega ste ponastavitev zahtevali.';
$hesklang['resim']='<b>Nastavite novo geslo v obrazcu spodaj!</b>';
$hesklang['permissions']='Dovoljenja';
$hesklang['atype']='Tip uporabnika';
$hesklang['astaff']='Osebje';
$hesklang['oon1']='Pošlji mi samo kode odprtih zahtevkov';
$hesklang['oon2']='Pošlji mi kode vseh zahtevkov';
$hesklang['anyown']='Vsi lastniki';
$hesklang['pfr']='Prejšnji uvoz iz POP3 je še aktiven.';
$hesklang['pjt']='Zastaranje prenosa';
$hesklang['pjt2']='minut po začetku';
$hesklang['nkba']='iskanje po zbirki znanja deluje bolje, če je na voljo dovolj različnih člankov.<br /><br />Za izboljšanje iskalnih zadetkov dodajte več člankov v zbirko znanja.';
$hesklang['saa']='Prilepljeni članki so prikazani nad drugimi';
$hesklang['yhbr']='Vaš dostop je blokiran za %s minut zaradi preveč odgovorov na zahtevek.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='sl';

// Added in version 2.7.0
$hesklang['imap']='Uvoz iz IMAP';
$hesklang['imaph']='IMAP strežnik';
$hesklang['imapp']='IMAP vrata';
$hesklang['enc']='Šifriranje';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Brez';
$hesklang['imapu']='IMAP uporabnik';
$hesklang['imapw']='IMAP geslo';
$hesklang['imaptest']='Preveri IMAP povezavo';
$hesklang['ifd']='[HESK] Uvoz iz IMAP je onemogočen v nastavitvah';
$hesklang['iei']='[HESK] PHP IMAP dodatek ni nameščen.';
$hesklang['ifr']='Prejšnji uvoz iz IMAP je še aktiven.';
$hesklang['arp']='Samodejno osveži stran';
$hesklang['arpp']='Samodejno osveži stran s seznamom zahtevkov vsakih:';
$hesklang['seconds']='sekund';
$hesklang['minutes']='minut';
$hesklang['atbr']='zahtevek mora biti dodeljen, preden se nanj lahko odgovori.';
$hesklang['attm']='Dodeli zahtevek meni';
$hesklang['owneed']='Potrebuje lastnika';
$hesklang['taat']='Ta zahtevek je že dodeljen uporabniku <b>%</b>.';
$hesklang['scoy']='Ste prepričani, da ga želite dodeliti sebi?';
$hesklang['scot']='Ste prepričani, da ga želite dodeliti uporabniku %s?';
$hesklang['ycto']='DA, spremeni lastnika';
$hesklang['ncto']='NE, obdrži trenutnega lastnika';
$hesklang['fass']='Zahtevaj lastnika';
$hesklang['req_sub']='Zahtevaj zadevo';
$hesklang['req_msg']='Zahtevaj sporočilo';
$hesklang['req_email']='Zahtevaj e-pošto';
$hesklang['default_subject']='Zahtevek stranke %s';
$hesklang['off-hide']='Skrij v obrazcu za stranke';
$hesklang['not_valid_email']='vnesite vejavni e-poštni naslov ali pustite polje prazno';
$hesklang['write_down']='<span style="color:red">Priporočamo, da si zapišete sledilno kodo zahtevka za v prihodnje.</span>';
$hesklang['re_confirm1']='Izklop te funkcije bo izklopil tudi "Zahtevaj e-poštni naslov za ogled zahtevka". Nadaljujem?';
$hesklang['re_confirm2']='Ta funkcija bo vklopila tudi "Zahtevaj e-pošto". Nadaljujem?';
$hesklang['can_email_tpl']='Urejanje predlog e-poštnih sporočil';
$hesklang['et_title']='Predloge sporočil';
$hesklang['et_intro']='Urejanje predlog sporočil, ki jih center za podporo uporabnikom preko e-pošte pošilja osebju in uporabnikom.';
$hesklang['file']='Datoteka';
$hesklang['efile']='Urejanje datoteke';
$hesklang['rdesc']='(Prejemnik) Opis';
$hesklang['desc_forgot_ticket_id']='(Stranka) Pozabljena sledilna koda zahtevka';
$hesklang['desc_new_reply_by_staff']='(Stranka) Nov odgovor na zahtevek';
$hesklang['desc_new_ticket']='(Stranka) Zahtevek prejet';
$hesklang['desc_ticket_closed']='(Stranka) Zahtevek razrešen';
$hesklang['desc_category_moved']='(Osebje) Zahtevek premaknjen v drugo kategorijo';
$hesklang['desc_new_reply_by_customer']='(Osebje) Nov odgovor stranke';
$hesklang['desc_new_ticket_staff']='(Osebje) Nov zahtevek oddan';
$hesklang['desc_ticket_assigned_to_you']='(Osebje) Dodeljen nov zahtevek';
$hesklang['desc_new_pm']='(Osebje) Novo zasebno sporočilo';
$hesklang['desc_new_note']='(Osebje) Nova opomba na dodeljenem zahtevku';
$hesklang['desc_reset_password']='(Osebje) Ponastavi geslo';
$hesklang['etfm']='Manjka vsaj ena predloga sporočil.<br /><br />Prenesite vse predloge e-poštnih sporočil v mapo <i>/language/%s/emails</i>';
$hesklang['etfw']='Nekatere predloge so označene samo za branje.<br /><br />
                   Poskrbite, da bodo PHP skripte imele dovoljenje spreminjati datoteke v mapi <i>/language/%s/emails</i><br /><br />
                   Na Linux strežnikih nastavite dovoljenje CHMOD na 666 (rw-rw-rw-) za vse predloge.';
$hesklang['et_e_id']='Manjka ID predloge';
$hesklang['et_fm']='Datoteka te predloge manjka';
$hesklang['et_fw']='Ni dovoljenja za spreminjanje te predloge';
$hesklang['et_save']='Shrani predlogo';
$hesklang['updated_on']='Posodobljeno';
$hesklang['ticket_url']='URL zahtevka';
$hesklang['pm_url']='URL zasebnega sporočila';
$hesklang['et_num']='Število zahtevkov';
$hesklang['et_list']='Sezam zahtevkov';
$hesklang['et_empty']='predloga ne sme biti prazna';
$hesklang['et_saved']='predloga shranjena';
$hesklang['source']='Izvorna datoteka';
$hesklang['select_category']='Izberite kategorijo';
$hesklang['select_category_text']='Kakšno pomoč potrebujete?';
$hesklang['select_category_staff']='Izberite kategorijo';
$hesklang['scat']='Meja izbora kategorije';
$hesklang['scat2']='(če je število kategorij višje, se bo prikazalo izbirno polje)';
$hesklang['new_cf']='Novo polje po meri';
$hesklang['cf_intro']='Ta zmogljivost vam omogoča določiti nova vnosna polja, ki jih morajo stranke ali osebje izpolniti pri vnosu novih zahtevkov.';
$hesklang['cf_public']='Javno';
$hesklang['cf_private']='Osebju';
$hesklang['cf_cust']='Za stranke';
$hesklang['cf_all']='Vse';
$hesklang['cf_cat']='Izbrane';
$hesklang['cf_ctrl']='Namig: pritisnite in držite tipko CTRL, da bi izbrali več kategorij';
$hesklang['visibility']='Vidnost';
$hesklang['cf_save']='Shrani polje';
$hesklang['ex_cf']='Aktivna polja po meri';
$hesklang['no_cf']='Ni aktivnih polj';
$hesklang['del_cf']='Izbrišem to polje? Pozor, izbrisani bodo tudi shranjeni podatki za to polje v podatkovni bazi!';
$hesklang['cf_e_id']='Nepravilen ID';
$hesklang['edit_cf']='Uredi polje';
$hesklang['cf_deleted']='polje izbrisano';
$hesklang['cf_not_found']='to polje po meri ne obstaja';
$hesklang['cf_added']='novo polje po meri je bilo ustvarjeno';
$hesklang['cf_nocat']='izberite vsaj eno kategorijo za to polje';
$hesklang['cf_mdf']='polje po meri je bilo shranjeno';
$hesklang['atl1']='vnesite vsaj eno vrednost';
$hesklang['sch']='Skrito polje';
$hesklang['meml3']='Dovoli vnos več e-poštnih naslovov';
$hesklang['dmin']='Najstarejši sprejet datum';
$hesklang['dmax']='Najnovejši sprejet datum';
$hesklang['d_day']='dan (dni)';
$hesklang['d_week']='teden (tednov)';
$hesklang['d_month']='mesec (mesecev)';
$hesklang['d_year']='leto (let)';
$hesklang['d_any']='Katerikoli datum';
$hesklang['d_fixed']='Določen datum';
$hesklang['d_relative']='Spremenljiv datum';
$hesklang['d_mm']='najstarejši datum ne sme biti mlajši od najnovejšega datuma';
$hesklang['d_emin']='najstarejši datum za <i>%s</i> je %s';
$hesklang['d_emax']='najnovejši datum za <i>%s</i> je %s';
$hesklang['d_format']='Oblika prikaza datuma';
$hesklang['d_custom']='Oblika po meri';
$hesklang['d_ci']='ZA NAPREDNE UPORABNIKE: vnesite veljavno obliko PHP datuma, skladno s PHP priročnikom.';
$hesklang['cf_noe']='vnesite veljaven naslov e-pošte v <i>%s</i>';
$hesklang['cf_noem']='vnesite vsaj en veljaven naslov e-pošte v <i>%s</i>';
$hesklang['can_resolve']='Lahko zaključi zahtevke';
$hesklang['can_change_own_cat']='Lahko premakne zahtevek v drugo kategorijo';
$hesklang['can_submit_any_cat']='Lahko odda nov zahtevek v katerokoli kategorijo';
$hesklang['noauth_submit']='nimate dovoljenja za oddajanje zahtevkov v to kategorijo.';
$hesklang['noauth_move']='nimate dovoljenja za premik zahtevka v to kategorijo.';
$hesklang['noauth_resolve']='nimate dovoljenja za zaključevanje zahtevkov.';
$hesklang['force_ssl']='Zahtevaj varno povezavo';
$hesklang['d_ssl']='<i>onemogočeno</i> - za spremembo nastavitve odprite to stran v varni povezavi https://';
$hesklang['scno']='Tega statusa ni mogoče spreminjati';
$hesklang['statuses']='Statusi';
$hesklang['statuses_intro']='Tu lahko dodajate nove statuse za uporabo v centru za podporo';
$hesklang['color']='Barva';
$hesklang['csscl']='CSS class ali barva';
$hesklang['clr_view']='Predogled obarvanega besedila';
$hesklang['cbc']='Stranke lahko spreminjajo';
$hesklang['ccc']='Ali lahko stranka spremeni ta status zahtevka?';
$hesklang['del_status']='Izbrišem status?';
$hesklang['ex_status']='Obstoječi statusi';
$hesklang['status_hesk']='Vgrajeni statusi (ne morete jih spreminjati)';
$hesklang['status_custom']='Statusi po meri';
$hesklang['status_custom_none']='Nimate polj po meri. Dodajte jih z uporabo zgornjega obrazca.';
$hesklang['status_save']='Shrani status';
$hesklang['list_tkt_status']='Seznam zahtevkov s tem statusom';
$hesklang['new_status']='Nov status';
$hesklang['edit_status']='Uredi status';
$hesklang['err_status']='vnesite ime statusa';
$hesklang['status_added']='nov status je bil ustvarjen';
$hesklang['status_e_id']='neveljaven ID';
$hesklang['status_mdf']='status je bil shranjen';
$hesklang['status_deleted']='status je bil izbrisan';
$hesklang['status_not_found']='ta status ne obstaja';
$hesklang['status_not_empty']='Tega statusa ne morete odstraniti, ker obstajajo zahtevki s tem statusom.';
$hesklang['status_limit']='Imate 100 statusov po meri, novih ni mogoče ustvariti.';
$hesklang['public_link']='Javna povezava';
$hesklang['frames']='Okvirji';
$hesklang['frames2']='Ne dovoli vstavljanja HESK-a v okvirje na drugih spletnih straneh.';
$hesklang['numsub']='Vnesenih zahtevkov';
$hesklang['hidf']='Skrita polja niso vidna strankam v obrazcu za vnos novega zahtevka, njihovo vrednost pa bodo videli v podrobnostih zahtevka.<br /><br />Osebju centra za podporo uporabnikom se skrita polja obnašajo kot navadna tekstovna vnosna polja.';
$hesklang['rcheck']='Ne izberi privzete možnosti';
$hesklang['refresh_page']='Osveži stran';
$hesklang['del_kba']='Izbriši članek';
$hesklang['del_kbaa']='Izbris članka iz podatkovne baze';
$hesklang['hni1']='HESK še ni nameščen?';
$hesklang['hni2']='Center za pomoč uporabnikom HESK še ni v celoti nameščen in prilagojen.';
$hesklang['hni3']='Prosim sledite <a href="docs/">Navodilom za namestitev</a>';
$hesklang['cf']='Mapa predpomnilnika';
$hesklang['e_cdir']='HESK ne more obdelovati uvožene e-pošte ali uporabljati predpomnilnika, če ta mapa ne obstaja ali če je zaščitena pred pisanjem.';
$hesklang['step1']='1. korak';
$hesklang['step2']='2. korak';
$hesklang['dffs']='Po končanem prenosu izbriši začasno datoteko na strežniku';
$hesklang['fd']='začasna izvozna datoteka izbrisana';

// Added in version 2.8.0
$hesklang['TZ']='Časovni pas';
$hesklang['thist17']='<li class="smaller">%s | ustvarjen iz IMAP uvoza</li>';
$hesklang['sir3']='Invisible reCAPTCHA';
$hesklang['invisible']='invisible';
$hesklang['imap_not']='PHP ni kompiliran s podporo za IMAP';
$hesklang['imap_warning']='uporabnik %1$s ima enak naslov e-pošte kot je naslov za IMAP uvoz: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='uporabnik %1$s ima enak naslov e-pošte kot je naslov za POP3 uvoz: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='To bi lahko privedlo do povratne zanke, kjer bi se novi zahtevki ustvarjali iz obvestil uporabniku. Vaša e-pošta za uvoz zahtevkov naj bo unikatna in ne uporabljana za karkoli drugega.';
$hesklang['can_view_ass_by']='Lahko vidi zahtevke, ki jih je dodelil(a) drugim';
$hesklang['can_privacy']='Lahko anonimizira zahtevke';
$hesklang['confirm_anony']='Anonimiziraj ta zahtevek';
$hesklang['anon_selected']='Anonimiziraj izbrane zahtevke';
$hesklang['privacy_anon_info']='Odstrani vse osebne podatke in vsebino iz zahtevka (strankino ime, e-pošto, sporočilo, IP naslov ...), vendar obdrži zahtevek v bazi za statistiko (pravica do pozabe).';
$hesklang['success_anon']='Zahtevek uspešno anonimiziran';
$hesklang['num_tickets_anon']='Število anonimiziranih zahtevkov: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Stranka]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Zadeva]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Sporočilo]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonimiziral %s</li>';
$hesklang['print_selected']='Natisni izbrane zahtevke';
$hesklang['with_selected']='Z izbranimi:';
$hesklang['assign_selected']='Izbrane zahtevke dodeli:';
$hesklang['assign_no']='uporabnik ni bil izbran, spremembe niso shranjene';
$hesklang['assign_1']='izbrani zahtevki so bili označeni kot Nedodeljeni.';
$hesklang['assign_2']='zahtevek ID %1$s označen kot Nedodeljen'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s napaka: je že dodeljen uporabniku %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s dodeljen uporabniku %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s napaka: %2$s nima dostopa do kategorije zahtevka'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='rezultat dodeljevanja zahtevkov:<br /><br />Dodeljeni: %1$s<br />Napake: %2$s<br /><br />Dnevnik:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP naslov';
$hesklang['moret']='Več možnosti'; // More options button title
$hesklang['btn_more']='Več'; // More options button text
$hesklang['btn_print']='Natisni';
$hesklang['btn_edit']='Uredi';
$hesklang['btn_lock']='Zakleni zahtevek';
$hesklang['btn_unlock']='Odkleni zahtevek';
$hesklang['btn_tag']='Označi zahtevek';
$hesklang['btn_resend']='Ponovno pošlji e-pošto';
$hesklang['btn_untag']='Odstrani značko';
$hesklang['btn_import_kb']='Uvozi v bazo znanja';
$hesklang['btn_anony']='Anonimiziraj zahtevek';
$hesklang['btn_delt']='Izbriši zahtevek';
$hesklang['btn_delr']='Izbriši odgovor';
$hesklang['ernf']='ne najdem odgovora';
$hesklang['tns']='e-poštna obvestila so bila ponovno poslana';
$hesklang['rns']='obvestilo o odgovoru je bilo ponovno poslano';
$hesklang['fname']='Ime';
$hesklang['export_selected']='Izvozi izbrane zahtevke';
$hesklang['btn_export']='Izvozi XML za Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Odgovori';
$hesklang['team']='Uporabniki';
$hesklang['sm_content']='Vsebina';
$hesklang['sm_settings']='Nastavitve';
$hesklang['wizard_back']='Nazaj'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Naprej'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Pojdi na nastavitve';
$hesklang['sm_return_to_editing']='Nazaj na urejanje';
$hesklang['email_tpl_title']='Naslov';
$hesklang['edit_email_template']='Uredi predlogo za e-pošto';
$hesklang['err_no_settings_section']='Manjka oddelek nastavitev.';
$hesklang['this_field_is_required']='To polje je zahtevano';
$hesklang['reset_your_password']='Ponastavi si geslo';
$hesklang['reset_password_instructions']='Prosim izpolni spodnji obrazec. Poslali ti bomo navodila za ponastavitev gesla.';
$hesklang['enter_email']='Vnesi e-pošto';
$hesklang['password_reset_check_your_email']='Preveri e-pošto';
$hesklang['password_reset_link_sent']='Poslali smo ti navodila za ponastavitev gesla.';
$hesklang['back_to_login']='Nazaj na prijavo';
$hesklang['pager_first']='Prva';
$hesklang['pager_previous']='Prejšnja';
$hesklang['pager_next']='Naslednja';
$hesklang['pager_last']='Zadnja';
$hesklang['new_team_member']='Nov uporabnik';
$hesklang['role']='Vloga';
$hesklang['optional']='Opcijsko';
$hesklang['edit_profile']='Uredi profil';
$hesklang['assigned_to']='Dodeljeno';
$hesklang['contact']='Kontakt';
$hesklang['unban_email']='Odstrani blokado e-pošte';
$hesklang['unban_ip']='Odstrani blokado IP-ja';
$hesklang['show_previous_replies']='Pokaži prejšnja sporočila';
$hesklang['type_your_message']='Vnesi sporočilo'; // Used when there are no canned responses
$hesklang['close_button_text']='Zapri';
$hesklang['create_new_ticket']='Nov zahtevek';
$hesklang['delete_article']='Izbriši članek';
$hesklang['view_existing_tickets']='Ogled zahtevka';
$hesklang['how_can_we_help']='Pozdravljeni, kako lahko pomagamo?';
$hesklang['search_for_articles']='Preišči članke';
$hesklang['submit_a_support_request']='Vnesi zahtevek za podporo';
$hesklang['verify_header']='Preprečevanje SPAM-a';
$hesklang['ticket_details']='Podrobnosti zahtevka';
$hesklang['yes_title_case']='Da';
$hesklang['no_title_case']='Ne';
$hesklang['no_results_found']='Iskanje ni vrnilo rezultatov';
$hesklang['site_theme']='Izbrana tema';
$hesklang['test_theme_folder']='Testiraj mapo s temami';
$hesklang['test_theme_folder_description']='Testiranje mape s temami. Samo teme, ki ustrezajo vsem merilom, so nameščene pravilno.';
$hesklang['err_site_theme']='Prosim izberi temo za Hesk';
$hesklang['confirm']='Potrdi';
$hesklang['confirm_deletion']='Potrdi izbris';
$hesklang['confirm_delete_status']='Si prepričan, da želiš izbrisati ta status?';
$hesklang['help_desk']='Podpora'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.sl.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Prikaz časa';
$hesklang['tdisd']='Datum in ura';
$hesklang['tdisa']='Opisno (primer: 5 ur nazaj)';
$hesklang['nav_templates']='Predloge'; // Admin panel navigation item
$hesklang['hide_replies']='Skrij odgovore v zahtevku';
$hesklang['hide_replies_no']='Nikoli, vedno pokaži vse odgovore';
$hesklang['hide_replies_yes']='Skrij vse razen zadnjih:';
$hesklang['hide_replies_def']='Pokaži zadnji odgovor osebja in morebitne kasnejše odgovore stranke';
$hesklang['reply_by']='Odgovoril'; // Reply by NAME
$hesklang['btt']='Nazaj na vrh';
$hesklang['lwidth']='Omeji širino zahtevka';
$hesklang['lwidtall']='Raztegni čez celoten zaslon';
$hesklang['lwidtpx']='Največja dovoljena širina v zaslonskih pikah:';
// 3-letter days of the week
$hesklang['mon']='pon';
$hesklang['tue']='tor';
$hesklang['wed']='sre';
$hesklang['thu']='čet';
$hesklang['fri']='pet';
$hesklang['sat']='sob';
$hesklang['sun']='ned';
$hesklang['clear']='Počisti'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Dodatki';
$hesklang['modules_demo']='Ta dodatek je na voljo samo v verziji %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Preizkusite v živo tukaj: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistika';
$hesklang['statistics']['intro']='To poročilo vam da vpogled v uporabo in odzivnost vaše podpore.';
$hesklang['statistics']['ntsp']='Ni zahtevkov v izbranem obdobju.';
$hesklang['statistics']['pie_title_ro']='Odprte in zaključene zadeve';
$hesklang['statistics']['open']='Odprte';
$hesklang['statistics']['resolved']='Zaključene';
$hesklang['statistics']['pie_title_as']='Odprte zadeve: dodeljene in nedodeljene';
$hesklang['statistics']['ass']='Dodeljene';
$hesklang['statistics']['unas']='Nedodeljene';
$hesklang['statistics']['pie_title_au']='Odprte zadeve: odgovorjene in neodgovorjene';
$hesklang['statistics']['answered']='Odgovorjene';
$hesklang['statistics']['unanswered']='Neodgovorjene';
$hesklang['statistics']['pie_title_so']='Stanje odprtih zahtev';
$hesklang['statistics']['retic']='Število:';
$hesklang['statistics']['chart_title_md']='Število zahtevkov na dan v mesecu';
$hesklang['statistics']['chart_title_wd']='Število zahtevkov na dan v tednu';
$hesklang['statistics']['chart_title_hd']='Število zahtevkov na uro v dnevu';
$hesklang['statistics']['chart_title_tfr']='Čas do prvega odgovora osebja';
$hesklang['statistics']['chart_title_tfrc']='Število odgovorjenih zahtevkov v časovnem obdobju';
$hesklang['statistics']['chart_title_ttr']='Čas od odprtja do zaključka';
$hesklang['statistics']['chart_title_ttrc']='Število zaključenih zahtevkov v časovnem obdobju';
$hesklang['statistics']['chart_title_sr']='Odgovori osebja';
$hesklang['statistics']['chart_title_srt']='Odgovori osebja na zahtevek';
$hesklang['statistics']['chart_title_srtr']='Odgovori osebja na zahtevek (samo zaključeni zahtevki)';
$hesklang['statistics']['chart_title_srt1']='Odgovori osebja na zahtevek (zahtevki z vsaj enim odgovorom)';
$hesklang['statistics']['ct_30']='30 minut';
$hesklang['statistics']['ct_1h']='1 ura';
$hesklang['statistics']['ct_2h']='2 uri';
$hesklang['statistics']['ct_4h']='4 ure';
$hesklang['statistics']['ct_1d']='1 dan';
$hesklang['statistics']['ct_2d']='2 dneva';
$hesklang['statistics']['ct_3d']='3 dnevi';
$hesklang['statistics']['ct_1w']='1 teden';
$hesklang['statistics']['ct_wp']='> 1 teden';
$hesklang['statistics']['ct_1m']='1 mesec';
$hesklang['statistics']['ct_mp']='> 1 mesec';
$hesklang['statistics']['axis1']='% odgovorjenih zahtevkov';
$hesklang['statistics']['axis2']='% zaključenih zahtevkov';
$hesklang['statistics']['axis3']='% vseh zahtevkov';
$hesklang['statistics']['axis4']='Čas do prvega odgovora';
$hesklang['statistics']['axis5']='Čas do zaključka';
$hesklang['statistics']['axis6']='Število odgovorov';
$hesklang['statistics']['axis7']='Število zahtevkov';
$hesklang['statistics']['axis8']='Dan v tednu';
$hesklang['statistics']['axis9']='Ura';
$hesklang['statistics']['axis10']='Dan v mesecu';
$hesklang['statistics']['tr_0']='Brez odgovora';
$hesklang['statistics']['tr_1']='1 odgovor';
$hesklang['statistics']['tr_2']='2 odgovora';
$hesklang['statistics']['tr_5']='3-5 odgovorov';
$hesklang['statistics']['tr_10']='6-10 odgovorov';
$hesklang['statistics']['tr_99']='> 10 odgovorov';
$hesklang['statistics']['average']='Povprečno';
$hesklang['statistics']['atfr']='Povprečen čas (ure in minute) do prvega odgovora osebja:';
$hesklang['statistics']['attr']='Povprečen čas (ure in minute) do zaključka:';
$hesklang['statistics']['about']='okoli %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Število zahtevkov, na katere je osebje odgovorilo:';
$hesklang['statistics']['trnr']='Število zahtevkov, zaključenih brez odgovora osebja:';
$hesklang['statistics']['tsr']='Skupaj odgovorov osebja:';
$hesklang['statistics']['tsrt']='Povprečno število odgovorov osebja na zahtevek:';
$hesklang['statistics']['tsro']='Povprečno število odgovorov osebja na zahtevek (zahtevki z vsaj 1 odgovorom):';
$hesklang['statistics']['tsrc']='Povprečno število odgovorov osebja do zaključka:';
$hesklang['statistics']['tsrr']='Povprečno število odgovorov osebja do zaključka (zahtevki z vsaj 1 odgovorom):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='in še mnogo več...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Zahtevek čez rok';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] Stopnjevano: %%SUBJECT%%';
$hesklang['escalate']['tab']='Stopnjevanje'; // Menu link
$hesklang['escalate']['page_title']='Stopnjevanje zahtevkov'; // Page H2 title
$hesklang['escalate']['intro']='Tu lahko nastavite pravila za samodejno stopnjevanje zahtevkov, ki niso pravočasno rešeni.';
$hesklang['escalate']['feat1']='Zahtevki niso dodeljeni, odgovorjeni ali razrešeni v časovnem obdobju';
$hesklang['escalate']['feat2']='zahtevki, ki se bližajo ali so že čez rok za razrešitev';
$hesklang['escalate']['feat3']='samodejna sprememba nujnosti, dodeljenega uporabnika, pošiljanje opomnikov';
$hesklang['escalate']['feat4']='upravljanje pravil glede na kategorijo, uporabnika in status zahtevka';
$hesklang['escalate']['prefix']='Stopnjevano:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktivna pravila';
$hesklang['escalate']['new']='Novo pravilo';
$hesklang['escalate']['no_rules']='Trenutno nimate nastavljenih pravil za stopnjevanje. Ustvarite novo pravilo s klikom na gumb &quot;Novo pravilo&quot; zgoraj.';
$hesklang['escalate']['title']='Ime pravila';
$hesklang['escalate']['titlet']='Opisno ime pravila, na primer: pošlji opomnik, če uporabnik ne odgovori v roku 12 ur';
$hesklang['escalate']['default_title']='Pravilo ustvaril %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Proženje';
$hesklang['escalate']['trigt']='Določite pogoj (stanje), ki bo sprožil to pravilo.';
$hesklang['escalate']['hits']='Zadteki'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Pogoj'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Postopek'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Uporabi'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Izbrišem to pravilo?';
$hesklang['escalate']['edit']='Urejanje pravila ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Sproži pravilo, če:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='zahtevek nima odgovora osebja';
$hesklang['escalate']['nrepc']='zahtevek nima odgovora stranke';
$hesklang['escalate']['nass']='zahtevek nima določenega lastnika';
$hesklang['escalate']['nres']='zahtevek ni razrešen';
$hesklang['escalate']['ndue']='se zahtevek pribljižuje roku';
$hesklang['escalate']['odue']='je potekel rok za razrešitev';
$hesklang['escalate']['within']='Znotraj:';
$hesklang['escalate']['minutes']='minut';
$hesklang['escalate']['hours']='ur';
$hesklang['escalate']['days']='dni';
$hesklang['escalate']['weeks']='tednov';
$hesklang['escalate']['months']='mesecev';
$hesklang['escalate']['years']='let';
$hesklang['escalate']['ofs']='odkar je bil ustvarjen';
$hesklang['escalate']['resend']='Pošlji e-poštno obvetilo:';
$hesklang['escalate']['force']='Vedno, ne glede na nastavitev upoabnika';
$hesklang['escalate']['noforce']='Upoštevaj nastavitev uporabnika';
$hesklang['escalate']['setpri']='Spremeni nujnost v:';
$hesklang['escalate']['setsta']='Spremeni status v:';
$hesklang['escalate']['assto']='Dodeli zahtevek:';
$hesklang['escalate']['asm']='Drugemu uporabniku';
$hesklang['escalate']['notify']='Obvesti upoabnike...';
$hesklang['escalate']['ato']='Uporabi za:';
$hesklang['escalate']['tic']='Zahtevke v kategoriji:';
$hesklang['escalate']['tat']='Zahtevke dodeljene:';
$hesklang['escalate']['tws']='Zahtevke s statusom:';
$hesklang['escalate']['tall']='Uporabi pravilo za obstoječe in nove zahtevke';
$hesklang['escalate']['tfn']='Uporabi pravilo samo za nove zahtevke, ignoriraj obstoječe';
$hesklang['escalate']['tfi']='Uporabi pravilo samo za zahtevke z ID številom višjim od:';
$hesklang['escalate']['save']='Shrani pravilo';
$hesklang['escalate']['e_tt']='Časovno obdobje mora biti med 1 in 10000';
$hesklang['escalate']['e_a']='Določi vsaj en postopek, ki naj se izvede';
$hesklang['escalate']['nocat']='Izberi vsaj eno kategorijo';
$hesklang['escalate']['nouser']='Izberi vsaj enega uporabnika';
$hesklang['escalate']['nostatus']='Izberi vsaj en status';
$hesklang['escalate']['nocata']='%1$s nima dostopa do naštetih kategorij:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Novo pravilo je bilo ustvarjeno';
$hesklang['escalate']['mdf']='Nastavitve pravila so bile shranjene';
$hesklang['escalate']['e_id']='Pravilo s to ID številko ne obstaja';
$hesklang['escalate']['deleted']='Izbrano pravilo je bilo izbrisano';
$hesklang['escalate']['edit_notice']='sprememba sprožila pravila ne bo vplivala na zahtevke, ki so že bili stopnjevani s tem pravilom (razen če ponastavite pravilo).';
$hesklang['escalate']['reset']='Ponastavi to pravilo';
$hesklang['escalate']['reset2']='Ste prepričani, da želite ponastaviti to pravilo?<br><br>Zadteki bodo ponastavljeni na 0 in vsak zahtevek, ki ustreza pogojem, bo ponovno stopnjevan.';
$hesklang['escalate']['reset3']='Izbrano pravilo je bilo ponastavljeno';
$hesklang['escalate']['log_title']='Pravilo #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | stopnjevano - %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - nastavi nujnost na %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - dodeli: %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - obvesti osebje</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - obvesti osebje (vedno)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - napaka: %2$s nima dostopa do kategorije zahtevka</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - napaka: %2$s nima pravice za ogled zahtevka</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - napaka: noben drug član osebja nima dostop do tega zahtevka</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - opomba: nujnost je že nastavljena na %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - opomba: zahtevek je že dodeljen %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - opomni: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - nastavi status na %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - opomba: status je že nastavljen na %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktivno'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktiviraj to pravilo (začni ga uporabljati)';
$hesklang['escalate']['activated']='Izbrano pravilo je bilo aktivirano'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deaktiviraj to pravilo (prenehaj ga uporabljati)';
$hesklang['escalate']['deactivated']='Izbrano pravilo je bilo deaktivirano'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Ni aktivnih pravil za stopnjevanje';
$hesklang['escalate']['matched']='Število najdenih zahtevkov: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Orodja';
$hesklang['escalate']['test']='Simuliraj to pravilo';
$hesklang['escalate']['testa']='Simuliraj vsa pravila';
$hesklang['escalate']['testaa']='Simuliraj vsa aktivna pravila';
$hesklang['escalate']['testr']='Rezultat simulacije';
$hesklang['escalate']['rsim']='Ponovi simulacijo';
$hesklang['escalate']['tbef']='Preden je pravilo v uporabi, ga morate aktivirati s klikom v stolpcu &quot;AKTIVNO&quot;.<br><br>
                               Toplo vam priporočamo, da vsako pravilo pred aktivacijo <strong>simulirate</strong> s klikom na ikono %1$s (Simuliraj to pravilo).
                               Tako preverite, kako bo pravilo vplivalo na vaše obstoječe zahtevke.<br><br>
                               <strong>Aktivna pravila so izvedena vsakih %2$s minut. Zahtevek je lahko samo enkrat stopnjevan z vsakim pravilom</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULACIJA, pravila se ne bodo dejansko izvedla';
$hesklang['escalate']['sic']='SIMULACIJA KONČANA';
$hesklang['escalate']['r']='[PRAVILO]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Namig: držite gumb CTRL na tipkovnici, da bi izbrali več opcij';
$hesklang['desc_ticket_escalated']='(Osebje) Zahtevek je bil stopnjevan'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Oblikovanje besedila (Osebje)';
$hesklang['ticket_formatting_plaintext']='Navadno besedilo';
$hesklang['ticket_formatting_rich_text']='Oblikovano besedilo (HTML)';
$hesklang['due_date']='Rok za razrešitev:';
$hesklang['invalid_due_date']='Neveljaven rok (datum).';
$hesklang['thist19']='<li class="smaller">%s | rok nastavljen na %s s strani %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | rok odstranjen s strani %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Rok za razrešitev zahtevka je bil posodobljen.';
$hesklang['menu_kb_manage']='Urejanje'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Ogled'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Izberi vse';
$hesklang['a_deselect']='Odstrani vse';
$hesklang['a_toggle']='Spremeni vse';
$hesklang['ql_all']='Vsi zahtevki';
$hesklang['ql_alo']='Vsi odprti zahtevki';
$hesklang['ql_fit']='Filtrirani zahtevki';
$hesklang['ql_a2m']='Dodeljeni meni';
$hesklang['ql_a2o']='Dodeljeni drugim';
$hesklang['ql_una']='Nedodeljeni';
$hesklang['ql_due']='Kmalu zapadejo';
$hesklang['ql_ovr']='Rok zapadel';
$hesklang['set_ds']='Prikaži kot &quot;Kmalu zapade&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='dni pred rokom';
$hesklang['not_aos']='Zaradi izbranih filtrov prikaz ne vsebuje vseh zahtevkov, do katerih lahko dostopate.';
$hesklang['ntoverdue']='Rok je potekel zahtevku:';
$hesklang['ovdcron']='za obvestila o zapadlem roku mora vaš administrator omogočiti samodejna opravila (cron job).';
$hesklang['instructions']='Navodila';
$hesklang['desc_overdue_ticket']='(Osebje) Zahtevku je potekel rok';
$hesklang['overdue_starting']='Pričenjam proces opominjanja za pretečene zahtevke';
$hesklang['overdue_sim']='Obveščanja in posodabljanja zahtevkov se ne izvaja med SIMULACIJO.';
$hesklang['overdue_ticket_count']='Najdenih pretečenih zahtevkov: %s'; // %s = Number of tickets
$hesklang['overdue_finished']='Končano obveščanje. Poslanih sporočil: %s Napak pri pošiljanju: %s.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='CSS nadzorne plošče';
$hesklang['admin_css2']='Naloži dodatno CSS datoteko v nadzorni plošči';
$hesklang['noval_cert']='Ne preverjaj strežniškega certifikata';
$hesklang['chg_cat']='Klikni za spremembo kategorije';
$hesklang['tlan']='Jezik zahtevka';
$hesklang['uue']='Vsaj dva člana osebja imata isti naslov e-pošte. Priporočamo, da vsakemu uporabniškemu računu nastavite unikatni e-poštni naslov.';
$hesklang['flood']='Omejitev poplave sporočil';
$hesklang['e_flood']='Ups, ravnokar ste poslali sporočilo. Ta zahevek smo prekinili, da bi preprečili podvojena sporočila.';
$hesklang['cookies']='Piškotki';
$hesklang['ukey']='URL dostopni ključ'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Ustvari naključni URL dostopni ključ';
$hesklang['ukeym']='Napaka: za dostop do te datoteke preko HTTP morate v spletni naslov dodati vaš URL dostopni ključ. Primer:';
$hesklang['ukeyw']='Napaka: napačni URL dostopni ključ';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Zahtevek prejet: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% je vaša enkratna koda';
$hesklang['follow_up_email']='Be honest - how did we do?';
$hesklang['mfa']='Dodatno preverjanje pristnosti (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA vključen?';
$hesklang['mfa_required']='Zahtevaj dodatno preverjanje pristnosti';
$hesklang['mfa_manage_profile']='Upravljaj MFA';
$hesklang['mfa_disabled']='Dodatno preverjanje pristonsti je izključeno';
$hesklang['mfa_enabled']='Dodatno preverjanje pristonsti je vključeno (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Brez';
$hesklang['mfa_method_none_subtext']='Odstrani dodatno preverjanje pristnosti na svojem računu.';
$hesklang['mfa_method_email']='E-pošta';
$hesklang['mfa_method_email_subtext']='Koda za dodatno preverjanje pristnosti ob prijavi bo poslana na <strong>%s</strong>.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Aplikacija';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Koda za dodatno preverjanje pristnosti bo ustvarjena s pomočjo aplikacije na pametnem telefonu, na primer Authy ali Google Authenticator.';
$hesklang['mfa_step_method']='Način';
$hesklang['mfa_step_verification']='Preverjanje';
$hesklang['mfa_step_complete']='Končano';
$hesklang['mfa_introduction']='Dodatno preverjanje pristnosti izboljša varnost računa tako, da pri prijavi v sistem zahteva vnos enkratne unikatne kode, ki se pošlje preko e-pošte ali ustvari s pomočjo aplikacije na pametnem telefonu (na primer Authy ali Google Authenticator).';
$hesklang['mfa_reset_warning']='Dodatno preverjanje pristnosti imate že vključeno. Če postopek vklopa ponovite, bo uporabljena nova nastavitev.';
$hesklang['mfa_select_method_colon']='Izberite način preverjanja pristnosti:';
$hesklang['mfa_verification_header']='Preverjanje - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Na vaš naslov <strong>%s</strong> je bila poslana šestštevilčna koda za dodatno preverjanje pristnosti. Za dokončanje prijave spodaj vnesite vašo kodo.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; 1. korak: preberite kodo na spodnji sliki z vašo aplikacijo za generiranje unikatnih kod (Auth, Google Authenticator).';
$hesklang['mfa_verification_auth_app_cant_scan']='Če vaša aplikacija ne prebere kode na sliki, vanjo ročno vtipkajte naslednjo kodo: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; 2. korak: vnesite šestštevilčno kodo, ki vam jo ustvari vaša aplikacija.';
$hesklang['mfa_verify']='Preveri';
$hesklang['mfa_invalid_method']='Neveljaven način dodatnega preverjanja pristnosti.';
$hesklang['mfa_invalid_verification_code']='Vnešena koda je napačna ali pa ji je pretekla veljavnost.';
$hesklang['mfa_configured']='Dodatno preverjanje pristnosti je bilo aktivirano za vaš račun.';
$hesklang['mfa_removed']='Dodatno preverjanje pristnosti je bilo onemogočeno za vaš račun.';
$hesklang['mfa_verification_needed']='Dodatno preverjanje pristnosti je aktivno za ta račun.';
$hesklang['mfa_verification_needed_email']='Vnesite kodo za dodatno preverjanje pristnosti, ki vam je bila poslana po e-pošti.';
$hesklang['mfa_verification_needed_auth_app']='Vnesite kodo za dodatno preverjanje pristnosti z vaše aplikacije.';
$hesklang['mfa_verification_code']='Koda za preverjanje';
$hesklang['mfa_server_time_issue']='Sistemski čas na vašem strežniku je nastavljen napačno: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Ponastavi dodatno preverjanje pristnosti';
$hesklang['mfa_reset_confirm']='Res želite ponastaviti dodatno preverjanje pristnosti (MFA) za tega uporabnika?';
$hesklang['mfa_reset_yes']='Ponastavi';
$hesklang['mfa_reset']='Dodatno preverjanje pristnosti je bilo ponastavljeno';
$hesklang['desc_mfa_verification']='(Osebje) Koda za dodatno preverjanje pristnosti';
$hesklang['mfa_code']='Koda:';
$hesklang['mfa_backup_codes_header']='SHRANITE SI VAŠE REZERVNE KODE!';
$hesklang['mfa_backup_codes_description']='Shranite te rezervne kode na varno a dostopno mesto. V primeru izgube vaše naprave za dodatno preverjanje pristnosti se boste lahko prijavili z eno od teh kod.<br><br><strong>S temi kodami ravnajte skrbno in jih varno shranite. Vidite jih lahko le tokrat!</strong>';
$hesklang['mfa_verify_another_way']='Preverite pristnost na drugačen način'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Prejmite kodo na %s';
$hesklang['mfa_verify_another_way_code']='Vnesite eno od vaših rezervnih kod';
$hesklang['mfa_verify_another_way_admin']='Kontaktirajte skrbnika za pomoč';
$hesklang['mfa_verify_another_way_reset']='Ponastavite dodatno preverjanje pristnosti s prenosom datoteke na strežnik';
$hesklang['mfa_send_another_email']='Pošlji novo e-pošto';
$hesklang['mfa_sent']='Na vaš e-poštni naslov smo poslali sporočilo z enkratno kodo';
$hesklang['mfa_backup_code']='Rezervna koda';
$hesklang['mfa_backup_codes']='Rezervne kode';
$hesklang['mfa_backup_codes_info']='Rezervne kode, s katerimi lahko potrdite pristnost, če ne morete dostopati do svoje e-pošte ali telefona. Vsaka rezervna koda je uporabna samo enkrat.';
$hesklang['mfa_backup_codes_num']='Nov set desetih rezervnih kod si lahko kadarkoli ustvarite. Ko ustvarite nov set, stare kode postanejo neveljavne.';
$hesklang['mfa_backup_codes_num2']='Število vaših aktivnih kod: %s';
$hesklang['mfa_invalid_backup_code']='Vnešena rezervna koda je neveljavna ali pa je bila že uporabljena.';
$hesklang['mfa_del_codes']='Izbriši moje rezervne kode';
$hesklang['mfa_del_codes2']='Vse vaše rezervne kode so bile izbrisane.';
$hesklang['mfa_new_codes']='Ustvari nove rezervne kode';
$hesklang['mfa_new_codes2']='Nove rezervne kode so bile ustvarjene';
$hesklang['old_php_version']='Napaka: ta verzija PHP ni podprta';
$hesklang['category_default_due_date']='Privzeti rok za razrešitev';
$hesklang['category_change_default_due_date']='Nastavi privzeti rok za razrešitev';
$hesklang['category_leave_blank_for_no_default_due_date']='(pustite prazno, če ne želite nastaviti privzeti rok)';
$hesklang['category_default_due_date_updated']='Privzeti rok za razrešitev je bil nastavljen.';
$hesklang['email_formatting']='Struktura e-pošte';
$hesklang['email_formatting_html_and_plaintext']='HTML in navadno besedilo iz predloge (privzeto)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML in navadno besedilo, samodejno pridobljeno iz HTML predloge';
$hesklang['email_formatting_html']='Samo HTML';
$hesklang['email_formatting_plaintext']='Samo navadno besedilo';
$hesklang['email_formatting_note']='Vaša izbira v %1$s &gt; %2$s &gt; %3$s je nastavljena na: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='To pomeni, da HTML predloge ne bodo uporabljene.';
$hesklang['email_formatting_note1']='To pomeni, da besedilne predloge ne bodo uporabljene, uporabljene bodo HTML predloge.';
$hesklang['email_formatting_note2']='To pomeni, da besedilne predloge ne bodo uporabljene, uporabljene bodo HTML predloge.';
$hesklang['etnu']='Ta predloga trenutno ni v uporabi glede na vašo izbiro v %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Uredi kategorijo';
$hesklang['create_category']='Ustvari kategorijo';
$hesklang['one_user_included']='1 uporabnik';
$hesklang['one_user_excluded']='razen 1 uporabnik';
$hesklang['x_users_included']='vključenih uporabnikov: %s'; // %s = Number of users
$hesklang['x_users_excluded']='izključenih uporabnikov: %s'; // %s = Number of users
$hesklang['aa_cat']='Zahtevke v tej kategoriji samodejno dodeli uporabnikom';
$hesklang['modify_autoassign_settings']='Spremeni samodejno dodeljevanje';
$hesklang['autoassign_on_all_users']='Da, komurkoli z dostopom v to kategorijo';
$hesklang['autoassign_on_select_users']='Da, enemu od oseb s seznama';
$hesklang['autoassign_off']='Ne, zahtevke bomo dodeljevali ročno';
$hesklang['autoassign_users']='Uporabniki, ki jih želite vključiti v/izključiti iz samodejnega dodeljevanja';
$hesklang['autoassign_selected_include']='Zahtevke v tej kategorji samodejno dodeli enemu od izbranih uporabnikov.';
$hesklang['autoassign_selected_exclude']='Zahtevke v tej kategorji samodejno dodeli komurkoli <strong>razen</strong> izbranim uporabnikom';
$hesklang['cat_edited']='Spremembe v kategoriji %s so bile shranjene';
$hesklang['search_for_user']='Najdi uporabnika';
$hesklang['email_sending']='Pošiljanje e-pošte';
$hesklang['email_to_ticket']='Zahtevki iz e-pošte';
$hesklang['email_to_ticket_info']='Samodejno ustvarjanje zahtevkov iz prejetih e-poštnih sporočil zahteva določene nastavitve na vašem strežniku. Za podrobnejša navodila si oglejte <a href="%s" target="_blank">ta članek iz baze znanja</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk uporablja SMTP strežnik za pošiljanje e-pošte. Vaš <strong>%1$s</strong> bi moral biti nastavljen na <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Manjka pripona datoteke';
$hesklang['block_ignore']='Zahtevki iz e-pošte - ignoriraj pošto in prepreči zanke';
$hesklang['block_noreply']='Ne odgovarjaj';
$hesklang['block_noreply2']='Ignoriraj sporočila iz &quot;ne odgovarjaj&quot; (do not reply) naslovov';
$hesklang['block_returned']='Samodejna sporočila';
$hesklang['block_returned2']='Ignoriraj samodejna sporočila, kot so poročila o neuspelem pošiljanju in samodejno odgovori';
$hesklang['block_duplicate']='Podvojena sporočila';
$hesklang['block_duplicate2']='Ignoriraj sporočila z identičnim besedilom, poslana znotraj &quot;%s&quot; sekund'; // %s = "Timeframe"
$hesklang['loop_info']='sporočila prejeta z istega naslova znotraj &quot;%s&quot; sekund';
$hesklang['thist21']='<li class="smaller">%s | poslano sporočilo o potečenem roku za razrešitev</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | poslano sporočilo o anketi</li>'; // %s = date
$hesklang['elevator_header']='Vstop v varnostno območje';
$hesklang['elevator_intro']='Vstopate v območje, ki zahteva potrditev pristnosti..';
$hesklang['elevator_enter_password']='Za nadaljevanje vnesite svoje geslo.';
$hesklang['elevator_duration_setting_title']='Omejitev prijave v varnostno območje';
$hesklang['desc_survey']='(Stranka) Anketno sporočilo'; // Email description
$hesklang['satisfaction']['tab']='Zadovoljstvo';
$hesklang['satisfaction']['title']='Anketa o zadovoljstvu strank';
$hesklang['satisfaction']['intro']='Pošlji strankam povezavo do ankete o zadovoljstvu strank, da se prepričate o njihovi izkušnji s podporo uporabnikom.';
$hesklang['satisfaction']['tab1']='Nastavitve';
$hesklang['satisfaction']['tab2']='Odjavljeni';
$hesklang['satisfaction']['enable']='Omogoči anketna sporočila:';
$hesklang['satisfaction']['enabled']='Anketa o zadovoljstvu strank je vklopljena.';
$hesklang['satisfaction']['disabled']='Anketa o zadovoljstvu strank je izklopljena.';
$hesklang['satisfaction']['url']='URL povezava do ankete:';
$hesklang['satisfaction']['send']='Premor pred pošiljanjem:';
$hesklang['satisfaction']['at_least']='Počakaj vsaj';
$hesklang['satisfaction']['after']='od zaključka zahtevka, preden pošlješ anketo.';
$hesklang['satisfaction']['h1']='Kako uporabiti to orodje?';
$hesklang['satisfaction']['h2']='Najprej pripravite anketo o zadovoljstvu uporabnikom v kateremkoli anketnem orodju. Če ne veste, katero orodje uporabiti ali kakšna vprašanja postaviti, imamo za vas <a href="%s" target="_blank">kratek priročnik tukaj</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Ko imate anketo pripravljeno, omogočite anketna sporočila s pomočjo spodnjega obrazca. Hesk bo enkrat na uro procesiral zaključene zahtevke z vsaj enim odgovorom podpornega osebja in strankam poslal povezavo do ankete.';
$hesklang['satisfaction']['e_url']='Vnesite veljavno povezavo do ankete, ki bo posredovana vašim strankam.';
$hesklang['satisfaction']['as']='Vnesite veljavno povezavo do ankete, ki bo posredovana vašim strankam.';
$hesklang['satisfaction']['oo1']='Na tej strani so navedeni e-poštni naslovi na katere povezava do ankete <b>ne</b> bo poslana.';
$hesklang['satisfaction']['oo2']='Vaše stranke se lahko odjavijo od nadaljnega prejemanja vabil na anketo s klikom na povezavo v e-poštnem sporočilu, lahko pa jih tudi sami odjavite s pomočjo obrazca spodaj.';
$hesklang['satisfaction']['ooe']='E-poštni naslov za odjavo';
$hesklang['satisfaction']['ooe2']='Vnesite e-poštni naslov na katerega ne želite, da se pošiljajo vabila na anketo o zadovoljstvu strank.';
$hesklang['satisfaction']['ooe3']='E-poštni naslov <i>%s</i> je že odjavljen z anketnih sporočil.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Odjavi ta naslov';
$hesklang['satisfaction']['oob']='Odjavil:';
$hesklang['satisfaction']['no_oo']='Noben e-poštni naslov še ni odjavljen od prejemanja vabil na anketo.';
$hesklang['satisfaction']['oor']='Ostrani';
$hesklang['satisfaction']['oor2']='E-poštni naslov je bil odstranjen iz odjav na vabila.';
$hesklang['satisfaction']['oor3']='Potrdi odstranitev';
$hesklang['satisfaction']['oor4']='Po odstranitvi s seznama bodo na ta naslov ponovno prihajala vabila na anketo.';
$hesklang['satisfaction']['optedout']='Vabila na anketo ne bodo več pošiljana na naslov <i>%s</i>.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Manjkajoč ali napačen ID ankete';
$hesklang['satisfaction']['starting']='Začenjam pošiljanje vabil na anketo o zadovoljstvu stran';
$hesklang['satisfaction']['tc']='Število zaprtih zahtevkov, ki še niso prejeli vabila na anketo: %s'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Pošiljanje anket končano. Poslana sporočila: %1$s. Napake pri pošiljanju: %2$s. Zahtevki brez e-poštnega naslova: %3$s. Zahtevki strank, ki ne želijo prejemati vabil: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignoriram, ta stranka ne želi prejemati vabil na anketo';
$hesklang['satisfaction']['ne']='Ignoriram, ta zahtevek je brez e-poštnega naslova';
$hesklang['satisfaction']['feat1']='Pripravite anketo o zadovoljstvu uporabnikov; uporabite katerokoli orodje za ankete, na primer Google Obrazci';
$hesklang['satisfaction']['feat2']='v tem dodatku shranite povezavo do ankete, uredite nastavitve in omejitve';
$hesklang['satisfaction']['feat3']='po zaptrju zahtevka bo stranka prejela e-pošto s povezavo in vabilom, da izpolni anketo';
$hesklang['dfor']='Zapis datuma';
$hesklang['dtfor']='Datum in čas';
$hesklang['cdfor']='Zapis izbire datuma';
$hesklang['custom']='Prilagojeno';
$hesklang['jsc_notice']='koledar uporablja svoj zapis datuma. Izberite eno od prednastavljenih možnosti spodaj ali kliknite na ikono %s za ogled podprtih opcij.'; // %s = replaced by icon
$hesklang['lcf3']='Samo datum'; // Display: "Date only"
$hesklang['epdd']='Napaka pri procesiranju parametra due_date:';
$hesklang['edit_pass']='Urejanje gesla';
$hesklang['save_pass']='Shrani geslo';
$hesklang['cur_pass']='Trenutno geslo';
$hesklang['cur_pass2']='Sprememba gesla zahteva vnos vašega trenutnega gesla.';
$hesklang['cur_pass3']='Po uspešni spremembni gesla boste preusmerjeni na vstopno stran, kjer se lahko prijavite z novim geslom.';
$hesklang['e_new_pass']='Prosim vnesite vaše novo geslo';
$hesklang['pass_len']='Dolžina gesla ne sme presegati 64 znakov';
$hesklang['pass_login']='Prosim prijavite se ponovno po spremembi gesla';
$hesklang['bf_int']='Odjavljeni ste bili zaradi preveliko neuspelih poskusov preverjanja pristnosti';
$hesklang['tst_cnt']='Število e-poštnih sporočil, ki jih bo vaš strežnik poslal Hesk-u: %s'; // %s = number of emails
$hesklang['wrn_imap']='V vašem e-poštnem nabiralniku je veliko število neprebranih sporočil (%1$s). Hesk bo vsa ta sporočila spremenil v zahtevke.<br><br>Morda bi bilo bolje, da pred aktiviranjem &quot;%2$s&quot; označite obstoječa sporočila kot prebrana ali pa uporabite nov (prazen) e-poštni predal.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='V vašem e-poštnem nabiralniku je veliko število sporočil (%1$s). Hesk bo vsa ta sporočila spremenil v zahtevke.<br><br>Morda bi bilo bolje, da pred aktiviranjem &quot;%2$s&quot; izbrišete obstoječa sporočila oziroma uporabite nov (prazen) e-poštni predal.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Rok razrešitve na'; // Due on (date)
$hesklang['search_due_date_range']='Rok razrešitve znotraj'; // Due in (X days)
$hesklang['attachment_add_files']='Dodaj datoteko';
$hesklang['attachment_max_exceeded']='Ta datoteka ne bo prenesena ker bi s tem presegli število dovoljenih priponk.';
$hesklang['attachment_viewer_message']='Povlecite datoteke tukaj ali kliknite gumb \'Dodaj datoteko\' in izberite datoteko za prenos.';
$hesklang['attachment_invalid_type_message']='Oprosite, ta tip datotek ni dovoljen za prenos.';
$hesklang['attachment_upload_error']='Napaka pri prenosu datoteke. Proimo poskusite ponovno kasneje.';
$hesklang['attachment_too_large']='Izbrana datoteka presega največjo dovoljeno velikost.';
$hesklang['attachment_cancel']='Prekliči';
$hesklang['attachment_confirm_cancel']='Želite res preklicati ta prenos?';
$hesklang['attachment_remove']='Odstrani datoteko';
$hesklang['attachment_too_many_uploads']='Z vašega naslova je bilo preneseno preveč datotek v kratkem časovnem obdobju. Prosimo poskusite ponovno kasneje.';
$hesklang['sub_note']='Oddaj opombo';
$hesklang['can_view_users']='Ogled vseh uporabnikov (brez urejanja)';
$hesklang['welcome1']='Pozdravljeni, ste prvič tukaj? Dobrodošli!';
$hesklang['welcome2']='Da bi vam pomagali pričeti z delom, vas vabimo na ogled %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk navodil za hitri začetek';
$hesklang['tmce1']='Uporabite Ctrl+Desni klik za dostop do črkovanja';
$hesklang['tmce2']='Pritisnite in zadržite tipko Control (Ctrl) ter kliknite z desnim miškinim gumbom na besedo za dostop do črkovanja.';
$hesklang['desc_new_ticket_by_staff']='(Stranka) Nov zahtevek vnešen v imenu stranke';
$hesklang['mod_et_h']='Predloge za e-poštna sporočila lahko urejate na strani %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Nastavi jezik na';
$hesklang['ouwa']='Na seznamu so samo uporabniki, ki imajo dostop do te kategorije. Uporabnikom lahko urejate dostop do te kategorije na strani %s'; // %s = Team
$hesklang['previous_tickets']='Prejšnji zahtevki';
$hesklang['no_previous']='Ni prejšnjih zahtevkov za %s'; // %s = email address
$hesklang['all_previous']='Prikaži vse prejšnje zahtevke';
$hesklang['confirm_delete_ticket']='Ste prepričani, da želite trajno izbrisati ta zahtevek?';
$hesklang['confirm_delete_reply']='Ste prepričani, da želite trajno izbrisati ta odgovor?';
$hesklang['select_new_category']='Število zahtevkov v tej kategoriji: %s<br><br>Izberite v katero kategorijo naj se prenesejo ti zahtevki:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Število zahtevkov dodeljenih temu uporabniku: %1$s<br>Število <b>odprtih</b> zahtevkov dodeljenih temu uporabniku: %2$s<br><br>Po izbrisu uporabnika bodo <b>odprti</b> zahtevki spremenjeni v nedodeljene.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK licenca';
$hesklang['hlic_free']='BREZPLAČNA';
$hesklang['hlic_buyl']='Kupi licenco';
$hesklang['hlic_paid']='Licencirana';
$hesklang['antdemo']='Dodajanje zahtevkov z nadzorne plošče je bila onemogočena v demo verziji.<br><br>Prosim uporabite <a href="%s" target="_blank">javno stran</a> za testiranje dodajanja zahtevkov.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Način avtentikacije';
$hesklang['email_authentication_method_username_password']='Osnoven (uporabniško ime in geslo)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Ni registriranih ponudnikov OAuth.';
$hesklang['email_authentication_method_oauth_link']='Urejanje OAuth ponudnikov'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL preverjanja pristnosti (Authorization Endpoint)';
$hesklang['email_oauth_token_url']='URL generatorja žetonov (Token Endpoint)';
$hesklang['email_oauth_client_id']='ID stranke (Client ID)';
$hesklang['email_oauth_client_secret']='Skrivnost stranke (Client Secret)';
$hesklang['email_oauth_scope']='Obseg (Scope)';
$hesklang['oauth_error_invalid_state']='OAuth stanje se ne sklada s stanjem, ki ga je poslal ponudnik OAuth.';
$hesklang['oauth_error_unknown']='Nepričakovana napaka pri shranjevanju OAuth žetonov.';
$hesklang['oauth_error_no_token']='Dostopni žeton manjka v JSON odgovoru.';
$hesklang['oauth_error_retrieve']='Napaka pri pridobivanju dostopnega žetona. Prosim preverite nastavitve OAuth ponudnika in jih ponovno shranite, da se posodobijo žetoni.';
$hesklang['email_oauth_provider']='OAuth ponudnik';
$hesklang['email_oauth_providers']='OAuth ponudniki';
$hesklang['email_oauth_provider_guide']='Preden lahko uporabite OAuth, morate registrirati OAuth ponudnika. Za več informacij preberite <a href="%s" target="_blank">ta članek iz baze znanja</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Vaš OAuth preusmeritveni URI (Redirect URI) za Hesk je:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Uporabite to orodje za dodajanje OAuth ponudnikov za uporabo v vaši podpori';
$hesklang['email_oauth_provider_name']='Ime'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nov ponudnik';
$hesklang['email_oauth_edit_provider']='Urejanje ponudnika';
$hesklang['email_oauth_provider_being_used_for']='Uporablja se za';
$hesklang['email_oauth_providers_none']='Nimate shranjenih ponudnikov. Dodajte jih s klikom na gumb "Nov ponudnik" zgoraj.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Tega ponudnika ni mogoče izbrisati, ker je trenutno v uporabi.';
$hesklang['email_oauth_confirm_delete_provider']='Ste prepričani, da želite izbrisati izbranega ponudnika?';
$hesklang['oauth_provider_saved']='OAuth ponudnik je bil shranjen';
$hesklang['oauth_provider_use']='Sedaj lahko tega ponudnika uporabite v nastavitvah na strani %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Vnesite ime pomnudnika';
$hesklang['oauth_provider_err_auth_url']='Vnesite veljaven URL preverjanja pristnosti';
$hesklang['oauth_provider_err_token_url']='Vnesite veljaven URL generatorja žetonov';
$hesklang['oauth_provider_err_client_id']='Vnesite ID stranke';
$hesklang['oauth_provider_err_client_secret']='Vnesite skrivnost stranke';
$hesklang['oauth_provider_err_scope']='Vnesite obseg (scope)';
$hesklang['oauth_provider_deleted']='OAuth ponudnik je bil izbrisan';
$hesklang['oauth_provider_not_found']='Ta OAuth ponudnik ne obstaja v bazi podatkov';
$hesklang['oauth_provider_verified']='Preverjen';
$hesklang['oauth_provider_click_to_verify']='Klikni za preverjanje';
$hesklang['can_due_date']='Lahko določi rok za razrešitev'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Nimate dovoljenja za nastavljanje rokov za razrešitev';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');