<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Ελληνικά (Greek)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Kostas Malavazos
* Evangelos Emmanouilidis
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Ελληνικά';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Greek';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Απαντήστε πάνω από αυτή τη γραμμή ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Νέο αίτημα: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Αίτημα παραλήφθηκε: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Αίτημα ανατέθηκε: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Νέα απάντηση σε: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Νέα απάντηση σε: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Αίτημα μετακινήθηκε: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Προστέθηκε σημέιωση στο: %%SUBJECT%%';
$hesklang['new_pm']='Νέο ιδιωτικό μήνυμα: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Λίστα των αιτημάτων υποστήριξή σας';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Δεν μπορεί να γίνει σύνδεση με την βάση δεδομένων!';
$hesklang['invalid_action']='Ακυρη ενέργεια';
$hesklang['select_username']='Παρακαλώ είσαγετε το όνομα χρήστη';
$hesklang['enter_pass']='Παρακαλώ εισάγετε τον κωδικό πρόσβασης';
$hesklang['cant_sql']='Δεν μπορεί να εκτελεστεί SQL';
$hesklang['contact_webmsater']='Παρακαλώ ενημερώστε τον webmaster στο';
$hesklang['mysql_said']='MySQL είπε';
$hesklang['wrong_pass']='Λάθος κωδικός πρόσβασης.';
$hesklang['session_expired']='Η σύνοδός σας έχει λήξει, μπορείτε να συνδεθείτε χρησιμοποιώντας την παρακάτω φόρμα.';
$hesklang['attempt']='Ακυρη προσπάθεια!';
$hesklang['not_authorized_tickets']='Δεν έχετε δικαίωμα να δείτε τα αιτήματα μέσα σ\' αυτή την κατηγορία!';
$hesklang['must_be_admin']='Δεν έχετε δικαίωμα να δείτε αυτή την σελίδα! Για να δείτε αυτή την σελίδα πρέπει να εισέλθετε σαν διαχειριστής.';
$hesklang['no_session']='Δεν μπορείτε να ξεκινήσετε καινούργια σύνοδο!';
$hesklang['error']='Λάθος';
$hesklang['int_error']='Εσωτερικό λάθος στο script';
$hesklang['no_trackID']='Δεν υπάρχει ID Παρακολούθησης';
$hesklang['status_not_valid']='Η κατάσταση δεν είναι έγκυρη';
$hesklang['trackID_not_found']='Το ID Παρακολούθησης δεν βρέθηκε';
$hesklang['enter_message']='Παρακαλώ εισάγετε το μήνυμά σας';
$hesklang['select_priority']='Παρακαλώ επιλέξτε προτεραιότητα';
$hesklang['ticket_not_found']='Το Αίτημα δεν βρέθηκε! Παρακαλώ επιβεβαιώστε ότι εισάγατε το σωστό ID παρακολούθησης!';
$hesklang['no_selected']='Δεν επιλέχτηκαν αιτήματα, δεν θα γίνει καμία αλλαγή';
$hesklang['id_not_valid']='Αυτό δεν είναι έγκυρο ID';
$hesklang['enter_id']='Παρακαλώ εισάγετε ID παρακολούθησης';
$hesklang['enter_name']='Παρακαλώ εισάγετε όνομα πελάτη';
$hesklang['enter_date']='Παρακαλώ εισάγετε την ημερομηνία που θέλετε να αναζητήσετε';
$hesklang['date_not_valid']='Δεν είναι σωστή η ημερομηνία. Παρακαλώ εισάγετε ημερομηνία σε μορφή<b>ΜΜ-ΗΗ-ΕΕΕΕ</b>.';
$hesklang['enter_subject']='Παρακαλώ εισάγετε θέμα στο αίτημα';
$hesklang['invalid_search']='Ακυρη ενέργεια αναζήτησης';
$hesklang['choose_cat_ren']='Παρακαλώ επιλέξτε μια κατηγορία για να μετονομαστεί';
$hesklang['cat_ren_name']='Παρακαλώ γράψτε νέο όνομα κατηγορίας';
$hesklang['cat_not_found']='Η κατηγορία δεν βρέθηκε';
$hesklang['enter_cat_name']='Παρακαλώ εισάγετε όνομα κατηγορίας';
$hesklang['no_cat_id']='Δεν υπάρχει το ID Κατηγορίας';
$hesklang['cant_del_default_cat']='Δεν μπορείτε να διαγράψετε την προεπιλεγμένη κατηγορία, μπορείτε μόνο να την μετονομάσετε';
$hesklang['no_valid_id']='Δεν ισχύει το ID χρήστη';
$hesklang['user_not_found']='Ο χρήστης δεν βρέθηκε';
$hesklang['enter_real_name']='Παρακαλώ εισάγετε το πραγματικό όνομα του χρήστη';
$hesklang['enter_valid_email']='Παρακαλώ εισάγετε μια έγκυρη email διεύθυνση';
$hesklang['enter_username']='Παρακαλώ εισάγετε όνομα χρήστη (login)';
$hesklang['asign_one_cat']='Παρακαλώ να ορίσετε το χρήστη σε τουλάχιστον μία κατηγορία!';
$hesklang['signature_long']='Η υπογραφή του χρήστη είναι πολύ μεγάλη! Παρακαλώ περιορίστε την υπογραφή σε 255 χαρακτήρες';
$hesklang['confirm_user_pass']='Παρακαλώ επιβεβαιώστε τον κωδικό πρόσβασης';
$hesklang['passwords_not_same']='Οι δύο κωδικοί πρόσβασης δεν είναι ίδιοι!';
$hesklang['cant_del_admin']='Δεν μπορείτε να διαγράψετε τον προεπιλεγμένο διαχειριστή!';
$hesklang['cant_del_own']='Δεν μπορείτε να διαγράψετε το προφίλ με το οποίο έχετε εισέλθει!';
$hesklang['enter_your_name']='Παρακαλώ εισάγετε το ονοματεπώνυμό σας';
$hesklang['sel_app_cat']='Παρακαλώ επιλέξτε την κατάλληλη κατηγορία';
$hesklang['sel_app_priority']='Παρακαλώ επιλέξτε την κατάλληλη προτεραιότητα';
$hesklang['enter_ticket_subject']='Παρακαλώ εισάγετε το θέμα του αιτήματος';
$hesklang['user_not_found_nothing_edit']='Ο χρήστης δεν βρέθηκε ή δεν υπάρχει κάτι να αλλάξει';

// ADMIN PANEL
$hesklang['administrator']='Διαχειριστής';
$hesklang['login']='Σύνδεση';
$hesklang['user']='Χρήστης';
$hesklang['username']='Όνομα Χρήστη';
$hesklang['pass']='Κωδικός Πρόσβασης';
$hesklang['confirm_pass']='Επιβεβαίωση Κωδικού Πρόσβασης';
$hesklang['logged_out']='Αποσυνδεθείτε';
$hesklang['logout']='Αποσύνδεση';
$hesklang['logout_success']='Έχετε αποσυνδεθεί επιτυχώς!';
$hesklang['click_login']='Κλικ για σύνδεση';
$hesklang['back']='Πάτε πίσω';
$hesklang['displaying_pages']='Προβολή <b>%d</b> Αιτημάτων. Σελίδες:';
$hesklang['trackID']='ID Παρακολούθησης';
$hesklang['timestamp']='Timestamp';
$hesklang['name']='Όνομα';
$hesklang['subject']='Θέμα';
$hesklang['status']='Κατάσταση';
$hesklang['priority']='Προτεραιότητα';
$hesklang['open']='Νέο';
$hesklang['open_action']='Ανοιγμα Αιτήματος'; // Open ACTION
$hesklang['close']='Κλειστό'; // Closed ticket STATUS
$hesklang['any_status']='Οποιαδήποτε κατάσταση';
$hesklang['high']='Υψηλή';
$hesklang['medium']='Μεσαία';
$hesklang['low']='Χαμηλή';
$hesklang['del_selected']='Διαγραφή επιλεγμένων αιτημάτων';
$hesklang['manage_cat']='Διαχείριση κατηγοριών';
$hesklang['profile']='Το προφίλ σας';
$hesklang['show_tickets']='Προβολή Αιτημάτων';
$hesklang['sort_by']='Ταξινόμηση κατά';
$hesklang['date_posted']='Ημερομηνία καταχώρησης';
$hesklang['category']='Κατηγορία';
$hesklang['any_cat']='Οποιαδήποτε κατηγορία';
$hesklang['order']='Ταξινόμηση';
$hesklang['ascending']='αύξουσα';
$hesklang['descending']='φθίνουσα';
$hesklang['display']='Προβολή';
$hesklang['tickets_page']='αιτήματα ανά σελίδα';
$hesklang['find_ticket']='Εύρεση αιτήματος';
$hesklang['yyyy_mm_dd']='ΕΕΕΕ-ΜΜ-ΗΗ';
$hesklang['results_page']='αποτελέσματα ανά σελίδα';
$hesklang['opened']='άνοιξε'; // The ticket has been OPENED
$hesklang['closed']='Επιλυμένο'; // Ticket has been RESOLVED
$hesklang['ticket']='Αίτημα';
$hesklang['tickets']='Αιτήματα';
$hesklang['ticket_been']='Αυτό το αίτημα έχει';
$hesklang['view_ticket']='Δείτε το αίτημα';
$hesklang['open_tickets']='Ανοικτά αιτήματα';
$hesklang['remove_statement']='Remove &quot;Powered by&quot; statement';
$hesklang['click_info']='Click here for more info';
$hesklang['reply_added']='Η απάντηση προστέθηκε';
$hesklang['reply_submitted']='Η απάντηση υποβλήθηκε';
$hesklang['ticket_marked']='Το αίτημα έχει σημειωθεί';
$hesklang['ticket_status']='Κατάσταση αιτήματος';
$hesklang['replies']='Απαντήσεις';
$hesklang['date']='Ημερομηνία';
$hesklang['email']='Email';
$hesklang['ip']='IP';
$hesklang['message']='Μήνυμα';
$hesklang['add_reply']='Προσθήκη απάντησης';
$hesklang['close_this_ticket']='Κλείσιμο αυτού του αιτήματος';
$hesklang['change_priority']='Αλλαγή προτεραιότητας σε';
$hesklang['attach_sign']='Επισύναψη υπογραφής';
$hesklang['profile_settings']='Ρυθμίσεις προφίλ';
$hesklang['submit_reply']='Υποβολή απάντησης';
$hesklang['support_panel']='Πίνακας Υποστήριξης';
$hesklang['ticket_trackID']='ID Παρακολούθησης Αιτήματος';
$hesklang['c2c']='Κλικ για να συνεχίσετε';
$hesklang['tickets_deleted']='Τα αιτήματα διαγράφηκαν';
$hesklang['num_tickets_deleted']='<b>%d</b> αιτήματα έχουν ήδη διαγραφεί';
$hesklang['confirm_del_cat']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την κατηγορία;?';
$hesklang['cat_intro']='Εδώ μπορείτε να διαχειριστείτε τις κατηγορίες. Οι κατηγορίες είναι χρήσιμες
για κατηγοριοποίηση των αιτημάτων βάση συνάφειας (για παράδειγμα &quot;Πωλήσεις&quot;,
&quot;Προβλήματα Hardware&quot;, &quot;PHP/MySQL προβήματα&quot; etc) και για να αντιστοιχήσετε χρήστες με τις κατηγορίες
(για παράδειγμα ο υπεύθυνος για τις πωλήσεις μπορεί να βλέπει αιτήματα που δημοσιεύονται στην κατηγορία &quot;Πωλήσεις&quot;)';
$hesklang['cat_name']='Όνομα κατηγορίας';
$hesklang['remove']='Διαγραφή';
$hesklang['add_cat']='Προσθήκη νέας κατηγορίας';
$hesklang['max_chars']='μέγ. 40 χαρακτήρες';
$hesklang['create_cat']='Δημιουργία νέας κατηγορίας';
$hesklang['ren_cat']='Μετονομασία κατηγορίας';
$hesklang['to']='προς';
$hesklang['cat_added']='Η κατηγορίας προστέθηκε';
$hesklang['cat_name_added']='Η κατηγορία %s έχει προστεθεί  με επιτυχία';
$hesklang['cat_renamed']='Η κατηγορία μετονομάστηκε';
$hesklang['cat_renamed_to']='Η επιλεγμένη κατηγορία έχει μετονομαστεί με επιτυχία σε ';
$hesklang['cat_removed']='Η κατηγορία διαγράφηκε';
$hesklang['cat_removed_db']='Selected category has been successfully removed from the database';
$hesklang['sure_remove_user']='Are you sure you want to remove this user?';
$hesklang['manage_users']='Διαχείριση χρηστών';
$hesklang['users_intro']='Εδώ μπορείτε να διαχειριστείτε τους χρήστε που μπορούν να εισέλθουν στη σελίδα διαχείρισης και να 
απαντούν αιτήματα. Οι διαχειριστές μπορούν να βλέπουν και να επεξεργάζονται τα αιτήματα σε οποιαδήποτε κατηγορία και να έχουν πρόσβαση
σε όλες τις λειτουργίες της σελίδας διαχείρισης (διαχείριση χρηστών, διαχείριση χρηστών, διαχείριση κατηγοριών, ...) ενώ 
οι υπόλοιποι χρήστες μπορούν να βλέπουν και να απαντούν μόνο τα αιτήματα που ανήκουν στις κατηγορίες τους.';
$hesklang['yes']='ΝΑΙ';
$hesklang['no']='ΟΧΙ';
$hesklang['edit']='Επεξεργασία';
$hesklang['add_user']='Προσθήκη νέου χρήστη';
$hesklang['req_marked_with']='Τα υποχρεωτικά πεδία σημειώνονται με';
$hesklang['real_name']='Ονοματεπώνυμο';
$hesklang['signature_max']='Υπογραφή (μέγιστο 255 χαρακτήρες)';
$hesklang['sign_extra']='HTML κώδικας δεν επιτρέπεται. Links will be clickable.';
$hesklang['create_user']='Δημιουργία χρήστη';
$hesklang['editing_user']='Επεξεργασία χρήστη';
$hesklang['user_added']='Ο χρήστης προστέθηκε';
$hesklang['user_added_success']='Νέος χρήστης %s με κωδικός πρόσβασης %s έχει προστεθεί επιτυχώς';
$hesklang['profile_updated']='Το προφίλ ενημερώθηκε';
$hesklang['profile_updated_success']='Το προφίλ σας ενημερώθηκε επιτυχώς';
$hesklang['user_removed']='Ο χρήστης διαγράφηκε';
$hesklang['sel_user_removed']='Ο επιλεγμένος χρήστης διαγράφηκε επιτυχώς από την βάση δεδομένων';
$hesklang['profile_for']='Προφίλ για';
$hesklang['new_pass']='Νέος κωδικός πρόσβασης';
$hesklang['update_profile']='Ενημέρωση προφίλ';
$hesklang['notify_new_posts']='Ειδοποίηση για νέα αιτήματα και αναρτήσεις στις κατηγορίες μου';
$hesklang['view_profile']='Προβολή προφίλ';
$hesklang['new_ticket_submitted']='Νέο αίτημα καταχωρήθηκε';
$hesklang['user_profile_updated_success']='Το προφίλ του χρήστη ενημερώθηκε επιτυχώς';
$hesklang['printer_friendly']='Εκδοση φιλική για εκτύπωση';
$hesklang['end_ticket']='--- Τέλος αιτήματος ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Το αίτημα σας έχει';
$hesklang['view_your_ticket']='Δείτε το αίτημα σας';
$hesklang['submit_ticket']='Καταχώρηση αιτήματος';
$hesklang['sub_ticket']='Καταχώρηση αιτήματος';
$hesklang['before_submit']='Πριν από την υποβολή βεβαιωθείτε για τα ακόλουθα';
$hesklang['all_info_in']='Όλες οι απαραίτητες πληροφορίες έχουν συμπληρωθεί';
$hesklang['all_error_free']='Όλες οι πληροφορίες είναι σωστές και χωρίς λάθη';
$hesklang['we_have']='Έχουμε';
$hesklang['recorded_ip']='καταγράψει την IP διεύθυνσή σας';
$hesklang['recorded_time']='καταγράψει τον χρόνο υποβολής';
$hesklang['save_changes']='Αποθήκευση αλλαγών';
$hesklang['reply_submitted_success']='Η απάντησή σας σε αυτό το αίτημα έχει υποβληθεί επιτυχώς';
$hesklang['ticket_submitted']='Το αίτημα υποβλήθηκε';
$hesklang['ticket_submitted_success']='Το αίτημα σας υποβλήθηκε επιτυχώς! ID Παρακολούθησης';
$hesklang['your_ticket']='Το αίτημα σας';

// Added in version 0.94
$hesklang['check_updates']='Βεβαιωθείτε ότι έχετε εγκαταστήσει την τελευταία έκδοση του HESK!';
$hesklang['check4updates']='Έλεγχος για ενημερώσεις';
$hesklang['wait_reply']='Αναμονή απάντησης';
$hesklang['replied']='Απαντημένο';
$hesklang['last_replier']='Τελευταίος που απάντησε';
$hesklang['staff']='Προσωπικό';
$hesklang['customer']='Πελάτης';
$hesklang['close_selected']='Σημείωσε τα επιλεγμένα αιτήματα ως Επιλυμένα';
$hesklang['execute']='Εκτέλεση';
$hesklang['saved_replies']='Έτοιμες Απαντήσεις';
$hesklang['manage_saved']='Έτοιμες απαντήσεις';
$hesklang['manage_intro']='Εδώ μπορείτε να προσθέσετε και να διαχειριστείτε έτοιμες απαντήσεις. These are commonly used replies which are more or less the same for every customer. You should use canned responses to avoid typing the same reply to different customers numerous times.';
$hesklang['saved_title']='Τίτλος';
$hesklang['no_saved']='Δεν υπάρχουν έτοιμες απαντήσεις';
$hesklang['delete_saved']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την έτοιμη απάντηση;';
$hesklang['new_saved']='Προσθήκη ή Επεξεργασία έτοιμης απάντησης';
$hesklang['canned_add']='Δημιουργία νέας έτοιμης απάντησης';
$hesklang['canned_edit']='Επεξεργασία επιλεγμένης έτοιμης απάντησης';
$hesklang['save_reply']='Αποθήκευση απάντησης';
$hesklang['saved']='Η απάντηση αποθηκεύτηκε';
$hesklang['your_saved']='Η έτοιμη απάντηση αποθηκεύτηκε για μελλοντική χρήση';
$hesklang['ent_saved_title']='Παρακαλώ εισάγετε τίτλο απάντησης';
$hesklang['ent_saved_msg']='Παρακαλώ εισάγετε μήνυμα απάντησης';
$hesklang['saved_removed']='Η έτοιμη απάντηση διαγράφηκε';
$hesklang['saved_rem_full']='Η επιλεγμένη έτοιμη απάντηση διαγράφηκε από την βάση δεδομένων';
$hesklang['clip_alt']='Αυτή η ανάρτηση έχει συνημμένα αρχεία';
$hesklang['attachments']='Συνημμένα';
$hesklang['fill_all']='Λείπει απαιτούμενο πεδίο';
$hesklang['file_too_large']='Το αρχείο σας %s είναι πολύ μεγάλο';
$hesklang['cannot_move_tmp']='Δεν μπορείτε να μετακινήσετε το αρχείο στο φάκελο συνημμένα';
$hesklang['created_on']='Δημιουργήθηκε στις';
$hesklang['tickets_closed']='Αιτήματα Κλειστά';
$hesklang['num_tickets_closed']='<b>%d</b> αιτήματα έχουν κλείσει';
$hesklang['select_saved']='Διαλέξτε μια έτοιμη απάντηση';
$hesklang['select_empty']='Επιλογή / Κενό';
$hesklang['insert_special']='Εισάγετε ειδική ετικέτα (θα αντικατασταθεί με πληροφορίες του πελάτη)';
$hesklang['move_to_catgory']='Μετακίνηση αιτήματος σε';
$hesklang['move']='Μετακίνηση';
$hesklang['moved']='Το αίτημα μετακινήθηκε';
$hesklang['moved_to']='Το αίτημα έχει μετακινηθεί σε νέα κατηγορία';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Όλα εκτός από τα κλειστά';
$hesklang['chg_all']='Αλλαγή όλων';
$hesklang['settings']='Ρυθμίσεις';
$hesklang['settings_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να διαμορφώσετε το help desk. Για περισσότερες πληροφορίες σχετικά με όλες τις ρυθμίσεις και τις επιλογές κάντε κλικ στο σύμβολο βοήθειας ή ανατρέξτε στο αρχείο README.html.';
$hesklang['all_req']='Όλα τα πεδία (εκτός από τα απενεργοποιημένα) είναι υποχρεωτικά!';
$hesklang['wbst_title']='Τίτλους του Website';
$hesklang['wbst_url']='Website URL';
$hesklang['email_wm']='Webmaster email';
$hesklang['max_listings']='Καταχωρήσεις ανά σελίδα';
$hesklang['print_size']='Μέγεθος φόντου εκτύπωσης';
$hesklang['debug_mode']='Κατάσταση αποσφαλμάτωσης (Debug mode)';
$hesklang['on']='ON';
$hesklang['off']='OFF';
$hesklang['use_secimg']='Χρήση εικόνας anti-SPAM';
$hesklang['secimg_no']='Δεν είναι διαθέσιμο';
$hesklang['attach_use']='Χρήση συνημμένων αρχείων';
$hesklang['attach_num']='Πλήθος ανά δημοσίευση';
$hesklang['attach_type']='Επιτρεπτοί τύποι αρχείων';
$hesklang['place_after']='Μετά το μήνυμα';
$hesklang['place_before']='Πριν το μήνυμα';
$hesklang['custom_f']='Προσαρμοσμένο πεδίο';
$hesklang['custom_u']='Χρησιμοποιήστε αυτό το πεδίο';
$hesklang['custom_n']='Όνομα πεδίου';
$hesklang['custom_l']='Μέγιστο μήκος (χαρακτήρες)';
$hesklang['db_host']='Database host';
$hesklang['db_name']='Database name';
$hesklang['db_user']='Database username';
$hesklang['db_pass']='Database password';
$hesklang['err_sname']='Παρακαλώ εισάγετε τίτλο για το website σας';
$hesklang['err_surl']='Please enter your website URL. Make sure it is a valid URL (start with http:// or https://)';
$hesklang['err_wmmail']='Παρακαλώ εισάγετε ένα έγκυρο email του webmaster';
$hesklang['err_nomail']='Please enter a valid noreply email';
$hesklang['err_htitle']='Παρακαλώ εισάγετε τον τίτλο του γραφείου υποστήριξης';
$hesklang['err_hurl']='Please enter your Hesk folder url. Make sure it is a valid URL (start with http:// or https://)';
$hesklang['err_lang']='Παρακαλώ επιλέξτε την γλώσσα του Hesk';
$hesklang['err_nolang']='Το αρχείο γλώσσας που επιλέξατα δεν υπάρχει στον φάκελο γλωσσών! Make sure the file is uploaded before changing the language setting.';
$hesklang['err_max']='Παρακαλώ εισάγετε τις μέγιστες καταχωρήσεις που θα εμφανίζονται ανά σελίδα';
$hesklang['err_psize']='Παρακαλώ εισάγετε το μέγεθος της γραμματοσειράς εκτύπωσης';
$hesklang['err_dbhost']='Παρακαλώ εισάγετε τον MySQL database host';
$hesklang['err_dbname']='Παρακαλώ εισάγετε το MySQL database name';
$hesklang['err_dbuser']='Παρακαλώ εισάγετε το MySQL database username';
$hesklang['err_dbpass']='Παρακαλώ εισάγετε το MySQL database password';
$hesklang['err_dbconn']='Δεν ήταν δυνατή η σύνδεση με τη βάση δεδομένων MySQL χρησιμοποιώντας τις πληροφορίες που παρέχονται!';
$hesklang['err_dbsele']='Could not select MySQL database, please double-check database NAME';
$hesklang['err_custname']='Please enter name(s) for selected optional field(s)';
$hesklang['err_openset']='Can\'t open file <b>hesk_settings.inc.php</b> for writing. Please CHMOD this file to 666 (rw-rw-rw-)';
$hesklang['set_saved']='Οι ρυθμίσεις αποθηκεύτηκαν';
$hesklang['set_were_saved']='Οι ρυθμίσεις αποθηκεύτηκαν επιτυχώς';
$hesklang['sec_img']='Εικόνα Ασφαλείας';
$hesklang['sec_miss']='Παρακαλώ εισάγετε τον αριθμό ασφαλείας';
$hesklang['sec_wrng']='Λάθος αριθμός ασφαλείας';
$hesklang['submit_problems']='Παρακαλώ επιστρέψτε πίσω και διορθώστε τα ακόλουθα προβλήματα';
$hesklang['cat_order']='Σειρά Κατηγοριών';
$hesklang['reply_order']='Σειρά έτοιμων απαντήσεων';
$hesklang['move_up']='Μετακίνηση πάνω';
$hesklang['move_dn']='Μετακίνηση κάτω';
$hesklang['cat_move_id']='Λείπει το ID κατηγορίας';
$hesklang['reply_move_id']='Λείπει το ID έτοιμης απάντησης';
$hesklang['forgot_tid']='Ξεχάσατε το ID παρακολούθησης;';
$hesklang['tid_send']='Στείλε μου το ID παρακολούθησης';
$hesklang['tid_not_found']='Δεν βρέθηκαν αιτήματα με αυτή την email διεύθυνση';
$hesklang['tid_sent']='Το ID παρακολούθησης στάλθηκε';
$hesklang['tid_sent2']='Ένα email με λεπτομέρειες σχετικά με τα αιτήματα σας στάλθηκε στο email σας';
$hesklang['check_spambox']='Επίσης να ελέγξετε για το email μέσα στον φάκελο SPAM/Ανεπιθύμητη αλληλογραφία!';
$hesklang['reply_not_found']='Η έτοιμη απάντηση δεν βρέθηκε';
$hesklang['exists']='Υπάρχει';
$hesklang['no_exists']='Δεν υπάρχει';
$hesklang['writable']='Εγγράψιμο';
$hesklang['not_writable']='Μη εγγράψιμο';
$hesklang['disabled']='απενεργοποιημένο';
$hesklang['e_settings']='Δεν θα μπορείτε να αποθηκεύσετε τις ρυθμίσεις σας έως ότου αυτό το αρχείο είναι εγγράψιμο από αυτό το script. Παρακαλούμε ανατρέξτε στο αρχείο readme για περεταίρω οδηγίες!';
$hesklang['e_attdir']='Δεν θα μπορείτε να αρχειοθετήσετε τις επισυνάψεις εώς ότου αυτό υπάρχει και είναι εγγράψιμο από αυτό το script. Παρακαλούμε ανατρέξτε στο αρχείο readme για περεταίρω οδηγίες!';
$hesklang['e_save_settings']='Αποτυχία αποθήκευσης των ρυθμίσεών σας επειδή το αρχείο <b>hesk_settings.inc.php</b> δεν είναι εγγράψιμο από αυτό το script.';
$hesklang['e_attach']='Απενεργοποιημένο επειδή ο φάκελος <b>attachments</b> δεν είναι εγγράψιμος από αυτό το script.';
$hesklang['go']='Εκτέλεση';

// Added in version 2.0
$hesklang['v']='HESK έκδοση';
$hesklang['check_status']='Έλεγχος κατάστασης';
$hesklang['sub_support']='Υποβολή αιτήματος';
$hesklang['open_ticket']='Υποβάλλετε ένα νέο θέμα σε ένα τμήμα';
$hesklang['view_existing']='Προβολή υπάρχοντος αιτήματος';
$hesklang['vet']='Προβολή αιτημάτων που υποβάλλατε στο παρελθόν';
$hesklang['enter_user']='Παρακαλώ εισάγετε το όνομα χρήστη';
$hesklang['remember_user']='Να θυμάσαι το όνομα χρήστη';
$hesklang['wrong_user']='Λάθος όνομα χρήστη';
$hesklang['no_permission']='You don\'t have permission to perform this task, please login with an account that has.';
$hesklang['tickets_on_pages']='Αριθμός αιτημάτων: %d | Αριθμός σελίδων: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Μετάβασε στη σελίδα:';
$hesklang['no_tickets_open']='Δεν βρέθηκαν ανεπίλυτα αιτήματα';
$hesklang['no_tickets_crit']='Δεν βρέθηκαν αιτήματα που να ταιριάζουν στα κριτήρια σας';
$hesklang['confirm_execute']='Έίστε σίγουροι ότι θέλετε να συνεχίσετε;';
$hesklang['legend']='Legend';
$hesklang['main_page']='Αρχή';
$hesklang['menu_users']='Χρήστες';
$hesklang['menu_cat']='Κατηγορίες';
$hesklang['menu_profile']='Προφίλ';
$hesklang['menu_kb']='Βάση γνώσεων'; // Admin MENU item
$hesklang['kb_text']='Βάση γνώσεων'; // Item visible to customers
$hesklang['viewkb']='Προβολή όλης της βάσης γνώσεων';
$hesklang['kb']='Διαχείριση βάσης γνώσεων';
$hesklang['kb_intro']='Η βάση γνώσεων είναι μια συλλογή από απαντήσεις σε συχνές ερωτήσεις (FAQ) και άρθρα τα οποία παρέχουν πόρους αυτοβοήθειας στους πελάτες σας.
Μια περιεκτική και καλογραμμένη βάση γνώσεων μπορεί να μειώσει δραστικά τον αριθμό των αιτημάτων υποστήριξης που λαμβάνετε και να σώσει πολύ χρόνο σας. Μπορείτε να τακτοποιήσετε άρθρα σε κατηγορίες
και υποκατηγορίες.'; // Description in ADMIN panel
$hesklang['kb_is']='Η βάση γνώσεων είναι κατηγοριοποιημένη συλλογή από απαντήσεις σε συχνές ερωτήσεις (FAQ) και άρθρα. Μπορείτε να διαβάσετε άρθρα σε αυτή την κατηγορία ή επιλέξτε μια υποκατηγορία που σας ενδιαφέρει.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Νέο άρθρο βάσης γνώσεων';
$hesklang['kb_cat']='Κατηγορία';
$hesklang['kb_subject']='Θέμα';
$hesklang['kb_content']='Περιεχόμενα';
$hesklang['kb_type']='Τύπος';
$hesklang['kb_published']='Δημοσιευμένο';
$hesklang['kb_published2']='Το άρθρο αυτό είναι ορατό σε όλους στην βάση γνώσεων.';
$hesklang['kb_private']='Ιδιωτικό';
$hesklang['kb_private2']='Τα ιδιωτικά άρθρα μπορούν να διαβάζονται μόνο από το προσωπικό.';
$hesklang['kb_draft']='Πρόχειρο';
$hesklang['kb_draft2']='Το άρθρο αποθηκεύτηκε αλλά δεν δημοσιεύτηκε ακόμα. Μπορεί να διαβαστεί μόνο από το προσωπικό<br /> που έχει δικαώματα διαχείρισης σε άρθρα της βάσης γνώσεων.';
$hesklang['kb_links']='<i><span class="notice"><b>Προσοχή!</b></span><br />Εισάγετε έγκυρο κώδικα χωρίς &lt;head&gt; και &lt;body&gt; ετικέτες, μόνο περιεχόμενο!</i>';
$hesklang['kb_ehtml']='Αυτό είναι κώδικας HTML (Θα εισάγω έγκυρο κώδικα (X)HTML)';
$hesklang['kb_dhtml']='Αυτό είναι απλό κείμενο (links will be clickable)';
$hesklang['kb_save']='Αποθήκευση άρθρου';
$hesklang['kb_e_subj']='Εισάγετε το θέμα του άρθρου!';
$hesklang['kb_e_cont']='Γράψτε τα περιέχομενα του άρθρου!';
$hesklang['kb_art_added']='Το άρθρο προστέθηκε';
$hesklang['your_kb_added']='Ένα νέο άρθρο προστέθηκε επιτυχώς στην βάση γνώσεων';
$hesklang['kb_art_deleted']='Το άρθρο διαγράφηκε';
$hesklang['your_kb_deleted']='Το επιλεγμένο άρθρο διαγράφηκε επιτυχώς από την βάση γνώσεων';
$hesklang['kb_art_mod']='Το άρθρο τροποποιήθηκε';
$hesklang['your_kb_mod']='Οι αλλαγές στο επιλεγμένο άρθρο αποθηκεύτηκαν επιτυχώς';
$hesklang['kb_cat_new']='Νέα κατηγορία βάσης γνώσεων';
$hesklang['kb_cat_parent']='Μητρική κατηγορία';
$hesklang['kb_cat_sub']='Υποκατηγορίες';
$hesklang['kb_cat_title']='Τίτλος κατηγορίας';
$hesklang['kb_cat_published']='Η κατηγορία είναι ορατή σε όλους στην βάση γνώσεων.';
$hesklang['kb_cat_private']='Η κατηγορία μπορεί να διαβαστεί μόνο από το προσωπικό.';
$hesklang['kb_cat_add']='Προσθήκη κατηγορίας';
$hesklang['kb_cat_e_title']='Εισάγετε τίτλο κατηγορίας!';
$hesklang['kb_cat_added']='Η κατηγορία προστέθηκε';
$hesklang['kb_cat_added2']='Μια νέα κατηγορία προστέθηκε επιτυχώς στην βάση γνώσεων';
$hesklang['kb_cat_man']='Διαχείριση κατηγορίας βάσης δεδομένων';
$hesklang['kb_cat_edit']='Επεξεργασία λεπτομερειών κατηγορίας';
$hesklang['kb_cat_inv']='Ακυρη κατηγορία';
$hesklang['kb_cat_art']='Αρθρα σ αυτήν την κατηγορία';
$hesklang['kb_p_art']='+ Αρθρο';
$hesklang['kb_p_art2']='προσθήκη νέου άρθρου στην επιλεγμένη κατηγορία.';
$hesklang['kb_add_art']='Προσθήκη άρθρου';
$hesklang['kb_p_cat']='+ Κατηγορία';
$hesklang['kb_p_cat2']='δημιουργία νέας υποκατηγορίας μέσα στην επιλεγμένη κατηγορία.';
$hesklang['kb_add_cat']='Προσθήκη κατηγορίας';
$hesklang['kb_p_man']='Διαχείριση';
$hesklang['kb_p_man2']='διαχείριση επιλεγμένης κατηγορίας (επεξεργασία, διαγραφή, διαχείριση άρθρων).';
$hesklang['kb_main']='Η κύρια κατηγορία της βάσης γνώσεων δεν μπορεί να διαγραφεί ή να μετακινηθεί.';
$hesklang['kb_no_art']='Δεν υπάρχουν άρθρα μέσα σ αυτήν την κατηγορία.';
$hesklang['author']='Συγγραφέας';
$hesklang['views']='Προβολές';
$hesklang['delete']='Διαγραφή';
$hesklang['rating']='Αξιολόγηση';
$hesklang['votes']='Ψήφοι';
$hesklang['kb_rated']='Το άρθρο αξιολογήθηκε %s/5.0';
$hesklang['kb_not_rated']='Το άρθρο δεν αξιολογήθηκε ακόμα';
$hesklang['del_art']='Είστε σίγουροι ότι θέλετε να διαγράψετε το επιλεγμένο άρθρο;';
$hesklang['kb_art_id']='Το ID του άρθρου δεν υπάρχει ή είναι άκυρο!';
$hesklang['kb_art_edit']='Επεξεργασία άρθρου';
$hesklang['revhist']='Ιστορικό εκδόσεων';
$hesklang['revision1']='<li class="smaller">%s | submitted by %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modified by %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Σειρά';
$hesklang['kb_delcat']='Είστε σίγουροι ότι θέλετε να διαγράψετε την επιλεγμένη κατηγορία;';
$hesklang['kb_cat_mod']='Η κατηγορία τροποποιήθηκε';
$hesklang['your_cat_mod']='Οι αλλαγές σας στην επιλεγμένη κατηγορία αποθηκεύτηκαν επιτυχώς';
$hesklang['kb_cat_del']='Η κατηγορία της βάσης γνώσεων διαγράφηκε';
$hesklang['kb_cat_dlt']='Η επιλεγμένη κατηγορία της βάσης γνώσεων έχει διαγραφεί';
$hesklang['allowed_cat']='Κατηγορίες';
$hesklang['allow_feat']='Χαρακτηριστικά';
$hesklang['can_view_tickets']='Προβολή αιτημάτων';
$hesklang['can_reply_tickets']='Απάντηση σε αιτήματα';
$hesklang['can_assign_tickets']='Ανάθεση αιτημάτων';
$hesklang['can_del_tickets']='Διαγραφή αιτημάτων';
$hesklang['can_edit_tickets']='Επεξεργασία απαντήσεων αιτήματος';
$hesklang['can_change_cat']='Αλλαγή κατηγορίας αιτήματος';
$hesklang['can_man_kb']='Διαχείριση βάσης γνώσεων';
$hesklang['can_man_users']='Διαχείριση χρηστών';
$hesklang['can_man_cat']='Διαχείριση κατηγοριών';
$hesklang['can_man_canned']='Διαχείριση έτοιμων απαντήσεων';
$hesklang['can_man_settings']='Διαχείριση ρυθμίσεων help desk';
$hesklang['can_del_notes']='Διαγραφή σημειώσεων αιτήματος';
$hesklang['dan']='οι χρήστες μπορούν να διαγράψουν τις σημειώσεις τους στο αίτημα, επιλέξτε αυτό μόνο αν επιθυμείτε ο χρήστης να μπορεί να διαγράφει σημειώσεις από άλλους χρήστες';
$hesklang['in_all_cat']='στις επιτρεπτές κατηγορίες μόνο';
$hesklang['admin_can']='(πρόσβαση σε όλα τα χαρακτηριστικά και κατηγορίες)';
$hesklang['staff_can']='(μπορείτε να περιορίσετε τα χαρακτηριστικά και τις κατηγορίες)';
$hesklang['asign_one_feat']='Παρακαλώ αναθέστε τουλάχιστον ένα χαρακτηριστικό σ αυτόν τον χρήστη!';
$hesklang['na_view_tickets']='Δεν είστε εξουσιοδοτημένος να βλέπετε αιτήματα';
$hesklang['support_notice']='Sorry, this section can only be hidden when you purchase a HESK license!';
$hesklang['rart']='Βοήθησε αυτό το άρθρο;';
$hesklang['r']='Βοήθησε αυτή η απάντηση;';
$hesklang['tyr']='Ευχαριστούμε για την αξιολόγησή σας';
$hesklang['cw']='Κλείσιμο παραθύρου';
$hesklang['cw2']='Κλείσιμο παραθύρου και υποβολή αιτήματος';
$hesklang['rh']='Αξιολόγηση ως <i>χρήσιμο (βοήθησε πολύ)</i>';
$hesklang['rnh']='Αξιολόγηση ως <i>άχρηστο (δεν βοήθησε)</i>';
$hesklang['ar']='Ήδη αξιολογήθηκε';
$hesklang['rated']='Αξιολόγηση χρήστη %s/5.0 (%s ψήφων)';
$hesklang['not_rated']='Ο χρήστης δεν αξιολογήθηκε ακόμα';
$hesklang['rdis']='Η αξιολόγηση είναι απενεργοποιημένη';
$hesklang['kbdis']='Η βάση γνώσεων είναι απενεργοποιημένη';
$hesklang['kbpart']='Συγνώμη, αλλά δεν έχετε πρόσβαση σ αυτό το άρθρο';
$hesklang['popart']='Κορυφαία άρθρα Βάσης Γνώσεων:';
$hesklang['latart']='Πρόσφατα άρθρα Βάσης Γνώσεων:';
$hesklang['m']='Περισσότερα θέματα';
$hesklang['ac']='Αρθρα σ αυτήν την κατηγορία:';
$hesklang['noa']='Δεν υπάρχουν άρθρα ακόμα';
$hesklang['noac']='Δεν υπάρχουν άρθρα ακόμα σ αυτήν την κατηγορία';
$hesklang['dta']='Ημερομηνία που προστέθηκε';
$hesklang['ad']='Λεπτομέρειες άρθρου';
$hesklang['aid']='ID Αρθρου';
$hesklang['as']='Λύση';
$hesklang['search']='Αναζήτηση';
$hesklang['sr']='Αποτελέσματα αναζήτησης';
$hesklang['nosr']='Δεν βρέθηκαν άρθρα. Περιηγηθείτε στην Βάση Γνώσεων ή υποβάλλετε νέο αίτημα υποστήριξης.';
$hesklang['rv']='Μηδενισμός θεάσων';
$hesklang['rr']='Μηδενισμός ψήφων (αξιολογήσεων)';
$hesklang['opt']='Επιλογές';
$hesklang['delcat']='Διαγραφή κατηγορίας';
$hesklang['move1']='Μετακίνηση άρθρων στη γονική κατηγορία';
$hesklang['move2']='Διαγραφή άρθρων σ αυτήν την κατηγορία';
$hesklang['sc']='Προτεινόμενα άρθρα Βάσης Γνώσεων';
$hesklang['not']='Αιτήματα'; // Number of all tickets in category
$hesklang['graph']='Γράφημα';
$hesklang['lu']='Λίστα χρηστών';
$hesklang['aclose']='Αυτόματο κλείσιμο αιτημάτων';
$hesklang['aclose2']='ημέρες μετά την τελευταία απάντηση από το προσωπικό';
$hesklang['s_ucrt']='Ανοιγμα ξανά αιτημάτων';
$hesklang['urate']='Απαντήση αξιολογήσεων';
$hesklang['hesk_url']='Help desk URL';
$hesklang['hesk_title']='Τίτλος Help desk';
$hesklang['cid']='ID παρακολούθησης υπόθεσης';
$hesklang['tfor']='Μορφή ώρας';
$hesklang['prefix']='Table prefix';
$hesklang['s_ekb']='Βάση Γνώσεων (ΒΓ)';
$hesklang['s_kbs']='Ενεργοποίηση αναζήτησης σε Βάση Γνώσεων';
$hesklang['s_kbr']='Ενεργοποίηση αξιολόγησης Βάσης Γνώσεων';
$hesklang['s_maxsr']='Μέγιστος αριθμός αποτελεσμάτων αναζήτησης';
$hesklang['s_suggest']='Πρότεινε άρθρα ΒΓ';
$hesklang['s_spop']='Δείξε δημοφιλή άρθρα';
$hesklang['s_slat']='Δείξε πρόσφατα άρθρα';
$hesklang['s_onin']='on <a href="../" target="_blank">help desk index</a> page';
$hesklang['s_onkb']='on <a href="../knowledgebase.php" target="_blank">knowledgebase index</a> page';
$hesklang['s_scol']='Κατηγορίες σε σειρά';
$hesklang['s_ptxt']='Μήκος προθέασης άρθρου';
$hesklang['s_psubart']='Αρθρα υποκατηγορίας';
$hesklang['enable']='Ενεργό';
$hesklang['s_type']='Τύπος';
$hesklang['custom_r']='Απαιτείται';
$hesklang['custom_place']='Θέση';
$hesklang['custom_use']='Προσαρμοσμένα πεδία';
$hesklang['stf']='Πεδίο Κειμένου';
$hesklang['stb']='Μεγάλο πλαίσιο κειμένου';
$hesklang['srb']='Radio button';
$hesklang['ssb']='Select box';
$hesklang['db']='Βάση δεδομένων';
$hesklang['hd']='Help desk ρυθμίσεις';
$hesklang['gs']='Γενικές ρυθμίσεις';
$hesklang['cwin']='Κλείσιμο παραθύρου';
$hesklang['defw']='Προεπιλεγμένη τιμή';
$hesklang['ok']='OK';
$hesklang['ns']='These are available options for this custom field. To save changes click <b>OK</b> and <b>Save changes</b> button on the admin settings page!';
$hesklang['rows']='Γραμμές (ύψος)';
$hesklang['cols']='Στήλες (πλάτος)';
$hesklang['opt2']='Options for this radio button, enter one option per line (each line will create a new radio button value to choose from). You need to enter at least two options!';
$hesklang['opt3']='Options for this select box, enter one option per line (each line will be a choice your customers can choose from). You need to enter at least two options!';
$hesklang['atl2']='Εισάγετε τουλάχιστον δύο επιλογές (μία σε κάθε γραμμή)!';
$hesklang['notes']='Σημειώσεις';
$hesklang['addnote']='+ Προσθήκη σημείωσης';
$hesklang['noteby']='Σημείωση από';
$hesklang['delnote']='Διαγραφή σημείωσης';
$hesklang['noteerr']='Η σημείωση ήδη διαγράφηκε ή έχει λάθος παραμέτρους';
$hesklang['s']='Υποβολή';
$hesklang['nhid']='Οι σημειώσεις είναι κρυφές από τους πελάτες!';
$hesklang['delt']='Διαγράφη αυτής της ανάρτησης';
$hesklang['edtt']='Επεξεργασία ανάρτησης';
$hesklang['edt1']='Η ανάρτηση τροποποιήθηκε';
$hesklang['edt2']='Οι αλλαγές στην επιλεγμένη ανάρτηση αποθηκεύτηκαν';
$hesklang['dele']='Διαγραφή αυτού του αιτήματος';
$hesklang['repd']='Η ανάρτηση διαγράφηκε';
$hesklang['repl']='Η επιλεγμένη ανάρτηση έχει διαγραφεί';
$hesklang['tickets_found']='Αποτελέσματα αναζήτησης';
$hesklang['al']='Admin link';
$hesklang['ap']='Προώθηση στον Πίνακα Διαχείρισης';
$hesklang['dap']='Προβολή ενός συνδέσμου στον πίνακα διαχείρισης από <a href="../" target="_blank">help desk index</a>';
$hesklang['q_miss']='Παρακαλώ απαντήστε στην ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['use_q']='Χρήση ερώτησης ασφαλείας (anti-SPAM)';
$hesklang['q_q']='-&gt; Ερώτηση (HTML code is <font class="success">επιτρέπεται</font>)';
$hesklang['q_a']='-&gt; Απάντηση';
$hesklang['err_qask']='Εισάγετε μια ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['err_qans']='Εισάγετε απάντηση για την ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['genq']='Δημιουργήστε μια τυχαία ερώτηση';

// Added in version 2.1
$hesklang['amo']='Προσθήκη περισσοτέρων';
$hesklang['delatt']='Διαγραφή επιλεγμένου συνημμένου;';
$hesklang['kb_att_rem']='Tο επιλεγμένο συνημμένο έχει διαγραφεί';
$hesklang['inv_att_id']='Ακυρο ID συνημμένου!';
$hesklang['scb']='Checkbox';
$hesklang['opt4']='Options for this checkbox, enter one option per line. Each line will be a choice your customers can choose from, multiple choices are possible. You need to enter at least two options!';
$hesklang['autologin']='Σύνδεση αυτόματα με κάθε επίσκεψή μου';
$hesklang['just_user']='Θυμήσου μόνο το όνομα χρήστη μου';
$hesklang['nothx']='Όχι, ευχαριστώ';
$hesklang['pinfo']='Πληροφορίες προφίλ';
$hesklang['sig']='Υπογραφή';
$hesklang['pref']='Προτιμήσεις';
$hesklang['aftrep']='Μετά την απάντηση σ ένα αίτημα';
$hesklang['showtic']='Δείξε το αίτημα που μόλις απάντησα';
$hesklang['gomain']='Επιστροφή στην κεντρική σελίδα διαχείρισης';
$hesklang['shownext']='Ανοιξε το επόμενο αίτημα που χρειάζεται να απαντήσω (αν δεν υπάρχει πάνε στην σελίδα διαχείρισης)';
$hesklang['rssn']='Εμφάνιση επόμενου αιτήματος που χρειάζεται την προσοχή σας';
$hesklang['mrep']='Αντικατάσταση υπάρχοντος μηνύματος';
$hesklang['madd']='Προσθήκη στο τέλος';
$hesklang['priv']='Ιδιωτικές κατηγορίες και άρθρα που εμφανίζονται μόνο στο προσωπικό είναι σημειωμένα με *';
$hesklang['inve']='Ακυρο αρχείο email';
$hesklang['emfm']='Λείπει το αρχείο email';
$hesklang['hesk_lang']='Προεπιλεγμένη γλώσσα';
$hesklang['s_mlang']='Πολλαπλές γλώσσες';
$hesklang['s_mlange']='Ενεργοποιήστε εφόσον παρέχετε υποστήριξη σε όλες τις εγκατεστημένες γλώσσες!';
$hesklang['s_inl']='Δοκιμή φακέλου που περιέχει τις γλώσσες';
$hesklang['s_inle']='Δοκιμές στο φάκελο της γλώσσας για την έγκυρη γλώσσα. Μόνο γλώσσες που έχουν περάσει όλες τις δοκιμές εγκαθίστανται σωστά.';
$hesklang['ta']='Δοκιμή ξανά';
$hesklang['alo']='Επιτρέπεται αυτόματη σύνδεση';
$hesklang['chol']='Προτιμώμενη γλώσσα';
$hesklang['mmdl']='Κάνε αυτή την προτιμώμενη γλώσσα';
$hesklang['warn']='ΠΡΟΣΟΧΗ';
$hesklang['dmod']='Debug mode is enabled. Make sure you disable debug mode in settings once HESK is installed and working properly.';
$hesklang['kb_spar']='Category can\'t be it\'s own parent category!';
$hesklang['mysql_root']='Your MySQL password is empty, are you sure you want to login with root user? This is a significant security risk!';
$hesklang['chg']='Αλλαγή';
$hesklang['chpri']='Η προτεραιότητα άλλαξε';
$hesklang['chpri2']='Η προτεραιότητα του αιτήματος έχει αλλάξει σε %s';
$hesklang['selcan']='Διαλέξτε την έτοιμη απάντηση που θέλετε να επεξεργαστείτε';
$hesklang['q_wrng']='Λάθος απάντηση ασφαλείας (anti-SPAM)';
$hesklang['cndupl']='Έχετε ήδη κατηγορία με αυτό τ όνομα. Διαλέξτε ένα μοναδικό όνομα για κάθε κατηγορία.';
$hesklang['wsel']='Επιλέξτε το πεδίο βάση του οποίου θέλετε να αναζητήσετε';

// Added in version 2.2
$hesklang['eto']='΄Μη έγκυρο αίτημα';
$hesklang['id']='ID';
$hesklang['geco']='Generate Direct Link';
$hesklang['genl']='Direct Category Link';
$hesklang['genl2']='Χρησιμοποιήστε αυτή τη σύνδεση για προεπιλέξετε κατηγορία στην φόρμα &quot;Υποβολής Αιτήματος&quot;.';
$hesklang['ask']='Αναζήτηση βοήθειας:';
$hesklang['exa']='Παραδείγματα';
$hesklang['small']='Small Box';
$hesklang['large']='Large Box';
$hesklang['cpri']='Προτεραιότητα πελάτη';
$hesklang['owner']='Υπεύθυνος';
$hesklang['unas']='Μη ανατεθειμένο';
$hesklang['assi']='Ανάθεση';
$hesklang['asst']='Ανάθεση σε';
$hesklang['asst2']='Ανάθεση του αιτήματος σε';
$hesklang['asss']='Ανάθεση σε μένα';
$hesklang['asss2']='Ανάθεση του αιτήματος σε μένα';
$hesklang['can_assign_self']='Μπορεί να αναθέτει αιτήματα σε μένα';
$hesklang['can_assign_others']='Μπορεί να αναθέτει αιτήματα σε άλλους';
$hesklang['can_run_reports']='Μπορεί να τρέξει εκθέσεις (δική σας)';
$hesklang['can_view_ass_others']='Μπορεί να βλέπει αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['unoa']='Ο επιλεγμένος χρήστης δεν έχει πρόσβαση σ αυτήν την κατηγορία';
$hesklang['tasi']='Υπεύθυνος ανατέθηκε';
$hesklang['tasy']='Αυτό το αίτημα ανατέθηκε σε σένα';
$hesklang['taso']='Αυτό το αίτημα ανατέθηκε στον επιλεγμένο χρήστη';
$hesklang['tasy2']='Ανατεθειμένα σε μένα';
$hesklang['taso2']='Ανατεθειμένα στο υπόλοιπο προσωπικό';
$hesklang['nose']='Επιλέξτε τον νέο υπεύθυνο';
$hesklang['onasc']='Αυτός ο υπεύθυνος δεν έχει πρόσβαση σ αυτήν την κατηγορία.';
$hesklang['tunasi']='Ticket Unassigned';
$hesklang['tunasi2']='Το αίτημα είναι χωρίς υπεύθυνο και έτοιμο να ανατεθεί ξανά';
$hesklang['note']='Σημείωση';
$hesklang['success']='Επιτυχία';
$hesklang['nyt']='Αυτό το αίτημα ανατέθηκε σε';
$hesklang['noch']='Δεν έχουν γίνει αλλαγές';
$hesklang['orch']='Η σειρά προβολής τροποποιήθηκε';
$hesklang['rfm']='Απαιτούμενες πληροφορίες λείπουν:';
$hesklang['repl0']='Ανεπαρκή δικαιώματα για την εκτέλεση αυτής της εργασίας';
$hesklang['repl1']='Αυτή η ανάρτηση δεν υπάρχει';
$hesklang['reports']='Αναφορές';
$hesklang['reports_intro']='The reports section lets you run several reports and see ticket statistics in a chosen date range.';
$hesklang['refi']='Καθαρισμός φόρμας';
$hesklang['dich']='Απόρριψη Αλλαγών';
$hesklang['dire']='Προβολή Αναφοράς';
$hesklang['m1']='Ιανουάριος';
$hesklang['m2']='Φεβρουάριος';
$hesklang['m3']='Μάρτιος';
$hesklang['m4']='Απρίλιος';
$hesklang['m5']='Μάιος';
$hesklang['m6']='Ιούνιος';
$hesklang['m7']='Ιούλιος';
$hesklang['m8']='Αύγουστος';
$hesklang['m9']='Σεπτέμβριους';
$hesklang['m10']='Οκτώβριος';
$hesklang['m11']='Νοέμβριος';
$hesklang['m12']='Δεκέμβριος';
$hesklang['d1']='Δευτέρα';
$hesklang['d2']='Τρίτη';
$hesklang['d3']='Τετάρτη';
$hesklang['d4']='Πέμπτη';
$hesklang['d5']='Παρασκευή';
$hesklang['d6']='Σάββατο';
$hesklang['d0']='Κυριακή';
$hesklang['mo']='Δε';
$hesklang['tu']='Τρ';
$hesklang['we']='Τε';
$hesklang['th']='Πε';
$hesklang['fr']='Πα';
$hesklang['sa']='Σα';
$hesklang['su']='Κυ';
$hesklang['from']='Από';
$hesklang['cinv']='Μη αποδεκτή ημερομηνία';
$hesklang['cinv2']='Αποδεκτή ημερομηνία είναι μμ/ηη/εεεε';
$hesklang['cinm']='Ακυρη τιμή μήνα';
$hesklang['cinm2']='Allowed range is';
$hesklang['cind']='Ακυρη τιμή ημέρας του μήνα';
$hesklang['cind2']='Allowed range for selected month is';
$hesklang['month']='Μήνας';
$hesklang['ocal']='Ανοιγμα Ημερολογίου';
$hesklang['ca01']='Προηγούμενο Έτος';
$hesklang['ca02']='Προηγούμενος Μήνας';
$hesklang['ca03']='Επόμενος Μήνας';
$hesklang['ca04']='Επόμενο Έτος';
$hesklang['ca05']='Κλείσιμο Ημερολογίου';
$hesklang['cdr']='Choose date range:';
$hesklang['crt']='Αναφορά τύπου';
$hesklang['r1']='Σήμερα';
$hesklang['r2']='Χθες';
$hesklang['r3']='Τρέχον μήνα';
$hesklang['r4']='Προηγούμενο μήνα';
$hesklang['r5']='Τελευταίες 30 ημέρες';
$hesklang['r6']='Τρέχουσα εβδομάδα (Δευ-Κυρ)';
$hesklang['r7']='Προηγούμενη εβδομάδα (Δευ-Κυρ)';
$hesklang['r8']='Τρέχουσα εργάσιμη εβδομάδα (Δευ-Παρ)';
$hesklang['r9']='Προηγούμενη εργάσιμη εβδομάδα (Δευ-Παρ)';
$hesklang['r10']='Τρέχον έτος';
$hesklang['r11']='Προηγούμενο έτος';
$hesklang['r12']='Όλα';
$hesklang['datetofrom']='&quot;Date From&quot; cannot be higher than &quot;Date to&quot;. The dates have been switched.';
$hesklang['t1']='Αιτήματα ανά ημέρα';
$hesklang['t2']='Αιτήματα ανά μήνα';
$hesklang['t3']='Αιτήματα ανά χρήστη';
$hesklang['t4']='Αιτήματα ανά κατηγορία';
$hesklang['ticass']='Ανατεθειμένα αιτήματα';
$hesklang['ticall']='Απαντήσεις σε αιτήματα';
$hesklang['totals']='Σύνολα';
$hesklang['all']='Όλα';
$hesklang['atik']='Νέα αιτήματα';
$hesklang['kbca']='Εχετε ήδη μια κατηγορία βάσης γνώσεων με αυτό το όνομα.';
$hesklang['menu_msg']='Μήνυμα';
$hesklang['menu_can']='Τυποποιημένα μηνύματα';
$hesklang['m_from']='Από:'; // Mail "from" address
$hesklang['m_to']='Προς:'; // Mail "to" address
$hesklang['m_sub']='Θέμα:'; // Mail subject
$hesklang['m_re']='Από:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Πρθ:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Ιδιωτικά μηνύματα';
$hesklang['m_intro']='Χρησιμοποιήστε τα ιδιωτικά μηνύματα για να στέλνετε γρήγορα μηνύματα στα υπόλοιπα μέλη του προσωπικού μέσα από εδώ.';
$hesklang['e_udel']='(Ο χρήστης διαγράφηκε)';
$hesklang['new_mail']='Νέο ιδιωτικό μήνυμα';
$hesklang['m_send']='Αποστολή μηνύματος';
$hesklang['m_rec']='Επιλέξτε τον παραλήπτη του μηνύματος';
$hesklang['m_inr']='Ακυρος παραλήπτης μηνύματος';
$hesklang['m_esu']='Εισάγετε το θέμα του ιδιωτικού μηνύματος';
$hesklang['m_pms']='Το ιδιωτικό σας μήνυμα έχει σταλθεί';
$hesklang['inbox']='ΕΙΣΕΡΧΟΜΕΝΑ';
$hesklang['outbox']='ΕΞΕΡΧΟΜΕΝΑ';
$hesklang['m_new']='ΝΕΟ ΜΗΝΥΜΑ';
$hesklang['pg']='Προβολή σελίδας';
$hesklang['npm']='Δεν υπάρχουν ιδιωτικά μηνύματα σ αυτόν τον φάκελο.';
$hesklang['m_ena']='Δεν έχετε δικαίωμα να διαβάσετε αυτό το μήνυμα.';
$hesklang['mau']='Σημείωση ως αδιάβαστο';
$hesklang['mo1']='Σημείωση επιλεγμένων μηνυμάτων ως αναγνωσμένα';
$hesklang['mo2']='Σημείωσε επιλεγμένω μηνυμάτων ως αδιάβαστα';
$hesklang['mo3']='Διαγραφή επιλεγμένων μηνυμάτων';
$hesklang['delm']='Διαγραφή του μηνύματος';
$hesklang['e_tid']='Σφάλμα δημιουργίας μοναδικού ID, παρακαλώ δοκιμάστε να υποβάλλετε την φόρμα ξανά αργότερα.';
$hesklang['smmr']='Τα επιλεγμένα μηνύματα έχουν σημειωθεί ως αναγνωσμένα';
$hesklang['smmu']='Τα επιλεγμένα μηνύματα έχουν σημειωθεί ως αδιάβαστα';
$hesklang['smdl']='Τα επιλεγμένα μηνύματα έχουν διαγραφεί';
$hesklang['show']='Προβολή';
$hesklang['s_my']='Ανατεθειμένα σε μένα';
$hesklang['s_ot']='Ανατεθειμένα σε άλλους';
$hesklang['s_un']='Μη ανατεθειμένα αιτήματα';
$hesklang['s_for']='Αναζήτηση για';
$hesklang['s_in']='Αναζήτηση σε';
$hesklang['s_incl']='Αναζήτηση μέσα';
$hesklang['find_ticket_by']='Αναζήτηση αιτημάτων';
$hesklang['e_nose']='Δεν επιλέχθηκε κατάσταση ανάθεσης, προβολή όλων των αιτημάτων.';
$hesklang['fsq']='Εισάγετε το ερώτημα αναζήτησης';
$hesklang['topen']='Open';
$hesklang['nms']='Δεν έχουν επιλεχθεί μηνύματα, δεν έχει γίνει καμία αλλαγή';
$hesklang['tlo']='Κλείδωμα αιτήματος';
$hesklang['tul']='Ξεκλείδωμα αιτήματος';
$hesklang['loc']='Κλειδωμένο';
$hesklang['isloc']='Οι πελάτες δεν μπορούν να απαντήσουν ή να ξαναανοίξουν κλειδωμένα αιτήματα. Όταν κλειδώνεται ένα αίτημα σημειώνεται ως επιλυμένο.';
$hesklang['tlock']='Το αίτημα έχει κλειδωθεί';
$hesklang['tunlock']='Το αίτημα έχει ξεκλειδωθεί';
$hesklang['tislock']='Το αίτημα έχει κλειδωθεί, ο πελάτης δεν θα μπορεί να απαντήσει.';
$hesklang['tislock2']='Το αίτημα έχει κλειδωθεί, δεν μπορείτε να απαντήσετε.';
$hesklang['nsfo']='Δεν βρέθηκα σχετικά άρθρα.';
$hesklang['thist1']='<li class="smaller">%s | moved to category %s by %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | assigned to %s by %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | closed by %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | opened by %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | locked by %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | unlocked by %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ticket created by %s</li>'; // %s = date, user making change
$hesklang['elocked']='Αυτό το αίτημα κλειδώθηκε ή διαγράφηκε.';
$hesklang['nti2']='Εισαγωγή νέου αιτήματος';
$hesklang['nti3']='Χρησιμοποίηστε αυτή την φόρμα για να δημιουργήσετε ένα νεο άιτημα στο όνομα ενός πελάτη. Εισάγετε τις πληροφορίες του πελάτη στη φόρμα (όνομα πελάτη, email κ.α.) και όχι το όνομά σας! Το αίτημα θα δημιουργηθεί σαν να το υπόβαλε ο πελάτης.';
$hesklang['addop']='Επιλογές';
$hesklang['seno']='Στείλε email ειδοποίηση στον πελάτη';
$hesklang['otas']='Δείξε το αίτημα μετά την υποβολή';
$hesklang['notn']='Ειδοποιήσεις';
$hesklang['nomw']='Το Help desk θα στείλει email ειδοποιήσεις όταν:';
$hesklang['nwts']='Ένα νέο αίτημα υποβλήθηκε με υπεύθυνο:';
$hesklang['ncrt']='Ο πελάτης ανταποκρίθηκε στο αίτημα με υπεύθυνο:';
$hesklang['ntam']='Ένα αίτημα ανατέθηκε σε μένα';
$hesklang['npms']='Ένα ιδιωτικό μήνυμα στάλθηκε σε μένα';
$hesklang['support_remove']='A lot of time and effort went into developing HESK. Support HESK, buy a license that will also remove the credits links <i>Powered by Help Desk Software HESK</i> from your helpdesk';
$hesklang['ycvtao']='Δεν επιτρέπεται να δείτε αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['password_not_valid']='Ο κωδικός πρόσβασης πρέπει να έχει τουλάχιστον 5 χαρακτήρες';
$hesklang['lkbs']='Φόρτωση προτάσεων γνωσιακής βάσης...';
$hesklang['auto']='(αυτόματα)';

// Added in version 2.3
$hesklang['unknown']='Αγνωστο';
$hesklang['pcer']='Παρακαλώ διορθώστε τα παρακάτω λάθη:';
$hesklang['seqid']='Αριθμός αιτήματος';
$hesklang['close_action']='Σημείωση ως επιλυμένο'; // Close ACTION
$hesklang['archived']='Αρχειοθετημένο';
$hesklang['archived2']='Αρχειοθετημένο αίτημα';
$hesklang['add_archive']='Αρχειοθετήστε αυτό το αίτημα';
$hesklang['add_archive_quick']='Αρχειοθετήστε τα επιλεγμένα αιτήματα';
$hesklang['remove_archive']='Απο-αρχειοθετήστε αυτό το αίτημα';
$hesklang['remove_archive_quick']='Απο-αρχειοθετήστε τα επιλεγμένα αιτήματα';
$hesklang['added_archive']='Το αίτημα αρχειοθετήθηκε';
$hesklang['removed_archive']='Το αίτημα απο-αρχειοθετήθηκε';
$hesklang['added2archive']='Το αίτημα έχει αρχειοθετηθεί';
$hesklang['removedfromarchive']='Το αίτημα έχειο απο-αρχειοθετηθεί';
$hesklang['num_tickets_tag']='<b>%d</b> αιτήματα έχουν αρχειοθετηθεί';
$hesklang['num_tickets_untag']='<b>%d</b> αιτήματα έχουν απο-αρχειοθετηθεί';
$hesklang['can_add_archive']='Μπορείτε να προσθέσετε ετικέτα (tag) στα αιτήματα';
$hesklang['disp_only_archived']='Μόνο τα αιτήματα με ετικέτες (αρχειοθετημένα)';
$hesklang['search_only_archived']='Μόνο τα αιτήματα με ετικέτες (αρχειοθετημένα)';
$hesklang['critical']=' * Κρίσιμο * ';
$hesklang['thist8']='<li class="smaller">%s | priority changed to %s by %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status changed to %s by %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automatically assigned to %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | submitted by email piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='ετ';
$hesklang['abbr']['month']='μη';
$hesklang['abbr']['week']='εβδ';
$hesklang['abbr']['day']='ημ';
$hesklang['abbr']['hour']='ω';
$hesklang['abbr']['minute']='λ';
$hesklang['abbr']['second']='δ';
// END abberviations
$hesklang['cnsm']='Δεν μπορώ να στείλω μήνυμα σε:';
$hesklang['yhbb']='Έχετε κλειδωθεί από το σύστημα για %s λεπτά γιατί έχετε πολλές αποτυχημένες προσπάθειες εισόδου.';
$hesklang['pwdst']='Ισχύς κωδικού πρόσβασης';
$hesklang['tid_mail']='Μην ανησυχείτε! Εισάγετε την <b>Email διεύθυνσή</b> σας και θα σας στείλουμε το ID παρακολούθησης αμέσως:';
$hesklang['rem_email']='Να θυμάσαι την email διεύθυνσή μου';
$hesklang['eytid']='Εισάγετε το ID παρακολούθησης του αιτήματος';
$hesklang['enmdb']='Το email που εισάγατε δεν αντιστοιχεί με αυτό στην βάση δεδομένων για το συγκεκριμένο ID παρακολούθησης.';
$hesklang['confemail']='Επιβεβαίωση Email';
$hesklang['confemail2']='Παρακαλώ επιβεβεβαιώστε το Email σας';
$hesklang['confemaile']='Τα δύο emails δεν είναι ίδια';
$hesklang['taso3']='Ανατέθηκε σε:';
$hesklang['sec_enter']='Πληκτρολογήστε τον αριθμό που βλέπετε στην παρακάτω εικόνα.';
$hesklang['reload']='Επαναφόρτωση εικόνας';
$hesklang['verify_q']='Πρόληψη SPAM:'; // For anti-spam question
$hesklang['verify_i']='Πρόληψη SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Σύνδεση Προσωπικού';
$hesklang['vrfy']='Η δοκιμή πέτυχε';
$hesklang['last_update']='Ενημερώθηκε';
$hesklang['cot']='Να μην τοποθετούνται τα κρίσιμα δελτία στην κορυφή';
$hesklang['def']='Κάνε αυτή την προβολή εξ\' ορισμού';
$hesklang['gbou']='Αυτά τα αιτήματα δεν είναι <b>Ανατεθειμένα</b>:';
$hesklang['gbom']='Τα αιτήματα ανατέθηκαν σε <b>μένα</b>:';
$hesklang['gboo']='Τα αιτήματα ανατέθηκαν σε <b>%s</b>:';
$hesklang['select']=' - - Κλικ για επιλογή - - ';
$hesklang['chngstatus']='Αλλαγή κατάστασης σε';
$hesklang['perat']='%s απ όλα τα αιτήματα'; // Will change to "23% of all tickets"
$hesklang['viewart']='Προβολή του άρθρου';
$hesklang['chdp']='Παρακαλώ αλλάξτε τον προεπιλεγμένο κωδικό πρόσβασης στην σελίδα του <a href="profile.php">Προφίλ</a> σας!';
$hesklang['chdp2']='Αλλάξτε τον κωδικό πρόσβασης, χρησιμοποιείτε τον προεπιλεγμένο!';
$hesklang['security']='Ασφάλεια';
$hesklang['kb_i_art']='Νέο άρθρο';
$hesklang['kb_i_art2']='Εισάγετε ένα άρθρο';
$hesklang['kb_i_cat']='Νέα κατηγορία';
$hesklang['kb_i_cat2']='Εισάγετε μια κατηγορία';
$hesklang['gopr']='Προβολή Βάσης Γνώσεων';
$hesklang['kbstruct']='Δομή Βάσης Γνώσεων';
$hesklang['cancel']='Ακυρο';
$hesklang['sh']='Κρύψε το μήνυμα';
$hesklang['goodkb']='Πως να γράψετε σωστά άρθρα για την βάση γνώσεων';
$hesklang['catset']='Ρυθμίσεις Κατηγορίας';
$hesklang['inpr']='Επιλέξτε νέα προτεραιότητα';
$hesklang['incat']='Επιλέξτε τη νέα κατηγορία';
$hesklang['instat']='Επιλέξτε νέα κατάσταση';
$hesklang['tsst']='Η κατάσταση του αιτήματος ορίστηκε σε %s';
$hesklang['aass']='Αυτόματη ανάθεση';
$hesklang['aaon']='Αυτόματη ανάθεση των αιτημάτων ενεργοποιημένη (κλικ για απενεργοποίηση)';
$hesklang['aaoff']='Αυτόματη ανάθεση των αιτημάτων απενεργοποιημένη (κλικ για ενεργοποίηση)';
$hesklang['uaaon']='Η αυτόματη ανάθεση έχει ενεργοποιηθεί για τον επιλεγμένο χρήστη';
$hesklang['uaaoff']='Auto-assign has been disabled for selected user';
$hesklang['taasy']='Αυτό το αίτημα έχει ανατεθεί αυτόματα σε σένα';
$hesklang['can_view_unassigned']='Μπορεί να βλέπει μη ανατεθειμένα αιτήματα';
$hesklang['ycovtay']='Μπορείτε να βλέπετε μόνο αιτήματα που είναι ανατεθειμένα σε εσάς';
$hesklang['in_progress']='Σε Πρόοδο';
$hesklang['on_hold']='Σε Αναμονή';
$hesklang['import_kb']='Εισαγωγή αυτού του αιτήματος σε άρθρο της Βάσης Γνώσεων';
$hesklang['import']='Εισάγετε ένα <i>ιδιωτικό αίτημα</i> μέσα σε ένα <i>δημόσιο άρθρο</i>.<br /><br />Σιγουρευτείτε να διαγράψετε οποιαδήποτε ιδιωτική ή ευαίσθητη πληροφορία από το θέμα του άρθρου ή από το μήνυμα!';
$hesklang['tab_1']='Γενικά';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Βάση Γνώσεων';
$hesklang['tab_4']='Προσαρμοσμένα πεδία';
$hesklang['tab_5']='Διάφορα';
$hesklang['disable']='Ανενεργό';
$hesklang['dat']='Ημερομηνία &amp; Ώρα';
$hesklang['lgs']='Γλώσσα';
$hesklang['onc']='ON - Πελάτες';
$hesklang['ons']='ON - Όλοι';
$hesklang['viewvtic']='Προβολή αιτημάτων';
$hesklang['reqetv']='Απαιτείται email για προβολή αιτήματος';
$hesklang['banlim']='Όριο προσπαθειών σύνδεσης (login)';
$hesklang['banmin']='Ban time (minutes)';
$hesklang['subnot']='Υποβολή σημείωσης';
$hesklang['subnot2']='Προβολή σημείωσης σε πελάτες που υποβάλλουν αιτήματα';
$hesklang['eseqid']='Διαδοχικά IDs';
$hesklang['sconfe']='Επιβεβαίωση email';
$hesklang['saass']='Αυτόματη ανάθεση αιτημάτων';
$hesklang['swyse']='WYSIWYG Επεξεργαστής';
$hesklang['hrts']='Αξιολογήστε το HESK';
$hesklang['hrts2']='Show Rate this script link in admin panel';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Send emails using';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Username';
$hesklang['smtpw']='SMTP Password';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Άλλα';
$hesklang['features']='Χαρακτηριστικά';
$hesklang['can_view_online']='Μπορεί να βλέπει τα online μέλη του προσωπικού';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Χρήστες Online'; // For display in footer
$hesklang['sonline']='Χρήστες Online'; // For settings page
$hesklang['sonline2']='Προβολή online χρηστών. Όριο (λεπτά):'; // For settings page
$hesklang['gb']='Ομαδοποίηση κατά';
$hesklang['dg']='Χωρίς ομαδοποίηση';
$hesklang['err_dpi']='Database %s does not contain all HESK tables with prefix %s, no changes saved.';
$hesklang['err_dpi2']='Tables not found:';
$hesklang['sme']='SMTP error';
$hesklang['scl']='SMTP connection log';
$hesklang['dnl']='Κατέβασμα';
$hesklang['dela']='Διαγράφη αυτού του συνημμένου';
$hesklang['pda']='Θέλετε να διαγράψετε μόνιμα αυτό το συνημμένο;';
$hesklang['thist12']='<li class="smaller">%s | attachment %s deleted by %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Περισσότερες επιλογές';
$hesklang['lopt']='Λιγότερες επιλογές';
$hesklang['meml']='Πολλαπλά Emails';
$hesklang['meml2']='Επιτρέπεται στους πελάτες να εισάγουν πολλαπλά emails.';

// Added in version 2.4
$hesklang['catd']='(Η κατηγορία διαγράφηκε)';
$hesklang['noopen']='Δεν έχουν βρεθεί ανοικτά αιτήματα για αυτή τη διεύθυνση email.';
$hesklang['maxopen']='Έχετε φτάσει στον μέγιστο αριθμό ανοικτών αιτημάτων  (%d of %d). Παρακαλούμε περιμένετε μέχρι τα τρέχοντα αιτήματά σας επιληθούν πριν ανοίξετε νέα αιτήματα.';
$hesklang['ntnote']='Κάποιος πρόσθεσε μία σημείωση σε ένα αίτημα που έχει ανατεθεί σε μένα.';
$hesklang['cat_public']='Αυτή η κατηγορία είναι ΔΗΜΟΣΙΑ (πατήστε εδώ για να την κάνετε ιδιωτική)';
$hesklang['cat_private']='Αυτή η κατηγορία είναι ΙΔΙΩΤΙΚΗ (πατήστε εδώ για να την κάνετε δημόσια)';
$hesklang['cat_aa']='Αυτόματη ανάθεση  αιτημάτων σ\' αυτή την κατηγορία.';
$hesklang['cat_type']='Κάντε αυτή την κατηγορία ιδιωτική (μόνο το προσωπικό μπορεί να την επιλέξει).';
$hesklang['caaon']='Η αυτόματη ανάθεση έχει ενεργοποιηθεί για την επιλεγμένη κατηγορία';
$hesklang['caaoff']='Η αυτόματη ανάθεση έχει απενεργοποιηθεί για την επιλεγμένη κατηγορία';
$hesklang['cpub']='Ο τύπος της κατηγορίας έχει αλλαχθεί σε ΔΗΜΟΣΙΑ';
$hesklang['cpriv']='Ο τύπος της κατηγορίας έχει αλλαχθεί σε ΙΔΙΩΤΙΚΗ';
$hesklang['cpric']='Οι πελάτες δεν μπορούν να επιλέξουν ιδιωτικές κατηγορίες, μόνο το προσωπικό μπορεί!';
$hesklang['user_aa']='Αυτόματη ανάθεση αιτημάτων σ\' αυτόν τον χρήστη.';
$hesklang['attach_size']='Μέγιστο μέγεθος αρχείου';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL Protocol';
$hesklang['smtptls']='TLS Protocol';
$hesklang['oo']='Μόνο ανοικτά';
$hesklang['ool']='Εμφάνισε μόνο ανοικτά αιτήματα σε &quot;Forgot tracking ID&quot; email';
$hesklang['mop']='Μέγιστος αριθμός ανοικτών αιτημάτων';
$hesklang['rord']='Σειρά απάντησης';
$hesklang['newbot']='Η πιο πρόσφατη απάντηση στο τέλος';
$hesklang['newtop']='Η πιο πρόσφατη απάντηση στην κορυφή';
$hesklang['ford']='Φόρμα απάντησης';
$hesklang['formbot']='Εμφάνιση της φόρμας στο κάτω μέρος';
$hesklang['formtop']='Εμφάνιση της φόρμας στην κορυφή';
$hesklang['mysqlv']='MySQL version';
$hesklang['phpv']='PHP version';
$hesklang['csrt']='Τρέχουσα ώρα HESK:';
$hesklang['listp']='Λίστα ιδιωτικών άρθρων';
$hesklang['listd']='Λίστα ημιτελών άρθρων';
$hesklang['artp']='Ιδιωτικά άρθρα';
$hesklang['artd']='Ημιτελή άρθρα';
$hesklang['kb_no_part']='Δεν υπάρχουν ιδιωτικά άρθρα στη γνωσιακή βάση.';
$hesklang['kb_no_dart']='Δεν υπάρχουν ημιτελή άρθρα στη γνωσιακή βάση.';
$hesklang['attpri']='Δεν έχετε πρόσβαση σ\' αυτή την επισύναψη.';
$hesklang['can_merge_tickets']='Συγχώνευση αιτημάτων';
$hesklang['mer_selected']='Συγχώνευση επιλεγμένων αιτημάτων';
$hesklang['merged']='Τα επιλεγμένα αιτήματα έχουν συγχωνευθεί σε ένα.';
$hesklang['merge_err']='Υπήρξε ένα πρόβλημα κατά την συγκώνευση των δελτίων:';
$hesklang['merr1']='επιλέξτε δύο τουλάχιστον αιτήματα.';
$hesklang['merr2']='Το τελικό αίτημα δεν βρέθηκε.';
$hesklang['merr3']='αίτημα σε μια κατηγορία που δεν έχετε πρόσβαση.';
$hesklang['tme']='Το αίτημα %s έχει συγχωνευθεί με αυτό το αίτημα(%s).';
$hesklang['tme1']='Το αίτημα %s έχει συγχωνευτεί με το αίτημα %s';
$hesklang['tme2']='Για να αποκτήσετε πρόσβαση στο αίτημα %s εισάγετε την αντιστοιχησμένη email διεύθυνση.';
$hesklang['eyou']='Χρησιμοποιήστε την σελίδα του προφίλ για να επεξεργαστείτε τις ρυθμίσεις σας.';
$hesklang['npea']='Δεν έχετε δικαίωμα να επεξεργαστείτε αυτό το χρήστη.';
$hesklang['duplicate_user']='Ο χρήστης μ\'αυτό το όνομα υπάρχει ήδη, επιλέξτε ένα διαφορετικό όνομα χρήστη.';
$hesklang['kw']='Λέξεις κλειδιά';
$hesklang['kw1']='(προαιρετικό - διαχωρίστε με κενό, κόμμα ή νέα γραμμή)';
$hesklang['type_not_allowed']='Τα αρχεία με κατάληξη <b>%s</b> δεν είναι αποδεκτά (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Ο πελάτης δεν έχει διαβάσει την απάντηση ακόμα.';
$hesklang['sticky']='Κάντε αυτό το άρθρο &quot;Sticky&quot;';
$hesklang['stickyon']='Αλλάξτε αυτό το άρθρο σε &quot;Sticky&quot;';
$hesklang['stickyoff']='Αλλάξτε το άρθρο σε &quot;Normal&quot;';
$hesklang['ason']='Το άρθρο έχει σημειωθεί ως &quot;Sticky&quot;';
$hesklang['asoff']='Το άρθρο έχει σημειωθεί ως &quot;Normal&quot;';
$hesklang['ts']='Χρόνος απασχόλησης';
$hesklang['start']='Start / Stop';
$hesklang['reset']='Επαναφορά';
$hesklang['save']='Αποθήκευση';
$hesklang['hh']='Ώρες';
$hesklang['mm']='Λεπτά';
$hesklang['ss']='Δευτερόλεπτα';
$hesklang['thist']='Ιστορικό αιτήματος';
$hesklang['thist13']='<li class="smaller">%s | merged with ticket %s by %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | time worked updated to %s by %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | submitted by %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | submitted by POP3 fetching</li>';
$hesklang['twu']='Ο χρόνος απασχόλησης στο αίτημα έχει ενημερωθεί.';
$hesklang['autoss']='Αυτόματα ξεκίνα το χρονομετρητή όταν ανοίγω το αίτημα';
$hesklang['ful']='Όρια μεταφόρτωσης αρχείου';
$hesklang['ufl']='Μπορείτε να μεταφορτώσετε αρχεία που έχουν κατάληξη σε:';
$hesklang['nat']='Μέγιστος αριθμός επισυνάψεων:';
$hesklang['mfs']='Μέγιστο μέγεθος ανά επισύναψη:';
$hesklang['lps']='Η προτίμηση γλώσσας έχει αποθηκευτεί';
$hesklang['sav']='Εμφάνιση προβολών άρθρου';
$hesklang['sad']='Εμφάνιση ημερομηνίας άρθρου';
$hesklang['emp']='Η PHP σας δεν έχει ενεργοποιημένη την υποστήριξη MySQL (απαιτείται επέκταση mysqli)';
$hesklang['epd']='[HESK] EMAIL PIPING IS DISABLED IN SETTINGS';
$hesklang['pfd']='[HESK] POP3 FETCHING IS DISABLED IN SETTINGS';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Πελάτης]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='POP3 Host';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='TLS Protocol';
$hesklang['pop3u']='POP3 Username';
$hesklang['pop3w']='POP3 Password';
$hesklang['pop3e']='POP3 error';
$hesklang['pop3log']='POP3 connection log';
$hesklang['mysqltest']='Test MySQL connection';
$hesklang['smtptest']='Test SMTP connection';
$hesklang['pop3test']='Test POP3 connection';
$hesklang['contest']='Testing connection, this can take a while...';
$hesklang['conok']='Connection successful!';
$hesklang['conokn']='Ωστόσο, αν ο εξυπηρετητής απαιτεί όνομα και κωδικό το email δεν θα σταλεί!';
$hesklang['saving']='Αποθήκευση ρυθμίσεων, παρακαλώ περιμένετε...';
$hesklang['sns']='Οι ρυθμίσεις αποθηκεύτηκαν, αλλά ορισμένες λειτουργίες έχουν απενεργοποιηθεί λόγω αποτυχημένων δοκιμών.';
$hesklang['looph']='Max Hits';
$hesklang['loopt']='Timeframe';
$hesklang['didum']='Εννοείτε %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ναι, φτιάξτε το';
$hesklang['nole']='Όχι αφήστε το';
$hesklang['sconfe2']='Προβάλετε ένα &quot;Επιβεβαίωση email&quot; πεδίο σε μία φόρμα υποβολλής αιτήματος';
$hesklang['oln']='Παλιό όνομα:';
$hesklang['nen']='Νέο όνομα:';
$hesklang['use_form_below']='<i>Χρησιμοποιήστε την παρακάτω φόρμα για να υποβάλλετε ένα αίτημα υποστήριξης.</br>Τα υποχρεωτικά πεδία είναι σημειωμένα με</i>';
$hesklang['esf']='Δεν μπορώ να στείλω ειδοποιήσεις μέσω email.';
$hesklang['qrr']='(οι παραθέσεις της απάντησης έχουν αφαιρεθεί)';
$hesklang['remqr']='Αφαιρέστε τις παραθέσεις απάντησης';
$hesklang['remqr2']='Διαγράψτε τις παραθέσεις απάντησης από τα emails των πελατών';
$hesklang['suge']='Ανίχνευσε λάθη στις email διευθύνσεις';
$hesklang['epro']='Πάροχοι email';
$hesklang['email_noreply']='&quot;Από:&quot; email';
$hesklang['email_name']='&quot;Από:&quot; όνομα';
$hesklang['vscl']='Ρυθμίσεις ορίων εξυπηρετητή';
$hesklang['fnuscphp']='Η μεταφόρτωση το αρχείου απέτυχε, προσπαθήστε με μικρότερο μέγεθος ή χωρίς επισύναψη.';
$hesklang['redv']='επαναφορά εξ\' όρισμού προβολής';
$hesklang['fatte1']='Οι ρυθμίσεις επισυνάψεων &quot;Αριθμός ανά δημοσίευση&quot; είναι μεγαλύτερη απ\' αυτή που επιτρέπει ο εξυπηρετητής!';
$hesklang['fatte2']='Your maximum attachment file size is larger than what your server allows!';
$hesklang['fatte3']='Ο εξυπηρεητής δεν επιτρέπει μεγάλες δημοσιεύσεις, προσπαθήστε να μειώσετε τον αριθμό των επισυνάψεων ή το επιτρεπώμενο μέγεθος αρχείου!';
$hesklang['embed']='Ενσωματομένα αρχεία';
$hesklang['embed2']='Αποθηκεύστε τα ενσωματομένα αρχεία ως επισυνάψεις';
$hesklang['emrem']='(η εικόνα αφαιρέθηκε)';
$hesklang['hdemo']='(ΚΡΥΦΗ ΣΤΗΝ ΔΟΚΙΜΑΣΤΙΚΗ ΕΚΔΟΣΗ)';
$hesklang['ddemo']='Συγνώμη, αλλά αυτή η λειτουργία έχει απενεργοποιηθεί στην δοκιμαστική έκδοση!';
$hesklang['sdemo']='Η αποθήκευση των αλλαγών έχουν απενεργοποιηθεί στην δοκιμαστική έκδοση';
$hesklang['hud']='Το HESK είναι ενημερωμένο';
$hesklang['hnw']='Διαθέσιμη ενημέρωση';
$hesklang['getup']='Ενημερώστε το HESK';
$hesklang['updates']='Ενημερώσεις';
$hesklang['updates2']='Αυτόματος έλεγχος για ενημερώσεις.';

// Added in version 2.5.0
$hesklang['attdel']='Αυτό το αρχείο έχει διαγραφεί από το διακομιστή και δεν είναι πλέον διαθέσιμο για κατέβασμα';
$hesklang['dsen']='Αυτοματοποιημένο μήνυμα, μην απαντήσετε σε αυτό';
$hesklang['attrem']='* Ορισμένα συνημμένα αρχεία έχουν αφαιρεθεί *';
$hesklang['attnum']='Ανώτατος αριθμός που έφθασε: %s'; // %s will show attachment name
$hesklang['attsiz']='Το αρχείο είναι πολύ μεγάλο: %s'; // %s will show attachment name
$hesklang['atttyp']='Δεν επιτρέπεται ο τύπος: %s'; // %s will show attachment name
$hesklang['adf']='Φάκελος διαχειριστή';
$hesklang['atf']='Φάκελος συννημένων';
$hesklang['err_adf']='Ο επιλεγμένος φάκελος διαχειριστή (%s) δεν υπάρχει!'; // %s will show folder name
$hesklang['err_atf']='Ο επιλεγμένος φάκελος συννημένων (%s) δεν υπάρχει!'; // %s will show folder name
$hesklang['err_atr']='Ο επιλεγμένος φάκελος συννημένων (%s) δεν είναι εγγράψιμος!'; // %s will show folder name
$hesklang['fatt']='Τα αρχεία που συνδέονται με αυτό το μήνυμα:';
$hesklang['wrepo']='Παρακαλώ γράψτε μια απάντηση, μετά το εκ νέου άνοιγμα του εισιτήριο.';
$hesklang['ktool']='&raquo; Γνωσιακά εργαλεία';
$hesklang['uac']='Επιβεβαίωση και επικαιροποίηση μετρητή κατηγορίας άρθρου';
$hesklang['acv']='Το πλήθος του άρθρου έχει επαληθευτεί';
$hesklang['xyz']='αριθμός των δημόσιων, ιδιωτικών και των σχεδίων των άρθρων στην κατηγορία.';
$hesklang['reports_tab']='Εκτελέστε αναφορές'; // Tab title
$hesklang['can_run_reports_full']='Μπορεί να τρέξει εκθέσεις (όλων)';
$hesklang['can_export']='Μπορεί να εξάγει τα εισιτήρια βλαβών';
$hesklang['roo']='<i>(Στην έκθεση περιλαμβάνονται μόνο τα εισιτήρια που σας έχουν ανατεθεί)</i>';
$hesklang['shu']='Short links';
$hesklang['export']='Εξαγόμενα εισιτήρια βλαβών'; // Tab title
$hesklang['export_btn']='Εξαγόμενα εισιτήρια βλαβών'; // Button title
$hesklang['export_intro']='Αυτό το εργαλείο σας επιτρέπει να εξάγετε τα εισιτήρια βλαβών σε ένα υπολογιστικό φύλλο XML που μπορεί να ανοίξει στο Excel.';
$hesklang['stte']='Επιλέξτε τα εισιτήρια βλαβών για την εξαγωγή';
$hesklang['dtrg']='Εύρος ημερομηνιών';
$hesklang['sequentially']='διαδοχικά'; // Order tickets: Sequentially
$hesklang['ede']='Δεν είναι δυνατή η δημιουργία του καταλόγου των εξαγωγών, παρακαλούμε να δημιουργήσετε ένα φάκελο με το όνομα <b>του εξαγόμενου αρχείου </b> στον οποίο θα μπουν τα αρχεία σας και βεβαιωθείτε ότι είναι εγγράψιμος με την PHP (on Linux CHMOD it to 777 - rwxrwxrwx).';
$hesklang['eef']='Δεν είναι δυνατή η δημιουργία του εξαγόμενου αρχείου,  δεν επιτρέπετε να γράψετε μέσα στον κατάλογο των εξαγωγών.';
$hesklang['inite']='Προετοιμασία εξαγόμενων αρχείων';
$hesklang['gXML']='Δημιουργία XML file';
$hesklang['nrow']='Αριθμός εξαγόμενων γραμμών: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Συμπιεση αρχείων σε ένα αρχείο zip';
$hesklang['eZIP']='Σφάλμα κατά τη δημιουργία του αρχείου Zip';
$hesklang['fZIP']='Ολοκληρώθηκε η συμπίεση του αρχείου';
$hesklang['pmem']='Κορυφαία χρήση μνήμης: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; Πατήστε εδώ για να κατεβάσετε το εξαγόμενο αρχείο &laquo;';
$hesklang['n2ex']='Δεν βρέθηκαν εισιτήρια βλάβών που να ανταποκρίνονται στα κριτήρια, δεν εξάγετε τίποτα!';
$hesklang['sp']='SPAM πρόληψη '; // For settings page
$hesklang['sit']='-&gt; Τύπος Εικόνας';
$hesklang['sis']='Απλή εικόνα ';
$hesklang['rcpb']='Δημόσιο κλειδί';
$hesklang['rcpv']='Ιδιωτικό κλειδί';
$hesklang['pop3keep']='Κράτα ένα αντίγραφο ';
$hesklang['beta']='(Δοκιμαστική Έκδοση)';
$hesklang['maxpost']='Υποβάλλατε περισσότερα δεδομένα από όσα μπορεί να δεχθεί ο διακομιστής.<br /><br />Δοκιμάστε να υποβάλετε ξανά τη φόρμα με μικρότερα ή καθόλου συνημμένα.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Ανακριβής SPAM Απάντηση Πρόληψης, παρακαλώ προσπαθήστε ξανά.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Το δελτίο έκλεισε/απαντήθηκε';
$hesklang['ms01']='Ιαν';
$hesklang['ms02']='Φεβ';
$hesklang['ms03']='Μαρ';
$hesklang['ms04']='Απρ';
$hesklang['ms05']='Μάι';
$hesklang['ms06']='Ιον';
$hesklang['ms07']='Ιολ';
$hesklang['ms08']='Αυγ';
$hesklang['ms09']='Σεπ';
$hesklang['ms10']='Οκτ';
$hesklang['ms11']='Νοε';
$hesklang['ms12']='Δεκ';
$hesklang['sdf']='Μορφοποίηση ημερομηνίας υποβολής';
$hesklang['lcf']='Μορφοποίηση ημερομηνίας ενημέρωσης';
$hesklang['lcf0']='Σύντομη περιγραφή';
$hesklang['lcf1']='Ημερομηνία και ώρα';
$hesklang['lcf2']='HESK στιλ';
$hesklang['ticket_tpl']='Πρότυπα δελτίων';
$hesklang['can_man_ticket_tpl']='Διαχείριση προτύπων δελτίων'; // Permission title
$hesklang['ticket_tpl_man']='Διαχείριση προτύπων δελτίων'; // Page and link title
$hesklang['ticket_tpl_intro']='Δημιουργία και επεξεργασία προτύπων δελτίων τα οποία μπορείτε να χρησιμοποιείσετε για να εισάγετε γρήγορα νέα δελτία από τη σελίδα διαχείρισης.';
$hesklang['no_ticket_tpl']='Κανένα πρότυπο δελτίων';
$hesklang['ticket_tpl_title']='Τίτλος';
$hesklang['delete_tpl']='Είστε σίγουρος/η ότι θέλετε να διαγράψετε αυτό το πρότυπο;';
$hesklang['new_ticket_tpl']='Προσθήκη ή επεξεργασία ενός προτύπου δελτίου';
$hesklang['ticket_tpl_add']='Δημιουργία ένος νέου προτύπου δελτίου';
$hesklang['ticket_tpl_edit']='Επεξεργασία επιλεγμένου πρότυπου δελτίου';
$hesklang['save_ticket_tpl']='Αποθήκευση πρότυπου δελτίου';
$hesklang['ticket_tpl_saved']='Το πρότυπο δελτίο αποθηκεύτηκε για μελλοντική χρήση';
$hesklang['ticket_tpl_removed']='Το επιλεγμένο πρότυπο δελτίο έχει αφαιρεθεί από τη Βάση Δεδομένων';
$hesklang['ticket_tpl_not_found']='Το πρότυπο δελτίο δεν βρέθηκε';
$hesklang['sel_ticket_tpl']='Επιλέξτε το πρότυπο δελτίο που θέλετε να επεξεργαστείτε';
$hesklang['ent_ticket_tpl_title']='Παρακαλώ δώστε έναν τίτλο στο πρότυπο δελτίο';
$hesklang['ent_ticket_tpl_msg']='Παρακαλώ δώστε το μήνυμα του πρότυπου δελτίου';
$hesklang['ticket_tpl_id']='Λείπειτο ID του πρότυπου δελτίου';
$hesklang['select_ticket_tpl']='Επιλέξτε ένα πρότυπο δελτίο';
$hesklang['list_tickets_cat']='Λίστα όλων των αιτημάτων ανά κατηγορία';
$hesklang['def_msg']='[No message]';
$hesklang['emlreqmsg']='Απαιτεί μήνυμα';
$hesklang['emlreqmsg2']='Αγνόησε piped/fetched emails χωρίς μήνυμα';
$hesklang['relart']='Σχετικά άρθρα'; // Title of related articles box
$hesklang['s_relart']='Σχετικά άρθρα'; // On settings page
$hesklang['tab_7']='Λίστα αιτήματος';
$hesklang['fitl']='Πεδία στη λίστα αιτημάτων';
$hesklang['submitted']='Υποβλήθηκε';
$hesklang['clickemail']='Προβολή';
$hesklang['set_pri_to']='Όρισε προτεραιότητα σε:'; // Action below the ticket list
$hesklang['pri_set_to']='Η προτεραιότητα έχει οριστεί σε:';
$hesklang['cat_pri']='Η προτεραιότητα της κατηγορίας θα χρησιμοποιηθεί όταν δε επιτρέπεται στους πολίτες να επιλέξουν προτεραιότητα.';
$hesklang['cat_pri_info']='Οι πολίτες επιτρέπεται να επιλέξουν προτεραιότητα, οπότε η επιλογή προτεραιότητας θα αγνοηθεί.<br /><br />Για να χρησιμοποιήσετε την επιλογή προτεραιότητας, απενεργοποιήστε την επόμενη επιλογή στο HESK:';
$hesklang['def_pri']='Προτεραιότητα κατηγορίας:';
$hesklang['ch_cat_pri']='Ορίστε προτεραιότητα κατηγορίας';
$hesklang['cat_pri_ch']='Η προτεραιότητα κατηγορίας ορίστηκε σε:';
$hesklang['err_dbversion']='Πολύ παλία MySQL έκδοση:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Επεξεργασία μηνύματος σημείωσης';
$hesklang['ednote2']='Το μήνυμα της σημείωσης αποθηκεύτηκε';
$hesklang['perm_deny']='Απαγορεύεται η πρόσβαση';
$hesklang['mis_note']='Απουσιάζει το ID της σημείωσης';
$hesklang['no_note']='Η σημείωση με αυτό το ID απουσιάζει';
$hesklang['sacl']='Αποθηκεύστε και συνεχίστε αργότερα';
$hesklang['reply_saved']='Το μήνυμα της απάντησης έχει αποθηκευτεί για αργότερα.';
$hesklang['submit_as']='Υποβολή ως:';
$hesklang['sasc']='Υποβολή απάντησης ως πολίτης';
$hesklang['creb']='Η απάντηση του πολίτη υποβλήθηκε ως:';
$hesklang['show_select']='Εμφάνιση &quot;Κάνε κλικ για να επιλέξεις&quot; ως προεπιλεγμένη επιλογή';
// Settings
$hesklang['mms']='Λειτουργία συντήρησης';
$hesklang['mmd']='Να επιτρέπεται η λειτουργία σηντήρησης';
// Customer notice
$hesklang['mm1']='Συντήρηση σε εξέλιξη';
$hesklang['mm2']='Η υπηρεσία δεν λειτουργεί για λόγους συντήρησης.';
$hesklang['mm3']='Λυπούμαστε για την ενόχληση, παρακαλώ δοκιμάστε ξανά σε λίγο.';
// Staff notice
$hesklang['mma1']='Η λειτουργία συντήρησης είναι ενεργοποιημένη';
$hesklang['mma2']='Οι πολίτες δεν μπορούν να χρησιμοποιούν το help desk.';
$hesklang['tools']='Εργαλεία';
$hesklang['banemail']='Ban emails';
$hesklang['banemail_intro']='Απέτρεψε από συγκεκριμένες διευθύνσεις email από το να υποβάλλουν αιτήματα στο help desk.';
$hesklang['no_banemails']='<i>Κανένα email δεν έχει γίνει ban.</i>';
$hesklang['eperm']='Email που είναι μόνιμα ban:';
$hesklang['bananemail']='Διευθύνσεις email για ban';
$hesklang['savebanemail']='Κάνε ban αυτό το email';
$hesklang['enterbanemail']='Δώστε διεύθυνση email για ban.';
$hesklang['validbanemail']='Δώστε μια έγκυρη διεύθυνση email (<i>john.doe@example.com</i>) ή ένα domain (<i>@example.com</i>)';
$hesklang['email_banned']='Η διεύθυνση email address <i>%s</i> έχει γίνει ban και η εφαρμογή HESK δε θα δέχεται πλέο αιτήματα από αυτή τη διεύθυνση.'; // %s will be replaced with email
$hesklang['emailbanexists']='Η διεύθυνση email <i>%s</i> έχει γίνει ban.'; // %s will be replaced with email
$hesklang['email_unbanned']='Διαγράφηκε ο αποκλεισμός του Email';
$hesklang['banby']='Έγινε ban από';
$hesklang['delban']='Διεγράψτε το ban';
$hesklang['delban_confirm']='Να διαγραφεί το ban;';
$hesklang['baned_e']='Σας έχει απαγορευτεί να υποβάλλετε νέο αίτημα.';
$hesklang['baned_ip']='Έχετε γίνει ban από το help desk';
$hesklang['can_ban_emails']='Μπορεί να κάνει ban τα emails';
$hesklang['can_unban_emails']='Μπορεί να κάνει unban τα emails (Ενεργοποιεί το Μπορεί να κάνει ban τα emails)';
$hesklang['eisban']='Αυτή η διεύθυνση email έχει γίνει ban.';
$hesklang['click_unban']='Κλικ εδώ για να απορρίψετε το ban.';
$hesklang['banip']='Ban IPs';
$hesklang['banip_intro']='Επισκέπτες από διευθύνσης IP που είναι ban δεν μπορούν να βλέπουν ή να υποβάλλουν αιτήματα και να συνδέονται στο the help desk.';
$hesklang['ipperm']='Διευθύνσεις IP που είναι ban:';
$hesklang['iptemp']='Αποκλεισμός λόγω αποτυχία σύνδεσης:';
$hesklang['savebanip']='Κάνε ban αυτή την IP';
$hesklang['no_banips']='<i>Καμία IP δεν έχει γίνει ban.</i>';
$hesklang['bananip']='Διευθύνσεις IP για να γίνουν ban';
$hesklang['banex']='Παραδείγματα:';
$hesklang['iprange']='Εύρος IP';
$hesklang['ippermban']='Κάνε οριστικά ban αυτήν την IP';
$hesklang['enterbanip']='Δώστε εύρος ή ακριβής διεύθυνση IP που επιθυμείς να γίνει ban.';
$hesklang['validbanip']='Δώστε μια έγκυρη διεύθυνση ή ένα εύρος IP';
$hesklang['ip_banned']='Η διεύθυνση IP <i>%s</i> έχει γίνει ban και η εφαρμογή δε θα δέχεται αιτήματα από αυτή τη διεύθυνση IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Αυτό το εύρος διεύθυνσης IP <i>%s</i> έχει γίνει ban και η εφαρμογή δε θα δέχεται αιτήματα από αυτή τη διεύθυνση IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Αυτή η διεύθυνση IP <i>%s</i> έχει γίνει ban.'; // %s will be replaced with IP
$hesklang['iprbanexists']='Αυτό το εύρος IP <i>%s</i> έχει γίνει ban.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Η διεύθυνση IP με ban διαγράφηκε';
$hesklang['ip_tempun']='Προσωρινή διεύθυνση IP με ban διαγράφηκε';
$hesklang['can_ban_ips']='Μπορεί να κάνει ban τις ips';
$hesklang['can_unban_ips']='Μπορεί να καταργήσει το ban τις ips (Ενεργοποιεί το Μπορεί να κάνει ban τις ips)';
$hesklang['ipisban']='Αυτή η διεύθυνση IP έχει γίνει ban.';
$hesklang['m2e']='Λήγει σε (λεπτά)';
$hesklang['info']='Πληροφορίες';
$hesklang['sm_title']='Υπηρεσία μηνυμάτων';
$hesklang['sm_intro']='Εφαρμόστε μια υπηρεσία μηνυμάτων στην περιοχή των πολιτών, για παράδειγμα να τους ενημερώσετε για ζητήματα και για σημαντικές ειδήσεις.';
$hesklang['can_service_msg']='Επεξεργασία υπηρεσίας μηνυμάτων';
$hesklang['new_sm']='Νέα υπηρεσία μηνυμάτων';
$hesklang['edit_sm']='Επεξεργασία υπηρεσίας μηνυμάτων';
$hesklang['ex_sm']='Υπάρχοντες υπηρεσίες μηνυμάτων';
$hesklang['sm_author']='Συγγραφέας';
$hesklang['sm_type']='Τύπος';
$hesklang['sm_published']='Δημοσιεύθηκε';
$hesklang['sm_draft']='Προσχέδιο';
$hesklang['sm_style']='Στυλ';
$hesklang['sm_none']='Κανένα';
$hesklang['sm_success']='Επιτυχία';
$hesklang['sm_info']='Πληροφορία';
$hesklang['sm_notice']='Σημείωση';
$hesklang['sm_error']='Σφάλμα';
$hesklang['sm_save']='Αποθήκευση υπηρεσία μηνύματος';
$hesklang['sm_preview']='Προβολή υπηρεσίες μηνυμάτων';
$hesklang['sm_mtitle']='Τίτλος';
$hesklang['sm_msg']='Μήνυμα';
$hesklang['sm_e_title']='Εισαγωγή τίτλου υπηρεσίας μηνυμάτων';
$hesklang['sm_e_msg']='Εισαγωγή υπηρεσίας μηνύματος';
$hesklang['sm_e_id']='Απώλεια ID μηνύματος';
$hesklang['sm_added']='Μια νέα υπηρεσία μηνύματος έχει προστεθεί';
$hesklang['sm_deleted']='Η υπηρεσία μηνύματος διαγράφηκε';
$hesklang['sm_not_found']='Αυή η υπηρεσία μηνύματος δεν υπάρχει';
$hesklang['no_sm']='Καμία υπηρεσία μηνυμάτων';
$hesklang['del_sm']='Διαγραφή της υπηρεσίας μηνύματος;';
$hesklang['sm_mdf']='Η υπηρεσία μηνύματος έχει αποθηκευθεί';
$hesklang['sska']='Προβολή προτεινόμενων άρθρων';
$hesklang['taws']='Αυτά είναι τα προτεινόμενα άρθρα:';
$hesklang['defaults']='Προεπιλεγμάτα';
$hesklang['pncn']='Επιλέξτε επιλογές ενημέρωσης του πολίτη στη φόρμα νέου αιτήματος';
$hesklang['pncr']='Επιλέξτε επιλογές ενημέρωσης του πολίτη στη φόρμα απάντησης νέου αιτήματος';
$hesklang['pssy']='Προβολή βάσης δεδομέων άρθρων που προτείνονται στους πολίτες';
$hesklang['ccct']='Επίλυση πολίτη';
$hesklang['custnot']='Ενημέρωση πολιτών όταν';
$hesklang['notnew']='Έχει υποβληθεί ένα νέο αίτημα';
$hesklang['notclo']='Ένα αίτημα επιλέχθηκε ως Επιλημένο';
$hesklang['enn']='Περίληψη για αιτήματα μέσω email εάν περιέχεται θέμα στο email:';
$hesklang['spamn']='Ειδοποίηση SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Κανένα email επιβεβαίωσης;</b><br />Αποστέλλουμε ένα μήνυμα επιβεβαίωσης στη διεύθυνση email. Εάν δεν λάβετε μήνυμα σε μερικά λεπτά, παρακαλώ ελέξτε τα ανεπιθύμητα μηνύματα. Σημειώστε το μήνυμα ως <b>μη ανεπιθύμητο</b> για να αποφύγετε μελλοντικά προβλήματα επικοινωνίας μας.</span>';
$hesklang['ekb_n']='<b>ΟΧΙ</b>, απόρριψη βάσης δεδομένων';
$hesklang['ekb_y']='<b>ΝΑΙ</b>, ενεργοποίηση βάσης δεδομένων';
$hesklang['ekb_o']='<b>ΝΑΙ</b>, χρησιμοποιήστε την εφαρμογή μόνο ως βάση δεδομένων (<i>απορρίπτει το help desk</i>)';
$hesklang['kb_set']='Λειτουργίες βάσης δεδομένων';
$hesklang['kbo1']='Λειτουργία μόνο της βάσης δεδομένων';
$hesklang['kbo2']='<br /><br />Οι επισκέπτες δεν μπορούν να υποβάλλουν νέα αιτήματα και κατευθύνονται απαυθείας στη βάση δεδομένων.';
$hesklang['fpass']='Ξέχασες τον κωδικό σου;';
$hesklang['passr']='Επαναφορά κωδικού';
$hesklang['passa']='Να επιτρέπεται οι χρήστες να επαναφέρουν τον κωδικό τους μέσω email';
$hesklang['passe']='Δώσε τη διεύθυνση email';
$hesklang['passs']='Στείλτε μου σύνδεσμο επαναφοράς κωδικού';
$hesklang['noace']='Δεν βρέθηκε λογαριασμός με αυτή τη διεύθυνση email';
$hesklang['pemls']='Σας αποστέλλουμε ένα email με οδηγίες για το πως θα επαναφέρετε τον κωδικό σας';
$hesklang['reset_password']='Επαναφέρατε τον κωδικό της εφαρμογής'; // Email subject
$hesklang['ehash']='Σύνδεσμος για λανθασμένο ή μη ενεργό κωδικό';
$hesklang['ehaip']='Λάθος διεύθυνση IP. Οι κωδικοί μπορούν να επανέρθουν μόνο από την διεύθυνση IP που ζητά την επαναφορά τους.';
$hesklang['resim']='<b>Ρύθμιστε τον νέο σας κωδικό από την επόμενη φόρμα!</b>';
$hesklang['permissions']='Δικαιώματα';
$hesklang['atype']='Τύπος λογαριασμού';
$hesklang['astaff']='Προσωπικό';
$hesklang['oon1']='Να μου αποστέλλονται μόνο ανοιχτά αιτήματα';
$hesklang['oon2']='Να μου αποστέλλονται όλα τα αιτήματα';
$hesklang['anyown']='Όλοι οι ιδιοκτήτες';
$hesklang['pfr']='Άλλη POP3 διεργασία είναι σε λειτουργία.';
$hesklang['pjt']='Λήξη διεργασίας';
$hesklang['pjt2']='λεπτά μετά την έναρξη';
$hesklang['nkba']='Η αναζήτηση στη βάση δεδομένων απαιτεί μοναδικά άρθρα για να λειτουργήσει σωστά.<br /><br />Να ληφθεί υπόψη ότι η προσθήκη περισσότερων άρθρων στη βάση δεδομώνων για να αναβαθμιστούν οι προτάσεις αποτελεσμέτων αναζήτησης.';
$hesklang['saa']='Τα Sticky άρθρα εμφανίζονται στην αρχή της λίστας άρθρων';
$hesklang['yhbr']='Έχετε κλειδωθεί έξω από το σύστημα για %s λεπτά εξαιτίας των πολλών απαντήσεων σε ένα αίτημα.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='en';

// Added in version 2.7.0
$hesklang['imap']='IMAP Fetching';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Encryption';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='None';
$hesklang['imapu']='IMAP Username';
$hesklang['imapw']='IMAP Password';
$hesklang['imaptest']='Test IMAP connection';
$hesklang['ifd']='[HESK] IMAP FETCHING IS DISABLED IN SETTINGS';
$hesklang['iei']='[HESK] PHP IMAP extension is not installed.';
$hesklang['ifr']='Another IMAP fetching task is still in progress.';
$hesklang['arp']='Αυτόματο φόρτωμα σελίδας';
$hesklang['arpp']='Να φορτώνει αυτόματα η σελίδα με τη λίστα αιτημάτων κάθε:';
$hesklang['seconds']='δευτερόλεπτα';
$hesklang['minutes']='λεπτά';
$hesklang['atbr']='Αυτό το αίτημα χρειάζεται να ανατεθεί πριν απαντήσουμε.';
$hesklang['attm']='Να ανατεθεί το αίτημα σε εμένα';
$hesklang['owneed']='Απαιτείται ιδιοκτήτης';
$hesklang['taat']='Αυτό το αίτημα έχει ήδη ανατεθεί σε <b>%s</b>.';
$hesklang['scoy']='>Είστε σίγουρος ότι θέλετε να το αναθέσετε σε εσάς;';
$hesklang['scot']='Είστε σίγουρος ότι θέλετε να το αναθέσετε σε %s?';
$hesklang['ycto']='ΝΑΙ, άλλαξε τον ιδιοκτήτη';
$hesklang['ncto']='ΟΧΙ, να διατηρηθεί ο τωρινός ιδιοκτήτης';
$hesklang['fass']='Απαιτείται ιδιοκτήτης';
$hesklang['req_sub']='Απαιτείται θέμα';
$hesklang['req_msg']='Απαιτείται μήνυμα';
$hesklang['req_email']='Απαιτείται λογαριασμός email';
$hesklang['default_subject']='Αίτημα από %s';
$hesklang['off-hide']='Απόκρυψη στην φόρμα του πολίτη';
$hesklang['not_valid_email']='Δώστε μια έγκυρη διεύθυνση email ή αφήστε αυτό το πεδίο κενό';
$hesklang['write_down']='<span style="color:red">Σας συνιστούμε να σημειώσετε το ID του αιτήματος για μελλοντική χρήση.</span>';
$hesklang['re_confirm1']='Καταργώντας το, θα καταργηθεί και το "Απαιτείται λογαριασμός email για την προβολή αιτήματος" στην "Ασφάλεια". Να προχωρήσουμε;';
$hesklang['re_confirm2']='Ενεργοποιώντας το, θα ενεργοποιηθεί και το "Απαιτείται λογαριασμός" under "Χαρακτηριστικά". Να προχωρήσουμε;';
$hesklang['can_email_tpl']='Επεξεργασία του προτύπου email';
$hesklang['et_title']='Πρότυπα email';
$hesklang['et_intro']='Επεξεργασία των emails που αποστέλλονται στο προσωπικό και στους πολίτες';
$hesklang['file']='Αρχείο';
$hesklang['efile']='Επεξεργασία αρχείου';
$hesklang['rdesc']='(Παραλήπτης) Περιγραφή';
$hesklang['desc_forgot_ticket_id']='(Πολίτης) Απώλεια ID αιτήματος';
$hesklang['desc_new_reply_by_staff']='(Πολίτης) Απάντηση νέου προσωπικού';
$hesklang['desc_new_ticket']='(Πολίτης) Ληφθέντα αιτήματα';
$hesklang['desc_ticket_closed']='(Πολίτης) Επιλυμένο/Κλειστό αίτημα';
$hesklang['desc_category_moved']='(Προσωπικό) Το αίτημα μεταφέρθηκε σε νέα κατηγορία';
$hesklang['desc_new_reply_by_customer']='(Προσωπικό) Νέα απάντηση πολίτη';
$hesklang['desc_new_ticket_staff']='(Προσωπικό) Υποβλήθηκε νέο αίτημα';
$hesklang['desc_ticket_assigned_to_you']='(Προσωπικό) Ένα νέο αίτημα υποβλήθηκε σε εσάς';
$hesklang['desc_new_pm']='(Προσωπικό) Νέο προσωπικό μήνυμα';
$hesklang['desc_new_note']='(Προσωπικό) Νέα σημείωση αιτήματος που έχει υποβληθεί σε εσάς';
$hesklang['desc_reset_password']='(Προσωπικό) Επαναφορά του κωδικού σας';
$hesklang['etfm']='Λείπουν ένα ή περισσότερα πρότυπα email.<br /><br />Βεβαιωθείτε ότι ανεβάσατε όλα τα πρότυπα email στον φάκελο <i>/language/%s/emails</i>.';
$hesklang['etfw']='Μερικά πρότυπα email δεν είναι επαναγράψημα.<br /><br />
                    Βεβαιωθείτε ότι η PHP έχει δικαιώματα εγγραφής σε όλα τα αρχεία στον φάκελο <i>/language/%s/emails</i>.<br /><br />
                    Στους Unix servers μπορεί να χρειάζεστε CHMOD τα πρότυπα email στο 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Απώλεια προτύπου ID';
$hesklang['et_fm']='Αυτό το αρχείο πρότυπου email λείπει';
$hesklang['et_fw']='Το αρχείο του πρότυπου email δεν είναι επαναγράψημο';
$hesklang['et_save']='Αποθήκευση προτύπου email';
$hesklang['updated_on']='Ανανέωση σε';
$hesklang['ticket_url']='URL αιτήματος';
$hesklang['pm_url']='URL ιδιωτικού μηνύματος';
$hesklang['et_num']='Αριθμός αιτημάτων';
$hesklang['et_list']='Λίστα υποστηριζόμενων αιτημάτων';
$hesklang['et_empty']='Το πρότυπο email δεν μπορεί να είναι άδειο';
$hesklang['et_saved']='Το πρότυπο του email αποθηκέυτηκε';
$hesklang['source']='Πηγή';
$hesklang['select_category']='Επιλέξτε μία κατηγορία';
$hesklang['select_category_text']='Πώς μπορούμε να σας βοηθήσουμε;';
$hesklang['select_category_staff']='Επιλογή κατηγορίας αιτήματος';
$hesklang['scat']='Επιλογή ορίου κατηγορίας';
$hesklang['scat2']='(εάν ο μετρητής της κατηγορίας είναι μεγαλύτερος, θα εμφανιστεί ένα πλαίσιο επιλογής)';
$hesklang['new_cf']='Πεδίο νέου πολίτη';
$hesklang['cf_intro']='Επιλέξτε αυτή τη λειτουργία για να προσθέσετε ένα προσαρμοσμένο πεδίο στην υποβολή αιτήματος, για τη συλλογή επιπλέον δεδομένων από τον πολίτη.';
$hesklang['cf_public']='Δημόσιο';
$hesklang['cf_private']='Μόνο για προσωπικό';
$hesklang['cf_cust']='Για τους πολίτες';
$hesklang['cf_all']='Όλα';
$hesklang['cf_cat']='Επιλεγμένα';
$hesklang['cf_ctrl']='Βοήθεια: κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε περισσότερες κατηγορίες';
$hesklang['visibility']='Ορατότητα';
$hesklang['cf_save']='Αποθήκευση προσαρμοσμένου πεδίου';
$hesklang['ex_cf']='Ενεργοποίηση προσαρμοσμένων πεδίων';
$hesklang['no_cf']='Κανένα προσαρμοσμένο πεδίο δεν είναι ενεργό';
$hesklang['del_cf']='Διαγραφή του προσαρμοσμένου πεδίου; Με αυτό θα διαγραφούν και όλα τα αποθηκευμένα προσαρμοσμένα πεδία από τη βάση δεδομένων!';
$hesklang['cf_e_id']='Λάθος ID';
$hesklang['edit_cf']='Επεξεργασία προσαρμοσμένου πεδίου';
$hesklang['cf_deleted']='Το προσαρμοσμένο πεδίο έχει διαγραφεί';
$hesklang['cf_not_found']='Αυτό το προσαρμοσμένο πεδίο δεν υπάρχει';
$hesklang['cf_added']='Έχει προστεθεί ένα νέο προσαρμοσμένο πεδίο';
$hesklang['cf_nocat']='Επιλέξτε τουλάχιστον μία κατηγορία για αυτό το προσαρμοσμένο πεδίο';
$hesklang['cf_mdf']='Το προσαρμοσμένο πεδίο έχει αποθηκευθεί';
$hesklang['atl1']='Εισάγετε τουλάχιστον μία επιλογή.';
$hesklang['sch']='Κρυφό';
$hesklang['meml3']='Να επιτρέπεται η πολλαπλή εισαγωγή λογαριασμών email';
$hesklang['dmin']='Ελάχιστη επιτρεπτή ημερομηνία';
$hesklang['dmax']='Μέγιστη επιτρεπτή ημερομηνία';
$hesklang['d_day']='ημέρα(ες)';
$hesklang['d_week']='εβδομάδα(ες)';
$hesklang['d_month']='μήνας(ες)';
$hesklang['d_year']='έτος(η)';
$hesklang['d_any']='Κάθε ημερομηνία';
$hesklang['d_fixed']='Προσαρμοσμένη ημερομηνία';
$hesklang['d_relative']='Σχετική ημερομηνία';
$hesklang['d_mm']='Η ελάχιστη ημερομηνία δεν μπορεί να είναι μεγαλύτερη από τη μέγιστη ημερομηνία';
$hesklang['d_emin']='Η ελάχιστη ημερομηνία για <i>%s</i> είναι %s';
$hesklang['d_emax']='Η μέγιστη ημερομηνία για <i>%s</i> είναι %s';
$hesklang['d_format']='Μορφή προβαλόμενης ημερομηνίας';
$hesklang['d_custom']='Προσαρμοσμένη μορφή';
$hesklang['d_ci']='ΓΙΑ ΠΡΟΧΩΡΗΜΕΝΟΥΣ ΧΤΗΣΤΕΣ ΜΟΝΟ: μια PHP έγκυρη μορφή ημερομηνία, δείτε τον οδηγό της PHP.';
$hesklang['cf_noe']='Δώστε μια έγκυρη διεύθυνση email στο <i>%s</i>';
$hesklang['cf_noem']='Δώστε μία ή περισσότερες έγκυρες διευθύνσεις email στο <i>%s</i>';
$hesklang['can_resolve']='Μπορεί να επιλύει αιτήματα';
$hesklang['can_change_own_cat']='Αλλαγή κατηγορίας αιτήματος (να επιτρέπεται)';
$hesklang['can_submit_any_cat']='Μπορούν να υποβληθούν σε κάθε κατηγορία';
$hesklang['noauth_submit']='Δεν είστε εξουσιοδοτημένος να υποβάλλετε αιτήματα σε αυτή την κατηγορία!';
$hesklang['noauth_move']='Δεν είστε εξουσιοδοτημένος να μεταφέρετε αιτήματα σε αυτή την κατηγορία!';
$hesklang['noauth_resolve']='Δεν είστε εξουσιοδοτημένος να αναλλαμβάνετε αιτήματα!';
$hesklang['force_ssl']='Force SSL connections';
$hesklang['d_ssl']='<i>μη ενεργοποιημένο</i> - ανοίξτε τη σελίδα με https:// για να διαχειρηστείτε αυτή την επιλογή';
$hesklang['scno']='Αυτή η κατάσταση δεν μπορεί να αλλάξει';
$hesklang['statuses']='Καταστάσεις';
$hesklang['statuses_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να προσθέσετε ένα προσαρμοσμένο πεδίο καταστάσεων στην εφαρμογή';
$hesklang['color']='Χρώμα';
$hesklang['csscl']='CSS class or color';
$hesklang['clr_view']='Color preview on text';
$hesklang['cbc']='Διαχειρίσιμα από τους πολίτες';
$hesklang['ccc']='Μπορούν οι πολίτες να αλλάξουν την κατάστασή τους;';
$hesklang['del_status']='Διαγραφή της κατάστασης;';
$hesklang['ex_status']='Υπάρχουσες καταστάσεις';
$hesklang['status_hesk']='Δημιουργημένες καταστάσεις (δεν μπορούν να τροποποιηθούν εδώ)';
$hesklang['status_custom']='Τροποποιημένες καταστάσεις';
$hesklang['status_custom_none']='Καμία τροποποιημένη κατάσταση. Μπορείτε να την προσθέσετε χρησιμοποιώντας την παρακάτω φόρμα.';
$hesklang['status_save']='Αποθήκευση κατάστασης';
$hesklang['list_tkt_status']='Λίστα όλων των αιτημάτων με αυτή την κατάσταση';
$hesklang['new_status']='Νέα τροποποιημένη κατάσταση';
$hesklang['edit_status']='Επεξεργασία τροποποιημένης κατάστασης';
$hesklang['err_status']='Δώστε το όνομα της κατάστασης';
$hesklang['status_added']='Μια νέα τροποποιημένη κατάσταση έχει προστεθεί';
$hesklang['status_e_id']='Λαθασμένο ID';
$hesklang['status_mdf']='Η τροποποιημένη κατάσταση έχει αποθηκευθεί';
$hesklang['status_deleted']='Η τροποποιημένη κατάσταση έχει διαγραφεί';
$hesklang['status_not_found']='Αυτή η τροποποιημένη κατάσταση δεν υπάρχει';
$hesklang['status_not_empty']='Αυτή η κατάσταση δεν μπορεί να αφαιρεθεί επειδή υπάρχουν ακόμα αιτήμα σε αυτήν';
$hesklang['status_limit']='Έχετε 100 τροποποιημένες καταστάσεις, δεν μπορεί να δημιουργηθεί νέα.';
$hesklang['public_link']='Δημόσιο link';
$hesklang['frames']='Frames';
$hesklang['frames2']='Prevent loading HESK in frames on third party domains';
$hesklang['numsub']='Υποβληθέντα αιτήματα';
$hesklang['hidf']='Οι κρυφές εγγραφές δεν είναι εμφανές στους πολίτες στην φόρμα υποβολής αιτήματος (η τιμή θα εξακολουθεί να είναι εμφανής στη σελίδα λεπτομερειών, αν είναι δημόσια). Θα συμπεριφέρονται ως πεδία κειμένου στο προσωπικό.';
$hesklang['rcheck']='Μην επιλέξετε μια προεπιλεγμένη επιλογή';
$hesklang['refresh_page']='Ανανεώστε τη σελίδα';
$hesklang['del_kba']='Διαγραφή του άρθρου';
$hesklang['del_kbaa']='Μόνιμη διαγραφή του άρθρου';
$hesklang['hni1']='Ηεφαρμογή HESK δεν έχει εγκατασταθεί ακόμα;';
$hesklang['hni2']='Είναι πιθανό η εγκατάσταση και ρύθμιση της εφαρμογής help desk να μην έχει γίνει σωστά ακόμα.';
$hesklang['hni3']='Για την εγκατάσταση της εφαρμογής HESK, ακολουθήστε <a href="docs/">τις οδηγίες</a>';
$hesklang['cf']='Cache folder';
$hesklang['e_cdir']='Hesk will not be able to parse emails or cache results unless the cache folder exists and is writable.';
$hesklang['step1']='Βήμα 1';
$hesklang['step2']='Βήμα 2';
$hesklang['dffs']='Όταν η λήψη ολοκληρωθεί, διαγράψτε το αρχείο από τον server';
$hesklang['fd']='Το αρχείο εξαγωγής έχει διαγραφεί από τον server';

// Added in version 2.8.0
$hesklang['TZ']='Ζώνη ώρας';
$hesklang['thist17']='<li class="smaller">%s | submitted by IMAP fetching</li>';
$hesklang['sir3']='Μη ορατό reCAPTCHA';
$hesklang['invisible']='αόρατο';
$hesklang['imap_not']='PHP is not compiled with IMAP support';
$hesklang['imap_warning']='user %1$s has the same email address as your IMAP fetching email address: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='user %1$s has the same email address as your POP3 fetching email address: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='This could result in an email loop where new tickets are being created from user email notifications. Your fetching email address should be unique and not used by anyone else.';
$hesklang['can_view_ass_by']='Μπορεί να παρακολουθεί αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['can_privacy']='Μπορεί να κάνει τα αιτήματα ανώνυμα';
$hesklang['confirm_anony']='Κάνε ανώνυμο το αίτημα';
$hesklang['anon_selected']='Κάνε ανώνυμα τα επιλεσμένα αιτήματα';
$hesklang['privacy_anon_info']='Διέγραψε τα προσωπικά δεδομένα των αιτημάτων (όνομα, email, μήνυμα, συνημμένα, IP...), αλλά διατήρησε τα αιτήματα στη βάση δεδομένων για στατηστικούς λόγους.';
$hesklang['success_anon']='Το αίτημα έγινε ανώνυμο επιτυχώς';
$hesklang['num_tickets_anon']='Αριθμός των αιτημάτων που έγιναν ανώνυμα: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Customer]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Subject]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Message]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | έγινε ανώνυμο από %s</li>';
$hesklang['print_selected']='Εκτύπωση των επιλεγμένων αιτημάτων';
$hesklang['with_selected']='Με επιλεγμένα:';
$hesklang['assign_selected']='Ανάθεση επιλεγμένων σε:';
$hesklang['assign_no']='Δεν έχει επιλεχθεί ιδιοκτήτης, δεν έγινε καμία αλλαγή';
$hesklang['assign_1']='Τα επιλεγμένα αιτήματα έχουν γίνει Μη ανατεθημένα.';
$hesklang['assign_2']='Το αίτημα με ID %1$s έγινε Μη ανατεθημένο'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s σφάλμα: έχει ήδη ανατεθεί σε %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s ανατλεθηκε σε %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s σφάλαμα: %2$s δεν έχει πρόσβαση στην κατηγορία του αιτήματος'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Bulk ticket assign result:<br /><br />Assigned: %1$s<br />Errors: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP address';
$hesklang['moret']='Περισσότερες επιλογές'; // More options button title
$hesklang['btn_more']='Περισσότερα'; // More options button text
$hesklang['btn_print']='Εκτύπωση';
$hesklang['btn_edit']='Επεξεργασία';
$hesklang['btn_lock']='Κλειδωμένο αίτημα';
$hesklang['btn_unlock']='Ξεκλείδωτο αίτημα';
$hesklang['btn_tag']='Tag ticket';
$hesklang['btn_resend']='ξαναστείλε ενημέρωση με email';
$hesklang['btn_untag']='Untag ticket';
$hesklang['btn_import_kb']='Εισαγωγή στη βάση δεδομένων';
$hesklang['btn_anony']='Ανώνυμα αιτήματα';
$hesklang['btn_delt']='Διαγραφή αιτήματος';
$hesklang['btn_delr']='Διαγραφή απάντησης';
$hesklang['ernf']='Η απάντηση δεν βράθηκε';
$hesklang['tns']='Οι ειδοποιήσεις του αιτήματος ξαναστάλθηκαν';
$hesklang['rns']='Οι ειδοποιήσεις της απάντησης ξαναστάλθηκαν';
$hesklang['fname']='Όνομα';
$hesklang['export_selected']='Εξαγωγή επιλεγμένων αιτημάτων';
$hesklang['btn_export']='Εξαγωγή σε XML για το Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Responses';
$hesklang['team']='Ομάδα';
$hesklang['sm_content']='Περιεχόμενο';
$hesklang['sm_settings']='Ρυθμίσεις';
$hesklang['wizard_back']='Πίσω'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Επόμενο'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Πηγαίνετε στις Ρυθμίσεις';
$hesklang['sm_return_to_editing']='Επιστροφή στην Επεξεργασία';
$hesklang['email_tpl_title']='Τίτλος';
$hesklang['edit_email_template']='Επεξεργασία πρότυπου email';
$hesklang['err_no_settings_section']='No settings section was provided.';
$hesklang['this_field_is_required']='Αυτό το πεδίο απαιτείται';
$hesklang['reset_your_password']='Επαναφορά του κωδικού σας';
$hesklang['reset_password_instructions']='Παρακαλούμε συμπληρώστε την παρακάτω φόρμα. Θα σας στείλουμε ένα σύνδεσμο με τον οποίο θα μπορέσετε να αλλάξετε τον κωδικό σας.';
$hesklang['enter_email']='Εισαγωγή email';
$hesklang['password_reset_check_your_email']='Ελέγξετε το email';
$hesklang['password_reset_link_sent']='Στείλαμε ένα σύνδεσμο για να επαναφέρετε τον κωδικό σας.';
$hesklang['back_to_login']='Πίσω στην είσοδο';
$hesklang['pager_first']='Πρώτη';
$hesklang['pager_previous']='Προηγούμενη';
$hesklang['pager_next']='Επόμενη';
$hesklang['pager_last']='Τελευταία';
$hesklang['new_team_member']='Νέο μέλος ομάδας';
$hesklang['role']='Ρόλος';
$hesklang['optional']='Προαιρετικό';
$hesklang['edit_profile']='Επεξεργασία προφίλ';
$hesklang['assigned_to']='Ανατίθεται σε';
$hesklang['contact']='Επαφή';
$hesklang['unban_email']='Unban αυτό το email';
$hesklang['unban_ip']='Unban αυτή την IP';
$hesklang['show_previous_replies']='Δείξε τις προηγούμενες απαντήσεις';
$hesklang['type_your_message']='Τυπώστε το μήνυμά σας'; // Used when there are no canned responses
$hesklang['close_button_text']='Κλείσιμο';
$hesklang['create_new_ticket']='Δημιουργία νέου αιτήματος';
$hesklang['delete_article']='Διαγραφή άρθρου';
$hesklang['view_existing_tickets']='Προβολή υπαρχόντων αιτημάτων';
$hesklang['how_can_we_help']='Γεια σας, πώς μπορούμε να σας βοηθήσουμε;';
$hesklang['search_for_articles']='Αναζήτηση για άρθρα';
$hesklang['submit_a_support_request']='Υποβολή ενός αιτήματος υποστήριξης';
$hesklang['verify_header']='Πρόληψη SPAM';
$hesklang['ticket_details']='Λεπτομέρειες Αιτήματος';
$hesklang['yes_title_case']='Ναι';
$hesklang['no_title_case']='Όχι';
$hesklang['no_results_found']='Δεν βρέθηκαν αποτελέσματα';
$hesklang['site_theme']='Θέμα ιστότοπου';
$hesklang['test_theme_folder']='Φάκελος δοκιμαστικού θέματος';
$hesklang['test_theme_folder_description']='Δοκιμή του φακέλου θεμάτων για έγκυρα θέματα. Μόνο τα θέματα τα οποία περνάνε όλα τα τεστ εγκαθίστανται.';
$hesklang['err_site_theme']='Παρακαλούμε επιλέξτε το θέμα του Hesk';
$hesklang['confirm']='Επιβεβαίωση';
$hesklang['confirm_deletion']='Επιβεβαίωση Διαγραφής';
$hesklang['confirm_delete_status']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή τη προσαρμοσμένη κατάσταση;';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.en.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Time display';
$hesklang['tdisd']='Date and time';
$hesklang['tdisa']='Time ago (example: 5 hours ago)';
$hesklang['nav_templates']='Templates'; // Admin panel navigation item
$hesklang['hide_replies']='Hide ticket replies';
$hesklang['hide_replies_no']='Do not hide, always show all replies';
$hesklang['hide_replies_yes']='Hide all replies except the last:';
$hesklang['hide_replies_def']='Show the last staff reply and any subsequent customer replies';
$hesklang['reply_by']='Reply by'; // Reply by NAME
$hesklang['btt']='Back to Top';
$hesklang['lwidth']='Limit ticket width';
$hesklang['lwidtall']='Use the full available width';
$hesklang['lwidtpx']='Maximum width in pixels:';
// 3-letter days of the week
$hesklang['mon']='Mon';
$hesklang['tue']='Tue';
$hesklang['wed']='Wed';
$hesklang['thu']='Thu';
$hesklang['fri']='Fri';
$hesklang['sat']='Sat';
$hesklang['sun']='Sun';
$hesklang['clear']='Clear'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Modules';
$hesklang['modules_demo']='This module is currently available only in %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Try the live demo here: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistics';
$hesklang['statistics']['intro']='This report will give you insight into your help desk usage and staff performance.';
$hesklang['statistics']['ntsp']='No tickets in the selected time period.';
$hesklang['statistics']['pie_title_ro']='Open vs Resolved tickets';
$hesklang['statistics']['open']='Open';
$hesklang['statistics']['resolved']='Resolved';
$hesklang['statistics']['pie_title_as']='Open tickets: Assigned vs Unassigned';
$hesklang['statistics']['ass']='Assigned';
$hesklang['statistics']['unas']='Unassigned';
$hesklang['statistics']['pie_title_au']='Open tickets: Answered vs Unanswered';
$hesklang['statistics']['answered']='Answered';
$hesklang['statistics']['unanswered']='Unanswered';
$hesklang['statistics']['pie_title_so']='Status of open tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets per day of month';
$hesklang['statistics']['chart_title_wd']='Tickets per weekday';
$hesklang['statistics']['chart_title_hd']='Tickets per day hour';
$hesklang['statistics']['chart_title_tfr']='Time to first staff reply';
$hesklang['statistics']['chart_title_tfrc']='Tickets replied to within a time frame';
$hesklang['statistics']['chart_title_ttr']='Time from submitting to resolving a ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets resolved within a time frame';
$hesklang['statistics']['chart_title_sr']='Staff replies';
$hesklang['statistics']['chart_title_srt']='Staff replies per ticket';
$hesklang['statistics']['chart_title_srtr']='Staff replies per ticket (resolved tickets only)';
$hesklang['statistics']['chart_title_srt1']='Staff replies per ticket (tickets with at least 1 reply)';
$hesklang['statistics']['ct_30']='30 minutes';
$hesklang['statistics']['ct_1h']='1 hour';
$hesklang['statistics']['ct_2h']='2 hours';
$hesklang['statistics']['ct_4h']='4 hours';
$hesklang['statistics']['ct_1d']='1 day';
$hesklang['statistics']['ct_2d']='2 days';
$hesklang['statistics']['ct_3d']='3 days';
$hesklang['statistics']['ct_1w']='1 week';
$hesklang['statistics']['ct_wp']='> 1 week';
$hesklang['statistics']['ct_1m']='1 month';
$hesklang['statistics']['ct_mp']='> 1 month';
$hesklang['statistics']['axis1']='% of tickets replied';
$hesklang['statistics']['axis2']='% of tickets resolved';
$hesklang['statistics']['axis3']='% of tickets';
$hesklang['statistics']['axis4']='Time to first reply';
$hesklang['statistics']['axis5']='Time to resolved';
$hesklang['statistics']['axis6']='Number of replies';
$hesklang['statistics']['axis7']='Number of tickets';
$hesklang['statistics']['axis8']='Weekday';
$hesklang['statistics']['axis9']='Hour';
$hesklang['statistics']['axis10']='Day of month';
$hesklang['statistics']['tr_0']='No reply';
$hesklang['statistics']['tr_1']='1 reply';
$hesklang['statistics']['tr_2']='2 replies';
$hesklang['statistics']['tr_5']='3-5 replies';
$hesklang['statistics']['tr_10']='6-10 replies';
$hesklang['statistics']['tr_99']='> 10 replies';
$hesklang['statistics']['average']='Average';
$hesklang['statistics']['atfr']='Average hours and minutes to first staff reply:';
$hesklang['statistics']['attr']='Average hours and minutes to resolve a ticket:';
$hesklang['statistics']['about']='about %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total tickets staff replied to:';
$hesklang['statistics']['trnr']='Total tickets resolved without a staff reply:';
$hesklang['statistics']['tsr']='Total staff replies:';
$hesklang['statistics']['tsrt']='Average staff replies per ticket:';
$hesklang['statistics']['tsro']='Average staff replies per ticket (tickets with at least 1 staff reply):';
$hesklang['statistics']['tsrc']='Average staff replies required to resolve a ticket:';
$hesklang['statistics']['tsrr']='Average staff replies required to resolve a ticket (tickets with at least 1 staff reply):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='and much more...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket overdue';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALATED: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalate'; // Menu link
$hesklang['escalate']['page_title']='Escalate Tickets'; // Page H2 title
$hesklang['escalate']['intro']='This module will help you escalate tickets that are not attended to on time.';
$hesklang['escalate']['feat1']='Tickets not assigned, replied to, or resolved within a timeframe';
$hesklang['escalate']['feat2']='tickets approaching due date and overdue tickets';
$hesklang['escalate']['feat3']='automatically change ticket priority, re-assign a ticket, send an email notification';
$hesklang['escalate']['feat4']='apply rules based on ticket category, owner, status';
$hesklang['escalate']['prefix']='Escalated:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Active rules';
$hesklang['escalate']['new']='New escalation rule';
$hesklang['escalate']['no_rules']='You do not have any escalation rules. Create one by clicking the &quot;New escalation rule&quot; button above.';
$hesklang['escalate']['title']='Rule title';
$hesklang['escalate']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['escalate']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Rule trigger';
$hesklang['escalate']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condition'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Action'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Apply to'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Delete this rule?';
$hesklang['escalate']['edit']='Editing escalation rule ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='A support ticket is:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='not replied to by staff';
$hesklang['escalate']['nrepc']='not replied to by customer';
$hesklang['escalate']['nass']='not assigned';
$hesklang['escalate']['nres']='not resolved';
$hesklang['escalate']['ndue']='approaching due date';
$hesklang['escalate']['odue']='overdue';
$hesklang['escalate']['within']='Within:';
$hesklang['escalate']['minutes']='minutes';
$hesklang['escalate']['hours']='hours';
$hesklang['escalate']['days']='days';
$hesklang['escalate']['weeks']='weeks';
$hesklang['escalate']['months']='months';
$hesklang['escalate']['years']='years';
$hesklang['escalate']['ofs']='of being submitted';
$hesklang['escalate']['resend']='Re-send email notifications:';
$hesklang['escalate']['force']='Always send, disregard staff settings';
$hesklang['escalate']['noforce']='Respect staff notifications settings';
$hesklang['escalate']['setpri']='Set priority to:';
$hesklang['escalate']['setsta']='Set status to:';
$hesklang['escalate']['assto']='Assign ticket to:';
$hesklang['escalate']['asm']='Another staff member';
$hesklang['escalate']['notify']='Notify staff members...';
$hesklang['escalate']['ato']='Apply to:';
$hesklang['escalate']['tic']='Tickets in category:';
$hesklang['escalate']['tat']='Tickets assigned to:';
$hesklang['escalate']['tws']='Tickets with status:';
$hesklang['escalate']['tall']='Apply this rule to existing and future tickets';
$hesklang['escalate']['tfn']='Apply this rule to future tickets only, ignore existing tickets';
$hesklang['escalate']['tfi']='Apply this rule only to tickets with ID higher than:';
$hesklang['escalate']['save']='Save rule';
$hesklang['escalate']['e_tt']='Time should be between 1 and 10000';
$hesklang['escalate']['e_a']='Select at least one action to perform on matching tickets';
$hesklang['escalate']['nocat']='Select at least one category';
$hesklang['escalate']['nouser']='Select at least one user';
$hesklang['escalate']['nostatus']='Select at least one status';
$hesklang['escalate']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['escalate']['rule_added']='New rule has been created';
$hesklang['escalate']['mdf']='Rule settings have been saved';
$hesklang['escalate']['e_id']='No rule with this ID found';
$hesklang['escalate']['deleted']='Selected rule has been deleted';
$hesklang['escalate']['edit_notice']='changing the rule trigger will have no effect on any ticket already escalated by this rule (unless you reset the rule).';
$hesklang['escalate']['reset']='Reset this rule';
$hesklang['escalate']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any ticket that matches this rule will be escalated again.';
$hesklang['escalate']['reset3']='Selected rule has been reset';
$hesklang['escalate']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalated by %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - set priority to %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - assign to %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - send staff notification</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - send staff notification (forced)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - error: %2$s doesn\'t have access to ticket category</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - error: %2$s doesn\'t have permission to view tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - error: no other user who can view this ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - notice: priority already set to %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - notice: already assigned to %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notify: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - set status to %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - notice: status already set to %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Active'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activate this rule (start using it)';
$hesklang['escalate']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['escalate']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['escalate']['no_active']='No active escalation rules';
$hesklang['escalate']['matched']='Number of matching tickets found: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Tools';
$hesklang['escalate']['test']='Simulate this rule';
$hesklang['escalate']['testa']='Simulate all rules';
$hesklang['escalate']['testaa']='Simulate all active rules';
$hesklang['escalate']['testr']='Simulation results';
$hesklang['escalate']['rsim']='Repeat simulation';
$hesklang['escalate']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               We strongly recommend that you <strong>simulate</strong> each rule by clicking the %1$s (Simulate this rule) icon in the rules table
                               to see how it will affect your existing tickets before activating it.<br><br>
                               <strong>Active rules are processed every %2$s minutes. A ticket can only be escalated once by each rule</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['escalate']['sic']='SIMULATION COMPLETE';
$hesklang['escalate']['r']='[RULE]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tip: hold down CTRL key to select multiple options';
$hesklang['desc_ticket_escalated']='(Staff) Ticket has been escalated'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ticket Formatting (Staff)';
$hesklang['ticket_formatting_plaintext']='Plain Text';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Due date';
$hesklang['invalid_due_date']='An invalid due date was entered.';
$hesklang['thist19']='<li class="smaller">%s | due date updated to %s by %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | due date removed by %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Ticket due date has been updated.';
$hesklang['menu_kb_manage']='Manage'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='View'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Select all';
$hesklang['a_deselect']='Deselect all';
$hesklang['a_toggle']='Toggle all';
$hesklang['ql_all']='All tickets';
$hesklang['ql_alo']='All open tickets';
$hesklang['ql_fit']='Filtered tickets';
$hesklang['ql_a2m']='Assigned to me';
$hesklang['ql_a2o']='Assigned to others';
$hesklang['ql_una']='Unassigned';
$hesklang['ql_due']='Due soon';
$hesklang['ql_ovr']='Overdue';
$hesklang['set_ds']='Show as &quot;due soon&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='days before due date';
$hesklang['not_aos']='Some open tickets you have access to are not shown due to your filters.';
$hesklang['ntoverdue']='A ticket is overdue with owner:';
$hesklang['ovdcron']='for overdue notifications to work, your administrator must enable a cron job.';
$hesklang['instructions']='Instructions';
$hesklang['desc_overdue_ticket']='(Staff) Ticket overdue';
$hesklang['overdue_starting']='Starting overdue tickets notification process';
$hesklang['overdue_sim']='Sending emails and updating tickets is disabled in SIMULATION mode.';
$hesklang['overdue_ticket_count']='Found %s tickets that are overdue.'; // %s = Number of tickets
$hesklang['overdue_finished']='Finished Overdue Tickets. %s emails sent. %s emails failed to send.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Load an extra custom style file for the admin panel';
$hesklang['noval_cert']='Do not validate server certificates';
$hesklang['chg_cat']='Click to change ticket category';
$hesklang['tlan']='Ticket language';
$hesklang['uue']='Two or more staff members have the same email address. We recommend setting a unique email address for each user.';
$hesklang['flood']='Flood limit';
$hesklang['e_flood']='Ooops, you already submitted a reply just recently. We stopped this request to prevent reply flooding.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL Access Key'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generate a random URL Access Key';
$hesklang['ukeym']='Error: to run this file via HTTP you must include your URL Access Key in the request. Example:';
$hesklang['ukeyw']='Error: wrong URL Access Key';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket received: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% is your verification code';
$hesklang['follow_up_email']='Be honest - how did we do?';
$hesklang['mfa']='Multi-Factor Authentication (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Enabled?';
$hesklang['mfa_required']='Require Multi-Factor Authentication';
$hesklang['mfa_manage_profile']='Manage MFA';
$hesklang['mfa_disabled']='Multi-Factor Authentication is disabled';
$hesklang['mfa_enabled']='Multi-Factor Authentication is Enabled (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='None';
$hesklang['mfa_method_none_subtext']='Remove multi-factor authentication on your account.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='The helpdesk will send an email with a random login code to <strong>%s</strong> when logging in.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Use a smartphone application, such as Authy or Google Authenticator, to generate a random login code when logging in.';
$hesklang['mfa_step_method']='Method';
$hesklang['mfa_step_verification']='Verification';
$hesklang['mfa_step_complete']='Complete';
$hesklang['mfa_introduction']='Multi-factor authentication improves account security by requiring you to verify your login using an additional verification method, such as email or an authenticator app (such as Authy or Google Authenticator).';
$hesklang['mfa_reset_warning']='You already have multi-factor authentication enabled. Completing this again will reset your multi-factor authentication device (if enabled).';
$hesklang['mfa_select_method_colon']='Select an authentication method:';
$hesklang['mfa_verification_header']='Verification - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='An email has been sent to <strong>%s</strong> containing a six-digit verification code. Enter the code you received via email below to continue.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scan the image below with the multi-factor authentication app on your mobile device.';
$hesklang['mfa_verification_auth_app_cant_scan']='Not able to scan the image? Manually enter this code on your device: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Enter the 6-digit code displayed on your application to verify your device.';
$hesklang['mfa_verify']='Verify';
$hesklang['mfa_invalid_method']='Invalid multi-factor authentication method was received.';
$hesklang['mfa_invalid_verification_code']='The code that was entered is incorrect or expired.';
$hesklang['mfa_configured']='Multi-factor authentication has been enabled for your account!';
$hesklang['mfa_removed']='Multi-factor authentication has been disabled for your account!';
$hesklang['mfa_verification_needed']='Multi-factor authentication is enabled for this account.';
$hesklang['mfa_verification_needed_email']='Please enter the verification code that was sent to your email address.';
$hesklang['mfa_verification_needed_auth_app']='Please enter the code that is displayed on your authentication app.';
$hesklang['mfa_verification_code']='Verification code';
$hesklang['mfa_server_time_issue']='Your server time seems to be inaccurate: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Reset multi-factor authentication';
$hesklang['mfa_reset_confirm']='Are you sure you wish to reset MFA for this user?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='Multi-Factor Authentication has been reset for the user';
$hesklang['desc_mfa_verification']='(Staff) Multi-Factor Authentication Code';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='SAVE YOUR BACKUP CODES!';
$hesklang['mfa_backup_codes_description']='Keep these backup codes somewhere safe but accessible. In case you lose access to your MFA device or email, you can enter one of the following backup codes to log in.<br><br><strong>Be sure to treat these backup codes like passwords. You will not be able to see these codes again!</strong>';
$hesklang['mfa_verify_another_way']='Verify your account another way'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Get a verification code at %s';
$hesklang['mfa_verify_another_way_code']='Enter one of your 8-character backup codes';
$hesklang['mfa_verify_another_way_admin']='Contact your helpdesk administrator for help';
$hesklang['mfa_verify_another_way_reset']='Reset your multi-factor authentication by uploading a file to the server';
$hesklang['mfa_send_another_email']='Send another email';
$hesklang['mfa_sent']='An email with a new verification code was sent to your email address';
$hesklang['mfa_backup_code']='Backup Code';
$hesklang['mfa_backup_codes']='Backup Codes';
$hesklang['mfa_backup_codes_info']='Single-use codes to pass multi-factor verification when unable to access your email or authenticator app. Once you use a backup code to sign in, that code becomes inactive.';
$hesklang['mfa_backup_codes_num']='You can get a new set of 10 backup codes whenever you want. When you create a new set of codes, the old set automatically becomes inactive.';
$hesklang['mfa_backup_codes_num2']='Number of your active codes: %s';
$hesklang['mfa_invalid_backup_code']='The backup code that was entered is incorrect or has already been used.';
$hesklang['mfa_del_codes']='Delete my backup codes';
$hesklang['mfa_del_codes2']='All your backup codes have been deleted.';
$hesklang['mfa_new_codes']='Generate new backup codes';
$hesklang['mfa_new_codes2']='New backup codes have been generated';
$hesklang['old_php_version']='Error: Unsupported PHP version';
$hesklang['category_default_due_date']='Default Due Date';
$hesklang['category_change_default_due_date']='Set Default Due Date';
$hesklang['category_leave_blank_for_no_default_due_date']='(leave blank for no default due date)';
$hesklang['category_default_due_date_updated']='Default due date has been updated.';
$hesklang['email_formatting']='Email formatting';
$hesklang['email_formatting_html_and_plaintext']='HTML with plain text alternative from plain text template (default)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML with plain text alternative generated from HTML template';
$hesklang['email_formatting_html']='HTML only';
$hesklang['email_formatting_plaintext']='Plain text only';
$hesklang['email_formatting_note']='Your selection in %1$s &gt; %2$s &gt; %3$s is set to: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='This means Hesk will ignore the HTML templates here.';
$hesklang['email_formatting_note1']='This means Hesk will ignore the plain text templates here.';
$hesklang['email_formatting_note2']='This means Hesk will generate plain text version of emails from your HTML templates and ignore the plain text templates here.';
$hesklang['etnu']='This email template is currently not used by Hesk based on your selection in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Edit Category';
$hesklang['create_category']='Create Category';
$hesklang['one_user_included']='1 user included';
$hesklang['one_user_excluded']='1 user excluded';
$hesklang['x_users_included']='%s users included'; // %s = Number of users
$hesklang['x_users_excluded']='%s users excluded'; // %s = Number of users
$hesklang['aa_cat']='Auto-assign tickets in this category';
$hesklang['modify_autoassign_settings']='Modify auto-assign settings';
$hesklang['autoassign_on_all_users']='Yes, to any user with access to this category';
$hesklang['autoassign_on_select_users']='Yes, to specific users';
$hesklang['autoassign_off']='No, submit tickets as unassigned';
$hesklang['autoassign_users']='Users to include/exclude in auto-assignment';
$hesklang['autoassign_selected_include']='Selected users should be <strong>included</strong> when auto-assigning tickets in this category';
$hesklang['autoassign_selected_exclude']='Selected users should be <strong>excluded</strong> when auto-assigning tickets in this category';
$hesklang['cat_edited']='Category %s has been successfully edited';
$hesklang['search_for_user']='Search for user';
$hesklang['email_sending']='Sending emails';
$hesklang['email_to_ticket']='Email to ticket';
$hesklang['email_to_ticket_info']='Converting emails to tickets requires some server-side setup. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk is using a SMTP server to send email notifications. Your <strong>%1$s</strong> should be set to <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Missing file extension';
$hesklang['block_ignore']='Email to ticket - Ignore emails and prevent loops';
$hesklang['block_noreply']='Do not reply';
$hesklang['block_noreply2']='Ignore emails sent from &quot;do not reply&quot; email addresses';
$hesklang['block_returned']='Returned';
$hesklang['block_returned2']='Ignore returned emails, such as delivery status notifications and automated replies';
$hesklang['block_duplicate']='Duplicates';
$hesklang['block_duplicate2']='Ignore emails with the same message sent within &quot;%s&quot; seconds'; // %s = "Timeframe"
$hesklang['loop_info']='emails received from the same email address within &quot;%s&quot; seconds';
$hesklang['thist21']='<li class="smaller">%s | overdue email notification sent</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | follow-up email sent</li>'; // %s = date
$hesklang['elevator_header']='Entering Secure Area';
$hesklang['elevator_intro']='You are about to enter a secure area.';
$hesklang['elevator_enter_password']='Please enter your password to continue.';
$hesklang['elevator_duration_setting_title']='Secure area duration';
$hesklang['desc_survey']='(Customer) Follow-up (survey) email'; // Email description
$hesklang['satisfaction']['tab']='Satisfaction';
$hesklang['satisfaction']['title']='Customer Satisfaction Survey';
$hesklang['satisfaction']['intro']='Send your customers a follow-up satisfaction survey to gather feedback about their experience with your help desk.';
$hesklang['satisfaction']['tab1']='Settings';
$hesklang['satisfaction']['tab2']='Opt-out';
$hesklang['satisfaction']['enable']='Enable follow-up emails:';
$hesklang['satisfaction']['enabled']='Customer Satisfaction Surveys are enabled.';
$hesklang['satisfaction']['disabled']='Customer Satisfaction Surveys are currently disabled.';
$hesklang['satisfaction']['url']='Survey URL address:';
$hesklang['satisfaction']['send']='Follow-up email delay:';
$hesklang['satisfaction']['at_least']='Wait at least';
$hesklang['satisfaction']['after']='after the ticket is resolved before sending the email';
$hesklang['satisfaction']['h1']='How to use this tool?';
$hesklang['satisfaction']['h2']='First, create a customer satisfaction survey in your favorite survey tool. If you are unsure what tool to use or what questions to ask, we have a <a href="%s" target="_blank">guide available here</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='When your survey is ready, enable follow-up emails using the form below. Hesk will process resolved tickets with at least one staff reply once per hour and send your survey link to your customers.';
$hesklang['satisfaction']['e_url']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['as']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['oo1']='This page lists email addresses that follow-up emails will <b>not</b> be sent to.';
$hesklang['satisfaction']['oo2']='Your customers are able to opt-out from receiving survey emails by clicking a link in the email. Alternatively, you can manually add email addresses on this page.';
$hesklang['satisfaction']['ooe']='Email address to opt-out';
$hesklang['satisfaction']['ooe2']='Enter the email address you wish to opt-out from receiving survey emails.';
$hesklang['satisfaction']['ooe3']='This email address <i>%s</i> is already opted out from receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Opt-out this email';
$hesklang['satisfaction']['oob']='Opted out by';
$hesklang['satisfaction']['no_oo']='No customer has opted out of receiving survey emails.';
$hesklang['satisfaction']['oor']='Remove';
$hesklang['satisfaction']['oor2']='Email removed from opt-out';
$hesklang['satisfaction']['oor3']='Confirm removal';
$hesklang['satisfaction']['oor4']='When removed from opt-out, this user will again receive follow-up emails.';
$hesklang['satisfaction']['optedout']='The email address <i>%s</i> was opted out of receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Missing or invalid survey ID';
$hesklang['satisfaction']['starting']='Starting customer satisfaction survey notification process';
$hesklang['satisfaction']['tc']='Found %s closed tickets that did not have satisfaction survey sent.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Finished Customer Satisfaction Survey. Emails sent: %1$s. Emails failed to send: %2$s. Tickets without an email: %3$s. Tickets with opt-out email: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignoring, this customer does not wish to receive survey emails.';
$hesklang['satisfaction']['ne']='Ignoring, this ticket is without an email address';
$hesklang['satisfaction']['feat1']='Create your survey using any third-party tool, such as Google Forms';
$hesklang['satisfaction']['feat2']='set up your survey URL, preferences, and limitations inside this module';
$hesklang['satisfaction']['feat3']='when you resolve a ticket, Hesk will email your customer the link to the survey';
$hesklang['dfor']='Date format';
$hesklang['dtfor']='Date and Time';
$hesklang['cdfor']='Date select format';
$hesklang['custom']='Custom';
$hesklang['jsc_notice']='The date selection doesn\'t support PHP-style date formatting. Select one of the pre-configured options or click the %s icon below to see available display options.'; // %s = replaced by icon
$hesklang['lcf3']='Date only'; // Display: "Date only"
$hesklang['epdd']='Error parsing due_date parameter:';
$hesklang['edit_pass']='Edit password';
$hesklang['save_pass']='Save password';
$hesklang['cur_pass']='Current password';
$hesklang['cur_pass2']='You must provide your current password in order to change it.';
$hesklang['cur_pass3']='After a successful password update, you will be redirected to the login page, where you can log in with your new password.';
$hesklang['e_new_pass']='Please enter your new password';
$hesklang['pass_len']='The password must not exceed 64 characters';
$hesklang['pass_login']='Please log in again after changing your password';
$hesklang['bf_int']='You have been logged out due to too many failed verification attempts';
$hesklang['tst_cnt']='Number of emails your mail server will send to Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='You have many unread emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to mark existing emails as read before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='You have many emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to delete existing emails before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Due on'; // Due on (date)
$hesklang['search_due_date_range']='Due in'; // Due in (X days)
$hesklang['attachment_add_files']='Add file';
$hesklang['attachment_max_exceeded']='This file will not be uploaded becuase you have already uploaded the maximum number of files allowed.';
$hesklang['attachment_viewer_message']='Drag files here or click the \'Add File\' button below to select files to upload.';
$hesklang['attachment_invalid_type_message']='Sorry, but the file type you tried to upload is not allowed.';
$hesklang['attachment_upload_error']='An error occurred when trying to upload. Please try again later.';
$hesklang['attachment_too_large']='This attachment is larger than the max filesize permitted.';
$hesklang['attachment_cancel']='Cancel';
$hesklang['attachment_confirm_cancel']='Are you sure you want to cancel this upload?';
$hesklang['attachment_remove']='Remove attachment';
$hesklang['attachment_too_many_uploads']='Too many attachments have been uploaded from your location in a short period of time. Please try your request again later.';
$hesklang['sub_note']='Submit note';
$hesklang['can_view_users']='View all users (but not manage them)';
$hesklang['welcome1']='Hey there, you seem to be new here. Welcome!';
$hesklang['welcome2']='To help you get started, check out the %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Quick Start Guide';
$hesklang['tmce1']='Use Ctrl+Right click to access spellchecker';
$hesklang['tmce2']='Hold the Control (Ctrl) key and right-click on the misspelled word to access the spellchecker.';
$hesklang['desc_new_ticket_by_staff']='(Customer) New staff-submitted ticket';
$hesklang['mod_et_h']='You can modify email templates under %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Set language to';
$hesklang['ouwa']='Only users with access to this category are listed below. To add staff members to this category, edit their permissions on the %s page'; // %s = Team
$hesklang['previous_tickets']='Previous tickets';
$hesklang['no_previous']='No previous tickets by %s'; // %s = email address
$hesklang['all_previous']='List all previous tickets';
$hesklang['confirm_delete_ticket']='Are you sure you want to permanently delete this ticket?';
$hesklang['confirm_delete_reply']='Are you sure you want to permanently delete this reply?';
$hesklang['select_new_category']='Number of tickets in this category: %s<br><br>Please select a new category to transfer these tickets to:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deleting this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK license';
$hesklang['hlic_free']='FREE';
$hesklang['hlic_buyl']='Buy a License';
$hesklang['hlic_paid']='Licensed';
$hesklang['antdemo']='Submitting tickets from the admin panel has been disabled in the demo mode.<br><br>Please use the <a href="%s" target="_blank">public side</a> to submit a test ticket.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Authentication method';
$hesklang['email_authentication_method_username_password']='Basic (Username / Password)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No verified OAuth providers configured.';
$hesklang['email_authentication_method_oauth_link']='Manage OAuth providers'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Authorization Endpoint URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scope';
$hesklang['oauth_error_invalid_state']='OAuth state does not match the state sent to OAuth provider.';
$hesklang['oauth_error_unknown']='An unknown error occurred when attempting to save OAuth tokens.';
$hesklang['oauth_error_no_token']='Access token missing in the JSON response.';
$hesklang['oauth_error_retrieve']='Unable to retrieve an access token. Please confirm your OAuth Provider settings and re-save them to acquire a new token.';
$hesklang['email_oauth_provider']='OAuth Provider';
$hesklang['email_oauth_providers']='OAuth Providers';
$hesklang['email_oauth_provider_guide']='Before using OAuth, you must register an OAuth Provider. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Your OAuth Redirect URI for Hesk is:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use this tool to add OAuth providers to your help desk';
$hesklang['email_oauth_provider_name']='Name'; // OAuth provider name
$hesklang['email_oauth_new_provider']='New Provider';
$hesklang['email_oauth_edit_provider']='Edit Provider';
$hesklang['email_oauth_provider_being_used_for']='Being Used For';
$hesklang['email_oauth_providers_none']='No OAuth providers saved. You can add them by clicking "New Provider" above.';
$hesklang['email_oauth_provider_cannot_be_deleted']='This provider cannot be removed because it is being used by the help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Are you sure you want to delete this OAuth provider?';
$hesklang['oauth_provider_saved']='OAuth provider has been saved';
$hesklang['oauth_provider_use']='You can now select this provider in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Enter the provider name';
$hesklang['oauth_provider_err_auth_url']='Enter a valid authorization URL';
$hesklang['oauth_provider_err_token_url']='Enter a valid token URL';
$hesklang['oauth_provider_err_client_id']='Enter the client ID';
$hesklang['oauth_provider_err_client_secret']='Enter the client secret';
$hesklang['oauth_provider_err_scope']='Enter the scope';
$hesklang['oauth_provider_deleted']='OAuth provider deleted';
$hesklang['oauth_provider_not_found']='This OAuth provider does not exist';
$hesklang['oauth_provider_verified']='Verified';
$hesklang['oauth_provider_click_to_verify']='Click to verify';
$hesklang['can_due_date']='Can set due date'; // Permission to set and modify due date
$hesklang['can_due_date_e']='You do not have permission to set due dates';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');