import { Component, splitter, btn, t, router } from "@intermesh/goui";
/**
 * MainThreeColumnPanel class
 *
 * Base class for modules that use a typical 3 column layout:
 *
 * west: navigation
 * center: main grid
 * east: Show detail
 */
export class MainThreeColumnPanel extends Component {
    /**
     * Constructor
     *
     * @param idAndRoute Used for state saving and also as the route to the main panel
     * @protected
     */
    constructor(idAndRoute) {
        super("section");
        this.id = idAndRoute;
        this.cls = "hbox fit mobile-cards";
        this.center = this.createCenter();
        this.center.itemId = "center";
        //center is active by default
        this.center.el.classList.add("active");
        this.west = this.createWest();
        this.west.itemId = "west";
        this.east = this.createEast();
        this.east.itemId = "east";
        this.items.add(this.west, splitter({
            resizeComponentPredicate: "west",
            stateId: this.id + "-west-splitter",
            minSize: 140
        }), this.center, splitter({
            stateId: this.id + "-east-splitter",
            resizeComponentPredicate: "east"
        }), this.east);
    }
    /**
     * Button to show the west panel. Use in overrides.
     *
     * @protected
     */
    showWestButton() {
        return btn({
            cls: "for-small-device",
            title: t("Menu"),
            icon: "menu",
            handler: (button, ev) => {
                this.activatePanel(this.west);
            }
        });
    }
    /**
     * Button to show the center panel. Use in overrides.
     * @protected
     */
    showCenterButton() {
        return btn({
            cls: "for-small-device",
            title: t("Close"),
            icon: "close",
            handler: (button, ev) => {
                this.activatePanel(this.center);
                router.setPath(this.id);
            }
        });
    }
    /**
     * Activate the given panel
     *
     * @param active
     */
    activatePanel(active) {
        this.center.el.classList.remove("active");
        this.east.el.classList.remove("active");
        this.west.el.classList.remove("active");
        active.el.classList.add("active");
    }
}
//# sourceMappingURL=MainThreeColumnPanel.js.map