import { comp, Component, FunctionUtil, tbar, Window } from "@intermesh/goui";
import { jmapds } from "../jmap";
import { router } from "../Router";
/**
 * Detail panel
 *
 * Used to show an entity when selected in the grid.
 */
export class DetailPanel extends Component {
    constructor(entityName) {
        super();
        this.entityName = entityName;
        // reload or reset on entity update or destroy
        jmapds(this.entityName).on("change", (ds, changes) => {
            if (this.entity) {
                const id = this.entity.id + "";
                if (changes.updated && changes.updated.indexOf(id) > -1) {
                    this.load(this.entity.id);
                }
                if (changes.destroyed && changes.destroyed.indexOf(id) > -1) {
                    this.reset();
                    // update router path
                    const rPath = router.getPath();
                    if (rPath.match("/" + id + "$")) {
                        router.setPath(rPath.substring(0, rPath.length - id.length - 1));
                    }
                }
            }
        });
        this.baseCls = "detail";
        this.disabled = true;
        this.cls = "vbox";
        this.items.add(this.toolbar = this.createToolbar(), this.scroller = comp({ flex: 1, cls: "scroll", hidden: true }));
    }
    get legacyDetailView() {
        if (!this.detailView) {
            const ro = new ResizeObserver(FunctionUtil.onRepaint(() => {
                this.detailView.doLayout();
            }));
            ro.observe(this.el);
            this.detailView = new go.detail.Panel({
                width: undefined,
                entityStore: go.Db.store(this.entityName),
                header: false
            });
            this.scroller.items.add(this.detailView);
        }
        return this.detailView;
    }
    addCustomFields() {
        this.legacyDetailView.addCustomFields();
    }
    addLinks() {
        this.legacyDetailView.addLinks();
    }
    addComments() {
        this.legacyDetailView.addComments();
    }
    addFiles() {
        this.legacyDetailView.addFiles();
    }
    addHistory() {
        this.legacyDetailView.addHistory();
    }
    createToolbar() {
        return tbar({
            cls: "border-bottom"
        }, '->');
    }
    set title(title) {
        super.title = title;
        if (this.titleCmp) {
            this.titleCmp.text = title;
        }
    }
    get title() {
        return super.title;
    }
    async load(id) {
        this.mask();
        try {
            this.entity = await jmapds(this.entityName).single(id.toString());
            if (!this.entity) {
                throw "notfound";
            }
            this.scroller.hidden = false;
            this.disabled = false;
            this.fire("load", this, this.entity);
            // this.title = this.entity.name;
            //
            // this.content.items.clear();
            // this.content.items.add(Image.replace(this.entity.content));
            this.legacyOnLoad();
        }
        catch (e) {
            console.error(e);
            void Window.error(e + "");
        }
        finally {
            this.unmask();
        }
        return this;
    }
    reset() {
        this.entity = undefined;
        this.title = "";
        if (this.detailView) {
            this.detailView.reset();
        }
        this.disabled = true;
        this.scroller.hidden = true;
        this.fire("reset", this);
    }
    legacyOnLoad() {
        if (this.detailView) {
            this.detailView.currentId = this.entity.id;
            this.detailView.internalLoad(this.entity);
        }
    }
}
//# sourceMappingURL=DetailPanel.js.map