/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { createComponent } from "../Component.js";
import { TimeField } from "./TimeField";
import { DateTime } from "../../util";
/**
 * Date field
 *
 * @property min The minimum value allowed. Same format as {@link DateField.value}.
 * @property max The maximum value allowed. Same format as {@link DateField.value}.
 *
 * @see Form
 */
export class DateField extends TimeField {
    constructor() {
        super();
        this.baseCls = "goui-form-field date no-floating-label";
        this.type = "date";
    }
    /**
     * Also render time input
     *
     * @param withTime
     */
    set withTime(withTime) {
        let v = this.value, newType = withTime ? "datetime-local" : "date";
        if (newType != this.input.type) {
            this.input.type = newType;
            if (!v) {
                return;
            }
            if (withTime) {
                v = this.appendTime(v);
            }
            else {
                const parts = v.split("T");
                v = parts[0];
                this.defaultTime = parts[1];
            }
            this.input.value = v;
        }
    }
    appendTime(v) {
        var _a;
        return v + "T" + ((_a = this.defaultTime) !== null && _a !== void 0 ? _a : (new DateTime()).format("H:i"));
    }
    get withTime() {
        return this.type == "datetime-local";
    }
    get value() {
        return super.value;
    }
    /**
     * The value of the date is in Y-m-d  or  Y-m-d H:i when withTime is true. {@link DateTime.format}
     * @param v
     */
    set value(v) {
        if (v) {
            const Tindex = v.indexOf("T");
            if (this.withTime) {
                if (Tindex == -1) {
                    v = this.appendTime(v);
                }
            }
            else {
                if (Tindex != -1) {
                    const parts = v.split("T");
                    v = parts[0];
                    this.defaultTime = parts[1];
                }
            }
        }
        super.value = v;
    }
    outputFormat() {
        return this.withTime ? "Y-m-dTH:i" : 'Y-m-d';
    }
}
/**
 * Shorthand function to create {@see DateField}
 *
 * @param config
 */
export const datefield = (config) => createComponent(new DateField(), config);
//# sourceMappingURL=DateField.js.map