import { AutocompleteEventMap, AutocompleteField } from "./AutocompleteField";
import { AbstractDataSource, DataSourceStore, DataSourceStoreConfig, QueryFilter } from "../../data";
import { Table } from "../table";
import { Config } from "../Observable";
export type ComboBoxStoreConfig<DS extends AbstractDataSource = AbstractDataSource> = Partial<DataSourceStoreConfig<DS, any>>;
export type ComboRenderer = (field: ComboBox, record: any) => string;
export declare const ComboBoxDefaultRenderer: ComboRenderer;
/**
 * Combo box
 *
 * An extension of the Autocomplete field that simplifies the creation of a simple combobox with a
 * valueProperty and displayProperty.
 */
export declare class ComboBox<DS extends AbstractDataSource = AbstractDataSource> extends AutocompleteField<Table<DataSourceStore<DS>>> {
    readonly dataSource: DS;
    readonly displayProperty: string;
    readonly valueProperty: string;
    protected renderer: ComboRenderer;
    /**
     * When autocompleting from the datasource this filter name will be used.
     */
    filterName: string;
    /**
     * Set additional filter properties on the store.
     */
    filter?: QueryFilter;
    constructor(dataSource: DS, displayProperty?: string, valueProperty?: string, renderer?: ComboRenderer, storeConfig?: ComboBoxStoreConfig<DS>);
    pickerRecordToValue(_field: this, record: any): string;
    valueToTextField(_field: this, value: string): Promise<string>;
}
export type ComboBoxConfig<Type extends ComboBox = ComboBox> = Config<Type, AutocompleteEventMap<Type>, "dataSource"> & {
    /**
     * Config for the {@link DataSourceStore}
     */
    storeConfig?: ComboBoxStoreConfig;
    /**
     * Renders the value in the list and input field. Must return plain text.
     */
    renderer?: ComboRenderer;
};
/**
 * Shorthand function to create {@see DateField}
 *
 * @param config
 */
export declare const combobox: (config: ComboBoxConfig) => ComboBox<AbstractDataSource<import("../../data").DefaultEntity>>;
//# sourceMappingURL=ComboBox.d.ts.map