go.modules.business.finance.PaymentDialog = Ext.extend(go.form.Dialog, {
	stateId: 'finance-PaymentForm',
	title: t("Payment"),
	entityStore: "Payment",
	width: dp(800),
	height: dp(600),
	maximizable: true,
	collapsible: true,
	modal: false,
	titleField: "description",

	saveBankNumber : function() {
		Ext.MessageBox.confirm(t("Save"), t("Do you want to save this bank account number to this customer?"), (btn) => {
			if(btn != "yes") {
				return;
			}

			this.getEl().mask(t("Loading..."));

			go.Db.store("Contact").save({
				IBAN:  this.contraAccountNumber.getValue(),
			}, this.selectCustomer.getValue()).finally(() => {
				this.getEl().unmask();
			})
		}, this);
	},

	initFormItems: function () {

		this.selectCustomer = new go.modules.community.addressbook.ContactCombo({
			fieldLabel: t("Customer"),
			hiddenName: 'customerId',
			isOrganization: null,
			allowBlank: true,
			listeners: {
				select: (combo, record)  =>{
					this.saveBankNumber();
				}
			}
		});

		this.businessCombo = new go.modules.business.business.BusinessCombo({


		});

		return [{
			xtype: 'fieldset',
			defaults: {
				anchor: "100%"
			},
			items: [
			{
					fieldLabel: t("Amount"),
					xtype: "gonumberfield",
					name: "amount"
				}, {
					xtype: "datefield",
					fieldLabel: t("Date"),
					name: "date",
					value: new Date()
				},

				{
					xtype: "financedocumentcombo",
					listeners: {
						select: function(combo, record) {
							if(!this.selectCustomer.getValue()) {
								this.selectCustomer.setValue(record.data.customerId);
								this.saveBankNumber();
							}
						}
						,scope: this
					}
				},
				this.selectCustomer,

				this.businessCombo,
				{
					xtype: "textarea",
					grow: true,
					maxLength: 190,
					fieldLabel: t("Description"),
					name: "description"
				},
				{
					xtype: "checkbox",
					boxLabel: t("Verified"),
					name: "checked",
					checked: true
				}, {
				 	xtype: "plainfield",
					fieldLabel: t("Account"),
					name: "contraAccountName"
				}, this.contraAccountNumber = new GO.form.PlainField({
					xtype: "plainfield",
					fieldLabel: t("Number"),
					name: "contraAccountNumber"
				})
				]
		}];

	}

});
