go.modules.business.finance.DebtorProfileDialog = Ext.extend(go.form.Dialog, {
	stateId: 'finance-DebtorProfileForm',
	title: t("Debtor profile"),
	entityStore: "DebtorProfile",
	width: dp(800),
	height: dp(800),
	maximizable: true,
	collapsible: true,
	modal: false,
	titleField: "number",

	initFormItems: function () {

		var items = [{
			xtype: 'fieldset',
			items: [
				{
					xtype: "hidden",
					name: "businessId"
				}, {
					fieldLabel: t("Name"),
					xtype: "textfield",
					name: "name",
					allowBlank: false
				}, {
					xtype: "compositefield",
					items: [{
						fieldLabel: t("Expires in"),
						xtype: "gonumberfield",
						name: "expireDays",
						allowBlank: false,
						decimals: 0
					}, {
						xtype: "label",
						text: t("Days")
					}]
				}, {
					xtype: "compositefield",
					items: [{
						fieldLabel: t("Quotes expire in"),
						xtype: "gonumberfield",
						name: "quoteExpireDays",
						allowBlank: false,
						decimals: 0
					}, {
						xtype: "label",
						text: t("Days")
					}]
				}, {
					xtype: "compositefield",
					items: [{
						fieldLabel: t("Grace period"),
						xtype: "gonumberfield",
						name: "graceDays",
						allowBlank: false,
						decimals: 0
					}, {
						xtype: "label",
						text: t("Days")
					}]
				}, {
					xtype: "tasklistcomboreset",
					role: "list",
					hiddenName: 'taskListId',
					hint: t("If not set then the default list of the user who executes the debtor actions will be used")
				}
			]
		}, {
			xtype: "fieldset",
			title: t("Actions"),
			items: [{
				xtype: "formgroup",
				name: "actions",
				itemCfg: {

					listeners: {
					// 	afterlayout: function (formContainer) {
					// 		var form = formContainer.findParentByType("entityform");
					// 		var btn = formContainer.items.last();
					// 		var index = formContainer.ownerCt.rowIndex;
					// 		btn.setDisabled(!form.entity || !form.entity.actions|| !form.entity.actions[index] || !form.entity.actions[index].id);
					//
					// 	},

						setvalue: function(formContainer, v) {

							formContainer.toggleTemplatesButton();

						}
					},
					layout: "hbox",
					toggleTemplatesButton : function() {

						const type = this.findField('type').getValue();
						const name = this.findField('name').getValue();
						//composite field has an "innerCt" where non form fields are included only
						const btn = this.items.itemAt(1).innerCt.items.last();
						btn.setDisabled(type == 'task' || !name);
					},
					items: [{
						xtype: "hidden",
						name: "id"
					}, {
						flex: 1,
						xtype: "compositefield",
						hideLabel: true,
						defaults: {
							flex: 1,
						},
						items: [{
							placeholder: t("Name"),
							xtype: "textfield",
							name: "name",
							setFocus: true, //this will focus this field when a new item has been added
							anchor: "100%",
							listeners: {
								change: function(field, v) {
									const formContainer = field.findParentByType("formcontainer");
									formContainer.toggleTemplatesButton();
								}
							}
						}, {
							xtype: 'selectfield',
							name: 'type',
							placeholder: t('Type'),
							options: [['email', 'E-mail'], ['task', t('Task')]],
							value: 'email',
							anchor: "100%",
							listeners: {
								change: function(field, v) {
									const formContainer = field.findParentByType("formcontainer");
									formContainer.toggleTemplatesButton();
								}
							}
						}, {
							placeholder: t("Expires in (Days)"),
							xtype: "gonumberfield",
							name: "triggerInDays",
							allowBlank: false,
							decimals: 0,
							anchor: "100%"
						}, {
							disabled: true,
							xtype: "button",
							text: t("Edit templates"),
							handler: function (btn) {

								const index = btn.findParentByType("formgroupitemcontainer").rowIndex,
									form = btn.findParentByType("entityform");

								form.submit().then(() => {
									const actionId = form.entity.actions[index].id;

									var win = new go.modules.business.finance.DebtorProfileActionDialog({
										actionId: actionId
									});

									win.show();
								});
							},

							scope: this
						}]
					}]
				}
			}]
		}];
		return items;
	}
});
