go.modules.business.contracts.ContractBookDialog = Ext.extend(go.form.Dialog, {
	stateId: 'contracts-book-dialog',
	title: t('Book'),
	entityStore: "ContractBook",
	titleField: "name",
	width: dp(800),
	height: dp(600),

	onReady: function() {
		this.enableTemplates();
		this.supr().onReady.call(this);

		if(!this.currentId) {
			this.formPanel.form.findField("businessId").selectFirst();
		}
	},

	onSubmit: function() {
		if(this.templatesGrid.disabled) {
			this.closeOnSubmit = false;
			this.enableTemplates();

			this.templatesGrid.show();
			setTimeout(() => {
				this.closeOnSubmit = true;
			});
		}

		this.supr().onSubmit.call(this);
	},

	enableTemplates: function() {
		if(this.currentId) {
			this.templatesGrid.setDisabled(false);
			this.templatesGrid.setKey( "contract-book-" + this.currentId  );
			this.templatesGrid.store.load();
		}
	},

	initFormItems: function () {

		this.addPanel(new go.permissions.SharePanel());

		this.templatesGrid = new go.emailtemplate.GridPanel({
			autoHeight: false,
			disabled: true,
			title: t("E-mail Templates"),
			module: {
				name: "contracts",
				package: "business"
			},
			hideLabel: true
		});

		this.addPanel(this.templatesGrid);

		return [{
			xtype: 'fieldset',
			items: [
				{
					xtype: "businesscombo"
				},
				{
					xtype: 'textfield',
					name: 'name',
					fieldLabel: t("Name"),
					anchor: '100%',
					allowBlank: false,
				},

				{
					xtype: "textfield",
					name: "numberFormat",
					fieldLabel: t("Number format"),
					value: "C%Y-00000"
				},
				{
					xtype:"financebookcombo",
					hiddenName: "targetBookId"
				},

				{
					xtype: "numberfield",
					decimals: 0,
					name: "nextNumber",
					fieldLabel: t("Next number"),
					value: 1
				},
				{
					xtype: "textfield",
					name: "currency",
					fieldLabel: t("Currency"),
					value: go.User.currency
				},

				new go.form.RadioGroup({
					anchor: '100%',
					xtype: 'radiogroup',
					fieldLabel: t("Business model"),
					name: "businessModel",
					value: null,
					items: [
						{boxLabel: t("B2B"), inputValue: 'b2b'},
						{boxLabel: t("B2C"), inputValue: 'b2c'}
					]
				})

			]
		}
		];
	}
});
