create table business_catalog_article
(
    id                     int auto_increment
        primary key,
    filesFolderId          int                           null,
    createdBy              int                           not null,
    createdAt              datetime                      not null,
    modifiedBy             int                           not null,
    modifiedAt             datetime                      null,
    businessId             int unsigned                  not null,
    number                 varchar(100)                  null,
    name                   varchar(100)                  null,
    description            text                          null,
    cost                   decimal(19, 4) default 0.0000 null,
    price                  decimal(19, 4) default 0.0000 null,
    supplierOrganizationId int                           null,
    supplierNumber         varchar(190)   default ''     not null,
    vatRateId              int unsigned                  null,
    constraint business_catalog_article_addressbook_contact_id_fk
        foreign key (supplierOrganizationId) references addressbook_contact (id),
    constraint business_catalog_article_business_business_id_fk
        foreign key (businessId) references business_business (id)
            on delete cascade,
    constraint business_catalog_article_business_business_vat_rate_id_fk
        foreign key (vatRateId) references business_business_vat_rate (id)
);

create table business_catalog_article_custom_fields
(
    id          int auto_increment
        primary key,
    constraint business_catalog_article_custom_fields_ibfk_1
        foreign key (id) references business_catalog_article (id)
            on delete cascade
);

