/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
interface RadioOption {
    value?: string;
    text: string;
}
type RadioType = 'box' | 'button';
/**
 * Radio field
 *
 * @example
 * ```
 * radio({
 * 		type: "button",
 * 		value: "option1",
 * 	  name: "radio",
 * 		options: [
 * 			{text: "Option 1", value: "option1"},
 * 			{text: "Option 2", value: "option2"},
 * 			{text: "Option 3", value: "option3"}
 * 		]}
 * 	)
 * ```
 */
export declare class RadioField extends Field {
    private inputs;
    private _options?;
    readonly type: RadioType;
    protected baseCls: string;
    constructor(type?: RadioType);
    protected createLabel(): HTMLDivElement | void;
    protected createControl(): undefined | HTMLElement;
    set options(options: RadioOption[]);
    get options(): RadioOption[];
    set value(v: string | undefined);
    get value(): string | undefined;
}
/**
 * Shorthand function to create {@see RadioField}
 *
 * @param config
 */
export declare const radio: (config?: Config<RadioField, FieldEventMap<RadioField>>) => RadioField;
export {};
//# sourceMappingURL=RadioField.d.ts.map