import { Component, createComponent } from "../Component.js";
import { E } from "../../util/index.js";
import { checkbox } from "./CheckboxField.js";
export class CheckboxGroup extends Component {
    constructor() {
        super("fieldset");
        this.label = "";
        this.baseCls = "checkbox-group";
    }
    set options(options) {
        this.items.replace(...options.map(o => {
            o.type = "button";
            return checkbox(o);
        }));
    }
    createLabel() {
        return;
    }
    renderItems() {
        const label = E("h3").cls("legend");
        label.innerText = this.label;
        this.el.appendChild(label);
        return super.renderItems();
    }
    get itemContainerEl() {
        if (!this._itemContainerEl) {
            this._itemContainerEl = E("div").cls("goui group");
            this.el.appendChild(this._itemContainerEl);
        }
        return this._itemContainerEl;
    }
}
export const checkboxgroup = (config) => createComponent(new CheckboxGroup(), config);
//# sourceMappingURL=CheckboxGroup.js.map