var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// groupoffice-core/script/auth/AuthManager.ts
import { root } from "../../goui/script/index.js";

// groupoffice-core/script/jmap/Client.ts
import { Format, FunctionUtil, Observable } from "../../goui/script/index.js";

// groupoffice-core/node_modules/@fortaine/fetch-event-source/lib/esm/parse.js
function getBytes(stream, onChunk) {
  return __async(this, null, function* () {
    const reader = stream.getReader();
    let result;
    while (!(result = yield reader.read()).done) {
      onChunk(result.value);
    }
  });
}
function getLines(onLine) {
  let buffer;
  let position;
  let fieldLength;
  let discardTrailingNewline = false;
  return function onChunk(arr) {
    if (buffer === void 0) {
      buffer = arr;
      position = 0;
      fieldLength = -1;
    } else {
      buffer = concat(buffer, arr);
    }
    const bufLength = buffer.length;
    let lineStart = 0;
    while (position < bufLength) {
      if (discardTrailingNewline) {
        if (buffer[position] === 10) {
          lineStart = ++position;
        }
        discardTrailingNewline = false;
      }
      let lineEnd = -1;
      for (; position < bufLength && lineEnd === -1; ++position) {
        switch (buffer[position]) {
          case 58:
            if (fieldLength === -1) {
              fieldLength = position - lineStart;
            }
            break;
          case 13:
            discardTrailingNewline = true;
          case 10:
            lineEnd = position;
            break;
        }
      }
      if (lineEnd === -1) {
        break;
      }
      onLine(buffer.subarray(lineStart, lineEnd), fieldLength);
      lineStart = position;
      fieldLength = -1;
    }
    if (lineStart === bufLength) {
      buffer = void 0;
    } else if (lineStart !== 0) {
      buffer = buffer.subarray(lineStart);
      position -= lineStart;
    }
  };
}
function getMessages(onMessage, onId, onRetry) {
  let message = newMessage();
  const decoder = new TextDecoder();
  return function onLine(line, fieldLength) {
    if (line.length === 0) {
      onMessage === null || onMessage === void 0 ? void 0 : onMessage(message);
      message = newMessage();
    } else if (fieldLength > 0) {
      const field = decoder.decode(line.subarray(0, fieldLength));
      const valueOffset = fieldLength + (line[fieldLength + 1] === 32 ? 2 : 1);
      const value = decoder.decode(line.subarray(valueOffset));
      switch (field) {
        case "data":
          message.data = message.data ? message.data + "\n" + value : value;
          break;
        case "event":
          message.event = value;
          break;
        case "id":
          onId === null || onId === void 0 ? void 0 : onId(message.id = value);
          break;
        case "retry":
          const retry = parseInt(value, 10);
          if (!isNaN(retry)) {
            onRetry === null || onRetry === void 0 ? void 0 : onRetry(message.retry = retry);
          }
          break;
      }
    }
  };
}
function concat(a, b) {
  const res = new Uint8Array(a.length + b.length);
  res.set(a);
  res.set(b, a.length);
  return res;
}
function newMessage() {
  return {
    data: "",
    event: "",
    id: "",
    retry: void 0
  };
}

// groupoffice-core/node_modules/@fortaine/fetch-event-source/lib/esm/fetch.js
var __rest = function(s, e) {
  var t7 = {};
  for (var p in s)
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t7[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t7[p[i]] = s[p[i]];
    }
  return t7;
};
var EventStreamContentType = "text/event-stream";
var DefaultRetryInterval = 1e3;
var LastEventId = "last-event-id";
function fetchEventSource(input, _a) {
  var { signal: inputSignal, headers: inputHeaders, onopen: inputOnOpen, onmessage, onclose, onerror, openWhenHidden, fetch: inputFetch } = _a, rest = __rest(_a, ["signal", "headers", "onopen", "onmessage", "onclose", "onerror", "openWhenHidden", "fetch"]);
  return new Promise((resolve, reject) => {
    const headers = Object.assign({}, inputHeaders);
    if (!headers.accept) {
      headers.accept = EventStreamContentType;
    }
    let curRequestController;
    function onVisibilityChange() {
      curRequestController.abort();
      if (!document.hidden) {
        create();
      }
    }
    if (typeof document !== "undefined" && !openWhenHidden) {
      document.addEventListener("visibilitychange", onVisibilityChange);
    }
    let retryInterval = DefaultRetryInterval;
    let retryTimer = 0;
    function dispose() {
      if (typeof document !== "undefined" && !openWhenHidden) {
        document.removeEventListener("visibilitychange", onVisibilityChange);
      }
      clearTimeout(retryTimer);
      curRequestController.abort();
    }
    inputSignal === null || inputSignal === void 0 ? void 0 : inputSignal.addEventListener("abort", () => {
      dispose();
      resolve();
    });
    const fetchFn = inputFetch !== null && inputFetch !== void 0 ? inputFetch : fetch;
    const onopen = inputOnOpen !== null && inputOnOpen !== void 0 ? inputOnOpen : defaultOnOpen;
    function create() {
      return __async(this, null, function* () {
        var _a2;
        curRequestController = new AbortController();
        try {
          const response = yield fetchFn(input, Object.assign(Object.assign({}, rest), { headers, signal: curRequestController.signal }));
          yield onopen(response);
          yield getBytes(response.body, getLines(getMessages(onmessage, (id) => {
            if (id) {
              headers[LastEventId] = id;
            } else {
              delete headers[LastEventId];
            }
          }, (retry) => {
            retryInterval = retry;
          })));
          onclose === null || onclose === void 0 ? void 0 : onclose();
          dispose();
          resolve();
        } catch (err) {
          if (!curRequestController.signal.aborted) {
            try {
              const interval = (_a2 = onerror === null || onerror === void 0 ? void 0 : onerror(err)) !== null && _a2 !== void 0 ? _a2 : retryInterval;
              clearTimeout(retryTimer);
              retryTimer = setTimeout(create, interval);
            } catch (innerErr) {
              dispose();
              reject(innerErr);
            }
          }
        }
      });
    }
    create();
  });
}
function defaultOnOpen(response) {
  const contentType = response.headers.get("content-type");
  if (!(contentType === null || contentType === void 0 ? void 0 : contentType.startsWith(EventStreamContentType))) {
    throw new Error(`Expected content-type to be ${EventStreamContentType}, Actual: ${contentType}`);
  }
}

// groupoffice-core/script/jmap/JmapDataSource.ts
import {
  AbstractDataSource
} from "../../goui/script/index.js";
import { createComponent } from "../../goui/script/index.js";
var JmapDataSource = class extends AbstractDataSource {
  constructor() {
    super(...arguments);
    /**
     * The ID to use when committing
     */
    this._nextCallId = 1;
  }
  internalQuery(params) {
    var _a;
    return client.jmap(((_a = this.controllerRoute) != null ? _a : this.id) + "/query", params, this.useCallId());
  }
  /**
   * The call ID of the next JMAP method call. Useful for result references.
   */
  get nextCallId() {
    return this.id + "_" + this._nextCallId;
  }
  useCallId() {
    const callId = this.nextCallId;
    this._nextCallId++;
    return callId;
  }
  internalCommit(params) {
    return __async(this, null, function* () {
      var _a;
      try {
        return yield client.jmap(((_a = this.controllerRoute) != null ? _a : this.id) + "/set", params, this.useCallId());
      } catch (error) {
        if (error.type && error.type == "stateMismatch") {
          console.warn("statemismatch, we'll update and auto retry the JMAP set request");
          yield this.updateFromServer();
          params.ifInState = yield this.getState();
          return this.internalCommit(params);
        }
        throw error;
      }
    });
  }
  /**
   * This function makes sure the store is up to date. Should not be necessary but we ran into problems where tasks
   * were out of date when viewed. This should always prevent that.
   * @return {Promise<self>}
   */
  validateState() {
    return __async(this, null, function* () {
      var _a;
      const r = yield client.jmap(((_a = this.controllerRoute) != null ? _a : this.id) + "/get", {
        ids: []
      });
      yield this.checkState(r.state, r);
      return this;
    });
  }
  internalGet(ids) {
    var _a;
    return client.jmap(((_a = this.controllerRoute) != null ? _a : this.id) + "/get", {
      ids
    }, this.useCallId());
  }
  internalRemoteChanges(state) {
    return __async(this, null, function* () {
      var _a;
      return client.jmap(((_a = this.controllerRoute) != null ? _a : this.id) + "/changes", {
        sinceState: state
      }, this.useCallId());
    });
  }
};
var stores = {};
var jmapds = (storeId, config) => {
  if (!stores[storeId]) {
    stores[storeId] = createComponent(new JmapDataSource(storeId), config);
  }
  return stores[storeId];
};

// groupoffice-core/script/jmap/Client.ts
var _Client = class _Client extends Observable {
  constructor() {
    super();
    this._lastCallCounter = 0;
    this._requests = [];
    this._requestData = {};
    this.debugParam = "";
    this.uri = "";
    this.CSRFToken = "";
    /**
     * Either a cookie + CSRFToken are used when the API is on the same site. If it's not then an access token can be used
     *
     * @private
     */
    this.accessToken = "";
    this.SSEEventsRegistered = false;
    this.delayedJmap = FunctionUtil.buffer(0, () => {
      this.doJmap();
    });
  }
  set session(session) {
    delete session.debug;
    delete session.accounts;
    delete session.state;
    if (session.accessToken) {
      this.accessToken = session.accessToken;
      sessionStorage.setItem("accessToken", this.accessToken);
      delete session.accessToken;
    }
    this._session = session;
    if (session.CSRFToken) {
      this.CSRFToken = session.CSRFToken;
    }
  }
  /**
   * this should be firing on set session() but in GO we first have to load custom fields and modules before this fires.
   */
  fireAuth() {
    this.fire("authenticated", this, this._session);
  }
  get session() {
    if (this._session) {
      return Promise.resolve(this._session);
    }
    if (!this.accessToken) {
      this.accessToken = sessionStorage.getItem("accessToken") || "";
    }
    return this.request().then((response) => {
      return response.json();
    }).then((session) => {
      this.session = session;
      return this._session;
    });
  }
  /**
   * The ID of the last JMAP method call
   */
  get lastCallId() {
    return this._lastCallId;
  }
  isLoggedIn() {
    return __async(this, null, function* () {
      if (this.user) {
        return this.user;
      } else {
        try {
          const user = yield this.getUser();
          return user || false;
        } catch (e) {
          return false;
        }
      }
    });
  }
  request(data) {
    return __async(this, null, function* () {
      const response = yield fetch(this.uri + "jmap.php" + (this.debugParam ? "?" + this.debugParam : ""), {
        method: data ? "POST" : "GET",
        mode: "cors",
        credentials: "include",
        // for cookie auth
        headers: this.buildHeaders(),
        body: data ? JSON.stringify(data) : void 0
      });
      if (response.status != 200) {
        throw response.statusText;
      }
      return response;
    });
  }
  logout() {
    return __async(this, null, function* () {
      yield fetch(this.uri + "auth.php" + (this.debugParam ? "?" + this.debugParam : ""), {
        method: "DELETE",
        mode: "cors",
        credentials: "include",
        headers: this.buildHeaders()
      });
      this.CSRFToken = "";
      this.accessToken = "";
      sessionStorage.removeItem("accessToken");
      this.fire("logout", this);
    });
  }
  getBlobURL(blobId) {
    if (!_Client.blobCache[blobId]) {
      let type;
      _Client.blobCache[blobId] = fetch(client.downloadUrl(blobId), {
        method: "GET",
        credentials: "include",
        headers: this.buildHeaders()
      }).then((r) => {
        type = r.headers.get("Content-Type") || void 0;
        return r.arrayBuffer();
      }).then((ab) => URL.createObjectURL(new Blob([ab], { type })));
    }
    return _Client.blobCache[blobId];
  }
  downloadBlobId(blobId, filename) {
    return __async(this, null, function* () {
      const url = yield this.getBlobURL(blobId);
      const anchor = document.createElement("a");
      anchor.href = url;
      anchor.download = filename;
      anchor.click();
      console.log("Downloading: " + url);
      URL.revokeObjectURL(url);
    });
  }
  auth(data) {
    return fetch(this.uri + "auth.php" + (this.debugParam ? "?" + this.debugParam : ""), {
      method: "POST",
      mode: "cors",
      credentials: "include",
      headers: this.buildHeaders(),
      body: JSON.stringify(data)
    });
  }
  /**
   * Get the logged-in user.
   */
  getUser() {
    return __async(this, null, function* () {
      if (!this.user) {
        try {
          const session = yield this.session;
          if (!session) {
            return void 0;
          }
          const ds = jmapds("User");
          this.user = yield ds.single(session.userId);
          if (this.user) {
            Format.dateFormat = this.user.dateFormat;
            Format.timeFormat = this.user.timeFormat;
            Format.timezone = this.user.timezone;
            Format.currency = this.user.currency;
            Format.thousandsSeparator = this.user.thousandsSeparator;
            Format.decimalSeparator = this.user.decimalSeparator;
            return this.user;
          } else {
            return void 0;
          }
        } catch (reason) {
          this.user = void 0;
          return Promise.reject(reason);
        }
      }
      return this.user;
    });
  }
  downloadUrl(blobId) {
    return this.uri + "download.php?blob=" + encodeURIComponent(blobId);
  }
  pageUrl(path) {
    return `${this.uri}page.php/${path}`;
  }
  getDefaultHeaders() {
    const headers = {
      "Content-Type": "application/json"
    };
    if (this.accessToken) {
      headers.Authorization = "Bearer " + this.accessToken;
    }
    if (this.CSRFToken) {
      headers["X-CSRF-Token"] = this.CSRFToken;
    }
    return headers;
  }
  buildHeaders(headers = {}) {
    return Object.assign(this.getDefaultHeaders(), headers);
  }
  /**
   * Upload a file to the API
   *
   * @todo Progress. Not possible ATM with fetch() so we probably need XMLHttpRequest()
   * @param file
   */
  upload(file) {
    return fetch(this.uri + "upload.php" + (this.debugParam ? "?" + this.debugParam : ""), {
      // Your POST endpoint
      method: "POST",
      credentials: "include",
      headers: this.buildHeaders({
        "X-File-Name": "UTF-8''" + encodeURIComponent(file.name),
        "Content-Type": file.type,
        "X-File-LastModified": Math.round(file["lastModified"] / 1e3).toString()
      }),
      body: file
    }).then((response) => {
      if (response.status > 201) {
        throw response.statusText;
      }
      return response;
    }).then((response) => response.json()).then((response) => Object.assign(response, { file }));
  }
  /**
   * Upload multiple files to the API
   *
   * @example
   * ```
   * btn({
   * 	type: "button",
   * 	text: t("Attach files"),
   * 	icon: "attach_file",
   * 	handler: async () => {
   *
   * 		const files = await browser.pickLocalFiles(true);
   * 		this.mask();
   * 		const blobs = await client.uploadMultiple(files);
   * 		this.unmask();
   * 	  console.warn(blobs);
   *
   * 	}
   * })
   * ```
   * @param files
   */
  uploadMultiple(files) {
    const p = [];
    for (let f of files) {
      p.push(this.upload(f));
    }
    return Promise.all(p);
  }
  /**
   * Execute JMAP method
   *
   * Multiple calls will be joined together in a single call on the next event loop
   *
   * @param method
   * @param params
   */
  jmap(method, params = {}, callId = void 0) {
    if (callId === void 0) {
      callId = "call-" + ++this._lastCallCounter;
    }
    this._lastCallId = callId;
    const promise = new Promise((resolve, reject) => {
      this._requestData[callId] = {
        reject,
        resolve,
        params,
        method
      };
    });
    this._requests.push([method, params, callId]);
    this.delayedJmap();
    return promise;
  }
  /**
   * Performs the requests queued in the jmap() method
   *
   * @private
   */
  doJmap() {
    this.request(this._requests).then((response) => {
      return response.json();
    }).then((responseData) => {
      responseData.forEach((response) => {
        const callId = response[2];
        if (!this._requestData[callId]) {
          console.debug("Aborted");
          return true;
        }
        const success = response[0] !== "error";
        if (success) {
          this._requestData[callId].resolve(response[1]);
        } else {
          this._requestData[callId].reject(response[1]);
        }
        delete this._requestData[callId];
      });
    });
    this._requests = [];
  }
  /**
   * When SSE is disabled we'll poll the server for changes every 2 minutes.
   * This also keeps the token alive. Which expires in 30M.
   */
  updateAllDataSources(entities2) {
    entities2.forEach(function(entity) {
      const ds = jmapds(entity);
      ds.getState().then((state) => {
        if (state)
          ds.updateFromServer();
      });
    });
  }
  startPolling(entities2) {
    this.updateAllDataSources(entities2);
    this.pollInterval = setInterval(() => {
      this.updateAllDataSources(entities2);
    }, 6e4);
  }
  stopSSE() {
    if (this.SSEABortController) {
      this.SSEABortController.abort();
    }
    if (this.pollInterval) {
      clearInterval(this.pollInterval);
      this.pollInterval = void 0;
    }
  }
  /**
   * Initializes Server Sent Events via EventSource. This function is called in MainLayout.onAuthenticated()
   *
   * Note: disable this if you want to use xdebug because it will crash if you use SSE.
   *
   * @returns {Boolean}
   */
  startSSE(entities2) {
    return __async(this, null, function* () {
      try {
        this.SSELastEntities = entities2;
        if (!this.SSEEventsRegistered) {
          this.registerSSEEvents();
        }
        if (!window.navigator.onLine) {
          console.log("SSE not stated because we're offline");
          return false;
        }
        const session = yield this.session;
        if (!session.eventSourceUrl) {
          console.debug("Server Sent Events (EventSource) is disabled on the server.");
          this.startPolling(entities2);
          return false;
        }
        console.debug("Starting SSE");
        const url = this.uri + "sse.php?types=" + entities2.join(",") + (this.debugParam ? "&" + this.debugParam : "");
        const headers = this.buildHeaders();
        delete headers["Content-Type"];
        document.addEventListener("visibilitychange", () => {
          if (!document.hidden) {
            this.updateAllDataSources(entities2);
          }
        });
        this.SSEABortController = new AbortController();
        void fetchEventSource(url, {
          headers,
          signal: this.SSEABortController.signal,
          onmessage: (msg) => {
            try {
              const data = JSON.parse(msg.data);
              for (let entity in data) {
                let ds = jmapds(entity);
                ds.getState().then((state) => {
                  if (!state || state == data[entity]) {
                    return;
                  }
                  ds.updateFromServer();
                });
              }
            } catch (e) {
              console.warn(e);
            }
          },
          onclose: () => {
            this.startSSE(entities2);
          }
        });
      } catch (e) {
        console.error("Failed to start Server Sent Events. Perhaps the API URL in the system settings is invalid?", e);
      }
    });
  }
  registerSSEEvents() {
    this.SSEEventsRegistered = true;
    window.addEventListener("offline", () => {
      console.log("Closing SSE because we're offline");
      this.stopSSE();
    });
    window.addEventListener("online", () => {
      console.log("Starting SSE because we're online");
      this.startSSE(this.SSELastEntities);
    });
  }
};
_Client.blobCache = {};
var Client = _Client;
var client = new Client();

// groupoffice-core/script/jmap/Image.ts
import { comp, Component, createComponent as createComponent2 } from "../../goui/script/index.js";
var _Image = class _Image extends Component {
  constructor() {
    super("img");
    this.blobId = "";
  }
  internalRender() {
    const el = super.internalRender();
    el.src = _Image.defaultSrc;
    if (this.blobId) {
      this.setBlobId(this.blobId);
    }
    return el;
  }
  setBlobId(blobId) {
    this.blobId = blobId;
    client.getBlobURL(this.blobId).then((src) => {
      this.el.src = src;
    }).catch(console.error);
  }
  static replace(html) {
    const c = comp({
      html
    });
    _Image.replaceImages(c.el);
    return c;
  }
  /**
   * Replaces all img tags with a blob ID source from group-office with an objectURL
   *
   * @param el
   * @return Promise that resolves when all images are fully loaded
   */
  static replaceImages(el) {
    const promises = [];
    el.querySelectorAll("img").forEach((img2) => {
      let blobId = img2.dataset.blobId;
      if (!blobId) {
        const regex = new RegExp(`blob=([^">'&?].*)`);
        const matches = regex.exec(img2.src);
        if (matches && matches[1]) {
          blobId = matches[1];
        }
      }
      if (blobId) {
        img2.src = _Image.defaultSrc;
        promises.push(client.getBlobURL(blobId).then((src) => {
          img2.src = src;
        }).then(() => {
          return new Promise((resolve) => {
            img2.onload = img2.onerror = resolve;
          });
        }));
      }
    });
    return Promise.all(promises);
  }
};
_Image.cache = {};
_Image.defaultSrc = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
var Image = _Image;
var img = (config) => createComponent2(new Image(), config);

// groupoffice-core/script/auth/Login.ts
import {
  btn as btn2,
  cards,
  comp as comp3,
  fieldset as fieldset2,
  form,
  Notifier,
  t as t2,
  tbar as tbar2,
  textfield as textfield2,
  Window
} from "../../goui/script/index.js";

// groupoffice-core/script/auth/RegisterForm.ts
import { btn, comp as comp2, fieldset, Form, t, tbar, textfield } from "../../goui/script/index.js";
var RegisterForm = class extends Form {
  constructor() {
    super();
    this.handler = (form2) => __async(this, null, function* () {
      const data = { action: "register", user: form2.value };
      data.user.mail_reminders = true;
      const response = yield client.auth(data);
      switch (response.status) {
        case 201:
          client.session = yield response.json();
          break;
        default:
          form2.setInvalid(response.statusText);
          break;
      }
    });
    this.cls = "vbox fit";
    this.items.add(
      fieldset(
        { cls: "flow scroll", flex: 1 },
        comp2({
          tagName: "p",
          html: t("Please enter your e-mail address to register")
        }),
        textfield({
          label: t("Name"),
          name: "displayName",
          required: true
        }),
        textfield({
          type: "email",
          label: t("E-mail"),
          name: "email",
          required: true,
          listeners: {
            change: (field) => {
              if (!field.isValid()) {
                return;
              }
              const username = this.findField("username");
              if (username.isEmpty()) {
                username.value = field.value;
              }
            }
          }
        }),
        textfield({
          type: "text",
          label: t("Username"),
          name: "username",
          required: true
        }),
        textfield({
          required: true,
          type: "password",
          label: t("Password"),
          name: "password"
        }),
        textfield({
          itemId: "confirm",
          //item ID used instead of name so this field won't be submitted
          type: "password",
          label: t("Confirm password"),
          required: true,
          listeners: {
            validate: (field) => {
              const form2 = field.findAncestorByType(Form);
              if (field.value != form2.findField("password").value) {
                field.setInvalid("The passwords don't match");
              }
            }
          }
        })
      ),
      tbar(
        {},
        btn({
          type: "button",
          text: t("Cancel"),
          handler: () => {
            this.fire("cancel", this);
          }
        }),
        comp2({
          flex: 1
        }),
        btn({
          type: "submit",
          text: t("Register")
        })
      )
    );
  }
};

// groupoffice-core/script/auth/Login.ts
var Login = class extends Window {
  constructor() {
    super();
    this.loginToken = "";
    this.width = 480;
    this.height = 800;
    this.title = t2("Login");
    this.cls = "login";
    this.modal = true;
    this.resizable = true;
    this.on("close", (window2) => __async(this, null, function* () {
      if (!(yield client.isLoggedIn())) {
        yield Window.alert(t2("Login is required for this page. You will return to the previous page."), t2("Login required"));
        history.back();
      }
    }));
    this.loginForm = form(
      {
        cls: "vbox fit",
        handler: (form2) => {
          this.login(form2);
        }
      },
      fieldset2(
        {
          flex: "1",
          cls: "flow scroll"
        },
        comp3({
          tagName: "p",
          html: t2("Please enter your username and password")
        }),
        textfield2({
          label: t2("Username"),
          name: "username",
          autocomplete: "username",
          required: true
        }),
        textfield2({
          label: t2("Password"),
          type: "password",
          name: "password",
          autocomplete: "current-password",
          required: true
        }),
        btn2({
          style: {
            width: "100%"
          },
          type: "submit",
          text: t2("Login")
        }),
        btn2({
          style: {
            width: "100%"
          },
          cls: "filled",
          type: "button",
          text: t2("Register"),
          handler: () => {
            this.showRegisterForm();
          }
        }),
        comp3(
          { style: { display: "flex", justifyContent: "center" } },
          btn2({
            cls: "small",
            text: t2("Forgot password?"),
            type: "button",
            handler: () => {
              this.showForgotPassword();
            }
          })
        )
      )
    );
    this.otpForm = form(
      {
        flex: 1,
        hidden: true,
        handler: (form2) => {
          client.auth({
            loginToken: this.loginToken,
            authenticators: {
              otpauthenticator: form2.value
            }
          }).then((response) => {
            console.log(response);
            switch (response.status) {
              case 201:
                return this.onLoginSuccess(response);
              default:
                Notifier.error(response.statusText);
            }
          });
        }
      },
      fieldset2(
        {
          flex: "1",
          cls: "flow scroll"
        },
        comp3({
          tagName: "p",
          html: t2("Please provide the one time code from your device")
        }),
        textfield2({
          label: "Code",
          name: "otp_code",
          required: true,
          autocomplete: "one-time-code"
        })
      ),
      tbar2(
        {},
        btn2({
          type: "button",
          text: t2("Cancel"),
          handler: () => {
            this.close();
            this.fire("cancel");
          }
        }),
        comp3({
          flex: 1
        }),
        btn2({
          type: "submit",
          text: t2("Login")
        })
      )
    );
    this.cardContainer = cards({ flex: 1 }, this.loginForm, this.otpForm);
    this.items.add(this.cardContainer);
  }
  showForgotPassword() {
    if (!this.forgotPasswordForm) {
      this.forgotPasswordForm = form(
        {
          cls: "vbox fit",
          handler: (form2) => __async(this, null, function* () {
            this.loginForm.show();
            const response = yield client.auth(Object.assign({ action: "forgotten" }, form2.value));
            Notifier.success(t2("If an account was found, you should receive an e-mail with instructions shortly."));
          })
        },
        fieldset2(
          { flex: 1 },
          comp3({
            tagName: "p",
            text: t2("Please enter your e-mail address to receive an e-mail to reset your password.")
          }),
          textfield2({
            name: "email",
            type: "email",
            label: t2("E-mail"),
            required: true
          })
        ),
        tbar2(
          {},
          btn2({
            type: "button",
            text: t2("Cancel"),
            handler: () => {
              this.forgotPasswordForm.reset();
              this.loginForm.show();
            }
          }),
          comp3({
            flex: 1
          }),
          btn2({
            type: "submit",
            text: t2("Send")
          })
        )
      );
      this.cardContainer.items.add(this.forgotPasswordForm);
    }
    this.forgotPasswordForm.show();
    this.forgotPasswordForm.focus();
  }
  showRegisterForm() {
    if (!this.registerForm) {
      this.registerForm = new RegisterForm();
      this.registerForm.on("submit", (form2) => {
        if (form2.isValid()) {
          this.close();
          Notifier.success(t2("Registration and successful"));
          this.fire("login");
        }
      });
      this.registerForm.on("cancel", (form2) => {
        this.registerForm.reset();
        this.loginForm.show();
      });
      this.cardContainer.items.add(this.registerForm);
    }
    this.registerForm.show();
    this.registerForm.findField("displayName").focus();
  }
  focus(o) {
    this.loginForm.focus(o);
  }
  login(form2) {
    return __async(this, null, function* () {
      try {
        this.mask();
        const response = yield client.auth(form2.value);
        switch (response.status) {
          case 200:
            response.json().then((responseData) => {
              this.loginToken = responseData.loginToken;
              this.otpForm.show();
              this.otpForm.focus();
            });
            break;
          case 201:
            return this.onLoginSuccess(response);
          default:
            this.loginForm.findField("username").setInvalid(response.statusText);
            Notifier.error(response.statusText);
        }
      } catch (e) {
        Notifier.error("Sorry, an unexpected error occurred: " + e);
      } finally {
        this.unmask();
      }
    });
  }
  onLoginSuccess(response) {
    return __async(this, null, function* () {
      client.session = yield response.json();
      Notifier.success(t2("Logged in successfully"));
      this.close();
      this.fire("login");
    });
  }
};

// groupoffice-core/script/auth/AuthManager.ts
var AuthManager = class {
  /**
   * Will continue if user is authenticated and present login dialog if not
   *
   * @todo what if there are concurrent requests to this method?
   */
  requireLogin() {
    return __async(this, null, function* () {
      if (this._requireLogin) {
        return this._requireLogin;
      }
      this._requireLogin = new Promise((resolve) => __async(this, null, function* () {
        root.mask();
        let user = yield client.isLoggedIn();
        root.unmask();
        while (!user) {
          yield this.showLogin();
          user = yield client.isLoggedIn();
        }
        resolve(user);
      }));
      return this._requireLogin;
    });
  }
  showLogin() {
    return new Promise((resolve, reject) => {
      const login = new Login();
      login.show();
      login.on("login", () => {
        resolve();
      });
      login.on("cancel", () => {
        reject();
      });
    });
  }
};
var authManager = new AuthManager();

// groupoffice-core/script/Modules.ts
import { translate } from "../../goui/script/index.js";
var GouiMainPanel;
if (window.GO) {
  client.uri = BaseHref + "api/";
  GO.mainLayout.on("authenticated", () => {
    client.session = go.User.session;
    translate.load(GO.lang.core.core, "core", "core");
    client.fireAuth();
  });
  GouiMainPanel = Ext.extend(go.modules.ModulePanel, {
    callback: void 0,
    cls: "go-module-panel goui-module-panel",
    initComponent: function() {
      GouiMainPanel.superclass.initComponent.call(this);
      this.on("afterrender", () => __async(this, null, function* () {
        const comp8 = yield this.callback();
        comp8.render(this.body.dom);
      }), this);
    }
  });
}
var Modules = class {
  constructor() {
    this.mods = [];
  }
  /**
   * Register a module so it's functionally is added to the GUI
   *
   * @param config
   */
  register(config) {
    this.mods.push(config);
    this.registerInExtjs(config);
    go.Translate.package = config.package;
    go.Translate.module = config.name;
    if (config.init) {
      config.init();
    }
  }
  /**
   * Add a main panel that is accessible through the main menu and tabs
   *
   * @param pkg
   * @param module
   * @param id
   * @param title
   * @param callback
   */
  addMainPanel(pkg, module, id, title, callback) {
    go.Translate.package = go.package = pkg;
    go.Translate.module = go.module = module;
    const proto = Ext.extend(GouiMainPanel, {
      id,
      title,
      callback
    });
    proto.package = pkg;
    proto.module = module;
    go.Modules.addPanel(proto);
  }
  /**
   * Open a main panel
   *
   * @param id
   */
  openMainPanel(id) {
    GO.mainLayout.openModule(id);
  }
  registerInExtjs(config) {
    go.Modules.register(config.package, config.name, {
      entities: config.entities
    });
  }
  /**
   * Get all modules
   */
  getAll() {
    return __async(this, null, function* () {
      if (!this.modules) {
        const mods = yield jmapds("Module").get();
        this.modules = mods.list;
      }
      return this.modules;
    });
  }
  /**
   * Check if the current user has this module
   *
   * @param pkg
   * @param name
   */
  isAvailable(pkg, name) {
    return go.Modules.isAvailable(pkg, name);
  }
  /**
   * Get a module
   *
   * @param pkg
   * @param name
   */
  get(pkg, name) {
    const mod = go.Modules.get(pkg, name);
    return mod ? mod : void 0;
  }
};
var modules = new Modules();

// groupoffice-core/script/Router.ts
import { Router as GouiRouter } from "../../goui/script/index.js";
var Router = class extends GouiRouter {
  add(re, handler) {
    go.Router.add(re, handler);
    return this;
  }
  setPath(path) {
    const oldPath = this.getPath();
    go.Router.setPath(path);
    this.fire("change", this.getPath(), oldPath);
  }
  start() {
    return Promise.resolve();
  }
  reload() {
    go.Router.check();
  }
};
var router = new Router();

// groupoffice-core/script/Validators.ts
function validateEmail(email) {
  return /\S+@\S+\.\S+/.test(email);
}

// groupoffice-core/script/permissions/SharePanel.ts
import {
  comp as comp4,
  createComponent as createComponent3,
  radio,
  t as t3,
  tbar as tbar3,
  searchbtn,
  Table,
  datasourcestore,
  column,
  avatar,
  select,
  Field,
  small
} from "../../goui/script/index.js";

// groupoffice-core/script/Entities.ts
var Entities = class {
  get(name) {
    return __async(this, null, function* () {
      var _a;
      if (!this.entities) {
        const mods = yield modules.getAll();
        this.entities = {};
        mods.forEach((m) => {
          for (let name2 in m.entities) {
            this.entities[name2] = m.entities[name2];
          }
        });
      }
      return (_a = this.entities[name]) != null ? _a : void 0;
    });
  }
};
var entities = new Entities();

// groupoffice-core/script/permissions/SharePanel.ts
var GroupTable = class extends Table {
  constructor(sharePanel) {
    super(
      datasourcestore({
        dataSource: jmapds("Group"),
        queryParams: {
          filter: {
            hideUsers: true,
            hideGroups: false
          }
        },
        sort: [{
          property: "name"
        }]
      }),
      [
        column({
          header: t3("Name"),
          id: "name",
          renderer: (columnValue, record, td, table, storeIndex) => __async(this, null, function* () {
            const first = record.users.slice(0, 3);
            const users = yield jmapds("User").get(first);
            let memberStr = users.list.map((u) => u.displayName).join(", ");
            const more = record.users.length - 3;
            if (more > 0) {
              memberStr += t3(" and {count} more").replace("{count}", more);
            }
            let user;
            if (record.isUserGroupFor) {
              user = yield jmapds("User").single(record.isUserGroupFor);
            }
            return comp4(
              { cls: "hbox" },
              avatar({
                displayName: record.name,
                backgroundImage: user && user.avatarId ? go.Jmap.downloadUrl(user.avatarId) : void 0
              }),
              comp4(
                { flex: 1 },
                comp4({ text: record.name }),
                small({ text: memberStr })
              )
            );
          })
        }),
        column({
          id: "level",
          width: 120,
          header: t3("Level"),
          renderer: (columnValue, record, td, table, storeIndex) => {
            var _a;
            return select({
              value: this.value ? (_a = this.value[record.id]) != null ? _a : void 0 : void 0,
              options: sharePanel.levels || [
                { value: "", name: "" },
                { value: 10, name: t3("Read") },
                { value: 20, name: t3("Create") },
                { value: 30, name: t3("Write") },
                { value: 40, name: t3("Delete") },
                { value: 50, name: t3("Manage") }
              ],
              listeners: {
                change: (field, newValue, oldValue) => {
                  this.value[record.id] = newValue ? newValue : null;
                }
              }
            });
          }
        })
      ]
    );
    this.fitParent = true;
    this.cls = "goui-share-panel";
  }
  setEntity(name, id) {
    this.store.queryParams.filter.inAcl = { entity: name, id };
    if (!id) {
      entities.get(name).then((entity) => {
        this.value = entity.defaultAcl;
      });
    }
  }
};
var SharePanel = class extends Field {
  constructor() {
    super("div");
    this.name = "acl";
    this.cls = "vbox";
    this.title = t3("Permissions");
    this.groupTable = new GroupTable(this);
    this.items.add(
      tbar3(
        {},
        radio({
          type: "button",
          value: "groups",
          listeners: {
            change: (field, newValue, oldValue) => {
              const f = this.groupTable.store.queryParams.filter;
              switch (newValue) {
                case "both":
                  f.hideUsers = false;
                  f.hideGroups = false;
                  break;
                case "users":
                  f.hideUsers = false;
                  f.hideGroups = true;
                  break;
                case "groups":
                  f.hideUsers = true;
                  f.hideGroups = false;
                  break;
              }
              this.groupTable.store.load();
            }
          },
          options: [
            {
              text: t3("All"),
              value: "both"
            },
            {
              text: t3("Users"),
              value: "users"
            },
            {
              text: t3("Groups"),
              value: "groups"
            }
          ]
        }),
        "->",
        searchbtn({
          listeners: {
            input: (sender, text) => {
              this.groupTable.store.queryParams.filter.text = text;
              void this.groupTable.store.load();
            }
          }
        })
      ),
      comp4(
        { cls: "scroll fit", flex: 1 },
        this.groupTable
      )
    );
  }
  createLabel() {
  }
  setEntity(name, id) {
    this.groupTable.setEntity(name, id);
  }
  load() {
    this.groupTable.store.load();
  }
  internalSetValue(v) {
    this.groupTable.value = v;
    return super.internalSetValue(v);
  }
};
var sharepanel = (config) => createComponent3(new SharePanel(), config);

// groupoffice-core/script/components/FormWindow.ts
import {
  btn as btn3,
  cardmenu,
  cards as cards2,
  comp as comp5,
  containerfield,
  datasourceform,
  t as t4,
  tbar as tbar4,
  Window as Window2
} from "../../goui/script/index.js";
var FormWindow = class extends Window2 {
  /**
   * Constructor
   *
   * @param entityName Name of the entity for the datasource form
   * @protected
   */
  constructor(entityName) {
    super();
    this.entityName = entityName;
    this.closeWithModifications = false;
    this.baseCls = "goui-window form-window";
    this.cls = "vbox";
    this.width = 460;
    this.height = 640;
    this.items.add(
      this.form = datasourceform(
        {
          dataSource: jmapds(this.entityName),
          cls: "vbox",
          flex: 1,
          listeners: {
            save: (form2, data) => {
              this.currentId = data.id;
              this.closeWithModifications = true;
              this.close();
            },
            invalid: (form2) => {
              const invalid = form2.findFirstInvalid();
              if (invalid) {
                const tab = invalid.findAncestor((cmp) => {
                  return cmp.el.classList.contains("card-container-item");
                });
                if (tab) {
                  tab.show();
                }
                invalid.focus();
              }
            }
          }
        },
        this.cardMenu = cardmenu(),
        this.cards = cards2(
          { flex: 1 },
          this.generalTab = comp5(
            {
              cls: "scroll fit",
              title: t4("General")
            }
          )
        ),
        tbar4(
          { cls: "border-top" },
          "->",
          btn3({
            type: "submit",
            text: t4("Save")
          })
        )
      )
    );
    this.on("show", () => {
      return this.onShow();
    });
    this.on("beforeclose", () => {
      return this.onBeforeClose();
    });
  }
  onBeforeClose() {
    if (this.closeWithModifications) {
      return true;
    }
    if (this.form.isModified()) {
      Window2.confirm(t4("Are you sure you want to close this window and discard your changes?")).then((confirmed) => {
        if (confirmed) {
          this.closeWithModifications = true;
          this.close();
        }
      });
      return false;
    }
  }
  onShow() {
    setTimeout(() => {
      this.cardMenu.hidden = this.cards.items.count() < 2;
      if (!this.currentId) {
        this.form.focus();
        this.fire("ready", this, this.currentId);
      }
    });
  }
  /**
   * Add a share panel to set permissions
   *
   * @params options if not provided the default is:
   * [
   * 	{value: "", name: ""},
   * 	{value: 10, name: t("Read")},
   * 	{value: 20, name: t("Create")},
   * 	{value: 30, name: t("Write")},
   * 	{value: 40, name: t("Delete")},
   * 	{value: 50, name: t("Manage")}
   * ]
   */
  addSharePanel(levels) {
    this.sharePanel = sharepanel({
      cls: "fit",
      levels,
      listeners: {
        show: () => {
          this.sharePanel.load();
        }
      }
    });
    this.cards.items.add(this.sharePanel);
    this.on("ready", () => {
      this.sharePanel.setEntity(this.entityName, this.currentId);
    });
  }
  load(id) {
    return __async(this, null, function* () {
      this.mask();
      try {
        this.currentId = id;
        yield this.form.load(id);
        this.fire("ready", this, this.currentId);
      } catch (e) {
        void Window2.alert(t4("Error"), e + "");
      } finally {
        this.unmask();
      }
      return this;
    });
  }
  addCustomFields() {
    this.on("render", () => {
      if (this.hidden) {
        this.on("show", () => this.renderCustomFields());
      } else {
        this.renderCustomFields();
      }
    });
  }
  renderCustomFields() {
    if (go.Entities.get(this.entityName).customFields) {
      const fieldsets = go.customfields.CustomFields.getFormFieldSets(this.entityName);
      fieldsets.forEach((fs) => {
        fs.cascade((item) => {
          if (item.getName) {
            let fieldName = item.getName().replace("customFields.", "");
            item.name = item.hiddenName = fieldName;
          }
        });
        if (fs.fieldSet.isTab) {
          fs.title = null;
          fs.collapsible = false;
          this.cards.items.add(
            containerfield(
              {
                name: "customFields",
                cls: "scroll",
                title: fs.fieldSet.name,
                listeners: {
                  show: () => {
                    fs.doLayout();
                  }
                }
              },
              fs
            )
          );
        } else {
          fs.columnWidth = 1;
          this.generalTab.items.add(containerfield({ name: "customFields" }, fs));
        }
      }, this);
    }
  }
  /**
   * Adds a link between two entities on save.
   *
   * @param {string} entityName - The name of the target entity.
   * @param {string} entityId - The ID of the target entity.
   * @return {void}
   */
  addLinkOnSave(entityName, entityId) {
    const unbindkey = this.form.on("save", (form1, data) => {
      const link = {
        "toId": entityId,
        "toEntity": entityName,
        "fromId": data.id,
        "fromEntity": this.entityName
      };
      jmapds("Link").create(link).catch((e) => {
        Window2.error(e.message);
      });
    }, { once: true });
    this.on("close", () => {
      setTimeout(() => {
        this.form.un("save", unbindkey);
      });
    });
  }
};

// groupoffice-core/script/components/DetailPanel.ts
import {
  comp as comp6,
  Component as Component5,
  FunctionUtil as FunctionUtil2,
  tbar as tbar5,
  Window as Window3
} from "../../goui/script/index.js";
var DetailPanel = class extends Component5 {
  constructor(entityName) {
    super();
    this.entityName = entityName;
    jmapds(this.entityName).on("change", (ds, changes) => {
      if (this.entity) {
        const id = this.entity.id + "";
        if (changes.updated && changes.updated.indexOf(id) > -1) {
          this.load(this.entity.id);
        }
        if (changes.destroyed && changes.destroyed.indexOf(id) > -1) {
          this.reset();
          const rPath = router.getPath();
          if (rPath.match("/" + id + "$")) {
            router.setPath(rPath.substring(0, rPath.length - id.length - 1));
          }
        }
      }
    });
    this.baseCls = "detail";
    this.disabled = true;
    this.cls = "vbox";
    this.items.add(
      this.toolbar = this.createToolbar(),
      this.scroller = comp6({ flex: 1, cls: "scroll", hidden: true })
    );
  }
  get legacyDetailView() {
    if (!this.detailView) {
      const ro = new ResizeObserver(FunctionUtil2.onRepaint(() => {
        this.detailView.doLayout();
      }));
      ro.observe(this.el);
      this.detailView = new go.detail.Panel({
        width: void 0,
        entityStore: go.Db.store(this.entityName),
        header: false
      });
      this.scroller.items.add(this.detailView);
    }
    return this.detailView;
  }
  addCustomFields() {
    this.legacyDetailView.addCustomFields();
  }
  addLinks() {
    this.legacyDetailView.addLinks();
  }
  addComments() {
    this.legacyDetailView.addComments();
  }
  addFiles() {
    this.legacyDetailView.addFiles();
  }
  addHistory() {
    this.legacyDetailView.addHistory();
  }
  createToolbar() {
    return tbar5(
      {
        cls: "border-bottom"
      },
      "->"
    );
  }
  set title(title) {
    super.title = title;
    if (this.titleCmp) {
      this.titleCmp.text = title;
    }
  }
  get title() {
    return super.title;
  }
  load(id) {
    return __async(this, null, function* () {
      this.mask();
      try {
        this.entity = yield jmapds(this.entityName).single(id.toString());
        if (!this.entity) {
          throw "notfound";
        }
        this.scroller.hidden = false;
        this.disabled = false;
        this.fire("load", this, this.entity);
        this.legacyOnLoad();
      } catch (e) {
        console.error(e);
        void Window3.error(e + "");
      } finally {
        this.unmask();
      }
      return this;
    });
  }
  reset() {
    this.entity = void 0;
    this.title = "";
    if (this.detailView) {
      this.detailView.reset();
    }
    this.disabled = true;
    this.scroller.hidden = true;
    this.fire("reset", this);
  }
  legacyOnLoad() {
    if (this.detailView) {
      this.detailView.currentId = this.entity.id;
      this.detailView.internalLoad(this.entity);
    }
  }
};

// groupoffice-core/script/components/UserDisplayCombo.ts
import { ComboBox, createComponent as createComponent4, t as t5 } from "../../goui/script/index.js";
var UserDisplayCombo = class extends ComboBox {
  constructor() {
    super(jmapds("UserDisplay"), "displayName");
    this.label = t5("User");
    this.name = "userId";
    this.filterName = "text";
  }
};
var userdisplaycombo = (config) => createComponent4(new UserDisplayCombo(), config);

// groupoffice-core/script/components/AddButton.ts
import { Component as Component6, createComponent as createComponent5 } from "../../goui/script/index.js";
var AddButton = class extends Component6 {
  constructor() {
    super();
    this.on("added", (comp8, index) => {
      const panel = this.findAncestor((cmp) => {
        return cmp instanceof DetailPanel;
      });
      this.items.get(0).detailView = panel.detailView;
    });
    this.items.add(new go.detail.addButton({
      // detailView: this.detailView
    }));
  }
};
var addbutton = (config) => createComponent5(new AddButton(), config);

// groupoffice-core/script/components/FilterPanel.ts
import { comp as comp7, Component as Component7, createComponent as createComponent6, FunctionUtil as FunctionUtil3 } from "../../goui/script/index.js";
var FilterPanel = class extends Component7 {
  constructor(entityName, store2) {
    super();
    this.entityName = entityName;
    this.store = store2;
    this.items.add(
      comp7(
        {},
        //somehow an extra comp is needed for the ext toolbar to resize properly
        this.goFilterPanel = new go.filter.FilterPanel({
          entity: entityName,
          store: store2
        })
      )
    );
    this.on("render", () => {
      const ro = new ResizeObserver(FunctionUtil3.onRepaint(() => {
        this.goFilterPanel.setWidth(this.el.offsetWidth);
      }));
      ro.observe(this.el);
    });
  }
};
var filterpanel = (config) => createComponent6(new FilterPanel(config.entityName, config.store), config);

// groupoffice-core/script/components/FilesButton.ts
import { Component as Component8, createComponent as createComponent7 } from "../../goui/script/index.js";
var FilesButton = class extends Component8 {
  constructor() {
    super();
    this.on("added", (comp8, index) => {
      const panel = this.findAncestor((cmp) => {
        return cmp instanceof DetailPanel;
      });
      this.items.get(0).detailView = panel.detailView;
    });
    this.items.add(new GO.files.DetailFileBrowserButton({
      // detailView: this.detailView
    }));
  }
};
var filesbutton = (config) => createComponent7(new FilesButton(), config);

// groupoffice-core/script/components/LinkBrowserButton.ts
import { Component as Component9, createComponent as createComponent8 } from "../../goui/script/index.js";
var LinkBrowserButton = class extends Component9 {
  constructor() {
    super();
    this.on("added", (comp8, index) => {
      const panel = this.findAncestor((cmp) => {
        return cmp instanceof DetailPanel;
      });
      this.items.get(0).detailView = panel.detailView;
    });
    this.items.add(new go.links.LinkBrowserButton({
      // detailView: this.detailView
    }));
  }
};
var linkbrowserbutton = (config) => createComponent8(new LinkBrowserButton(), config);

// groupoffice-core/script/components/MainThreeColumnPanel.ts
import { Component as Component10, splitter, btn as btn4, t as t6, router as router2 } from "../../goui/script/index.js";
var MainThreeColumnPanel = class extends Component10 {
  /**
   * Constructor
   *
   * @param idAndRoute Used for state saving and also as the route to the main panel
   * @protected
   */
  constructor(idAndRoute) {
    super("section");
    this.id = idAndRoute;
    this.cls = "hbox fit mobile-cards";
    this.center = this.createCenter();
    this.center.itemId = "center";
    this.center.el.classList.add("active");
    this.west = this.createWest();
    this.west.itemId = "west";
    this.east = this.createEast();
    this.east.itemId = "east";
    this.items.add(
      this.west,
      splitter({
        resizeComponentPredicate: "west",
        stateId: this.id + "-west-splitter",
        minSize: 140
      }),
      this.center,
      splitter({
        stateId: this.id + "-east-splitter",
        resizeComponentPredicate: "east"
      }),
      this.east
    );
  }
  /**
   * Button to show the west panel. Use in overrides.
   *
   * @protected
   */
  showWestButton() {
    return btn4({
      cls: "for-small-device",
      title: t6("Menu"),
      icon: "menu",
      handler: (button, ev) => {
        this.activatePanel(this.west);
      }
    });
  }
  /**
   * Button to show the center panel. Use in overrides.
   * @protected
   */
  showCenterButton() {
    return btn4({
      cls: "for-small-device",
      title: t6("Close"),
      icon: "close",
      handler: (button, ev) => {
        this.activatePanel(this.center);
        router2.setPath(this.id);
      }
    });
  }
  /**
   * Activate the given panel
   *
   * @param active
   */
  activatePanel(active) {
    this.center.el.classList.remove("active");
    this.east.el.classList.remove("active");
    this.west.el.classList.remove("active");
    active.el.classList.add("active");
  }
};
export {
  AddButton,
  Client,
  DetailPanel,
  FilesButton,
  FilterPanel,
  FormWindow,
  Image,
  JmapDataSource,
  LinkBrowserButton,
  Login,
  MainThreeColumnPanel,
  RegisterForm,
  SharePanel,
  UserDisplayCombo,
  addbutton,
  authManager,
  client,
  filesbutton,
  filterpanel,
  img,
  jmapds,
  linkbrowserbutton,
  modules,
  router,
  sharepanel,
  userdisplaycombo,
  validateEmail
};
/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
//# sourceMappingURL=index.js.map
