import { storeRecordType } from "../../data";
import { Component, ComponentEventMap } from "../Component";
import { List, listStoreType } from "../List";
import { Config, Listener, ObservableListenerOpts } from "../Observable";
export type listPickerListType<ListPickerType> = ListPickerType extends ListPicker<infer ListType> ? ListType : never;
export interface ListPickerEventMap<Type extends ListPicker<List>> extends ComponentEventMap<Type> {
    select: (listPicker: Type, record: storeRecordType<listStoreType<listPickerListType<Type>>>) => false | void;
}
export interface ListPicker<ListType extends List = List> extends Component {
    on<K extends keyof ListPickerEventMap<this>, L extends Listener>(eventName: K, listener: Partial<ListPickerEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof ListPickerEventMap<this>>(eventName: K, listener: Partial<ListPickerEventMap<this>>[K]): boolean;
    fire<K extends keyof ListPickerEventMap<this>>(eventName: K, ...args: Parameters<ListPickerEventMap<any>[K]>): boolean;
}
export declare class ListPicker<ListType extends List = List> extends Component {
    readonly list: ListType;
    constructor(list: ListType);
    focus(o?: FocusOptions): void;
    onSelect(): void;
}
export type ListPickerConfig<ListType extends List> = Config<ListPicker<ListType>, ListPickerEventMap<ListPicker<ListType>>, "list">;
/**
 * Shorthand function to create {@see Table}
 *
 * @param config
 */
export declare const listpicker: <ListType extends List<import("../../data").Store<import("../../data").StoreRecord>> = List<import("../../data").Store<import("../../data").StoreRecord>>>(config: ListPickerConfig<ListType>) => ListPicker<ListType>;
//# sourceMappingURL=ListPicker.d.ts.map