/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
/**
 * TextField component
 *
 * @see Form
 */
export declare class HiddenField extends Field {
    protected baseCls: string;
    constructor();
}
/**
 * Shorthand function to create {@see HiddenField}
 *
 * @param config
 */
export declare const hiddenfield: (config?: Config<HiddenField, FieldEventMap<HiddenField>>) => HiddenField;
//# sourceMappingURL=HiddenField.d.ts.map