go.modules.business.contracts.ReportWindow = Ext.extend(go.Window, {

	title: t("Annual value"),
	layout: "fit",
	width: dp(1200),
	height: dp(600),
	initComponent: function() {


		this.items = [
			this.chart = new go.chart.LineChart({
				height: dp(200),
				width: "auto",
				options: {
					seriesBarDistance: 5,
					axisX: {
						offset: dp(32)
					},
					axisY: {
						offset: dp(48),
						labelInterpolationFnc: function(value) {
							return value > 1000 ? (value / 1000) + "k" : value;
						},
						scaleMinSpace: dp(16)
					},
					plugins: [
						Chartist.plugins.tooltip({
							currency: '€ '
						})
					]
				}

			})
		];



		go.modules.business.finance.MonthlyReportWindow.superclass.initComponent.call(this);
	},

	load: async function(bookId, year) {
		this.bookId = bookId;
		const book = await go.Db.store("FinanceBook").single(bookId);

		this.setTitle(t("Annual value") + " - " + book.name);

		this.updateYearChart();
	},

	updateYearChart: function() {

		this.chartMaxYear = (new Date).getFullYear();
		this.chartMinYear = this.chartMaxYear - 10;
		this.chartSeries = [];

		this.totals = {};
		const promises = [];

		for(let i = this.chartMinYear; i <= this.chartMaxYear; i++) {
			promises.push(this.getYearTotals(i));
		}

		Promise.all(promises).then(() => {
			this.chart.update([Object.values(this.chartSeries)], Object.keys(this.chartSeries));
		});

	},

	getYearTotals : function(year) {
		return go.Jmap.request({
			method: "Contract/yearTotals",
			params: {
				bookId: this.bookId,
				date: year + "-12-31"
			}
		}).then((total) => {

			const series = [];
			this.chartSeries[year] = total;

		});
	}

});
