Ext.define('go.modules.business.business.VatRateCombo', {
	extend: go.form.ComboBox,

	fieldLabel: t("VAT Rate"),
	hiddenName: 'vatRateId',
	tpl: new Ext.XTemplate(
		'<tpl for=".">',
		'<div class="x-combo-list-item">' +
		'{name} <small>{rate}%</small>' +
		'</div>',
		'</tpl>'
	),
	emptyText: t("Please select..."),
	displayField : 'name',
	valueField: 'id',
	triggerAction: 'all',
	mode:'local',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: false,
	initComponent: function() {
		if(!this.store) {
			this.store = new Ext.data.JsonStore({
				fields: ['id', 'name', 'rate'],
				root: "records",
				autoDestroy: true
			});
		}
	},
	setBusiness :  function(business) {
		this.store.loadData({records: business.vatRates});
		var v = this.getValue();
		if(!v && business.vatRates[0]) {
			v = business.vatRates[0].id;
		}
		this.setValue(v);
	}
});

Ext.reg("vatratecombo",go.modules.business.business.VatRateCombo);