<?php
namespace go\modules\business\automation;

use go\core;
use go\core\cron\GarbageCollection;
use go\core\db\Query;
use go\core\model;
use go\core\model\EmailTemplate;
use go\modules\business\automation\cron\AutomationCron;
use go\modules\business\automation\model\Automation;

/**
 * @copyright (c) 2022, Intermesh BV https://www.intermesh.nl
 * @author Intermesh Administrator <admin@intermesh.dev>
 * @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
 */
class Module extends core\Module
{
	public function getAuthor(): string
	{
		return "Intermesh Administrator <admin@intermesh.dev>";
	}

	public function requiredLicense(): ?string
	{
		return "groupoffice-pro";
	}

	public function defineListeners()
	{
		parent::defineListeners();

		GarbageCollection::on(GarbageCollection::EVENT_RUN, static::class, 'onGarbageCollection');
	}

	public static function onGarbageCollection() {

		//clean up templates where actions have been removed
		$moduleId = static::get()->getModel()->id;
		EmailTemplate::delete(
			(new core\orm\Query())
				->where(['moduleId' => $moduleId])
				->where('key', 'NOT IN', Automation::find()->selectSingleValue('id'))
		);
	}

	protected function afterInstall(model\Module $model): bool
	{
		AutomationCron::install("*/10 * * * *");

		return parent::afterInstall($model);

	}


}
