import { BaseEntity, Component, EntityID } from "@intermesh/goui";
import { Entity } from "./Entities";
export interface EntityFilter {
    name: string;
    type: string;
    typeConfig?: Record<string, any>;
    title: string;
    multiple: boolean;
}
export interface EntityLink {
    title?: string;
    iconCls: string;
    linkWindow: (entity: string, entityId: EntityID) => void;
    linkDetail: () => void;
}
export interface EntityConfig {
    name: string;
    links?: EntityLink[];
    filters?: EntityFilter[];
}
export type ModuleConfig = {
    /**
     * Module package name
     */
    package: string;
    /**
     * Module name
     */
    name: string;
    /**
     * Init function. Is called when the main Group-Office page loads
     */
    init?: () => void;
    /**
     * Registered module entities
     */
    entities?: (string | EntityConfig)[];
};
declare global {
    var GO: any;
    var go: any;
    var Ext: any;
    var BaseHref: string;
}
export interface Module extends BaseEntity {
    name: string;
    package: string;
    rights: string[];
    settings?: Record<string, any>;
    userRights: Record<string, boolean>;
    version: number;
    entities: Record<string, Entity>;
}
declare class Modules {
    private mods;
    private modules?;
    /**
     * Register a module so it's functionally is added to the GUI
     *
     * @param config
     */
    register(config: ModuleConfig): void;
    /**
     * Add a main panel that is accessible through the main menu and tabs
     *
     * @param pkg
     * @param module
     * @param id
     * @param title
     * @param callback
     */
    addMainPanel(pkg: string, module: string, id: string, title: string, callback: () => Component | Promise<Component>): void;
    /**
     * Add a system settings panel
     *
     * @param pkg
     * @param module
     * @param id
     * @param title
     * @param icon
     * @param callback
     */
    addSystemSettingsPanel(pkg: string, module: string, id: string, title: string, icon: string, callback: () => Component | Promise<Component>): void;
    /**
     * Open a main panel
     *
     * @param id
     */
    openMainPanel(id: string): void;
    private registerInExtjs;
    /**
     * Get all modules
     */
    getAll(): Promise<Module[]>;
    /**
     * Check if the current user has this module
     *
     * @param pkg
     * @param name
     */
    isAvailable(pkg: string, name: string): boolean;
    /**
     * Get a module
     *
     * @param pkg
     * @param name
     */
    get(pkg: string, name: string): Module | undefined;
}
export declare const modules: Modules;
export {};
//# sourceMappingURL=Modules.d.ts.map