/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
type KeyValue = Record<string, any>;
/**
 * Utilities to operate on objects
 * @category Utility
 */
export declare class ObjectUtil {
    static isObject: (obj: any) => boolean;
    /**
     * Simple JSON path function
     *
     * eg.
     * const obj = {
     *   foo : {
     *     bar: {
     *       test: 1
     *     }
     *   }
     * }
     *
     * Object.path(obj, 'foo.bar.test'); // 1
     *
     * @param obj
     * @param path
     * @return The value from the path or undefined if not found
     */
    static path(obj: KeyValue, path: string): any;
    /**
     * Deep merge two key value objects
     * @param o1
     * @param o2
     */
    static merge(o1: Record<string, any>, o2: any): any;
    /**
     * Clone an object
     *
     * @param source
     */
    static clone<T>(source: T): T;
}
export {};
//# sourceMappingURL=ObjectUtil.d.ts.map