import {column, DataSourceStore, datasourcestore, datetimecolumn, t, Table} from "@intermesh/goui";
import {JmapDataSource, jmapds} from "@intermesh/groupoffice-core";

export class TaskTable extends Table<DataSourceStore> {
	constructor() {

		const store = datasourcestore({
			dataSource: jmapds("SupportTicket"),
				queryParams: {
				limit: 20,
				filter: {
					createdBy: "{{me}}",
					permissionLevel: 5,
					complete: false
				}
			},
			sort: [{property: "createdAt", isAscending: false}],
			relations: {
				agent: {
					path: "responsibleUserId",
					dataSource: jmapds("UserDisplay")
				},
				taskList: {
					path: "tasklistId",
					dataSource: jmapds("SupportList")
				}
			}
		});



		const columns = [
			column({
				id: "progress",
				resizable: false,
				width: 48,
				sortable: false,
				renderer:(columnValue, record, td, table1, rowIndex) => {

					return columnValue == "completed" ? `<i class="icon support-progress-check">check_circle</i>` : `<i class="icon">radio_button_unchecked</i>`;
				}
			}),
			column({
				header: "ID",
				id:"id",
				resizable: true,
				width: 80,
				sortable: true,
				align: "right",
				hidden: true
			}),
			column({
				header: t("Subject"),
				id:"title",
				resizable: true,
				width: 312,
				sortable: true
			}),
			datetimecolumn({
				header: t("Modified At"),
				id: "modifiedAt",
				sortable: true
			}),
			column({
				header: t("Agent"),
				id: "agent.displayName",
				resizable: true,
				width: 200,
				sortable: false
			}),
			column({
				header: t("List"),
				id: "taskList.name",
				resizable: true,
				width: 200,
				sortable: false
			})
		];

		super(store, columns );

		this.rowSelectionConfig =  {
			multiSelect: true
		};

	}
}